/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.text.NumberFormat;
import java.util.Locale;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.PyUnicode;
import org.python.core.codecs;
import org.python.core.util.ExtraMath;

final class StringFormatter {
    int index = 0;
    String format;
    StringBuilder buffer;
    boolean negative;
    int precision;
    int argIndex;
    PyObject args;
    boolean unicodeCoercion;

    final char pop() {
        try {
            return this.format.charAt(this.index++);
        }
        catch (StringIndexOutOfBoundsException e2) {
            throw Py.ValueError("incomplete format");
        }
    }

    final char peek() {
        return this.format.charAt(this.index);
    }

    final void push() {
        --this.index;
    }

    public StringFormatter(String format) {
        this(format, false);
    }

    public StringFormatter(String format, boolean unicodeCoercion) {
        this.format = format;
        this.unicodeCoercion = unicodeCoercion;
        this.buffer = new StringBuilder(format.length() + 100);
    }

    PyObject getarg() {
        PyObject ret = null;
        switch (this.argIndex) {
            case -3: {
                return this.args;
            }
            case -2: {
                break;
            }
            case -1: {
                this.argIndex = -2;
                return this.args;
            }
            default: {
                ret = this.args.__finditem__(this.argIndex++);
            }
        }
        if (ret == null) {
            throw Py.TypeError("not enough arguments for format string");
        }
        return ret;
    }

    int getNumber() {
        char c2 = this.pop();
        if (c2 == '*') {
            PyObject o2 = this.getarg();
            if (o2 instanceof PyInteger) {
                return ((PyInteger)o2).getValue();
            }
            throw Py.TypeError("* wants int");
        }
        if (Character.isDigit(c2)) {
            int numStart = this.index - 1;
            while (Character.isDigit(c2 = this.pop())) {
            }
            --this.index;
            Integer i2 = Integer.valueOf(this.format.substring(numStart, this.index));
            return i2;
        }
        --this.index;
        return 0;
    }

    private void checkPrecision(String type) {
        if (this.precision > 250) {
            throw Py.OverflowError("formatted " + type + " is too long (precision too long?)");
        }
    }

    private String formatLong(PyObject arg, char type, boolean altFlag) {
        PyString argAsString;
        switch (type) {
            case 'o': {
                argAsString = arg.__oct__();
                break;
            }
            case 'X': 
            case 'x': {
                argAsString = arg.__hex__();
                break;
            }
            default: {
                argAsString = arg.__str__();
            }
        }
        this.checkPrecision("long");
        String s2 = argAsString.toString();
        int end = s2.length();
        int ptr = 0;
        int numnondigits = 0;
        if (type == 'x' || type == 'X') {
            numnondigits = 2;
        }
        if (s2.endsWith("L")) {
            --end;
        }
        boolean bl2 = this.negative = s2.charAt(0) == '-';
        if (this.negative) {
            ++ptr;
        }
        int numdigits = end - numnondigits - ptr;
        if (!altFlag) {
            switch (type) {
                case 'o': {
                    if (numdigits <= 1) break;
                    ++ptr;
                    --numdigits;
                    break;
                }
                case 'X': 
                case 'x': {
                    ptr += 2;
                    numnondigits -= 2;
                }
            }
        }
        if (this.precision > numdigits) {
            int i2;
            StringBuilder buf = new StringBuilder();
            for (i2 = 0; i2 < numnondigits; ++i2) {
                buf.append(s2.charAt(ptr++));
            }
            for (i2 = 0; i2 < this.precision - numdigits; ++i2) {
                buf.append('0');
            }
            for (i2 = 0; i2 < numdigits; ++i2) {
                buf.append(s2.charAt(ptr++));
            }
            s2 = buf.toString();
        } else if (end < s2.length() || ptr > 0) {
            s2 = s2.substring(ptr, end);
        }
        switch (type) {
            case 'X': {
                s2 = s2.toUpperCase();
            }
        }
        return s2;
    }

    private String formatInteger(PyObject arg, int radix, boolean unsigned, char type, boolean altFlag) {
        PyObject argAsInt;
        if (arg instanceof PyInteger || arg instanceof PyLong) {
            argAsInt = arg;
        } else if (arg instanceof PyFloat) {
            argAsInt = arg.__int__();
        } else {
            try {
                argAsInt = arg.__getattr__("__int__").__call__();
            }
            catch (PyException e2) {
                if (e2.match(Py.AttributeError)) {
                    throw Py.TypeError("int argument required");
                }
                throw e2;
            }
        }
        if (argAsInt instanceof PyInteger) {
            return this.formatInteger(((PyInteger)argAsInt).getValue(), radix, unsigned);
        }
        return this.formatLong(argAsInt, type, altFlag);
    }

    private String formatInteger(long v2, int radix, boolean unsigned) {
        this.checkPrecision("integer");
        if (unsigned) {
            if (v2 < 0L) {
                v2 = 0x100000000L + v2;
            }
        } else if (v2 < 0L) {
            this.negative = true;
            v2 = -v2;
        }
        String s2 = Long.toString(v2, radix);
        while (s2.length() < this.precision) {
            s2 = "0" + s2;
        }
        return s2;
    }

    private double asDouble(PyObject obj) {
        try {
            return obj.asDouble();
        }
        catch (PyException pye) {
            throw !pye.match(Py.TypeError) ? pye : Py.TypeError("float argument required");
        }
    }

    private String formatFloatDecimal(double v2, boolean truncate) {
        this.checkPrecision("decimal");
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        int prec = this.precision;
        if (prec == -1) {
            prec = 6;
        }
        if (v2 < 0.0) {
            v2 = -v2;
            this.negative = true;
        }
        numberFormat.setMaximumFractionDigits(prec);
        numberFormat.setMinimumFractionDigits(truncate ? 0 : prec);
        numberFormat.setGroupingUsed(false);
        String ret = numberFormat.format(v2);
        return ret;
    }

    private String formatFloatExponential(PyObject arg, char e2, boolean truncate) {
        StringBuilder buf = new StringBuilder();
        double v2 = this.asDouble(arg);
        boolean isNegative = false;
        if (v2 < 0.0) {
            v2 = -v2;
            isNegative = true;
        }
        double power = 0.0;
        if (v2 > 0.0) {
            power = ExtraMath.closeFloor(Math.log10(v2));
        }
        int savePrecision = this.precision;
        this.precision = 2;
        String exp = this.formatInteger((long)power, 10, false);
        if (this.negative) {
            this.negative = false;
            exp = '-' + exp;
        } else {
            exp = '+' + exp;
        }
        this.precision = savePrecision;
        double base2 = v2 / Math.pow(10.0, power);
        buf.append(this.formatFloatDecimal(base2, truncate));
        buf.append(e2);
        buf.append(exp);
        this.negative = isNegative;
        return buf.toString();
    }

    public PyString format(PyObject args) {
        PyObject dict = null;
        this.args = args;
        boolean needUnicode = this.unicodeCoercion;
        if (args instanceof PyTuple) {
            this.argIndex = 0;
        } else {
            this.argIndex = -1;
            if (args instanceof PyDictionary || args instanceof PyStringMap || !(args instanceof PySequence) && args.__findattr__("__getitem__") != null) {
                dict = args;
                this.argIndex = -3;
            }
        }
        while (this.index < this.format.length()) {
            boolean ljustFlag = false;
            boolean signFlag = false;
            boolean blankFlag = false;
            boolean altFlag = false;
            boolean zeroFlag = false;
            int width = -1;
            this.precision = -1;
            char c2 = this.pop();
            if (c2 != '%') {
                this.buffer.append(c2);
                continue;
            }
            c2 = this.pop();
            if (c2 == '(') {
                if (dict == null) {
                    throw Py.TypeError("format requires a mapping");
                }
                int parens = 1;
                int keyStart = this.index;
                while (parens > 0) {
                    c2 = this.pop();
                    if (c2 == ')') {
                        --parens;
                        continue;
                    }
                    if (c2 != '(') continue;
                    ++parens;
                }
                String tmp = this.format.substring(keyStart, this.index - 1);
                this.args = dict.__getitem__(needUnicode ? new PyUnicode(tmp) : new PyString(tmp));
            } else {
                this.push();
            }
            block24: while (true) {
                c2 = this.pop();
                switch (c2) {
                    case '-': {
                        ljustFlag = true;
                        continue block24;
                    }
                    case '+': {
                        signFlag = true;
                        continue block24;
                    }
                    case ' ': {
                        blankFlag = true;
                        continue block24;
                    }
                    case '#': {
                        altFlag = true;
                        continue block24;
                    }
                    case '0': {
                        zeroFlag = true;
                        continue block24;
                    }
                }
                break;
            }
            this.push();
            width = this.getNumber();
            if (width < 0) {
                width = -width;
                ljustFlag = true;
            }
            if ((c2 = this.pop()) == '.') {
                this.precision = this.getNumber();
                if (this.precision < -1) {
                    this.precision = 0;
                }
                c2 = this.pop();
            }
            if (c2 == 'h' || c2 == 'l' || c2 == 'L') {
                c2 = this.pop();
            }
            if (c2 == '%') {
                this.buffer.append(c2);
                continue;
            }
            PyObject arg = this.getarg();
            char fill = ' ';
            String string2 = null;
            this.negative = false;
            fill = zeroFlag ? (char)'0' : ' ';
            switch (c2) {
                case 's': {
                    if (arg instanceof PyUnicode) {
                        needUnicode = true;
                    }
                }
                case 'r': {
                    fill = ' ';
                    string2 = c2 == 's' ? (needUnicode ? arg.__unicode__().toString() : arg.__str__().toString()) : arg.__repr__().toString();
                    if (this.precision < 0 || string2.length() <= this.precision) break;
                    string2 = string2.substring(0, this.precision);
                    break;
                }
                case 'd': 
                case 'i': {
                    if (arg instanceof PyLong) {
                        string2 = this.formatLong(arg, c2, altFlag);
                        break;
                    }
                    string2 = this.formatInteger(arg, 10, false, c2, altFlag);
                    break;
                }
                case 'u': {
                    if (arg instanceof PyLong) {
                        string2 = this.formatLong(arg, c2, altFlag);
                        break;
                    }
                    if (arg instanceof PyInteger || arg instanceof PyFloat) {
                        string2 = this.formatInteger(arg, 10, false, c2, altFlag);
                        break;
                    }
                    throw Py.TypeError("int argument required");
                }
                case 'o': {
                    if (arg instanceof PyLong) {
                        string2 = this.formatLong(arg, c2, altFlag);
                        break;
                    }
                    if (arg instanceof PyInteger || arg instanceof PyFloat) {
                        string2 = this.formatInteger(arg, 8, false, c2, altFlag);
                        if (!altFlag || string2.charAt(0) == '0') break;
                        string2 = "0" + string2;
                        break;
                    }
                    throw Py.TypeError("int argument required");
                }
                case 'x': {
                    if (arg instanceof PyLong) {
                        string2 = this.formatLong(arg, c2, altFlag);
                        break;
                    }
                    if (arg instanceof PyInteger || arg instanceof PyFloat) {
                        string2 = this.formatInteger(arg, 16, false, c2, altFlag);
                        string2 = string2.toLowerCase();
                        if (!altFlag) break;
                        string2 = "0x" + string2;
                        break;
                    }
                    throw Py.TypeError("int argument required");
                }
                case 'X': {
                    if (arg instanceof PyLong) {
                        string2 = this.formatLong(arg, c2, altFlag);
                        break;
                    }
                    if (arg instanceof PyInteger || arg instanceof PyFloat) {
                        string2 = this.formatInteger(arg, 16, false, c2, altFlag);
                        string2 = string2.toUpperCase();
                        if (!altFlag) break;
                        string2 = "0X" + string2;
                        break;
                    }
                    throw Py.TypeError("int argument required");
                }
                case 'E': 
                case 'e': {
                    string2 = this.formatFloatExponential(arg, c2, false);
                    break;
                }
                case 'F': 
                case 'f': {
                    string2 = this.formatFloatDecimal(this.asDouble(arg), false);
                    break;
                }
                case 'G': 
                case 'g': {
                    double v2;
                    int origPrecision = this.precision;
                    if (this.precision == -1) {
                        this.precision = 6;
                    }
                    int exponent = (int)ExtraMath.closeFloor(Math.log10(Math.abs((v2 = this.asDouble(arg)) == 0.0 ? 1.0 : v2)));
                    if (v2 == Double.POSITIVE_INFINITY) {
                        string2 = "inf";
                        break;
                    }
                    if (v2 == Double.NEGATIVE_INFINITY) {
                        string2 = "-inf";
                        break;
                    }
                    if (exponent >= -4 && exponent < this.precision) {
                        this.precision -= exponent + 1;
                        string2 = this.formatFloatDecimal(v2, !altFlag);
                        if (!altFlag || string2.indexOf(46) != -1) break;
                        int zpad = origPrecision - string2.length();
                        string2 = string2 + '.';
                        if (zpad <= 0) break;
                        char[] zeros = new char[zpad];
                        int ci2 = 0;
                        while (ci2 < zpad) {
                            zeros[ci2++] = 48;
                        }
                        string2 = string2 + new String(zeros);
                        break;
                    }
                    --this.precision;
                    string2 = this.formatFloatExponential(arg, (char)(c2 - 2), !altFlag);
                    break;
                }
                case 'c': {
                    int val;
                    fill = ' ';
                    if (arg instanceof PyString) {
                        string2 = ((PyString)arg).toString();
                        if (string2.length() != 1) {
                            throw Py.TypeError("%c requires int or char");
                        }
                        if (!(arg instanceof PyUnicode)) break;
                        needUnicode = true;
                        break;
                    }
                    try {
                        val = arg.__int__().asInt();
                    }
                    catch (PyException e2) {
                        if (e2.match(Py.AttributeError)) {
                            throw Py.TypeError("%c requires int or char");
                        }
                        throw e2;
                    }
                    if (!needUnicode) {
                        if (val < 0) {
                            throw Py.OverflowError("unsigned byte integer is less than minimum");
                        }
                        if (val > 255) {
                            throw Py.OverflowError("unsigned byte integer is greater than maximum");
                        }
                    } else if (val < 0 || val > 0x10FFFF) {
                        throw Py.OverflowError("%c arg not in range(0x110000) (wide Python build)");
                    }
                    string2 = new String(new int[]{val}, 0, 1);
                    break;
                }
                default: {
                    throw Py.ValueError("unsupported format character '" + codecs.encode(Py.newString(c2), null, "replace") + "' (0x" + Integer.toHexString(c2) + ") at index " + (this.index - 1));
                }
            }
            int length = string2.length();
            int n2 = 0;
            String string3 = null;
            if (this.negative) {
                string3 = "-";
            } else if (signFlag) {
                string3 = "+";
            } else if (blankFlag) {
                string3 = " ";
            }
            if (width < length) {
                width = length;
            }
            if (string3 != null) {
                if (fill != ' ') {
                    this.buffer.append(string3);
                }
                if (width > length) {
                    --width;
                }
            }
            if (altFlag && (c2 == 'x' || c2 == 'X')) {
                if (fill != ' ') {
                    this.buffer.append('0');
                    this.buffer.append(c2);
                    n2 += 2;
                }
                if ((width -= 2) < 0) {
                    width = 0;
                }
                length -= 2;
            }
            if (width > length && !ljustFlag) {
                do {
                    this.buffer.append(fill);
                } while (--width > length);
            }
            if (fill == ' ') {
                if (string3 != null) {
                    this.buffer.append(string3);
                }
                if (altFlag && (c2 == 'x' || c2 == 'X')) {
                    this.buffer.append('0');
                    this.buffer.append(c2);
                    n2 += 2;
                }
            }
            if (n2 > 0) {
                this.buffer.append(string2.substring(n2));
            } else {
                this.buffer.append(string2);
            }
            while (--width >= length) {
                this.buffer.append(' ');
            }
        }
        if (this.argIndex == -1 || this.argIndex >= 0 && args.__finditem__(this.argIndex) != null) {
            throw Py.TypeError("not all arguments converted during string formatting");
        }
        if (needUnicode) {
            return new PyUnicode(this.buffer);
        }
        return new PyString(this.buffer);
    }
}

