/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySequenceList;
import org.python.core.ReflectedCallData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectedArgs {
    public Class<?>[] args;
    public Object data;
    public Class<?> declaringClass;
    public boolean isStatic;
    public boolean isVarArgs;
    public int flags;
    public static final int StandardCall = 0;
    public static final int PyArgsCall = 1;
    public static final int PyArgsKeywordsCall = 2;
    public static final int REPLACE = 1998;

    public ReflectedArgs(Object data, Class<?>[] args, Class<?> declaringClass, boolean isStatic) {
        this(data, args, declaringClass, isStatic, false);
    }

    public ReflectedArgs(Object data, Class<?>[] args, Class<?> declaringClass, boolean isStatic, boolean isVarArgs) {
        this.data = data;
        this.args = args;
        this.declaringClass = declaringClass;
        this.isStatic = isStatic;
        this.isVarArgs = isVarArgs;
        this.flags = args.length == 1 && args[0] == PyObject[].class ? 1 : (args.length == 2 && args[0] == PyObject[].class && args[1] == String[].class ? 2 : 0);
    }

    public boolean matches(PyObject self, PyObject[] pyArgs, String[] keywords, ReflectedCallData callData) {
        int non_varargs_len;
        Object tmp;
        if (this.flags != 2 && keywords != null && keywords.length != 0) {
            return false;
        }
        if (this.isStatic) {
            if (self != null) {
                self = null;
            }
        } else if (self == null) {
            if (pyArgs.length == 0) {
                return false;
            }
            self = pyArgs[0];
            PyObject[] newArgs = new PyObject[pyArgs.length - 1];
            System.arraycopy(pyArgs, 1, newArgs, 0, newArgs.length);
            pyArgs = newArgs;
        }
        if (this.flags == 2) {
            callData.setLength(2);
            callData.args[0] = pyArgs;
            callData.args[1] = keywords;
            callData.self = self;
            if (self != null && (tmp = self.__tojava__(this.declaringClass)) != Py.NoConversion) {
                callData.self = tmp;
            }
            return true;
        }
        if (this.flags == 1) {
            callData.setLength(1);
            callData.args[0] = pyArgs;
            callData.self = self;
            if (self != null && (tmp = self.__tojava__(this.declaringClass)) != Py.NoConversion) {
                callData.self = tmp;
            }
            return true;
        }
        int n2 = this.args.length;
        if (this.isVarArgs && (pyArgs.length == 0 || !(pyArgs[pyArgs.length - 1] instanceof PySequenceList)) && pyArgs.length >= (non_varargs_len = n2 - 1)) {
            PyObject[] boxedPyArgs = new PyObject[n2];
            for (int i2 = 0; i2 < non_varargs_len; ++i2) {
                boxedPyArgs[i2] = pyArgs[i2];
            }
            int varargs_len = pyArgs.length - non_varargs_len;
            PyObject[] varargs = new PyObject[varargs_len];
            for (int i3 = 0; i3 < varargs_len; ++i3) {
                varargs[i3] = pyArgs[non_varargs_len + i3];
            }
            boxedPyArgs[non_varargs_len] = new PyList(varargs);
            pyArgs = boxedPyArgs;
        }
        if (pyArgs.length != n2) {
            return false;
        }
        callData.errArg = -1;
        if (self != null) {
            Object tmp2 = self.__tojava__(this.declaringClass);
            if (tmp2 == Py.NoConversion) {
                return false;
            }
            callData.self = tmp2;
        } else {
            callData.self = null;
        }
        callData.setLength(n2);
        Object[] javaArgs = callData.args;
        for (int i4 = 0; i4 < n2; ++i4) {
            Object javaArg;
            PyObject pyArg = pyArgs[i4];
            Class<?> targetClass = this.args[i4];
            javaArgs[i4] = javaArg = pyArg.__tojava__(targetClass);
            if (javaArg != Py.NoConversion) continue;
            if (i4 > callData.errArg) {
                callData.errArg = i4;
            }
            return false;
        }
        return true;
    }

    public static int precedence(Class<?> arg) {
        if (arg == Object.class) {
            return 3000;
        }
        if (arg.isPrimitive()) {
            if (arg == Long.TYPE) {
                return 10;
            }
            if (arg == Integer.TYPE) {
                return 11;
            }
            if (arg == Short.TYPE) {
                return 12;
            }
            if (arg == Character.TYPE) {
                return 13;
            }
            if (arg == Byte.TYPE) {
                return 14;
            }
            if (arg == Double.TYPE) {
                return 20;
            }
            if (arg == Float.TYPE) {
                return 21;
            }
            if (arg == Boolean.TYPE) {
                return 30;
            }
        }
        if (arg == String.class) {
            return 40;
        }
        if (arg.isArray()) {
            Class<?> componentType = arg.getComponentType();
            if (componentType == Object.class) {
                return 2500;
            }
            return 100 + ReflectedArgs.precedence(componentType);
        }
        return 2000;
    }

    public static int compare(Class<?> arg1, Class<?> arg2) {
        int p1 = ReflectedArgs.precedence(arg1);
        int p2 = ReflectedArgs.precedence(arg2);
        if (p1 >= 2000 && p2 >= 2000) {
            if (arg1.isAssignableFrom(arg2)) {
                if (arg2.isAssignableFrom(arg1)) {
                    return 0;
                }
                return 2;
            }
            if (arg2.isAssignableFrom(arg1)) {
                return -2;
            }
            int cmp = arg1.getName().compareTo(arg2.getName());
            return cmp > 0 ? 1 : -1;
        }
        return p1 > p2 ? 2 : (p1 == p2 ? 0 : -2);
    }

    public int compareTo(ReflectedArgs other) {
        Class<?>[] oargs = other.args;
        if (other.flags != this.flags) {
            return other.flags < this.flags ? -1 : 1;
        }
        int n2 = this.args.length;
        if (n2 < oargs.length) {
            return -1;
        }
        if (n2 > oargs.length) {
            return 1;
        }
        if (this.isStatic && !other.isStatic) {
            return 1;
        }
        if (!this.isStatic && other.isStatic) {
            return -1;
        }
        int cmp = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int tmp = ReflectedArgs.compare(this.args[i2], oargs[i2]);
            if (tmp == 2 || tmp == -2) {
                cmp = tmp;
            }
            if (cmp != 0) continue;
            cmp = tmp;
        }
        if (cmp != 0) {
            return cmp > 0 ? 1 : -1;
        }
        boolean replace = other.declaringClass.isAssignableFrom(this.declaringClass);
        if (!this.isStatic) {
            replace = !replace;
        }
        return replace ? 1998 : 0;
    }

    public String toString() {
        String s2 = this.declaringClass + ", static=" + this.isStatic + ", varargs=" + this.isVarArgs + ",flags=" + this.flags + ", " + this.data + "\n";
        s2 = s2 + "\t(";
        for (Class<?> arg : this.args) {
            s2 = s2 + arg.getName() + ", ";
        }
        s2 = s2 + ")";
        return s2;
    }
}

