/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyFastSequenceIter;
import org.python.core.PyList;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequenceList;
import org.python.core.PyTuple$PyExposer;
import org.python.core.PyTupleDerived;
import org.python.core.PyType;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExposedType(name="tuple", base=PyObject.class, doc="tuple() -> an empty tuple\ntuple(sequence) -> tuple initialized from sequence's items\n\nIf the argument is a tuple, the return value is the same object.")
public class PyTuple
extends PySequenceList
implements List {
    public static final PyType TYPE;
    private final PyObject[] array;
    private volatile List<PyObject> cachedList = null;
    private static final PyTuple EMPTY_TUPLE;

    public PyTuple() {
        this(TYPE, Py.EmptyObjects);
    }

    public PyTuple(PyObject ... elements) {
        this(TYPE, elements);
    }

    public PyTuple(PyType subtype, PyObject[] elements) {
        super(subtype);
        if (elements == null) {
            this.array = new PyObject[0];
        } else {
            this.array = new PyObject[elements.length];
            System.arraycopy(elements, 0, this.array, 0, elements.length);
        }
    }

    public PyTuple(PyObject[] elements, boolean copy2) {
        this(TYPE, elements, copy2);
    }

    public PyTuple(PyType subtype, PyObject[] elements, boolean copy2) {
        super(subtype);
        if (copy2) {
            this.array = new PyObject[elements.length];
            System.arraycopy(elements, 0, this.array, 0, elements.length);
        } else {
            this.array = elements;
        }
    }

    private static PyTuple fromArrayNoCopy(PyObject[] elements) {
        return new PyTuple(elements, false);
    }

    List<PyObject> getList() {
        if (this.cachedList == null) {
            this.cachedList = Arrays.asList(this.array);
        }
        return this.cachedList;
    }

    @ExposedNew
    static final PyObject tuple_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap2 = new ArgParser("tuple", args, keywords, new String[]{"sequence"}, 0);
        PyObject S2 = ap2.getPyObject(0, null);
        if (new_.for_type == subtype) {
            if (S2 == null) {
                return EMPTY_TUPLE;
            }
            if (S2 instanceof PyTupleDerived) {
                return new PyTuple(((PyTuple)S2).getArray());
            }
            if (S2 instanceof PyTuple) {
                return S2;
            }
            return PyTuple.fromArrayNoCopy(Py.make_array(S2));
        }
        if (S2 == null) {
            return new PyTupleDerived(subtype, Py.EmptyObjects);
        }
        return new PyTupleDerived(subtype, Py.make_array(S2));
    }

    public static PyTuple fromIterable(PyObject iterable) {
        return PyTuple.fromArrayNoCopy(Py.make_array(iterable));
    }

    @Override
    protected PyObject getslice(int start, int stop, int step) {
        if (step > 0 && stop < start) {
            stop = start;
        }
        int n2 = PyTuple.sliceLength(start, stop, step);
        PyObject[] newArray = new PyObject[n2];
        if (step == 1) {
            System.arraycopy(this.array, start, newArray, 0, stop - start);
            return PyTuple.fromArrayNoCopy(newArray);
        }
        int i2 = start;
        for (int j2 = 0; j2 < n2; ++j2) {
            newArray[j2] = this.array[i2];
            i2 += step;
        }
        return PyTuple.fromArrayNoCopy(newArray);
    }

    @Override
    protected PyObject repeat(int count) {
        int newSize;
        int size;
        if (count < 0) {
            count = 0;
        }
        if ((size = this.size()) == 0 || count == 1) {
            if (this.getType() == TYPE) {
                return this;
            }
            if (size == 0) {
                return EMPTY_TUPLE;
            }
        }
        if ((newSize = size * count) / size != count) {
            throw Py.MemoryError("");
        }
        PyObject[] newArray = new PyObject[newSize];
        for (int i2 = 0; i2 < count; ++i2) {
            System.arraycopy(this.array, 0, newArray, i2 * size, size);
        }
        return PyTuple.fromArrayNoCopy(newArray);
    }

    @Override
    public int __len__() {
        return this.tuple___len__();
    }

    final int tuple___len__() {
        return this.size();
    }

    final boolean tuple___contains__(PyObject o2) {
        return super.__contains__(o2);
    }

    final PyObject tuple___ne__(PyObject o2) {
        return super.__ne__(o2);
    }

    final PyObject tuple___eq__(PyObject o2) {
        return super.__eq__(o2);
    }

    final PyObject tuple___gt__(PyObject o2) {
        return super.__gt__(o2);
    }

    final PyObject tuple___ge__(PyObject o2) {
        return super.__ge__(o2);
    }

    final PyObject tuple___lt__(PyObject o2) {
        return super.__lt__(o2);
    }

    final PyObject tuple___le__(PyObject o2) {
        return super.__le__(o2);
    }

    @Override
    public PyObject __add__(PyObject generic_other) {
        return this.tuple___add__(generic_other);
    }

    final PyObject tuple___add__(PyObject generic_other) {
        PyTuple sum = null;
        if (generic_other instanceof PyTuple) {
            PyTuple other = (PyTuple)generic_other;
            PyObject[] newArray = new PyObject[this.array.length + other.array.length];
            System.arraycopy(this.array, 0, newArray, 0, this.array.length);
            System.arraycopy(other.array, 0, newArray, this.array.length, other.array.length);
            sum = PyTuple.fromArrayNoCopy(newArray);
        }
        return sum;
    }

    @Override
    public PyObject __mul__(PyObject o2) {
        return this.tuple___mul__(o2);
    }

    final PyObject tuple___mul__(PyObject o2) {
        if (!o2.isIndex()) {
            return null;
        }
        return this.repeat(o2.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __rmul__(PyObject o2) {
        return this.tuple___rmul__(o2);
    }

    final PyObject tuple___rmul__(PyObject o2) {
        if (!o2.isIndex()) {
            return null;
        }
        return this.repeat(o2.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __iter__() {
        return this.tuple___iter__();
    }

    public PyObject tuple___iter__() {
        return new PyFastSequenceIter(this);
    }

    final PyObject tuple___getslice__(PyObject s_start, PyObject s_stop, PyObject s_step) {
        return this.seq___getslice__(s_start, s_stop, s_step);
    }

    final PyObject tuple___getitem__(PyObject index) {
        PyObject ret = this.seq___finditem__(index);
        if (ret == null) {
            throw Py.IndexError("index out of range: " + index);
        }
        return ret;
    }

    final PyTuple tuple___getnewargs__() {
        return new PyTuple(new PyTuple(this.getArray()));
    }

    @Override
    public PyTuple __getnewargs__() {
        return this.tuple___getnewargs__();
    }

    @Override
    public int hashCode() {
        return this.tuple___hash__();
    }

    /*
     * WARNING - void declaration
     */
    final int tuple___hash__() {
        int n2 = this.size();
        int len = 1000003;
        int mult = 3430008;
        while (--n2 >= 0) {
            void y2;
            int x2 = this.array[n2].hashCode();
            mult = (mult ^ x2) * len;
            len += 82520 + y2 + y2;
        }
        return mult + 97531;
    }

    private String subobjRepr(PyObject o2) {
        if (o2 == null) {
            return "null";
        }
        return o2.__repr__().toString();
    }

    @Override
    public String toString() {
        return this.tuple___repr__();
    }

    final String tuple___repr__() {
        StringBuilder buf = new StringBuilder("(");
        for (int i2 = 0; i2 < this.array.length - 1; ++i2) {
            buf.append(this.subobjRepr(this.array[i2]));
            buf.append(", ");
        }
        if (this.array.length > 0) {
            buf.append(this.subobjRepr(this.array[this.array.length - 1]));
        }
        if (this.array.length == 1) {
            buf.append(",");
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public List subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        PyObject[] elements = new PyObject[toIndex - fromIndex];
        int i2 = 0;
        int j2 = fromIndex;
        while (i2 < elements.length) {
            elements[i2] = this.array[j2];
            ++i2;
            ++j2;
        }
        return new PyTuple(elements);
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            private final Iterator<PyObject> iter;
            {
                this.iter = PyTuple.this.getList().iterator();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public Object next() {
                return this.iter.next().__tojava__(Object.class);
            }
        };
    }

    @Override
    public boolean add(Object o2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection c2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator listIterator(final int index) {
        return new ListIterator(){
            private final ListIterator<PyObject> iter;
            {
                this.iter = PyTuple.this.getList().listIterator(index);
            }

            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public Object next() {
                return this.iter.next().__tojava__(Object.class);
            }

            public boolean hasPrevious() {
                return this.iter.hasPrevious();
            }

            public Object previous() {
                return this.iter.previous().__tojava__(Object.class);
            }

            public int nextIndex() {
                return this.iter.nextIndex();
            }

            public int previousIndex() {
                return this.iter.previousIndex();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void set(Object o2) {
                throw new UnsupportedOperationException();
            }

            public void add(Object o2) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    protected String unsupportedopMessage(String op, PyObject o2) {
        if (op.equals("+")) {
            return "can only concatenate tuple (not \"{2}\") to tuple";
        }
        return super.unsupportedopMessage(op, o2);
    }

    @Override
    public void pyset(int index, PyObject value) {
        throw Py.TypeError("'tuple' object does not support item assignment");
    }

    @Override
    public boolean contains(Object o2) {
        return this.getList().contains(Py.java2py(o2));
    }

    @Override
    public boolean containsAll(Collection c2) {
        if (c2 instanceof PyList) {
            return this.getList().containsAll(((PyList)c2).getList());
        }
        if (c2 instanceof PyTuple) {
            return this.getList().containsAll(((PyTuple)c2).getList());
        }
        return this.getList().containsAll(new PyList(c2));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof PyObject) {
            return this._eq((PyObject)other).__nonzero__();
        }
        if (other instanceof List) {
            return other.equals(this);
        }
        return false;
    }

    @Override
    public Object get(int index) {
        return this.array[index].__tojava__(Object.class);
    }

    @Override
    public PyObject[] getArray() {
        return this.array;
    }

    @Override
    public int indexOf(Object o2) {
        return this.getList().indexOf(Py.java2py(o2));
    }

    @Override
    public boolean isEmpty() {
        return this.array.length == 0;
    }

    @Override
    public int lastIndexOf(Object o2) {
        return this.getList().lastIndexOf(Py.java2py(o2));
    }

    @Override
    public void pyadd(int index, PyObject element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean pyadd(PyObject o2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PyObject pyget(int index) {
        return this.array[index];
    }

    @Override
    public void remove(int start, int stop) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public Object[] toArray() {
        Object[] converted = new Object[this.array.length];
        for (int i2 = 0; i2 < this.array.length; ++i2) {
            converted[i2] = this.array[i2].__tojava__(Object.class);
        }
        return converted;
    }

    @Override
    public Object[] toArray(Object[] converted) {
        int i2;
        Class<?> type = converted.getClass().getComponentType();
        if (converted.length < this.array.length) {
            converted = (Object[])Array.newInstance(type, this.array.length);
        }
        for (i2 = 0; i2 < this.array.length; ++i2) {
            converted[i2] = type.cast(this.array[i2].__tojava__(type));
        }
        if (this.array.length < converted.length) {
            for (i2 = this.array.length; i2 < converted.length; ++i2) {
                converted[i2] = null;
            }
        }
        return converted;
    }

    static {
        PyType.addBuilder(PyTuple.class, new PyTuple$PyExposer());
        TYPE = PyType.fromClass(PyTuple.class);
        EMPTY_TUPLE = new PyTuple();
    }
}

