/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import junit.framework.TestCase;
import org.python.core.PySystemState;
import org.python.posix.util.Platform;

public class PySystemStateTest
extends TestCase {
    public void testGetJarFileNameFromURL() throws Exception {
        PySystemStateTest.assertNull((Object)PySystemState.getJarFileNameFromURL(null));
        String urlString = "jar:file:/some_dir/some.jar!/a/package/with/A.class";
        URL url = new URL(urlString);
        PySystemStateTest.assertEquals((String)"/some_dir/some.jar", (String)PySystemState.getJarFileNameFromURL(url));
        urlString = "jar:file:/some%20dir/some.jar!/a/package/with/A.class";
        url = new URL(urlString);
        PySystemStateTest.assertEquals((String)"/some dir/some.jar", (String)PySystemState.getJarFileNameFromURL(url));
        urlString = "jar:file:/some+dir/some.jar!/a/package/with/A.class";
        url = new URL(urlString);
        PySystemStateTest.assertEquals((String)"/some+dir/some.jar", (String)PySystemState.getJarFileNameFromURL(url));
    }

    public void testGetJarFileNameFromURL_jboss() throws Exception {
        String protocol = "vfszip";
        String host = "";
        int port = -1;
        TestJBossURLStreamHandler handler2 = new TestJBossURLStreamHandler();
        if (Platform.IS_WINDOWS) {
            String file = "/C:/some_dir/some.jar/org/python/core/PySystemState.class";
            URL url = new URL("vfszip", "", -1, file, handler2);
            PySystemStateTest.assertEquals((String)"vfszip:/C:/some_dir/some.jar/org/python/core/PySystemState.class", (String)url.toString());
            PySystemStateTest.assertEquals((String)"C:/some_dir/some.jar", (String)PySystemState.getJarFileNameFromURL(url));
            file = "/C:/some%20dir/some.jar/org/python/core/PySystemState.class";
            url = new URL("vfszip", "", -1, file, handler2);
            PySystemStateTest.assertEquals((String)"vfszip:/C:/some%20dir/some.jar/org/python/core/PySystemState.class", (String)url.toString());
            PySystemStateTest.assertEquals((String)"C:/some dir/some.jar", (String)PySystemState.getJarFileNameFromURL(url));
            file = "/C:/some+dir/some.jar/org/python/core/PySystemState.class";
            url = new URL("vfszip", "", -1, file, handler2);
            PySystemStateTest.assertEquals((String)"vfszip:/C:/some+dir/some.jar/org/python/core/PySystemState.class", (String)url.toString());
            PySystemStateTest.assertEquals((String)"C:/some+dir/some.jar", (String)PySystemState.getJarFileNameFromURL(url));
        } else {
            String file = "/some_dir/some.jar/org/python/core/PySystemState.class";
            URL url = new URL("vfszip", "", -1, file, handler2);
            PySystemStateTest.assertEquals((String)"vfszip:/some_dir/some.jar/org/python/core/PySystemState.class", (String)url.toString());
            PySystemStateTest.assertEquals((String)"/some_dir/some.jar", (String)PySystemState.getJarFileNameFromURL(url));
            file = "/some%20dir/some.jar/org/python/core/PySystemState.class";
            url = new URL("vfszip", "", -1, file, handler2);
            PySystemStateTest.assertEquals((String)"vfszip:/some%20dir/some.jar/org/python/core/PySystemState.class", (String)url.toString());
            PySystemStateTest.assertEquals((String)"/some dir/some.jar", (String)PySystemState.getJarFileNameFromURL(url));
            file = "/some+dir/some.jar/org/python/core/PySystemState.class";
            url = new URL("vfszip", "", -1, file, handler2);
            PySystemStateTest.assertEquals((String)"vfszip:/some+dir/some.jar/org/python/core/PySystemState.class", (String)url.toString());
            PySystemStateTest.assertEquals((String)"/some+dir/some.jar", (String)PySystemState.getJarFileNameFromURL(url));
        }
    }

    protected static class TestJBossURLStreamHandler
    extends URLStreamHandler {
        protected TestJBossURLStreamHandler() {
        }

        protected URLConnection openConnection(URL u2) throws IOException {
            throw new RuntimeException("unexpected call to openConnection " + u2.toString());
        }
    }
}

