/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySequenceIter;
import org.python.core.PySlice;
import org.python.core.PyType;
import org.python.core.SequenceIndexDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PySequence
extends PyObject {
    protected final SequenceIndexDelegate delegator = new SequenceIndexDelegate(){

        public String getTypeName() {
            return PySequence.this.getType().fastGetName();
        }

        public void setItem(int idx, PyObject value) {
            PySequence.this.pyset(idx, value);
        }

        public void setSlice(int start, int stop, int step, PyObject value) {
            PySequence.this.setslice(start, stop, step, value);
        }

        public int len() {
            return PySequence.this.__len__();
        }

        public void delItem(int idx) {
            PySequence.this.del(idx);
        }

        public void delItems(int start, int stop) {
            PySequence.this.delRange(start, stop);
        }

        public PyObject getItem(int idx) {
            return PySequence.this.pyget(idx);
        }

        public PyObject getSlice(int start, int stop, int step) {
            return PySequence.this.getslice(start, stop, step);
        }
    };

    protected PySequence(PyType type) {
        super(type);
    }

    protected abstract PyObject pyget(int var1);

    protected abstract PyObject getslice(int var1, int var2, int var3);

    protected abstract PyObject repeat(int var1);

    protected void pyset(int index, PyObject value) {
        throw Py.TypeError("can't assign to immutable object");
    }

    protected void setslice(int start, int stop, int step, PyObject value) {
        throw Py.TypeError(String.format("'%s' object does not support item assignment", this.getType().fastGetName()));
    }

    protected void del(int i2) {
        throw Py.TypeError(String.format("'%s' object does not support item deletion", this.getType().fastGetName()));
    }

    protected void delRange(int start, int stop) {
        throw Py.TypeError(String.format("'%s' object does not support item deletion", this.getType().fastGetName()));
    }

    @Override
    public boolean __nonzero__() {
        return this.seq___nonzero__();
    }

    final boolean seq___nonzero__() {
        return this.__len__() != 0;
    }

    @Override
    public PyObject __iter__() {
        return this.seq___iter__();
    }

    final PyObject seq___iter__() {
        return new PySequenceIter(this);
    }

    @Override
    public PyObject __eq__(PyObject o2) {
        return this.seq___eq__(o2);
    }

    final PyObject seq___eq__(PyObject o2) {
        int ol;
        if (!this.isSubType(o2)) {
            return null;
        }
        int tl = this.__len__();
        if (tl != (ol = o2.__len__())) {
            return Py.False;
        }
        int i2 = PySequence.cmp(this, tl, o2, ol);
        return i2 < 0 ? Py.True : Py.False;
    }

    @Override
    public PyObject __ne__(PyObject o2) {
        return this.seq___ne__(o2);
    }

    final PyObject seq___ne__(PyObject o2) {
        int ol;
        if (!this.isSubType(o2)) {
            return null;
        }
        int tl = this.__len__();
        if (tl != (ol = o2.__len__())) {
            return Py.True;
        }
        int i2 = PySequence.cmp(this, tl, o2, ol);
        return i2 < 0 ? Py.False : Py.True;
    }

    @Override
    public PyObject __lt__(PyObject o2) {
        return this.seq___lt__(o2);
    }

    final PyObject seq___lt__(PyObject o2) {
        if (!this.isSubType(o2)) {
            return null;
        }
        int i2 = PySequence.cmp(this, -1, o2, -1);
        if (i2 < 0) {
            return i2 == -1 ? Py.True : Py.False;
        }
        return this.__finditem__(i2)._lt(o2.__finditem__(i2));
    }

    @Override
    public PyObject __le__(PyObject o2) {
        return this.seq___le__(o2);
    }

    final PyObject seq___le__(PyObject o2) {
        if (!this.isSubType(o2)) {
            return null;
        }
        int i2 = PySequence.cmp(this, -1, o2, -1);
        if (i2 < 0) {
            return i2 == -1 || i2 == -2 ? Py.True : Py.False;
        }
        return this.__finditem__(i2)._le(o2.__finditem__(i2));
    }

    @Override
    public PyObject __gt__(PyObject o2) {
        return this.seq___gt__(o2);
    }

    final PyObject seq___gt__(PyObject o2) {
        if (!this.isSubType(o2)) {
            return null;
        }
        int i2 = PySequence.cmp(this, -1, o2, -1);
        if (i2 < 0) {
            return i2 == -3 ? Py.True : Py.False;
        }
        return this.__finditem__(i2)._gt(o2.__finditem__(i2));
    }

    @Override
    public PyObject __ge__(PyObject o2) {
        return this.seq___ge__(o2);
    }

    final PyObject seq___ge__(PyObject o2) {
        if (!this.isSubType(o2)) {
            return null;
        }
        int i2 = PySequence.cmp(this, -1, o2, -1);
        if (i2 < 0) {
            return i2 == -3 || i2 == -2 ? Py.True : Py.False;
        }
        return this.__finditem__(i2)._ge(o2.__finditem__(i2));
    }

    protected boolean isSubType(PyObject other) {
        PyType otherType;
        PyType type = this.getType();
        return type == (otherType = other.getType()) || type.isSubType(otherType);
    }

    protected static int cmp(PyObject o1, int ol1, PyObject o2, int ol2) {
        if (ol1 < 0) {
            ol1 = o1.__len__();
        }
        if (ol2 < 0) {
            ol2 = o2.__len__();
        }
        for (int i2 = 0; i2 < ol1 && i2 < ol2; ++i2) {
            if (o1.__getitem__(i2).equals(o2.__getitem__(i2))) continue;
            return i2;
        }
        if (ol1 == ol2) {
            return -2;
        }
        return ol1 < ol2 ? -1 : -3;
    }

    protected static PySequence fastSequence(PyObject seq, String msg) {
        if (seq instanceof PySequence) {
            return (PySequence)seq;
        }
        PyList list = new PyList();
        PyObject iter = Py.iter(seq, msg);
        PyObject item = null;
        while ((item = iter.__iternext__()) != null) {
            list.append(item);
        }
        return list;
    }

    protected static final int sliceLength(int start, int stop, long step) {
        int ret = step > 0L ? (int)(((long)(stop - start) + step - 1L) / step) : (int)(((long)(stop - start) + step + 1L) / step);
        if (ret < 0) {
            return 0;
        }
        return ret;
    }

    protected int boundToSequence(int index) {
        int length = this.__len__();
        if (index < 0) {
            if ((index += length) < 0) {
                index = 0;
            }
        } else if (index > length) {
            index = length;
        }
        return index;
    }

    @Override
    public PyObject __finditem__(int index) {
        return this.seq___finditem__(index);
    }

    final PyObject seq___finditem__(int index) {
        return this.delegator.checkIdxAndFindItem(index);
    }

    @Override
    public PyObject __finditem__(PyObject index) {
        return this.seq___finditem__(index);
    }

    final PyObject seq___finditem__(PyObject index) {
        return this.delegator.checkIdxAndFindItem(index);
    }

    @Override
    public PyObject __getitem__(PyObject index) {
        return this.seq___getitem__(index);
    }

    final PyObject seq___getitem__(PyObject index) {
        return this.delegator.checkIdxAndGetItem(index);
    }

    @Override
    public boolean isMappingType() throws PyIgnoreMethodTag {
        return false;
    }

    @Override
    public boolean isNumberType() throws PyIgnoreMethodTag {
        return false;
    }

    @Override
    public PyObject __getslice__(PyObject start, PyObject stop, PyObject step) {
        return this.seq___getslice__(start, stop, step);
    }

    final PyObject seq___getslice__(PyObject start, PyObject stop, PyObject step) {
        return this.delegator.getSlice(new PySlice(start, stop, step));
    }

    @Override
    public void __setslice__(PyObject start, PyObject stop, PyObject step, PyObject value) {
        this.seq___setslice__(start, stop, step, value);
    }

    final void seq___setslice__(PyObject start, PyObject stop, PyObject step, PyObject value) {
        if (value == null) {
            value = step;
            step = null;
        }
        this.delegator.checkIdxAndSetSlice(new PySlice(start, stop, step), value);
    }

    @Override
    public void __delslice__(PyObject start, PyObject stop, PyObject step) {
        this.seq___delslice__(start, stop, step);
    }

    final void seq___delslice__(PyObject start, PyObject stop, PyObject step) {
        this.delegator.checkIdxAndDelItem(new PySlice(start, stop, step));
    }

    @Override
    public void __setitem__(int index, PyObject value) {
        this.delegator.checkIdxAndSetItem(index, value);
    }

    @Override
    public void __setitem__(PyObject index, PyObject value) {
        this.seq___setitem__(index, value);
    }

    final void seq___setitem__(PyObject index, PyObject value) {
        this.delegator.checkIdxAndSetItem(index, value);
    }

    @Override
    public void __delitem__(PyObject index) {
        this.seq___delitem__(index);
    }

    final void seq___delitem__(PyObject index) {
        this.delegator.checkIdxAndDelItem(index);
    }

    @Override
    public synchronized Object __tojava__(Class<?> c2) throws PyIgnoreMethodTag {
        if (c2.isArray()) {
            Class<?> component = c2.getComponentType();
            try {
                int n2 = this.__len__();
                PyArray array = new PyArray(component, n2);
                for (int i2 = 0; i2 < n2; ++i2) {
                    PyObject o2 = this.pyget(i2);
                    array.set(i2, o2);
                }
                return array.getArray();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.__tojava__(c2);
    }

    @Override
    protected String unsupportedopMessage(String op, PyObject o2) {
        if (op.equals("*")) {
            return "can''t multiply sequence by non-int of type ''{2}''";
        }
        return null;
    }

    @Override
    protected String runsupportedopMessage(String op, PyObject o2) {
        if (op.equals("*")) {
            return "can''t multiply sequence by non-int of type ''{1}''";
        }
        return null;
    }

    @Override
    public boolean isSequenceType() {
        return true;
    }
}

