/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyGenerator$PyExposer;
import org.python.core.PyIterator;
import org.python.core.PyObject;
import org.python.core.PyTraceback;
import org.python.core.PyType;
import org.python.core.ThreadState;
import org.python.expose.ExposedType;

@ExposedType(name="generator", base=PyObject.class, isBaseType=false)
public class PyGenerator
extends PyIterator {
    public static final PyType TYPE;
    protected PyFrame gi_frame;
    protected boolean gi_running;
    private PyObject closure;

    public PyGenerator(PyFrame frame, PyObject closure) {
        super(TYPE);
        this.gi_frame = frame;
        this.closure = closure;
    }

    public PyObject send(PyObject value) {
        return this.generator_send(value);
    }

    final PyObject generator_send(PyObject value) {
        if (this.gi_frame == null) {
            throw Py.StopIteration("");
        }
        if (this.gi_frame.f_lasti == 0 && value != Py.None) {
            throw Py.TypeError("can't send non-None value to a just-started generator");
        }
        this.gi_frame.setGeneratorInput(value);
        return this.next();
    }

    public PyObject throw$(PyObject type, PyObject value, PyObject tb) {
        return this.generator_throw$(type, value, tb);
    }

    final PyObject generator_throw$(PyObject type, PyObject value, PyObject tb) {
        if (tb == Py.None) {
            tb = null;
        } else if (tb != null && !(tb instanceof PyTraceback)) {
            throw Py.TypeError("throw() third argument must be a traceback object");
        }
        return this.raiseException(Py.makeException(type, value, tb));
    }

    public PyObject close() {
        return this.generator_close();
    }

    final PyObject generator_close() {
        try {
            this.raiseException(Py.makeException(Py.GeneratorExit));
            throw Py.RuntimeError("generator ignored GeneratorExit");
        }
        catch (PyException e2) {
            if (e2.type != Py.StopIteration && e2.type != Py.GeneratorExit) {
                throw e2;
            }
            return Py.None;
        }
    }

    public PyObject next() {
        return this.generator_next();
    }

    final PyObject generator_next() {
        return super.next();
    }

    public PyObject __iter__() {
        return this.generator___iter__();
    }

    final PyObject generator___iter__() {
        return this;
    }

    private PyObject raiseException(PyException ex) {
        if (this.gi_frame == null || this.gi_frame.f_lasti == 0) {
            this.gi_frame = null;
            throw ex;
        }
        this.gi_frame.setGeneratorInput(ex);
        return this.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        if (this.gi_frame == null || this.gi_frame.f_lasti == -1) {
            return;
        }
        try {
            this.close();
        }
        catch (PyException pye) {
            String className = PyException.exceptionClassName(pye.type);
            int lastDot = className.lastIndexOf(46);
            if (lastDot != -1) {
                className = className.substring(lastDot + 1);
            }
            String msg = String.format("Exception %s: %s in %s", className, pye.value.__repr__(), this.__repr__());
            Py.println(Py.getSystemState().stderr, Py.newString(msg));
        }
        catch (Throwable throwable) {
        }
        finally {
            super.finalize();
        }
    }

    public PyObject __iternext__() {
        return this.__iternext__(Py.getThreadState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PyObject __iternext__(ThreadState state) {
        if (this.gi_running) {
            throw Py.ValueError("generator already executing");
        }
        if (this.gi_frame == null) {
            return null;
        }
        if (this.gi_frame.f_lasti == -1) {
            this.gi_frame = null;
            return null;
        }
        this.gi_running = true;
        PyObject result = null;
        try {
            result = this.gi_frame.f_code.call(state, this.gi_frame, this.closure);
        }
        catch (PyException pye) {
            if (pye.type != Py.StopIteration && pye.type != Py.GeneratorExit) {
                this.gi_frame = null;
                throw pye;
            }
            this.stopException = pye;
            this.gi_frame = null;
            PyObject pyObject = null;
            return pyObject;
        }
        finally {
            this.gi_running = false;
        }
        if (result == Py.None && this.gi_frame.f_lasti == -1) {
            return null;
        }
        return result;
    }

    static {
        PyType.addBuilder(PyGenerator.class, new PyGenerator$PyExposer());
        TYPE = PyType.fromClass(PyGenerator.class);
    }
}

