/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;

public class PyFileReader
extends PyObject {
    static final int DEFAULT_BUF_SIZE = 1024;
    private final BufferedReader reader;
    private boolean closed;
    private char[] reuseableBuffer = null;

    public PyFileReader(Reader reader) {
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.closed = false;
    }

    public boolean closed() {
        return this.closed;
    }

    public void checkClosed() {
        if (this.closed()) {
            throw Py.ValueError("I/O operation on closed file");
        }
    }

    public synchronized void flush() {
        this.checkClosed();
    }

    public void close() {
        try {
            if (!this.closed()) {
                this.reader.close();
                this.closed = true;
            }
        }
        catch (IOException e2) {
            throw Py.IOError(e2);
        }
    }

    protected char[] needBuffer(int size) {
        if (this.reuseableBuffer == null) {
            if (size > 1024) {
                return new char[size];
            }
            this.reuseableBuffer = new char[1024];
        }
        if (size <= this.reuseableBuffer.length) {
            return this.reuseableBuffer;
        }
        return new char[size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PyString read(int n2) {
        if (n2 < 0) {
            BufferedReader bufferedReader = this.reader;
            synchronized (bufferedReader) {
                this.checkClosed();
                StringBuilder sb = new StringBuilder();
                char[] cbuf = this.needBuffer(1024);
                int buflen = cbuf.length;
                try {
                    int x2;
                    while ((x2 = this.reader.read(cbuf, 0, buflen)) >= 0) {
                        sb.append(cbuf, 0, x2);
                        if (x2 >= buflen) continue;
                        break;
                    }
                }
                catch (IOException e2) {
                    throw Py.IOError(e2);
                }
                return new PyString(sb.toString());
            }
        }
        BufferedReader bufferedReader = this.reader;
        synchronized (bufferedReader) {
            this.checkClosed();
            char[] cbuf = this.needBuffer(n2);
            int buflen = cbuf.length;
            try {
                int x3 = this.reader.read(cbuf, 0, n2);
                if (x3 < 1) {
                    return new PyString("");
                }
                return new PyString(new String(cbuf, 0, x3));
            }
            catch (IOException e3) {
                throw Py.IOError(e3);
            }
        }
    }

    public PyString read() {
        return this.read(-1);
    }

    public PyString readline(int max) {
        if (max >= 0) {
            throw Py.NotImplementedError("size argument to readline not implemented for PyFileReader");
        }
        BufferedReader bufferedReader = this.reader;
        synchronized (bufferedReader) {
            try {
                String line = this.reader.readLine();
                if (line == null) {
                    return new PyString("");
                }
                return new PyString(line + "\n");
            }
            catch (IOException e2) {
                throw Py.IOError(e2);
            }
        }
    }

    public PyString readline() {
        return this.readline(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PyObject readlines(int sizehint) {
        BufferedReader bufferedReader = this.reader;
        synchronized (bufferedReader) {
            PyString line;
            int len;
            this.checkClosed();
            PyList list = new PyList();
            int size = 0;
            while ((len = (line = this.readline(-1)).getString().length()) != 0) {
                list.append(line);
                if (sizehint <= 0 || (size += len) < sizehint) continue;
            }
            return list;
        }
    }

    public PyObject readlines() {
        return this.readlines(0);
    }
}

