/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.python.core.CodeFlag;
import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyBaseCode;
import org.python.core.PyCell;
import org.python.core.PyCode;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyFunction;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySequenceList;
import org.python.core.PySlice;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.PyTraceback;
import org.python.core.PyTuple;
import org.python.core.ThreadState;
import org.python.core.__builtin__;
import org.python.core.imp;

public class PyBytecode
extends PyBaseCode {
    private int count = 0;
    private int maxCount = -1;
    public static boolean defaultDebug = false;
    private static PyObject dis;
    private static PyObject opname;
    private boolean debug = defaultDebug;
    public static final int CO_MAXBLOCKS = 20;
    public final byte[] co_code;
    public final PyObject[] co_consts;
    public final String[] co_names;
    public final int co_stacksize;
    public final byte[] co_lnotab;
    private static final int CALL_FLAG_VAR = 1;
    private static final int CALL_FLAG_KW = 2;
    private static final String[] __members__;

    private static synchronized PyObject get_dis() {
        if (dis == null) {
            dis = __builtin__.__import__("dis");
        }
        return dis;
    }

    private static synchronized PyObject get_opname() {
        if (opname == null) {
            opname = PyBytecode.get_dis().__getattr__("opname");
        }
        return opname;
    }

    public static void _allDebug(boolean setting) {
        defaultDebug = setting;
    }

    public PyObject _debug(int maxCount) {
        this.debug = maxCount > 0;
        this.maxCount = maxCount;
        return Py.None;
    }

    public PyBytecode(int argcount, int nlocals, int stacksize, int flags, String codestring, PyObject[] constants, String[] names, String[] varnames, String filename, String name, int firstlineno, String lnotab) {
        this(argcount, nlocals, stacksize, flags, codestring, constants, names, varnames, filename, name, firstlineno, lnotab, null, null);
    }

    public PyBytecode(int argcount, int nlocals, int stacksize, int flags, String codestring, PyObject[] constants, String[] names, String[] varnames, String filename, String name, int firstlineno, String lnotab, String[] cellvars, String[] freevars) {
        this.co_argcount = this.nargs = argcount;
        this.co_varnames = varnames;
        this.co_nlocals = nlocals;
        this.co_filename = filename;
        this.co_firstlineno = firstlineno;
        this.co_cellvars = cellvars;
        this.co_freevars = freevars;
        this.co_name = name;
        this.co_flags = new CompilerFlags(flags);
        this.varargs = this.co_flags.isFlagSet(CodeFlag.CO_VARARGS);
        this.varkwargs = this.co_flags.isFlagSet(CodeFlag.CO_VARKEYWORDS);
        this.co_stacksize = stacksize;
        this.co_consts = constants;
        this.co_names = names;
        this.co_code = PyBytecode.getBytes(codestring);
        this.co_lnotab = PyBytecode.getBytes(lnotab);
    }

    public PyObject __dir__() {
        PyObject[] members = new PyString[__members__.length];
        for (int i2 = 0; i2 < __members__.length; ++i2) {
            members[i2] = new PyString(__members__[i2]);
        }
        return new PyList(members);
    }

    private void throwReadonly(String name) {
        for (int i2 = 0; i2 < __members__.length; ++i2) {
            if (__members__[i2] != name) continue;
            throw Py.TypeError("readonly attribute");
        }
        throw Py.AttributeError(name);
    }

    public void __setattr__(String name, PyObject value) {
        this.throwReadonly(name);
    }

    public void __delattr__(String name) {
        this.throwReadonly(name);
    }

    private static PyTuple toPyStringTuple(String[] ar2) {
        if (ar2 == null) {
            return Py.EmptyTuple;
        }
        int sz = ar2.length;
        PyObject[] pystr = new PyString[sz];
        for (int i2 = 0; i2 < sz; ++i2) {
            pystr[i2] = new PyString(ar2[i2]);
        }
        return new PyTuple(pystr);
    }

    public PyObject __findattr_ex__(String name) {
        if (name == "co_varnames") {
            return PyBytecode.toPyStringTuple(this.co_varnames);
        }
        if (name == "co_cellvars") {
            return PyBytecode.toPyStringTuple(this.co_cellvars);
        }
        if (name == "co_freevars") {
            return PyBytecode.toPyStringTuple(this.co_freevars);
        }
        if (name == "co_filename") {
            return new PyString(this.co_filename);
        }
        if (name == "co_name") {
            return new PyString(this.co_name);
        }
        if (name == "co_code") {
            return new PyString(PyBytecode.getString(this.co_code));
        }
        if (name == "co_lnotab") {
            return new PyString(PyBytecode.getString(this.co_lnotab));
        }
        if (name == "co_consts") {
            return new PyTuple(this.co_consts);
        }
        if (name == "co_flags") {
            return Py.newInteger(this.co_flags.toBits());
        }
        return super.__findattr_ex__(name);
    }

    private static String stringify_blocks(PyFrame f2) {
        if (f2.f_exits == null || f2.f_lineno == 0) {
            return "[]";
        }
        StringBuilder buf = new StringBuilder("[");
        int len = f2.f_lineno;
        for (int i2 = 0; i2 < len; ++i2) {
            buf.append(f2.f_exits[i2].toString());
            if (i2 >= len - 1) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    private void print_debug(int count, int next_instr, int line, int opcode2, int oparg, PyStack stack, PyFrame f2) {
        if (this.debug) {
            System.err.println(this.co_name + " " + line + ":" + count + "," + f2.f_lasti + "> " + PyBytecode.get_opname().__getitem__(Py.newInteger(opcode2)) + (opcode2 >= 90 ? " " + oparg : "") + ", stack: " + stack.toString() + ", blocks: " + PyBytecode.stringify_blocks(f2));
        }
    }

    private static PyTryBlock popBlock(PyFrame f2) {
        return (PyTryBlock)((PyList)f2.f_exits[0]).pop();
    }

    private static void pushBlock(PyFrame f2, PyTryBlock block) {
        if (f2.f_exits == null) {
            f2.f_exits = new PyObject[1];
            f2.f_exits[0] = new PyList();
        }
        ((PyList)f2.f_exits[0]).append(block);
    }

    private boolean blocksLeft(PyFrame f2) {
        if (f2.f_exits != null) {
            return ((PyList)f2.f_exits[0]).__nonzero__();
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected PyObject interpret(PyFrame f, ThreadState ts) {
        stack = new PyStack();
        next_instr = -1;
        var5_5 = false;
        oparg = Why.NOT;
        why = null;
        retval = null;
        lineCache = -1;
        last_line = 0;
        if (this.debug) {
            System.err.println(this.co_name + ":" + f.f_lasti + "/" + this.co_code.length + ", cells:" + Arrays.toString(this.co_cellvars) + ", free:" + Arrays.toString(this.co_freevars));
            line = 0;
            for (String i$ : this.co_cellvars) {
                System.err.println(i$ + " = " + f.f_env[line++]);
            }
            for (String i$ : this.co_freevars) {
                System.err.println(i$ + " = " + f.f_env[line++]);
            }
            PyBytecode.get_dis().invoke("disassemble", this);
        }
        if (f.f_lasti >= this.co_code.length) {
            throw Py.SystemError("");
        }
        next_instr = f.f_lasti;
        line = 0;
        if (f.f_savedlocals != null) {
            for (checkGeneratorInput = 0; checkGeneratorInput < f.f_savedlocals.length; ++checkGeneratorInput) {
                i = (PyObject)f.f_savedlocals[checkGeneratorInput];
                stack.push(i);
            }
            line = 1;
            f.f_savedlocals = null;
        }
        while (!this.debug || this.maxCount == -1 || this.count < this.maxCount) {
            block197: {
                if (f.tracefunc != null || this.debug) {
                    if (retval == null) {
                        retval = new LineCache();
                        if (this.debug) {
                            System.err.println("LineCache: " + retval.toString());
                        }
                    }
                    if ((last_line = LineCache.access$100(retval, next_instr)) != lineCache) {
                        f.setline(last_line);
                    }
                }
                try {
                    if (line != 0) {
                        line = 0;
                        checkGeneratorInput = f.getGeneratorInput();
                        if (checkGeneratorInput instanceof PyException) {
                            throw (PyException)checkGeneratorInput;
                        }
                        stack.push((PyObject)checkGeneratorInput);
                    }
                    if ((freevar = PyBytecode.getUnsigned(this.co_code, next_instr)) >= 'Z') {
                        opcode = (PyBytecode.getUnsigned(this.co_code, next_instr += 2) << 8) + PyBytecode.getUnsigned(this.co_code, next_instr - 1);
                    }
                    this.print_debug(this.count, next_instr, last_line, freevar, opcode, stack, f);
                    ++this.count;
                    f.f_lasti = ++next_instr;
                    block3 : switch (freevar) {
                        case '\t': {
                            break;
                        }
                        case '|': {
                            stack.push(f.getlocal(opcode));
                            break;
                        }
                        case 'd': {
                            stack.push(this.co_consts[opcode]);
                            break;
                        }
                        case '}': {
                            f.setlocal(opcode, stack.pop());
                            break;
                        }
                        case '\u0001': {
                            stack.pop();
                            break;
                        }
                        case '\u0002': {
                            stack.rot2();
                            break;
                        }
                        case '\u0003': {
                            stack.rot3();
                            break;
                        }
                        case '\u0005': {
                            stack.rot4();
                            break;
                        }
                        case '\u0004': {
                            stack.dup();
                            break;
                        }
                        case 'c': {
                            if (opcode == 2 || opcode == 3) {
                                stack.dup(opcode);
                                break;
                            }
                            throw Py.RuntimeError("invalid argument to DUP_TOPX (bytecode corruption?)");
                        }
                        case '\n': {
                            stack.push(stack.pop().__pos__());
                            break;
                        }
                        case '\u000b': {
                            stack.push(stack.pop().__neg__());
                            break;
                        }
                        case '\f': {
                            stack.push(stack.pop().__not__());
                            break;
                        }
                        case '\r': {
                            stack.push(stack.pop().__repr__());
                            break;
                        }
                        case '\u000f': {
                            stack.push(stack.pop().__invert__());
                            break;
                        }
                        case '\u0013': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            stack.push(b._pow(checkGeneratorInput));
                            break;
                        }
                        case '\u0014': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            stack.push(b._mul(checkGeneratorInput));
                            break;
                        }
                        case '\u0015': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            if (!this.co_flags.isFlagSet(CodeFlag.CO_FUTURE_DIVISION)) {
                                stack.push(b._div(checkGeneratorInput));
                                break;
                            }
                            stack.push(b._truediv(checkGeneratorInput));
                            break;
                        }
                        case '\u001b': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            stack.push(b._truediv(checkGeneratorInput));
                            break;
                        }
                        case '\u001a': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            stack.push(b._floordiv(checkGeneratorInput));
                            break;
                        }
                        case '\u0016': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            stack.push(b._mod(checkGeneratorInput));
                            break;
                        }
                        case '\u0017': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            stack.push(b._add(checkGeneratorInput));
                            break;
                        }
                        case '\u0018': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            stack.push(b._sub(checkGeneratorInput));
                            break;
                        }
                        case '\u0019': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            stack.push(b.__getitem__(checkGeneratorInput));
                            break;
                        }
                        case '>': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            stack.push(b._lshift(checkGeneratorInput));
                            break;
                        }
                        case '?': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            stack.push(b._rshift(checkGeneratorInput));
                            break;
                        }
                        case '@': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            stack.push(b._and(checkGeneratorInput));
                            break;
                        }
                        case 'A': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            stack.push(b._xor(checkGeneratorInput));
                            break;
                        }
                        case 'B': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            stack.push(b._or(checkGeneratorInput));
                            break;
                        }
                        case '\u0012': {
                            checkGeneratorInput = stack.pop();
                            b = (PyList)stack.pop();
                            b.append(checkGeneratorInput);
                            break;
                        }
                        case 'C': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            stack.push(b._ipow(checkGeneratorInput));
                            break;
                        }
                        case '9': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            stack.push(b._imul(checkGeneratorInput));
                            break;
                        }
                        case ':': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            if (!this.co_flags.isFlagSet(CodeFlag.CO_FUTURE_DIVISION)) {
                                stack.push(b._idiv(checkGeneratorInput));
                                break;
                            }
                            stack.push(b._itruediv(checkGeneratorInput));
                            break;
                        }
                        case '\u001d': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            stack.push(b._itruediv(checkGeneratorInput));
                            break;
                        }
                        case '\u001c': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            stack.push(b._ifloordiv(checkGeneratorInput));
                            break;
                        }
                        case ';': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            stack.push(b._imod(checkGeneratorInput));
                            break;
                        }
                        case '7': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            stack.push(b._iadd(checkGeneratorInput));
                            break;
                        }
                        case '8': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            stack.push(b._isub(checkGeneratorInput));
                            break;
                        }
                        case 'K': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            stack.push(b._ilshift(checkGeneratorInput));
                            break;
                        }
                        case 'L': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            stack.push(b._irshift(checkGeneratorInput));
                            break;
                        }
                        case 'M': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            stack.push(b._iand(checkGeneratorInput));
                            break;
                        }
                        case 'N': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            stack.push(b._ixor(checkGeneratorInput));
                            break;
                        }
                        case 'O': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            stack.push(b._ior(checkGeneratorInput));
                            break;
                        }
                        case '\u001e': 
                        case '\u001f': 
                        case ' ': 
                        case '!': {
                            checkGeneratorInput = (freevar - 30 & 2) != 0 ? stack.pop() : null;
                            stop = (freevar - 30 & 1) != 0 ? stack.pop() : null;
                            start = stack.pop();
                            stack.push(start.__getslice__(stop, checkGeneratorInput));
                            break;
                        }
                        case '(': 
                        case ')': 
                        case '*': 
                        case '+': {
                            checkGeneratorInput = (freevar - 40 & 2) != 0 ? stack.pop() : null;
                            stop = (freevar - 40 & 1) != 0 ? stack.pop() : null;
                            start = stack.pop();
                            obj = stack.pop();
                            start.__setslice__(stop, checkGeneratorInput, obj);
                            break;
                        }
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': {
                            checkGeneratorInput = (value - 50 & 2) != 0 ? stack.pop() : null;
                            stop = (value - 50 & 1) != 0 ? stack.pop() : null;
                            start = stack.pop();
                            start.__delslice__(stop, checkGeneratorInput);
                            break;
                        }
                        case '<': {
                            checkGeneratorInput = stack.pop();
                            key = stack.pop();
                            obj = stack.pop();
                            key.__setitem__(checkGeneratorInput, obj);
                            break;
                        }
                        case '=': {
                            checkGeneratorInput = stack.pop();
                            key = stack.pop();
                            key.__delitem__(checkGeneratorInput);
                            break;
                        }
                        case 'F': {
                            PySystemState.displayhook(stack.pop());
                            break;
                        }
                        case 'I': {
                            Py.printComma(stack.pop(), stack.pop());
                            break;
                        }
                        case 'G': {
                            Py.printComma(stack.pop());
                            break;
                        }
                        case 'J': {
                            Py.printlnv(stack.pop());
                            break;
                        }
                        case 'H': {
                            Py.println();
                            break;
                        }
                        case '\u0082': {
                            switch (opcode) {
                                case 3: {
                                    checkGeneratorInput = (PyTraceback)stack.pop();
                                    tb = stack.pop();
                                    value = stack.pop();
                                    throw PyException.doRaise(value, tb, checkGeneratorInput);
                                }
                                case 2: {
                                    checkGeneratorInput = stack.pop();
                                    value = stack.pop();
                                    throw PyException.doRaise(value, checkGeneratorInput, null);
                                }
                                case 1: {
                                    checkGeneratorInput = stack.pop();
                                    throw PyException.doRaise(checkGeneratorInput, null, null);
                                }
                                case 0: {
                                    throw PyException.doRaise(null, null, null);
                                }
                            }
                            throw Py.SystemError("bad RAISE_VARARGS oparg");
                        }
                        case 'R': {
                            stack.push(f.f_locals);
                            break;
                        }
                        case 'S': {
                            why = stack.pop();
                            oparg = Why.RETURN;
                            break;
                        }
                        case 'V': {
                            why = stack.pop();
                            oparg = Why.YIELD;
                            break;
                        }
                        case 'U': {
                            checkGeneratorInput = stack.pop();
                            locals = stack.pop();
                            globals = stack.pop();
                            Py.exec(globals, locals == Py.None ? null : locals, checkGeneratorInput == Py.None ? null : checkGeneratorInput);
                            break;
                        }
                        case 'W': {
                            checkGeneratorInput = PyBytecode.popBlock(f);
                            while (stack.size() > checkGeneratorInput.b_level) {
                                stack.pop();
                            }
                            break;
                        }
                        case 'X': {
                            checkGeneratorInput = stack.pop();
                            if (checkGeneratorInput instanceof PyStackWhy) {
                                oparg = ((PyStackWhy)checkGeneratorInput).why;
                                if (!PyBytecode.$assertionsDisabled && oparg == Why.YIELD) {
                                    throw new AssertionError();
                                }
                                if (oparg == Why.RETURN || oparg == Why.CONTINUE) {
                                    why = stack.pop();
                                }
                            } else {
                                if (checkGeneratorInput instanceof PyStackException) {
                                    ts.exception = ((PyStackException)checkGeneratorInput).exception;
                                    oparg = Why.RERAISE;
                                    break;
                                }
                                if (checkGeneratorInput instanceof PyString) {
                                    oparg = Why.RERAISE;
                                    break;
                                }
                                if (checkGeneratorInput != Py.None) {
                                    throw Py.SystemError("'finally' pops bad exception");
                                }
                            }
                            break;
                        }
                        case 'Y': {
                            checkGeneratorInput = stack.pop();
                            methods = ((PySequenceList)stack.pop()).getArray();
                            bases = stack.pop().toString();
                            stack.push(Py.makeClass(bases, methods, checkGeneratorInput));
                            break;
                        }
                        case 'Z': {
                            f.setlocal(this.co_names[opcode], stack.pop());
                            break;
                        }
                        case '[': {
                            f.dellocal(this.co_names[opcode]);
                            break;
                        }
                        case '\\': {
                            PyBytecode.unpack_iterable(opcode, stack);
                            break;
                        }
                        case '_': {
                            checkGeneratorInput = stack.pop();
                            obj = stack.pop();
                            checkGeneratorInput.__setattr__(this.co_names[opcode], obj);
                            break;
                        }
                        case '`': {
                            stack.pop().__delattr__(this.co_names[opcode]);
                            break;
                        }
                        case 'a': {
                            f.setglobal(this.co_names[opcode], stack.pop());
                            break;
                        }
                        case 'b': {
                            f.delglobal(this.co_names[opcode]);
                            break;
                        }
                        case 'e': {
                            stack.push(f.getname(this.co_names[opcode]));
                            break;
                        }
                        case 't': {
                            stack.push(f.getglobal(this.co_names[opcode]));
                            break;
                        }
                        case '~': {
                            f.dellocal(opcode);
                            break;
                        }
                        case '\u0087': {
                            checkGeneratorInput = (PyCell)f.getclosure(opcode);
                            if (checkGeneratorInput.ob_ref == null) {
                                cell = opcode >= this.co_cellvars.length ? this.co_freevars[opcode - this.co_cellvars.length] : this.co_cellvars[opcode];
                                if (f.f_fastlocals != null) {
                                    name = 0;
                                    i = false;
                                    for (String match : this.co_varnames) {
                                        if (match.equals(cell)) {
                                            i = true;
                                            break;
                                        }
                                        ++name;
                                    }
                                    if (i) {
                                        checkGeneratorInput.ob_ref = f.f_fastlocals[name];
                                    }
                                } else {
                                    checkGeneratorInput.ob_ref = f.f_locals.__finditem__(cell);
                                }
                            }
                            stack.push(checkGeneratorInput);
                            break;
                        }
                        case '\u0088': {
                            checkGeneratorInput = (PyCell)f.getclosure(opcode);
                            if (checkGeneratorInput.ob_ref == null) {
                                cell = opcode >= this.co_cellvars.length ? this.co_freevars[opcode - this.co_cellvars.length] : this.co_cellvars[opcode];
                                if (f.f_fastlocals != null) {
                                    name = 0;
                                    i = false;
                                    for (String match : this.co_varnames) {
                                        if (match.equals(cell)) {
                                            i = true;
                                            break;
                                        }
                                        ++name;
                                    }
                                    if (i) {
                                        checkGeneratorInput.ob_ref = f.f_fastlocals[name];
                                    }
                                } else {
                                    checkGeneratorInput.ob_ref = f.f_locals.__finditem__(cell);
                                }
                            }
                            stack.push(checkGeneratorInput.ob_ref);
                            break;
                        }
                        case '\u0089': {
                            f.setderef(opcode, stack.pop());
                            break;
                        }
                        case 'f': {
                            stack.push(new PyTuple(stack.popN(opcode)));
                            break;
                        }
                        case 'g': {
                            stack.push(new PyList(stack.popN(opcode)));
                            break;
                        }
                        case 'h': {
                            stack.push(new PyDictionary());
                            break;
                        }
                        case 'i': {
                            checkGeneratorInput = this.co_names[opcode];
                            stack.push(stack.pop().__getattr__(checkGeneratorInput));
                            break;
                        }
                        case 'j': {
                            checkGeneratorInput = stack.pop();
                            b = stack.pop();
                            switch (opcode) {
                                case 0: {
                                    stack.push(b._lt(checkGeneratorInput));
                                    break block3;
                                }
                                case 1: {
                                    stack.push(b._le(checkGeneratorInput));
                                    break block3;
                                }
                                case 2: {
                                    stack.push(b._eq(checkGeneratorInput));
                                    break block3;
                                }
                                case 3: {
                                    stack.push(b._ne(checkGeneratorInput));
                                    break block3;
                                }
                                case 4: {
                                    stack.push(b._gt(checkGeneratorInput));
                                    break block3;
                                }
                                case 5: {
                                    stack.push(b._ge(checkGeneratorInput));
                                    break block3;
                                }
                                case 6: {
                                    stack.push(b._in(checkGeneratorInput));
                                    break block3;
                                }
                                case 7: {
                                    stack.push(b._notin(checkGeneratorInput));
                                    break block3;
                                }
                                case 8: {
                                    stack.push(b._is(checkGeneratorInput));
                                    break block3;
                                }
                                case 9: {
                                    stack.push(b._isnot(checkGeneratorInput));
                                    break block3;
                                }
                                case 10: {
                                    if (b instanceof PyStackException) {
                                        a = ((PyStackException)b).exception;
                                        stack.push(Py.newBoolean(a.match(checkGeneratorInput)));
                                        break block3;
                                    }
                                    stack.push(Py.newBoolean(new PyException(b).match(checkGeneratorInput)));
                                }
                            }
                            break;
                        }
                        case 'k': {
                            checkGeneratorInput = f.f_builtins.__finditem__("__import__");
                            if (checkGeneratorInput == null) {
                                throw Py.ImportError("__import__ not found");
                            }
                            __import__ = Py.newString(this.co_names[opcode]);
                            name = stack.pop();
                            fromlist = stack.pop();
                            if (fromlist.asInt() != -1) {
                                stack.push(checkGeneratorInput.__call__(new PyObject[]{__import__, f.f_globals, f.f_locals, name, fromlist}));
                                break;
                            }
                            stack.push(checkGeneratorInput.__call__(new PyObject[]{__import__, f.f_globals, f.f_locals, name}));
                            break;
                        }
                        case 'T': {
                            checkGeneratorInput = stack.pop();
                            imp.importAll(checkGeneratorInput, f);
                            break;
                        }
                        case 'l': {
                            checkGeneratorInput = this.co_names[opcode];
                            try {
                                stack.push(stack.top().__getattr__(checkGeneratorInput));
                                break;
                            }
                            catch (PyException name) {
                                if (name.match(Py.AttributeError)) {
                                    throw Py.ImportError(String.format("cannot import name %.230s", new Object[]{checkGeneratorInput}));
                                }
                                throw name;
                            }
                        }
                        case 'n': {
                            next_instr += opcode;
                            break;
                        }
                        case 'o': {
                            if (!stack.top().__nonzero__()) {
                                next_instr += opcode;
                            }
                            break;
                        }
                        case 'p': {
                            if (stack.top().__nonzero__()) {
                                next_instr += opcode;
                            }
                            break;
                        }
                        case 'q': {
                            next_instr = opcode;
                            break;
                        }
                        case 'D': {
                            name = stack.top().__iter__();
                            if (name != null) {
                                stack.set_top(name);
                            }
                            break;
                        }
                        case ']': {
                            name = stack.pop();
                            try {
                                it = name.__iternext__();
                                if (it != null) {
                                    stack.push(name);
                                    stack.push(it);
                                    break;
                                }
                            }
                            catch (PyException it) {
                                if (it.match(Py.StopIteration)) ** GOTO lbl543
                                throw it;
                            }
lbl543:
                            // 2 sources

                            next_instr += opcode;
                            break;
                        }
                        case 'P': {
                            oparg = Why.BREAK;
                            break;
                        }
                        case 'w': {
                            why = Py.newInteger(opcode);
                            if (why.__nonzero__()) {
                                oparg = Why.CONTINUE;
                            }
                            break;
                        }
                        case 'x': 
                        case 'y': 
                        case 'z': {
                            PyBytecode.pushBlock(f, new PyTryBlock((int)level, next_instr + opcode, stack.size()));
                            break;
                        }
                        case 'Q': {
                            name = stack.top();
                            exit = stack.top(2);
                            if (exit == Py.None || exit instanceof PyStackWhy) {
                                u = w = Py.None;
                                exit = w;
                            } else {
                                u = stack.top(3);
                                w = stack.top(4);
                            }
                            x = null;
                            if (exit instanceof PyStackException) {
                                exc = ((PyStackException)exit).exception;
                                x = name.__call__(exc.type, exc.value, (PyObject)exc.traceback);
                            } else {
                                x = name.__call__(exit, u, w);
                            }
                            if (exit != Py.None && x != null && x.__nonzero__()) {
                                stack.popN(4);
                                stack.push(Py.None);
                                break;
                            }
                            stack.pop();
                            break;
                        }
                        case '\u0083': {
                            name = opcode & 255;
                            na = opcode >> 8 & 255;
                            if (na == 0) {
                                PyBytecode.call_function(name, stack);
                                break;
                            }
                            PyBytecode.call_function(name, na, stack);
                            break;
                        }
                        case '\u008c': 
                        case '\u008d': 
                        case '\u008e': {
                            name = opcode & 255;
                            na = opcode >> 8 & 255;
                            nk = v - 131 & 3;
                            PyBytecode.call_function(name, na, (nk & 1) != 0, (nk & 2) != 0, stack);
                            break;
                        }
                        case '\u0084': {
                            name = (PyCode)stack.pop();
                            code = stack.popN(opcode);
                            defaults = null;
                            if (name instanceof PyBytecode && ((PyBytecode)name).co_consts.length > 0) {
                                defaults = ((PyBytecode)name).co_consts[0];
                            }
                            func = new PyFunction(f.f_globals, code, name, defaults);
                            stack.push(func);
                            break;
                        }
                        case '\u0086': {
                            name = (PyCode)stack.pop();
                            code = ((PySequenceList)stack.pop()).getArray();
                            closure_cells = stack.popN(opcode);
                            doc = null;
                            if (name instanceof PyBytecode && ((PyBytecode)name).co_consts.length > 0) {
                                doc = ((PyBytecode)name).co_consts[0];
                            }
                            func = new PyFunction(f.f_globals, closure_cells, name, doc, code);
                            stack.push(func);
                            break;
                        }
                        case '\u0085': {
                            name = opcode == 3 ? stack.pop() : null;
                            step = stack.pop();
                            stop = stack.pop();
                            stack.push(new PySlice(stop, step, name));
                            break;
                        }
                        case '\u008f': {
                            var16_144 = PyBytecode.getUnsigned(this.co_code, next_instr++);
                            opcode = opcode << 16 | (PyBytecode.getUnsigned(this.co_code, next_instr += 2) << 8) + PyBytecode.getUnsigned(this.co_code, next_instr - 1);
                            break;
                        }
                        default: {
                            Py.print(Py.getSystemState().stderr, Py.newString(String.format("XXX lineno: %d, opcode: %d\n", new Object[]{f.f_lasti, (int)var16_144})));
                            throw Py.SystemError("unknown opcode");
                        }
                    }
                }
                catch (Throwable checkGeneratorInput) {
                    t = Py.setException(checkGeneratorInput, f);
                    oparg = Why.EXCEPTION;
                    ts.exception = t;
                    if (!this.debug) break block197;
                    System.err.println("Caught exception:" + t);
                }
            }
            if (oparg == Why.YIELD) break;
            if (oparg == Why.RERAISE) {
                oparg = Why.EXCEPTION;
            }
            while (oparg != Why.NOT && this.blocksLeft(f)) {
                checkGeneratorInput = PyBytecode.popBlock(f);
                if (this.debug) {
                    System.err.println("Processing block: " + checkGeneratorInput);
                }
                if (!PyBytecode.$assertionsDisabled && oparg == Why.YIELD) {
                    throw new AssertionError();
                }
                if (checkGeneratorInput.b_type == 120 && oparg == Why.CONTINUE) {
                    PyBytecode.pushBlock(f, checkGeneratorInput);
                    oparg = Why.NOT;
                    next_instr = why.asInt();
                    break;
                }
                while (stack.size() > checkGeneratorInput.b_level) {
                    stack.pop();
                }
                if (checkGeneratorInput.b_type == 120 && oparg == Why.BREAK) {
                    oparg = Why.NOT;
                    next_instr = checkGeneratorInput.b_handler;
                    break;
                }
                if (checkGeneratorInput.b_type != 122 && (checkGeneratorInput.b_type != 121 || oparg != Why.EXCEPTION)) continue;
                if (oparg == Why.EXCEPTION) {
                    b = ts.exception;
                    if (checkGeneratorInput.b_type == 121) {
                        b.normalize();
                    }
                    stack.push(b.traceback);
                    stack.push(b.value);
                    stack.push(new PyStackException(b));
                } else {
                    if (oparg == Why.RETURN || oparg == Why.CONTINUE) {
                        stack.push(why);
                    }
                    stack.push(new PyStackWhy(oparg));
                }
                oparg = Why.NOT;
                next_instr = checkGeneratorInput.b_handler;
                break;
            }
            if (oparg == Why.NOT) continue;
        }
        if (oparg != Why.YIELD) {
            while (stack.size() > 0) {
                stack.pop();
            }
            if (oparg != Why.RETURN) {
                why = Py.None;
            }
        } else {
            f.f_savedlocals = stack.popN(stack.size());
        }
        f.f_lasti = next_instr;
        if (this.debug) {
            System.err.println(this.count + "," + f.f_lasti + "> Returning from " + (Object)oparg + ": " + why + ", stack: " + stack.toString() + ", blocks: " + PyBytecode.stringify_blocks(f));
        }
        if (oparg == Why.EXCEPTION) {
            throw ts.exception;
        }
        if (this.co_flags.isFlagSet(CodeFlag.CO_GENERATOR) && oparg == Why.RETURN && why == Py.None) {
            f.f_lasti = -1;
        }
        return why;
    }

    private static void call_function(int na, PyStack stack) {
        switch (na) {
            case 0: {
                PyObject callable = stack.pop();
                stack.push(callable.__call__());
                break;
            }
            case 1: {
                PyObject arg = stack.pop();
                PyObject callable = stack.pop();
                stack.push(callable.__call__(arg));
                break;
            }
            case 2: {
                PyObject arg1 = stack.pop();
                PyObject arg0 = stack.pop();
                PyObject callable = stack.pop();
                stack.push(callable.__call__(arg0, arg1));
                break;
            }
            case 3: {
                PyObject arg2 = stack.pop();
                PyObject arg1 = stack.pop();
                PyObject arg0 = stack.pop();
                PyObject callable = stack.pop();
                stack.push(callable.__call__(arg0, arg1, arg2));
                break;
            }
            case 4: {
                PyObject arg3 = stack.pop();
                PyObject arg2 = stack.pop();
                PyObject arg1 = stack.pop();
                PyObject arg0 = stack.pop();
                PyObject callable = stack.pop();
                stack.push(callable.__call__(arg0, arg1, arg2, arg3));
                break;
            }
            default: {
                PyObject[] args = stack.popN(na);
                PyObject callable = stack.pop();
                stack.push(callable.__call__(args));
            }
        }
    }

    private static void call_function(int na, int nk, PyStack stack) {
        int i2;
        int n2 = na + nk * 2;
        PyObject[] params = stack.popN(n2);
        PyObject callable = stack.pop();
        PyObject[] args = new PyObject[na + nk];
        String[] keywords = new String[nk];
        for (i2 = 0; i2 < na; ++i2) {
            args[i2] = params[i2];
        }
        int j2 = 0;
        while (i2 < n2) {
            keywords[j2] = params[i2].toString();
            args[na + j2] = params[i2 + 1];
            i2 += 2;
            ++j2;
        }
        stack.push(callable.__call__(args, keywords));
    }

    private static void call_function(int na, int nk, boolean var, boolean kw, PyStack stack) {
        int i2;
        int n2 = na + nk * 2;
        PyObject kwargs = kw ? stack.pop() : null;
        PyObject starargs = var ? stack.pop() : null;
        PyObject[] params = stack.popN(n2);
        PyObject callable = stack.pop();
        PyObject[] args = new PyObject[na + nk];
        String[] keywords = new String[nk];
        for (i2 = 0; i2 < na; ++i2) {
            args[i2] = params[i2];
        }
        int j2 = 0;
        while (i2 < n2) {
            keywords[j2] = params[i2].toString();
            args[na + j2] = params[i2 + 1];
            i2 += 2;
            ++j2;
        }
        stack.push(callable._callextra(args, keywords, starargs, kwargs));
    }

    private static void unpack_iterable(int oparg, PyStack stack) {
        PyObject v2 = stack.pop();
        int i2 = oparg;
        PyObject[] items = new PyObject[oparg];
        for (PyObject item : v2.asIterable()) {
            if (i2 <= 0) {
                throw Py.ValueError("too many values to unpack");
            }
            items[--i2] = item;
        }
        if (i2 > 0) {
            throw Py.ValueError(String.format("need more than %d value%s to unpack", i2, i2 == 1 ? "" : "s"));
        }
        for (i2 = 0; i2 < oparg; ++i2) {
            stack.push(items[i2]);
        }
    }

    protected int getline(PyFrame f2) {
        int addrq = f2.f_lasti;
        int size = this.co_lnotab.length / 2;
        int p2 = 0;
        int line = this.co_firstlineno;
        int addr = 0;
        while (--size >= 0 && (addr += PyBytecode.getUnsigned(this.co_lnotab, p2++)) <= addrq) {
            line += PyBytecode.getUnsigned(this.co_lnotab, p2++);
        }
        return line;
    }

    private static char getUnsigned(byte[] x2, int i2) {
        byte b2 = x2[i2];
        if (b2 < 0) {
            return (char)(b2 + 256);
        }
        return (char)b2;
    }

    private static String getString(byte[] x2) {
        StringBuilder buffer = new StringBuilder(x2.length);
        for (int i2 = 0; i2 < x2.length; ++i2) {
            buffer.append(PyBytecode.getUnsigned(x2, i2));
        }
        return buffer.toString();
    }

    private static byte[] getBytes(String s2) {
        int len = s2.length();
        byte[] x2 = new byte[len];
        for (int i2 = 0; i2 < len; ++i2) {
            x2[i2] = (byte)(s2.charAt(i2) & 0xFF);
        }
        return x2;
    }

    static {
        __members__ = new String[]{"co_name", "co_argcount", "co_varnames", "co_filename", "co_firstlineno", "co_flags", "co_cellvars", "co_freevars", "co_nlocals", "co_code", "co_consts", "co_names", "co_lnotab", "co_stacksize"};
    }

    private class LineCache {
        List<Integer> addr_breakpoints = new ArrayList<Integer>();
        List<Integer> lines = new ArrayList<Integer>();

        private LineCache() {
            int size = PyBytecode.this.co_lnotab.length / 2;
            int p2 = 0;
            int lastline = -1;
            int line = PyBytecode.this.co_firstlineno;
            int addr = 0;
            while (--size >= 0) {
                char byte_incr = PyBytecode.getUnsigned(PyBytecode.this.co_lnotab, p2++);
                char line_incr = PyBytecode.getUnsigned(PyBytecode.this.co_lnotab, p2++);
                if (byte_incr > '\u0000') {
                    if (line != lastline) {
                        this.addr_breakpoints.add(addr);
                        this.lines.add(line);
                        lastline = line;
                    }
                    addr += byte_incr;
                }
                line += line_incr;
            }
            if (line != lastline) {
                this.lines.add(line);
            }
        }

        private int getline(int addrq) {
            int lo = 0;
            int hi = this.addr_breakpoints.size();
            while (lo < hi) {
                int mid = (lo + hi) / 2;
                if (addrq < this.addr_breakpoints.get(mid)) {
                    hi = mid;
                    continue;
                }
                lo = mid + 1;
            }
            return this.lines.get(lo);
        }

        public String toString() {
            return this.addr_breakpoints.toString() + ";" + this.lines.toString();
        }

        static /* synthetic */ int access$100(LineCache x0, int x1) {
            return x0.getline(x1);
        }

        private class Pair {
            private final int addr;
            private final int line;

            private Pair(int a2, int b2) {
                this.addr = a2;
                this.line = b2;
            }

            public String toString() {
                return "(" + this.addr + "," + this.line + ")";
            }
        }
    }

    private static class PyTryBlock
    extends PyObject {
        int b_type;
        int b_handler;
        int b_level;

        PyTryBlock(int type, int handler2, int level) {
            this.b_type = type;
            this.b_handler = handler2;
            this.b_level = level;
        }

        public String toString() {
            return "<" + PyBytecode.get_opname().__getitem__(Py.newInteger(this.b_type)) + "," + this.b_handler + "," + this.b_level + ">";
        }
    }

    private static class PyStack {
        final List<PyObject> stack = new ArrayList<PyObject>();

        PyStack() {
        }

        PyObject top() {
            return this.stack.get(this.stack.size() - 1);
        }

        PyObject top(int n2) {
            return this.stack.get(this.stack.size() - n2);
        }

        PyObject pop() {
            return this.stack.remove(this.stack.size() - 1);
        }

        void push(PyObject v2) {
            this.stack.add(v2);
        }

        void set_top(PyObject v2) {
            this.stack.set(this.stack.size() - 1, v2);
        }

        void dup() {
            this.stack.add(this.top());
        }

        void dup(int n2) {
            int length = this.stack.size();
            for (int i2 = n2; i2 > 0; --i2) {
                this.stack.add(this.stack.get(length - i2));
            }
        }

        PyObject[] popN(int n2) {
            int end = this.stack.size();
            PyObject[] ret = new PyObject[n2];
            List<PyObject> lastN = this.stack.subList(end - n2, end);
            lastN.toArray(ret);
            lastN.clear();
            return ret;
        }

        void rot2() {
            int length = this.stack.size();
            PyObject v2 = this.stack.get(length - 1);
            PyObject w2 = this.stack.get(length - 2);
            this.stack.set(length - 1, w2);
            this.stack.set(length - 2, v2);
        }

        void rot3() {
            int length = this.stack.size();
            PyObject v2 = this.stack.get(length - 1);
            PyObject w2 = this.stack.get(length - 2);
            PyObject x2 = this.stack.get(length - 3);
            this.stack.set(length - 1, w2);
            this.stack.set(length - 2, x2);
            this.stack.set(length - 3, v2);
        }

        void rot4() {
            int length = this.stack.size();
            PyObject u2 = this.stack.get(length - 1);
            PyObject v2 = this.stack.get(length - 2);
            PyObject w2 = this.stack.get(length - 3);
            PyObject x2 = this.stack.get(length - 4);
            this.stack.set(length - 1, v2);
            this.stack.set(length - 2, w2);
            this.stack.set(length - 3, x2);
            this.stack.set(length - 4, u2);
        }

        int size() {
            return this.stack.size();
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            int size = this.stack.size();
            int N2 = size > 4 ? 4 : size;
            buffer.append("[");
            for (int i2 = 0; i2 < N2; ++i2) {
                if (i2 > 0) {
                    buffer.append(", ");
                }
                PyObject item = this.stack.get(size - (i2 + 1));
                buffer.append(this.upto(item.__repr__().toString()));
            }
            if (N2 < size) {
                buffer.append(String.format(", %d more...", size - N2));
            }
            buffer.append("]");
            return buffer.toString();
        }

        private String upto(String x2) {
            return this.upto(x2, 100);
        }

        private String upto(String x2, int n2) {
            if ((x2 = x2.replace('\n', '|')).length() > n2) {
                StringBuilder item = new StringBuilder(x2.substring(0, n2));
                item.append("...");
                return item.toString();
            }
            return x2;
        }
    }

    private static class PyStackException
    extends PyObject {
        PyException exception;

        PyStackException(PyException exception) {
            this.exception = exception;
        }

        public String toString() {
            return String.format("PyStackException<%s,%s,%.100s>", this.exception.type, this.exception.value, this.exception.traceback);
        }
    }

    private static class PyStackWhy
    extends PyObject {
        Why why;

        PyStackWhy(Why why) {
            this.why = why;
        }

        public String toString() {
            return this.why.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Why {
        NOT,
        EXCEPTION,
        RERAISE,
        RETURN,
        BREAK,
        CONTINUE,
        YIELD;

    }
}

