/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import org.python.core.MakeProxies;
import org.python.core.Py;
import org.python.core.PyCompoundCallable;
import org.python.core.PyObject;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyBeanEventProperty
extends PyObject {
    private static Map<String, Class<?>> adapterClasses = Generic.map();
    private static Map<Object, Map<String, WeakReference<Object>>> adapters = new WeakHashMap<Object, Map<String, WeakReference<Object>>>();
    public Method addMethod;
    public String eventName;
    public Class<?> eventClass;
    public String __name__;
    private Field adapterField;
    private Class<?> adapterClass;

    public PyBeanEventProperty(String eventName, Class<?> eventClass, Method addMethod, Method eventMethod) {
        this.__name__ = eventMethod.getName().intern();
        this.addMethod = addMethod;
        this.eventName = eventName;
        this.eventClass = eventClass;
    }

    @Override
    public PyObject _doget(PyObject self) {
        Object field;
        if (self == null) {
            return this;
        }
        this.initAdapter();
        Object jself = Py.tojava(self, this.addMethod.getDeclaringClass());
        try {
            field = this.adapterField.get(this.getAdapter(jself));
        }
        catch (Exception exc) {
            throw Py.JavaError(exc);
        }
        if (field == null) {
            PyCompoundCallable func = new PyCompoundCallable();
            this.setFunction(jself, func);
            return func;
        }
        if (field instanceof PyCompoundCallable) {
            return (PyCompoundCallable)field;
        }
        PyCompoundCallable func = new PyCompoundCallable();
        this.setFunction(jself, func);
        func.append((PyObject)field);
        return func;
    }

    @Override
    public boolean _doset(PyObject self, PyObject value) {
        Object jself = Py.tojava(self, this.addMethod.getDeclaringClass());
        if (!(value instanceof PyCompoundCallable)) {
            PyCompoundCallable func = new PyCompoundCallable();
            this.setFunction(jself, func);
            func.append(value);
        } else {
            this.setFunction(jself, value);
        }
        return true;
    }

    @Override
    public String toString() {
        return "<beanEventProperty " + this.__name__ + " for event " + this.eventClass.toString() + " " + Py.idstr(this) + ">";
    }

    private Object getAdapter(Object o2, String evc) {
        Map<String, WeakReference<Object>> ads = adapters.get(o2);
        if (ads == null) {
            return null;
        }
        WeakReference<Object> adw = ads.get(evc);
        if (adw == null) {
            return null;
        }
        return adw.get();
    }

    private void putAdapter(Object o2, String evc, Object ad2) {
        Map<String, WeakReference<Object>> ads = adapters.get(o2);
        if (ads == null) {
            ads = Generic.map();
            adapters.put(o2, ads);
        }
        ads.put(evc, new WeakReference<Object>(ad2));
    }

    private synchronized Object getAdapter(Object self) {
        String eventClassName = this.eventClass.getName();
        Object adapter = this.getAdapter(self, eventClassName);
        if (adapter != null) {
            return adapter;
        }
        try {
            adapter = this.adapterClass.newInstance();
            this.addMethod.invoke(self, adapter);
        }
        catch (Exception e2) {
            throw Py.JavaError(e2);
        }
        this.putAdapter(self, eventClassName, adapter);
        return adapter;
    }

    private void initAdapter() {
        if (this.adapterClass == null) {
            this.adapterClass = PyBeanEventProperty.getAdapterClass(this.eventClass);
            try {
                this.adapterField = this.adapterClass.getField(this.__name__);
            }
            catch (NoSuchFieldException exc) {
                throw Py.AttributeError("Internal bean event error: " + this.__name__);
            }
        }
    }

    private void setFunction(Object self, PyObject callable) {
        this.initAdapter();
        try {
            this.adapterField.set(this.getAdapter(self), callable);
        }
        catch (Exception exc) {
            throw Py.JavaError(exc);
        }
    }

    private static synchronized Class<?> getAdapterClass(Class<?> c2) {
        String name = "org.python.proxies." + c2.getName() + "$Adapter";
        Class<?> pc = Py.findClass(name);
        if (pc == null && (pc = adapterClasses.get(name)) == null) {
            pc = MakeProxies.makeAdapter(c2);
            adapterClasses.put(name, pc);
        }
        return pc;
    }
}

