/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyObject;
import org.python.core.PyTuple;

class MaxFunction
extends PyBuiltinFunction {
    MaxFunction() {
        super("max", "max(iterable[, key=func]) -> value\nmax(a, b, c, ...[, key=func]) -> value\n\nWith a single iterable argument, return its largest item.\nWith two or more arguments, return the largest argument.");
    }

    public PyObject __call__(PyObject[] args, String[] kwds) {
        int argslen = args.length;
        PyObject key = null;
        if (args.length - kwds.length == 0) {
            throw Py.TypeError("max() expected 1 arguments, got 0");
        }
        if (kwds.length > 0) {
            if (kwds[0].equals("key")) {
                key = args[argslen - 1];
                PyObject[] newargs = new PyObject[argslen - 1];
                System.arraycopy(args, 0, newargs, 0, argslen - 1);
                args = newargs;
            } else {
                throw Py.TypeError("max() got an unexpected keyword argument");
            }
        }
        if (args.length > 1) {
            return MaxFunction.max(new PyTuple(args), key);
        }
        return MaxFunction.max(args[0], key);
    }

    private static PyObject max(PyObject o2, PyObject key) {
        PyObject max = null;
        PyObject maxKey = null;
        for (PyObject item : o2.asIterable()) {
            PyObject itemKey = key == null ? item : key.__call__(item);
            if (maxKey != null && !itemKey._gt(maxKey).__nonzero__()) continue;
            maxKey = itemKey;
            max = item;
        }
        if (max == null) {
            throw Py.ValueError("min of empty sequence");
        }
        return max;
    }
}

