/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.IOException;
import org.python.objectweb.asm.AnnotationVisitor;
import org.python.objectweb.asm.ClassReader;
import org.python.objectweb.asm.commons.EmptyVisitor;

public class AnnotationReader
extends EmptyVisitor {
    private boolean nextVisitIsVersion = false;
    private boolean nextVisitIsMTime = false;
    private int version = -1;
    private long mtime = -1L;

    public AnnotationReader(byte[] data) throws IOException {
        ClassReader r2;
        try {
            r2 = new ClassReader(data);
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            IOException ioe = new IOException("Malformed bytecode: not enough data");
            ioe.initCause(e2);
            throw ioe;
        }
        r2.accept(this, 0);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.nextVisitIsVersion = desc.equals("Lorg/python/compiler/APIVersion;");
        this.nextVisitIsMTime = desc.equals("Lorg/python/compiler/MTime;");
        return this;
    }

    public void visit(String name, Object value) {
        if (this.nextVisitIsVersion) {
            this.version = (Integer)value;
            this.nextVisitIsVersion = false;
        } else if (this.nextVisitIsMTime) {
            this.mtime = (Long)value;
            this.nextVisitIsVersion = false;
        }
    }

    public int getVersion() {
        return this.version;
    }

    public long getMTime() {
        return this.mtime;
    }
}

