/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.python.antlr.ParseException;
import org.python.antlr.PythonTree;
import org.python.antlr.ast.Str;
import org.python.antlr.base.mod;
import org.python.compiler.ClassConstants;
import org.python.compiler.ClassFile;
import org.python.compiler.Code;
import org.python.compiler.CodeCompiler;
import org.python.compiler.CompilationContext;
import org.python.compiler.Constant;
import org.python.compiler.Future;
import org.python.compiler.PyCodeConstant;
import org.python.compiler.PyComplexConstant;
import org.python.compiler.PyFloatConstant;
import org.python.compiler.PyIntegerConstant;
import org.python.compiler.PyLongConstant;
import org.python.compiler.PyStringConstant;
import org.python.compiler.PyUnicodeConstant;
import org.python.compiler.ScopeInfo;
import org.python.compiler.ScopesCompiler;
import org.python.core.CodeBootstrap;
import org.python.core.CodeLoader;
import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyFunctionTable;
import org.python.core.PyObject;
import org.python.core.PyRunnable;
import org.python.core.PyRunnableBootstrap;
import org.python.core.ThreadState;
import org.python.objectweb.asm.Label;
import org.python.objectweb.asm.Opcodes;
import org.python.objectweb.asm.Type;
import org.python.util.CodegenUtils;

public class Module
implements Opcodes,
ClassConstants,
CompilationContext {
    ClassFile classfile;
    Constant filename;
    String sfilename;
    Constant mainCode;
    boolean linenumbers;
    Future futures;
    Hashtable<PythonTree, ScopeInfo> scopes;
    List<PyCodeConstant> codes;
    long mtime;
    Hashtable<Constant, Constant> constants;

    public Module(String name, String filename, boolean linenumbers) {
        this(name, filename, linenumbers, -1L);
    }

    public Module(String name, String filename, boolean linenumbers, long mtime) {
        this.linenumbers = linenumbers;
        this.mtime = mtime;
        this.classfile = new ClassFile(name, CodegenUtils.p(PyFunctionTable.class), 33, mtime);
        this.constants = new Hashtable();
        this.sfilename = filename;
        this.filename = filename != null ? this.stringConstant(filename) : null;
        this.codes = new ArrayList<PyCodeConstant>();
        this.futures = new Future();
        this.scopes = new Hashtable();
    }

    public Module(String name) {
        this(name, name + ".py", true, -1L);
    }

    private Constant findConstant(Constant c2) {
        Constant ret = this.constants.get(c2);
        if (ret != null) {
            return ret;
        }
        ret = c2;
        c2.module = this;
        c2.name = "_" + this.constants.size();
        this.constants.put(ret, ret);
        return ret;
    }

    Constant integerConstant(int value) {
        return this.findConstant(new PyIntegerConstant(value));
    }

    Constant floatConstant(double value) {
        return this.findConstant(new PyFloatConstant(value));
    }

    Constant complexConstant(double value) {
        return this.findConstant(new PyComplexConstant(value));
    }

    Constant stringConstant(String value) {
        return this.findConstant(new PyStringConstant(value));
    }

    Constant unicodeConstant(String value) {
        return this.findConstant(new PyUnicodeConstant(value));
    }

    Constant longConstant(String value) {
        return this.findConstant(new PyLongConstant(value));
    }

    PyCodeConstant codeConstant(mod tree, String name, boolean fast_locals, String className, boolean classBody, boolean printResults, int firstlineno, ScopeInfo scope, CompilerFlags cflags) throws Exception {
        return this.codeConstant(tree, name, fast_locals, className, null, classBody, printResults, firstlineno, scope, cflags);
    }

    PyCodeConstant codeConstant(mod tree, String name, boolean fast_locals, String className, Str classDoc, boolean classBody, boolean printResults, int firstlineno, ScopeInfo scope, CompilerFlags cflags) throws Exception {
        PyCodeConstant code2 = new PyCodeConstant(tree, name, fast_locals, className, classBody, printResults, firstlineno, scope, cflags, this);
        this.codes.add(code2);
        CodeCompiler compiler2 = new CodeCompiler(this, printResults);
        Code c2 = this.classfile.addMethod(code2.fname, CodegenUtils.sig(PyObject.class, PyFrame.class, ThreadState.class), 1);
        compiler2.parse(tree, c2, fast_locals, className, classDoc, classBody, scope, cflags);
        return code2;
    }

    public void addInit() throws IOException {
        Code c2 = this.classfile.addMethod("<init>", CodegenUtils.sig(Void.TYPE, String.class), 1);
        c2.aload(0);
        c2.invokespecial(CodegenUtils.p(PyFunctionTable.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
        this.addConstants(c2);
    }

    public void addRunnable() throws IOException {
        Code c2 = this.classfile.addMethod("getMain", CodegenUtils.sig(PyCode.class, new Class[0]), 1);
        this.mainCode.get(c2);
        c2.areturn();
    }

    public void addMain() throws IOException {
        Code c2 = this.classfile.addMethod("main", CodegenUtils.sig(Void.TYPE, String[].class), 9);
        c2.new_(this.classfile.name);
        c2.dup();
        c2.ldc(this.classfile.name);
        c2.invokespecial(this.classfile.name, "<init>", CodegenUtils.sig(Void.TYPE, String.class));
        c2.invokevirtual(this.classfile.name, "getMain", CodegenUtils.sig(PyCode.class, new Class[0]));
        c2.invokestatic(CodegenUtils.p(CodeLoader.class), "createSimpleBootstrap", CodegenUtils.sig(CodeBootstrap.class, PyCode.class));
        c2.aload(0);
        c2.invokestatic(CodegenUtils.p(Py.class), "runMain", CodegenUtils.sig(Void.TYPE, CodeBootstrap.class, String[].class));
        c2.return_();
    }

    public void addBootstrap() throws IOException {
        Code c2 = this.classfile.addMethod("getCodeBootstrap", CodegenUtils.sig(CodeBootstrap.class, new Class[0]), 9);
        c2.ldc(Type.getType("L" + this.classfile.name + ";"));
        c2.invokestatic(CodegenUtils.p(PyRunnableBootstrap.class), "getFilenameConstructorReflectionBootstrap", CodegenUtils.sig(CodeBootstrap.class, Class.class));
        c2.areturn();
    }

    void addConstants(Code c2) throws IOException {
        this.classfile.addField("self", "L" + this.classfile.name + ";", 8);
        c2.aload(0);
        c2.putstatic(this.classfile.name, "self", "L" + this.classfile.name + ";");
        Enumeration<Constant> e2 = this.constants.elements();
        while (e2.hasMoreElements()) {
            Constant constant = e2.nextElement();
            constant.put(c2);
        }
        for (int i2 = 0; i2 < this.codes.size(); ++i2) {
            PyCodeConstant pyc = this.codes.get(i2);
            pyc.put(c2);
        }
        c2.return_();
    }

    public void addFunctions() throws IOException {
        int i2;
        Code code2 = this.classfile.addMethod("call_function", CodegenUtils.sig(PyObject.class, Integer.TYPE, PyFrame.class, ThreadState.class), 1);
        code2.aload(0);
        code2.aload(2);
        code2.aload(3);
        Label def = new Label();
        Label[] labels = new Label[this.codes.size()];
        for (i2 = 0; i2 < labels.length; ++i2) {
            labels[i2] = new Label();
        }
        code2.iload(1);
        code2.tableswitch(0, labels.length - 1, def, labels);
        for (i2 = 0; i2 < labels.length; ++i2) {
            code2.label(labels[i2]);
            code2.invokevirtual(this.classfile.name, this.codes.get((int)i2).fname, CodegenUtils.sig(PyObject.class, PyFrame.class, ThreadState.class));
            code2.areturn();
        }
        code2.label(def);
        code2.aconst_null();
        code2.areturn();
    }

    public void write(OutputStream stream) throws IOException {
        this.addInit();
        this.addRunnable();
        this.addMain();
        this.addBootstrap();
        this.addFunctions();
        this.classfile.addInterface(CodegenUtils.p(PyRunnable.class));
        if (this.sfilename != null) {
            this.classfile.setSource(this.sfilename);
        }
        this.classfile.write(stream);
    }

    public Future getFutures() {
        return this.futures;
    }

    public String getFilename() {
        return this.sfilename;
    }

    public ScopeInfo getScopeInfo(PythonTree node) {
        return this.scopes.get(node);
    }

    public void error(String msg, boolean err, PythonTree node) throws Exception {
        block3: {
            if (!err) {
                try {
                    Py.warning(Py.SyntaxWarning, msg, this.sfilename != null ? this.sfilename : "?", node.getLine(), null, Py.None);
                    return;
                }
                catch (PyException e2) {
                    if (e2.match(Py.SyntaxWarning)) break block3;
                    throw e2;
                }
            }
        }
        throw new ParseException(msg, node);
    }

    public static void compile(mod node, OutputStream ostream, String name, String filename, boolean linenumbers, boolean printResults, CompilerFlags cflags) throws Exception {
        Module.compile(node, ostream, name, filename, linenumbers, printResults, cflags, -1L);
    }

    public static void compile(mod node, OutputStream ostream, String name, String filename, boolean linenumbers, boolean printResults, CompilerFlags cflags, long mtime) throws Exception {
        Module module = new Module(name, filename, linenumbers, mtime);
        if (cflags == null) {
            cflags = new CompilerFlags();
        }
        module.futures.preprocessFutures(node, cflags);
        new ScopesCompiler(module, module.scopes).parse(node);
        PyCodeConstant main = module.codeConstant(node, "<module>", false, null, false, printResults, 0, module.getScopeInfo(node), cflags);
        module.mainCode = main;
        module.write(ostream);
    }
}

