/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.util;

import org.python.apache.xerces.util.AugmentationsImpl;
import org.python.apache.xerces.xni.Augmentations;
import org.python.apache.xerces.xni.QName;
import org.python.apache.xerces.xni.XMLAttributes;

public class XMLAttributesImpl
implements XMLAttributes {
    protected static final int TABLE_SIZE = 101;
    protected static final int SIZE_LIMIT = 20;
    protected boolean fNamespaces = true;
    protected int fLargeCount = 1;
    protected int fLength;
    protected Attribute[] fAttributes = new Attribute[4];
    protected Attribute[] fAttributeTableView;
    protected int[] fAttributeTableViewChainState;
    protected int fTableViewBuckets;
    protected boolean fIsTableViewConsistent;

    public XMLAttributesImpl() {
        this(101);
    }

    public XMLAttributesImpl(int n2) {
        this.fTableViewBuckets = n2;
        int n3 = 0;
        while (n3 < this.fAttributes.length) {
            this.fAttributes[n3] = new Attribute();
            ++n3;
        }
    }

    public void setNamespaces(boolean bl2) {
        this.fNamespaces = bl2;
    }

    public int addAttribute(QName qName, String string2, String string3) {
        Attribute[] attributeArray;
        int n2;
        if (this.fLength < 20) {
            int n3 = n2 = qName.uri != null && !qName.uri.equals("") ? this.getIndexFast(qName.uri, qName.localpart) : this.getIndexFast(qName.rawname);
            if (n2 == -1) {
                n2 = this.fLength;
                if (this.fLength++ == this.fAttributes.length) {
                    attributeArray = new Attribute[this.fAttributes.length + 4];
                    System.arraycopy(this.fAttributes, 0, attributeArray, 0, this.fAttributes.length);
                    int n4 = this.fAttributes.length;
                    while (n4 < attributeArray.length) {
                        attributeArray[n4] = new Attribute();
                        ++n4;
                    }
                    this.fAttributes = attributeArray;
                }
            }
        } else if (qName.uri == null || qName.uri.length() == 0 || (n2 = this.getIndexFast(qName.uri, qName.localpart)) == -1) {
            int n5;
            if (!this.fIsTableViewConsistent || this.fLength == 20) {
                this.prepareAndPopulateTableView();
                this.fIsTableViewConsistent = true;
            }
            if (this.fAttributeTableViewChainState[n5 = this.getTableViewBucket(qName.rawname)] != this.fLargeCount) {
                n2 = this.fLength;
                if (this.fLength++ == this.fAttributes.length) {
                    Attribute[] attributeArray2 = new Attribute[this.fAttributes.length << 1];
                    System.arraycopy(this.fAttributes, 0, attributeArray2, 0, this.fAttributes.length);
                    int n6 = this.fAttributes.length;
                    while (n6 < attributeArray2.length) {
                        attributeArray2[n6] = new Attribute();
                        ++n6;
                    }
                    this.fAttributes = attributeArray2;
                }
                this.fAttributeTableViewChainState[n5] = this.fLargeCount;
                this.fAttributes[n2].next = null;
                this.fAttributeTableView[n5] = this.fAttributes[n2];
            } else {
                Attribute attribute = this.fAttributeTableView[n5];
                while (attribute != null) {
                    if (attribute.name.rawname == qName.rawname) break;
                    attribute = attribute.next;
                }
                if (attribute == null) {
                    n2 = this.fLength;
                    if (this.fLength++ == this.fAttributes.length) {
                        Attribute[] attributeArray3 = new Attribute[this.fAttributes.length << 1];
                        System.arraycopy(this.fAttributes, 0, attributeArray3, 0, this.fAttributes.length);
                        int n7 = this.fAttributes.length;
                        while (n7 < attributeArray3.length) {
                            attributeArray3[n7] = new Attribute();
                            ++n7;
                        }
                        this.fAttributes = attributeArray3;
                    }
                    this.fAttributes[n2].next = this.fAttributeTableView[n5];
                    this.fAttributeTableView[n5] = this.fAttributes[n2];
                } else {
                    n2 = this.getIndexFast(qName.rawname);
                }
            }
        }
        attributeArray = this.fAttributes[n2];
        attributeArray.name.setValues(qName);
        attributeArray.type = string2;
        attributeArray.value = string3;
        attributeArray.nonNormalizedValue = string3;
        attributeArray.specified = false;
        attributeArray.augs.removeAllItems();
        return n2;
    }

    public void removeAllAttributes() {
        this.fLength = 0;
    }

    public void removeAttributeAt(int n2) {
        this.fIsTableViewConsistent = false;
        if (n2 < this.fLength - 1) {
            Attribute attribute = this.fAttributes[n2];
            System.arraycopy(this.fAttributes, n2 + 1, this.fAttributes, n2, this.fLength - n2 - 1);
            this.fAttributes[this.fLength - 1] = attribute;
        }
        --this.fLength;
    }

    public void setName(int n2, QName qName) {
        this.fAttributes[n2].name.setValues(qName);
    }

    public void getName(int n2, QName qName) {
        qName.setValues(this.fAttributes[n2].name);
    }

    public void setType(int n2, String string2) {
        this.fAttributes[n2].type = string2;
    }

    public void setValue(int n2, String string2) {
        Attribute attribute = this.fAttributes[n2];
        attribute.value = string2;
        attribute.nonNormalizedValue = string2;
    }

    public void setNonNormalizedValue(int n2, String string2) {
        if (string2 == null) {
            string2 = this.fAttributes[n2].value;
        }
        this.fAttributes[n2].nonNormalizedValue = string2;
    }

    public String getNonNormalizedValue(int n2) {
        String string2 = this.fAttributes[n2].nonNormalizedValue;
        return string2;
    }

    public void setSpecified(int n2, boolean bl2) {
        this.fAttributes[n2].specified = bl2;
    }

    public boolean isSpecified(int n2) {
        return this.fAttributes[n2].specified;
    }

    public int getLength() {
        return this.fLength;
    }

    public String getType(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        return this.getReportableType(this.fAttributes[n2].type);
    }

    public String getType(String string2) {
        int n2 = this.getIndex(string2);
        return n2 != -1 ? this.getReportableType(this.fAttributes[n2].type) : null;
    }

    public String getValue(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        return this.fAttributes[n2].value;
    }

    public String getValue(String string2) {
        int n2 = this.getIndex(string2);
        return n2 != -1 ? this.fAttributes[n2].value : null;
    }

    public String getName(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        return this.fAttributes[n2].name.rawname;
    }

    public int getIndex(String string2) {
        int n2 = 0;
        while (n2 < this.fLength) {
            Attribute attribute = this.fAttributes[n2];
            if (attribute.name.rawname != null && attribute.name.rawname.equals(string2)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int getIndex(String string2, String string3) {
        int n2 = 0;
        while (n2 < this.fLength) {
            Attribute attribute = this.fAttributes[n2];
            if (attribute.name.localpart != null && attribute.name.localpart.equals(string3) && (string2 == attribute.name.uri || string2 != null && attribute.name.uri != null && attribute.name.uri.equals(string2))) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public String getLocalName(int n2) {
        if (!this.fNamespaces) {
            return "";
        }
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        return this.fAttributes[n2].name.localpart;
    }

    public String getQName(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        String string2 = this.fAttributes[n2].name.rawname;
        return string2 != null ? string2 : "";
    }

    public String getType(String string2, String string3) {
        if (!this.fNamespaces) {
            return null;
        }
        int n2 = this.getIndex(string2, string3);
        return n2 != -1 ? this.getReportableType(this.fAttributes[n2].type) : null;
    }

    public String getPrefix(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        String string2 = this.fAttributes[n2].name.prefix;
        return string2 != null ? string2 : "";
    }

    public String getURI(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        String string2 = this.fAttributes[n2].name.uri;
        return string2;
    }

    public String getValue(String string2, String string3) {
        int n2 = this.getIndex(string2, string3);
        return n2 != -1 ? this.getValue(n2) : null;
    }

    public Augmentations getAugmentations(String string2, String string3) {
        int n2 = this.getIndex(string2, string3);
        return n2 != -1 ? this.fAttributes[n2].augs : null;
    }

    public Augmentations getAugmentations(String string2) {
        int n2 = this.getIndex(string2);
        return n2 != -1 ? this.fAttributes[n2].augs : null;
    }

    public Augmentations getAugmentations(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        return this.fAttributes[n2].augs;
    }

    public void setAugmentations(int n2, Augmentations augmentations) {
        this.fAttributes[n2].augs = augmentations;
    }

    public void setURI(int n2, String string2) {
        this.fAttributes[n2].name.uri = string2;
    }

    public void setSchemaId(int n2, boolean bl2) {
        this.fAttributes[n2].schemaId = bl2;
    }

    public boolean getSchemaId(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return false;
        }
        return this.fAttributes[n2].schemaId;
    }

    public boolean getSchemaId(String string2) {
        int n2 = this.getIndex(string2);
        return n2 != -1 ? this.fAttributes[n2].schemaId : false;
    }

    public boolean getSchemaId(String string2, String string3) {
        if (!this.fNamespaces) {
            return false;
        }
        int n2 = this.getIndex(string2, string3);
        return n2 != -1 ? this.fAttributes[n2].schemaId : false;
    }

    public int getIndexFast(String string2) {
        int n2 = 0;
        while (n2 < this.fLength) {
            Attribute attribute = this.fAttributes[n2];
            if (attribute.name.rawname == string2) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void addAttributeNS(QName qName, String string2, String string3) {
        Attribute[] attributeArray;
        int n2 = this.fLength;
        if (this.fLength++ == this.fAttributes.length) {
            attributeArray = this.fLength < 20 ? new Attribute[this.fAttributes.length + 4] : new Attribute[this.fAttributes.length << 1];
            System.arraycopy(this.fAttributes, 0, attributeArray, 0, this.fAttributes.length);
            int n3 = this.fAttributes.length;
            while (n3 < attributeArray.length) {
                attributeArray[n3] = new Attribute();
                ++n3;
            }
            this.fAttributes = attributeArray;
        }
        attributeArray = this.fAttributes[n2];
        attributeArray.name.setValues(qName);
        attributeArray.type = string2;
        attributeArray.value = string3;
        attributeArray.nonNormalizedValue = string3;
        attributeArray.specified = false;
        attributeArray.augs.removeAllItems();
    }

    public QName checkDuplicatesNS() {
        if (this.fLength <= 20) {
            int n2 = 0;
            while (n2 < this.fLength - 1) {
                Attribute attribute = this.fAttributes[n2];
                int n3 = n2 + 1;
                while (n3 < this.fLength) {
                    Attribute attribute2 = this.fAttributes[n3];
                    if (attribute.name.localpart == attribute2.name.localpart && attribute.name.uri == attribute2.name.uri) {
                        return attribute2.name;
                    }
                    ++n3;
                }
                ++n2;
            }
        } else {
            this.fIsTableViewConsistent = false;
            this.prepareTableView();
            int n4 = this.fLength - 1;
            while (n4 >= 0) {
                Attribute attribute = this.fAttributes[n4];
                int n5 = this.getTableViewBucket(attribute.name.localpart, attribute.name.uri);
                if (this.fAttributeTableViewChainState[n5] != this.fLargeCount) {
                    this.fAttributeTableViewChainState[n5] = this.fLargeCount;
                    attribute.next = null;
                    this.fAttributeTableView[n5] = attribute;
                } else {
                    Attribute attribute3 = this.fAttributeTableView[n5];
                    while (attribute3 != null) {
                        if (attribute3.name.localpart == attribute.name.localpart && attribute3.name.uri == attribute.name.uri) {
                            return attribute.name;
                        }
                        attribute3 = attribute3.next;
                    }
                    attribute.next = this.fAttributeTableView[n5];
                    this.fAttributeTableView[n5] = attribute;
                }
                --n4;
            }
        }
        return null;
    }

    public int getIndexFast(String string2, String string3) {
        int n2 = 0;
        while (n2 < this.fLength) {
            Attribute attribute = this.fAttributes[n2];
            if (attribute.name.localpart == string3 && attribute.name.uri == string2) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private String getReportableType(String string2) {
        if (string2.charAt(0) == '(') {
            return "NMTOKEN";
        }
        return string2;
    }

    protected int getTableViewBucket(String string2) {
        return (string2.hashCode() & Integer.MAX_VALUE) % this.fTableViewBuckets;
    }

    protected int getTableViewBucket(String string2, String string3) {
        if (string3 == null) {
            return (string2.hashCode() & Integer.MAX_VALUE) % this.fTableViewBuckets;
        }
        return (string2.hashCode() + string3.hashCode() & Integer.MAX_VALUE) % this.fTableViewBuckets;
    }

    protected void cleanTableView() {
        if (++this.fLargeCount < 0) {
            if (this.fAttributeTableViewChainState != null) {
                int n2 = this.fTableViewBuckets - 1;
                while (n2 >= 0) {
                    this.fAttributeTableViewChainState[n2] = 0;
                    --n2;
                }
            }
            this.fLargeCount = 1;
        }
    }

    protected void prepareTableView() {
        if (this.fAttributeTableView == null) {
            this.fAttributeTableView = new Attribute[this.fTableViewBuckets];
            this.fAttributeTableViewChainState = new int[this.fTableViewBuckets];
        } else {
            this.cleanTableView();
        }
    }

    protected void prepareAndPopulateTableView() {
        this.prepareTableView();
        int n2 = 0;
        while (n2 < this.fLength) {
            Attribute attribute = this.fAttributes[n2];
            int n3 = this.getTableViewBucket(attribute.name.rawname);
            if (this.fAttributeTableViewChainState[n3] != this.fLargeCount) {
                this.fAttributeTableViewChainState[n3] = this.fLargeCount;
                attribute.next = null;
                this.fAttributeTableView[n3] = attribute;
            } else {
                attribute.next = this.fAttributeTableView[n3];
                this.fAttributeTableView[n3] = attribute;
            }
            ++n2;
        }
    }

    static class Attribute {
        public QName name = new QName();
        public String type;
        public String value;
        public String nonNormalizedValue;
        public boolean specified;
        public boolean schemaId;
        public Augmentations augs = new AugmentationsImpl();
        public Attribute next;

        Attribute() {
        }
    }
}

