/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.parsers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.python.apache.xerces.util.ParserConfigurationSettings;
import org.python.apache.xerces.util.SymbolTable;
import org.python.apache.xerces.xni.XMLDTDContentModelHandler;
import org.python.apache.xerces.xni.XMLDTDHandler;
import org.python.apache.xerces.xni.XMLDocumentHandler;
import org.python.apache.xerces.xni.XNIException;
import org.python.apache.xerces.xni.parser.XMLComponent;
import org.python.apache.xerces.xni.parser.XMLComponentManager;
import org.python.apache.xerces.xni.parser.XMLConfigurationException;
import org.python.apache.xerces.xni.parser.XMLDocumentSource;
import org.python.apache.xerces.xni.parser.XMLEntityResolver;
import org.python.apache.xerces.xni.parser.XMLErrorHandler;
import org.python.apache.xerces.xni.parser.XMLInputSource;
import org.python.apache.xerces.xni.parser.XMLParserConfiguration;

public abstract class BasicParserConfiguration
extends ParserConfigurationSettings
implements XMLParserConfiguration {
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    protected static final String EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    protected static final String XML_STRING = "http://xml.org/sax/properties/xml-string";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    protected static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    protected SymbolTable fSymbolTable;
    protected Locale fLocale;
    protected ArrayList fComponents = new ArrayList();
    protected XMLDocumentHandler fDocumentHandler;
    protected XMLDTDHandler fDTDHandler;
    protected XMLDTDContentModelHandler fDTDContentModelHandler;
    protected XMLDocumentSource fLastComponent;

    protected BasicParserConfiguration() {
        this(null, null);
    }

    protected BasicParserConfiguration(SymbolTable symbolTable) {
        this(symbolTable, null);
    }

    protected BasicParserConfiguration(SymbolTable symbolTable, XMLComponentManager xMLComponentManager) {
        super(xMLComponentManager);
        this.fRecognizedFeatures = new ArrayList();
        this.fRecognizedProperties = new ArrayList();
        this.fFeatures = new HashMap();
        this.fProperties = new HashMap();
        String[] stringArray = new String[]{"http://apache.org/xml/features/internal/parser-settings", VALIDATION, NAMESPACES, EXTERNAL_GENERAL_ENTITIES, EXTERNAL_PARAMETER_ENTITIES};
        this.addRecognizedFeatures(stringArray);
        this.fFeatures.put("http://apache.org/xml/features/internal/parser-settings", Boolean.TRUE);
        this.fFeatures.put(VALIDATION, Boolean.FALSE);
        this.fFeatures.put(NAMESPACES, Boolean.TRUE);
        this.fFeatures.put(EXTERNAL_GENERAL_ENTITIES, Boolean.TRUE);
        this.fFeatures.put(EXTERNAL_PARAMETER_ENTITIES, Boolean.TRUE);
        String[] stringArray2 = new String[]{XML_STRING, SYMBOL_TABLE, ERROR_HANDLER, ENTITY_RESOLVER};
        this.addRecognizedProperties(stringArray2);
        if (symbolTable == null) {
            symbolTable = new SymbolTable();
        }
        this.fSymbolTable = symbolTable;
        this.fProperties.put(SYMBOL_TABLE, this.fSymbolTable);
    }

    protected void addComponent(XMLComponent xMLComponent) {
        Object object;
        String string2;
        int n2;
        if (this.fComponents.contains(xMLComponent)) {
            return;
        }
        this.fComponents.add(xMLComponent);
        String[] stringArray = xMLComponent.getRecognizedFeatures();
        this.addRecognizedFeatures(stringArray);
        String[] stringArray2 = xMLComponent.getRecognizedProperties();
        this.addRecognizedProperties(stringArray2);
        if (stringArray != null) {
            n2 = 0;
            while (n2 < stringArray.length) {
                string2 = stringArray[n2];
                object = xMLComponent.getFeatureDefault(string2);
                if (object != null) {
                    super.setFeature(string2, (Boolean)object);
                }
                ++n2;
            }
        }
        if (stringArray2 != null) {
            n2 = 0;
            while (n2 < stringArray2.length) {
                string2 = stringArray2[n2];
                object = xMLComponent.getPropertyDefault(string2);
                if (object != null) {
                    super.setProperty(string2, object);
                }
                ++n2;
            }
        }
    }

    public abstract void parse(XMLInputSource var1) throws XNIException, IOException;

    public void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.fDocumentHandler = xMLDocumentHandler;
        if (this.fLastComponent != null) {
            this.fLastComponent.setDocumentHandler(this.fDocumentHandler);
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.setDocumentSource(this.fLastComponent);
            }
        }
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    public void setDTDHandler(XMLDTDHandler xMLDTDHandler) {
        this.fDTDHandler = xMLDTDHandler;
    }

    public XMLDTDHandler getDTDHandler() {
        return this.fDTDHandler;
    }

    public void setDTDContentModelHandler(XMLDTDContentModelHandler xMLDTDContentModelHandler) {
        this.fDTDContentModelHandler = xMLDTDContentModelHandler;
    }

    public XMLDTDContentModelHandler getDTDContentModelHandler() {
        return this.fDTDContentModelHandler;
    }

    public void setEntityResolver(XMLEntityResolver xMLEntityResolver) {
        this.fProperties.put(ENTITY_RESOLVER, xMLEntityResolver);
    }

    public XMLEntityResolver getEntityResolver() {
        return (XMLEntityResolver)this.fProperties.get(ENTITY_RESOLVER);
    }

    public void setErrorHandler(XMLErrorHandler xMLErrorHandler) {
        this.fProperties.put(ERROR_HANDLER, xMLErrorHandler);
    }

    public XMLErrorHandler getErrorHandler() {
        return (XMLErrorHandler)this.fProperties.get(ERROR_HANDLER);
    }

    public void setFeature(String string2, boolean bl2) throws XMLConfigurationException {
        int n2 = this.fComponents.size();
        int n3 = 0;
        while (n3 < n2) {
            XMLComponent xMLComponent = (XMLComponent)this.fComponents.get(n3);
            xMLComponent.setFeature(string2, bl2);
            ++n3;
        }
        super.setFeature(string2, bl2);
    }

    public void setProperty(String string2, Object object) throws XMLConfigurationException {
        int n2 = this.fComponents.size();
        int n3 = 0;
        while (n3 < n2) {
            XMLComponent xMLComponent = (XMLComponent)this.fComponents.get(n3);
            xMLComponent.setProperty(string2, object);
            ++n3;
        }
        super.setProperty(string2, object);
    }

    public void setLocale(Locale locale2) throws XNIException {
        this.fLocale = locale2;
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    protected void reset() throws XNIException {
        int n2 = this.fComponents.size();
        int n3 = 0;
        while (n3 < n2) {
            XMLComponent xMLComponent = (XMLComponent)this.fComponents.get(n3);
            xMLComponent.reset(this);
            ++n3;
        }
    }

    protected void checkProperty(String string2) throws XMLConfigurationException {
        int n2;
        if (string2.startsWith("http://xml.org/sax/properties/") && (n2 = string2.length() - "http://xml.org/sax/properties/".length()) == "xml-string".length() && string2.endsWith("xml-string")) {
            short s2 = 1;
            throw new XMLConfigurationException(s2, string2);
        }
        super.checkProperty(string2);
    }

    protected void checkFeature(String string2) throws XMLConfigurationException {
        int n2;
        if (string2.startsWith("http://apache.org/xml/features/") && (n2 = string2.length() - "http://apache.org/xml/features/".length()) == "internal/parser-settings".length() && string2.endsWith("internal/parser-settings")) {
            short s2 = 1;
            throw new XMLConfigurationException(s2, string2);
        }
        super.checkFeature(string2);
    }
}

