/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.impl.xpath.regex;

import java.io.Serializable;
import java.text.CharacterIterator;
import org.python.apache.xerces.impl.xpath.regex.BMPattern;
import org.python.apache.xerces.impl.xpath.regex.Match;
import org.python.apache.xerces.impl.xpath.regex.Op;
import org.python.apache.xerces.impl.xpath.regex.ParseException;
import org.python.apache.xerces.impl.xpath.regex.ParserForXMLSchema;
import org.python.apache.xerces.impl.xpath.regex.REUtil;
import org.python.apache.xerces.impl.xpath.regex.RangeToken;
import org.python.apache.xerces.impl.xpath.regex.RegexParser;
import org.python.apache.xerces.impl.xpath.regex.Token;

public class RegularExpression
implements Serializable {
    private static final long serialVersionUID = 6242499334195006401L;
    static final boolean DEBUG = false;
    String regex;
    int options;
    int nofparen;
    Token tokentree;
    boolean hasBackReferences = false;
    transient int minlength;
    transient Op operations = null;
    transient int numberOfClosures;
    transient Context context = null;
    transient RangeToken firstChar = null;
    transient String fixedString = null;
    transient int fixedStringOptions;
    transient BMPattern fixedStringTable = null;
    transient boolean fixedStringOnly = false;
    static final int IGNORE_CASE = 2;
    static final int SINGLE_LINE = 4;
    static final int MULTIPLE_LINES = 8;
    static final int EXTENDED_COMMENT = 16;
    static final int USE_UNICODE_CATEGORY = 32;
    static final int UNICODE_WORD_BOUNDARY = 64;
    static final int PROHIBIT_HEAD_CHARACTER_OPTIMIZATION = 128;
    static final int PROHIBIT_FIXED_STRING_OPTIMIZATION = 256;
    static final int XMLSCHEMA_MODE = 512;
    static final int SPECIAL_COMMA = 1024;
    private static final int WT_IGNORE = 0;
    private static final int WT_LETTER = 1;
    private static final int WT_OTHER = 2;
    static final int LINE_FEED = 10;
    static final int CARRIAGE_RETURN = 13;
    static final int LINE_SEPARATOR = 8232;
    static final int PARAGRAPH_SEPARATOR = 8233;

    private synchronized void compile(Token token2) {
        if (this.operations != null) {
            return;
        }
        this.numberOfClosures = 0;
        this.operations = this.compile(token2, null, false);
    }

    private Op compile(Token token2, Op op, boolean bl2) {
        Op op2;
        switch (token2.type) {
            case 11: {
                op2 = Op.createDot();
                op2.next = op;
                break;
            }
            case 0: {
                op2 = Op.createChar(token2.getChar());
                op2.next = op;
                break;
            }
            case 8: {
                op2 = Op.createAnchor(token2.getChar());
                op2.next = op;
                break;
            }
            case 4: 
            case 5: {
                op2 = Op.createRange(token2);
                op2.next = op;
                break;
            }
            case 1: {
                op2 = op;
                if (!bl2) {
                    int n2 = token2.size() - 1;
                    while (n2 >= 0) {
                        op2 = this.compile(token2.getChild(n2), op2, false);
                        --n2;
                    }
                } else {
                    int n3 = 0;
                    while (n3 < token2.size()) {
                        op2 = this.compile(token2.getChild(n3), op2, true);
                        ++n3;
                    }
                }
                break;
            }
            case 2: {
                Op.UnionOp unionOp = Op.createUnion(token2.size());
                int n4 = 0;
                while (n4 < token2.size()) {
                    unionOp.addElement(this.compile(token2.getChild(n4), op, bl2));
                    ++n4;
                }
                op2 = unionOp;
                break;
            }
            case 3: 
            case 9: {
                Token token3 = token2.getChild(0);
                int n5 = token2.getMin();
                int n6 = token2.getMax();
                if (n5 >= 0 && n5 == n6) {
                    op2 = op;
                    int n7 = 0;
                    while (n7 < n5) {
                        op2 = this.compile(token3, op2, bl2);
                        ++n7;
                    }
                } else {
                    if (n5 > 0 && n6 > 0) {
                        n6 -= n5;
                    }
                    if (n6 > 0) {
                        op2 = op;
                        int n8 = 0;
                        while (n8 < n6) {
                            Op.ChildOp childOp = Op.createQuestion(token2.type == 9);
                            childOp.next = op;
                            childOp.setChild(this.compile(token3, op2, bl2));
                            op2 = childOp;
                            ++n8;
                        }
                    } else {
                        Op.ChildOp childOp = token2.type == 9 ? Op.createNonGreedyClosure() : (token3.getMinLength() == 0 ? Op.createClosure(this.numberOfClosures++) : Op.createClosure(-1));
                        childOp.next = op;
                        childOp.setChild(this.compile(token3, childOp, bl2));
                        op2 = childOp;
                    }
                    if (n5 <= 0) break;
                    int n9 = 0;
                    while (n9 < n5) {
                        op2 = this.compile(token3, op2, bl2);
                        ++n9;
                    }
                }
                break;
            }
            case 7: {
                op2 = op;
                break;
            }
            case 10: {
                op2 = Op.createString(token2.getString());
                op2.next = op;
                break;
            }
            case 12: {
                op2 = Op.createBackReference(token2.getReferenceNumber());
                op2.next = op;
                break;
            }
            case 6: {
                if (token2.getParenNumber() == 0) {
                    op2 = this.compile(token2.getChild(0), op, bl2);
                    break;
                }
                if (bl2) {
                    op = Op.createCapture(token2.getParenNumber(), op);
                    op = this.compile(token2.getChild(0), op, bl2);
                    op2 = Op.createCapture(-token2.getParenNumber(), op);
                    break;
                }
                op = Op.createCapture(-token2.getParenNumber(), op);
                op = this.compile(token2.getChild(0), op, bl2);
                op2 = Op.createCapture(token2.getParenNumber(), op);
                break;
            }
            case 20: {
                op2 = Op.createLook(20, op, this.compile(token2.getChild(0), null, false));
                break;
            }
            case 21: {
                op2 = Op.createLook(21, op, this.compile(token2.getChild(0), null, false));
                break;
            }
            case 22: {
                op2 = Op.createLook(22, op, this.compile(token2.getChild(0), null, true));
                break;
            }
            case 23: {
                op2 = Op.createLook(23, op, this.compile(token2.getChild(0), null, true));
                break;
            }
            case 24: {
                op2 = Op.createIndependent(op, this.compile(token2.getChild(0), null, bl2));
                break;
            }
            case 25: {
                op2 = Op.createModifier(op, this.compile(token2.getChild(0), null, bl2), ((Token.ModifierToken)token2).getOptions(), ((Token.ModifierToken)token2).getOptionsMask());
                break;
            }
            case 26: {
                Token.ConditionToken conditionToken = (Token.ConditionToken)token2;
                int n10 = conditionToken.refNumber;
                Op op3 = conditionToken.condition == null ? null : this.compile(conditionToken.condition, null, bl2);
                Op op4 = this.compile(conditionToken.yes, op, bl2);
                Op op5 = conditionToken.no == null ? null : this.compile(conditionToken.no, op, bl2);
                op2 = Op.createCondition(op, n10, op3, op4, op5);
                break;
            }
            default: {
                throw new RuntimeException("Unknown token type: " + token2.type);
            }
        }
        return op2;
    }

    public boolean matches(char[] cArray) {
        return this.matches(cArray, 0, cArray.length, (Match)null);
    }

    public boolean matches(char[] cArray, int n2, int n3) {
        return this.matches(cArray, n2, n3, (Match)null);
    }

    public boolean matches(char[] cArray, Match match) {
        return this.matches(cArray, 0, cArray.length, match);
    }

    public boolean matches(char[] cArray, int n2, int n3, Match match) {
        int n4;
        int n5;
        RegularExpression regularExpression = this;
        synchronized (regularExpression) {
            if (this.operations == null) {
                this.prepare();
            }
            if (this.context == null) {
                this.context = new Context();
            }
        }
        Context context = null;
        Context context2 = this.context;
        synchronized (context2) {
            context = this.context.inuse ? new Context() : this.context;
            context.reset(cArray, n2, n3, this.numberOfClosures);
        }
        if (match != null) {
            match.setNumberOfGroups(this.nofparen);
            match.setSource(cArray);
        } else if (this.hasBackReferences) {
            match = new Match();
            match.setNumberOfGroups(this.nofparen);
        }
        context.match = match;
        if (RegularExpression.isSet(this.options, 512)) {
            int n6 = this.matchCharArray(context, this.operations, context.start, 1, this.options);
            if (n6 == context.limit) {
                if (context.match != null) {
                    context.match.setBeginning(0, context.start);
                    context.match.setEnd(0, n6);
                }
                context.inuse = false;
                return true;
            }
            return false;
        }
        if (this.fixedStringOnly) {
            int n7 = this.fixedStringTable.matches(cArray, context.start, context.limit);
            if (n7 >= 0) {
                if (context.match != null) {
                    context.match.setBeginning(0, n7);
                    context.match.setEnd(0, n7 + this.fixedString.length());
                }
                context.inuse = false;
                return true;
            }
            context.inuse = false;
            return false;
        }
        if (this.fixedString != null && (n5 = this.fixedStringTable.matches(cArray, context.start, context.limit)) < 0) {
            context.inuse = false;
            return false;
        }
        n5 = context.limit - this.minlength;
        int n8 = -1;
        if (this.operations != null && this.operations.type == 7 && this.operations.getChild().type == 0) {
            if (RegularExpression.isSet(this.options, 4)) {
                n4 = context.start;
                n8 = this.matchCharArray(context, this.operations, context.start, 1, this.options);
            } else {
                boolean bl2 = true;
                n4 = context.start;
                while (n4 <= n5) {
                    char c2 = cArray[n4];
                    if (RegularExpression.isEOLChar(c2)) {
                        bl2 = true;
                    } else {
                        if (bl2 && 0 <= (n8 = this.matchCharArray(context, this.operations, n4, 1, this.options))) break;
                        bl2 = false;
                    }
                    ++n4;
                }
            }
        } else if (this.firstChar != null) {
            RangeToken rangeToken = this.firstChar;
            if (RegularExpression.isSet(this.options, 2)) {
                rangeToken = this.firstChar.getCaseInsensitiveToken();
                n4 = context.start;
                while (n4 <= n5) {
                    char c3;
                    int n9 = cArray[n4];
                    if (!(!REUtil.isHighSurrogate(n9) || n4 + 1 >= context.limit ? !rangeToken.match(n9) && !rangeToken.match(c3 = Character.toUpperCase((char)n9)) && !rangeToken.match(Character.toLowerCase(c3)) : !rangeToken.match(n9 = REUtil.composeFromSurrogates(n9, cArray[n4 + 1])))) {
                        n8 = this.matchCharArray(context, this.operations, n4, 1, this.options);
                        if (0 <= n8) break;
                    }
                    ++n4;
                }
            } else {
                n4 = context.start;
                while (n4 <= n5) {
                    int n10 = cArray[n4];
                    if (REUtil.isHighSurrogate(n10) && n4 + 1 < context.limit) {
                        n10 = REUtil.composeFromSurrogates(n10, cArray[n4 + 1]);
                    }
                    if (!rangeToken.match(n10) || 0 > (n8 = this.matchCharArray(context, this.operations, n4, 1, this.options))) {
                        ++n4;
                        continue;
                    }
                    break;
                }
            }
        } else {
            n4 = context.start;
            while (n4 <= n5) {
                n8 = this.matchCharArray(context, this.operations, n4, 1, this.options);
                if (0 > n8) {
                    ++n4;
                    continue;
                }
                break;
            }
        }
        if (n8 >= 0) {
            if (context.match != null) {
                context.match.setBeginning(0, n4);
                context.match.setEnd(0, n8);
            }
            context.inuse = false;
            return true;
        }
        context.inuse = false;
        return false;
    }

    /*
     * Could not resolve type clashes
     */
    private int matchCharArray(Context context, Op op, int n2, int n3, int n4) {
        char[] cArray = context.charTarget;
        block32: while (true) {
            if (op == null) {
                return RegularExpression.isSet(n4, 512) && n2 != context.limit ? -1 : n2;
            }
            if (n2 > context.limit || n2 < context.start) {
                return -1;
            }
            switch (op.type) {
                case 1: {
                    int n5;
                    if (RegularExpression.isSet(n4, 2)) {
                        n5 = op.getData();
                        if (n3 > 0) {
                            if (n2 >= context.limit || !RegularExpression.matchIgnoreCase(n5, cArray[n2])) {
                                return -1;
                            }
                            ++n2;
                        } else {
                            int n6 = n2 - 1;
                            if (n6 >= context.limit || n6 < 0 || !RegularExpression.matchIgnoreCase(n5, cArray[n6])) {
                                return -1;
                            }
                            n2 = n6;
                        }
                    } else {
                        n5 = op.getData();
                        if (n3 > 0) {
                            if (n2 >= context.limit || n5 != cArray[n2]) {
                                return -1;
                            }
                            ++n2;
                        } else {
                            int n7 = n2 - 1;
                            if (n7 >= context.limit || n7 < 0 || n5 != cArray[n7]) {
                                return -1;
                            }
                            n2 = n7;
                        }
                    }
                    op = op.next;
                    continue block32;
                }
                case 0: {
                    int n5;
                    if (n3 > 0) {
                        if (n2 >= context.limit) {
                            return -1;
                        }
                        n5 = cArray[n2];
                        if (RegularExpression.isSet(n4, 4)) {
                            if (REUtil.isHighSurrogate(n5) && n2 + 1 < context.limit) {
                                ++n2;
                            }
                        } else {
                            if (REUtil.isHighSurrogate(n5) && n2 + 1 < context.limit) {
                                n5 = REUtil.composeFromSurrogates(n5, cArray[++n2]);
                            }
                            if (RegularExpression.isEOLChar(n5)) {
                                return -1;
                            }
                        }
                        ++n2;
                    } else {
                        n5 = n2 - 1;
                        if (n5 >= context.limit || n5 < 0) {
                            return -1;
                        }
                        int n8 = cArray[n5];
                        if (RegularExpression.isSet(n4, 4)) {
                            if (REUtil.isLowSurrogate(n8) && n5 - 1 >= 0) {
                                // empty if block
                            }
                        } else {
                            if (REUtil.isLowSurrogate(n8) && n5 - 1 >= 0) {
                                n8 = REUtil.composeFromSurrogates(cArray[--n5], n8);
                            }
                            if (!RegularExpression.isEOLChar(n8)) {
                                return -1;
                            }
                        }
                        n2 = --n5;
                    }
                    op = op.next;
                    continue block32;
                }
                case 3: 
                case 4: {
                    char c2;
                    int n5;
                    if (n3 > 0) {
                        if (n2 >= context.limit) {
                            return -1;
                        }
                        n5 = cArray[n2];
                        if (REUtil.isHighSurrogate(n5) && n2 + 1 < context.limit) {
                            n5 = REUtil.composeFromSurrogates(n5, cArray[++n2]);
                        }
                        RangeToken rangeToken = op.getToken();
                        if (RegularExpression.isSet(n4, 2)) {
                            if (!(rangeToken = rangeToken.getCaseInsensitiveToken()).match(n5)) {
                                if (n5 >= 65536) {
                                    return -1;
                                }
                                char c3 = Character.toUpperCase((char)n5);
                                c2 = c3;
                                if (!rangeToken.match(c3) && !rangeToken.match(Character.toLowerCase(c2))) {
                                    return -1;
                                }
                            }
                        } else if (!rangeToken.match(n5)) {
                            return -1;
                        }
                        ++n2;
                    } else {
                        n5 = n2 - 1;
                        if (n5 >= context.limit || n5 < 0) {
                            return -1;
                        }
                        int n9 = cArray[n5];
                        if (REUtil.isLowSurrogate(n9) && n5 - 1 >= 0) {
                            n9 = REUtil.composeFromSurrogates(cArray[--n5], n9);
                        }
                        RangeToken rangeToken = op.getToken();
                        if (RegularExpression.isSet(n4, 2)) {
                            if (!(rangeToken = rangeToken.getCaseInsensitiveToken()).match(n9)) {
                                if (n9 >= 65536) {
                                    return -1;
                                }
                                char c4 = Character.toUpperCase((char)n9);
                                if (!rangeToken.match(c4) && !rangeToken.match(Character.toLowerCase(c4))) {
                                    return -1;
                                }
                            }
                        } else if (!rangeToken.match(n9)) {
                            return -1;
                        }
                        n2 = n5;
                    }
                    op = op.next;
                    continue block32;
                }
                case 5: {
                    char c2;
                    int n5 = 0;
                    switch (op.getData()) {
                        case 94: {
                            if (!(RegularExpression.isSet(n4, 8) ? n2 != context.start && (n2 <= context.start || !RegularExpression.isEOLChar(cArray[n2 - 1])) : n2 != context.start)) break;
                            return -1;
                        }
                        case 64: {
                            if (n2 == context.start || n2 > context.start && RegularExpression.isEOLChar(cArray[n2 - 1])) break;
                            return -1;
                        }
                        case 36: {
                            if (!(RegularExpression.isSet(n4, 8) ? n2 != context.limit && (n2 >= context.limit || !RegularExpression.isEOLChar(cArray[n2])) : !(n2 == context.limit || n2 + 1 == context.limit && RegularExpression.isEOLChar(cArray[n2]) || n2 + 2 == context.limit && cArray[n2] == '\r' && cArray[n2 + 1] == '\n'))) break;
                            return -1;
                        }
                        case 65: {
                            if (n2 == context.start) break;
                            return -1;
                        }
                        case 90: {
                            if (n2 == context.limit || n2 + 1 == context.limit && RegularExpression.isEOLChar(cArray[n2]) || n2 + 2 == context.limit && cArray[n2] == '\r' && cArray[n2 + 1] == '\n') break;
                            return -1;
                        }
                        case 122: {
                            if (n2 == context.limit) break;
                            return -1;
                        }
                        case 98: {
                            if (context.length == 0) {
                                return -1;
                            }
                            int n10 = RegularExpression.getWordType(cArray, context.start, context.limit, n2, n4);
                            if (n10 == 0) {
                                return -1;
                            }
                            c2 = RegularExpression.getPreviousWordType(cArray, context.start, context.limit, n2, n4);
                            if (n10 != c2) break;
                            return -1;
                        }
                        case 66: {
                            if (context.length == 0) {
                                n5 = 1;
                            } else {
                                int n11 = RegularExpression.getWordType(cArray, context.start, context.limit, n2, n4);
                                int n12 = n5 = n11 == 0 || n11 == RegularExpression.getPreviousWordType(cArray, context.start, context.limit, n2, n4) ? 1 : 0;
                            }
                            if (n5 != 0) break;
                            return -1;
                        }
                        case 60: {
                            if (context.length == 0 || n2 == context.limit) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(cArray, context.start, context.limit, n2, n4) == 1 && RegularExpression.getPreviousWordType(cArray, context.start, context.limit, n2, n4) == 2) break;
                            return -1;
                        }
                        case 62: {
                            if (context.length == 0 || n2 == context.start) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(cArray, context.start, context.limit, n2, n4) == 2 && RegularExpression.getPreviousWordType(cArray, context.start, context.limit, n2, n4) == 1) break;
                            return -1;
                        }
                    }
                    op = op.next;
                    continue block32;
                }
                case 16: {
                    int n13 = op.getData();
                    if (n13 <= 0 || n13 >= this.nofparen) {
                        throw new RuntimeException("Internal Error: Reference number must be more than zero: " + n13);
                    }
                    if (context.match.getBeginning(n13) < 0 || context.match.getEnd(n13) < 0) {
                        return -1;
                    }
                    char c2 = context.match.getBeginning(n13);
                    int n14 = context.match.getEnd(n13) - c2;
                    if (!RegularExpression.isSet(n4, 2)) {
                        if (n3 > 0) {
                            if (!RegularExpression.regionMatches(cArray, n2, context.limit, (int)c2, n14)) {
                                return -1;
                            }
                            n2 += n14;
                        } else {
                            if (!RegularExpression.regionMatches(cArray, n2 - n14, context.limit, (int)c2, n14)) {
                                return -1;
                            }
                            n2 -= n14;
                        }
                    } else if (n3 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(cArray, n2, context.limit, (int)c2, n14)) {
                            return -1;
                        }
                        n2 += n14;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(cArray, n2 - n14, context.limit, (int)c2, n14)) {
                            return -1;
                        }
                        n2 -= n14;
                    }
                    op = op.next;
                    continue block32;
                }
                case 6: {
                    String string2 = op.getString();
                    char c2 = string2.length();
                    if (!RegularExpression.isSet(n4, 2)) {
                        if (n3 > 0) {
                            if (!RegularExpression.regionMatches(cArray, n2, context.limit, string2, (int)c2)) {
                                return -1;
                            }
                            n2 += c2;
                        } else {
                            if (!RegularExpression.regionMatches(cArray, n2 - c2, context.limit, string2, (int)c2)) {
                                return -1;
                            }
                            n2 -= c2;
                        }
                    } else if (n3 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(cArray, n2, context.limit, string2, (int)c2)) {
                            return -1;
                        }
                        n2 += c2;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(cArray, n2 - c2, context.limit, string2, (int)c2)) {
                            return -1;
                        }
                        n2 -= c2;
                    }
                    op = op.next;
                    continue block32;
                }
                case 7: {
                    char c2;
                    int n15 = op.getData();
                    if (n15 >= 0) {
                        c2 = context.offsets[n15];
                        if (c2 < '\u0000' || c2 != n2) {
                            context.offsets[n15] = n2;
                        } else {
                            context.offsets[n15] = -1;
                            op = op.next;
                            continue block32;
                        }
                    }
                    c2 = this.matchCharArray(context, op.getChild(), n2, n3, n4);
                    if (n15 >= 0) {
                        context.offsets[n15] = -1;
                    }
                    if (c2 >= '\u0000') {
                        return c2;
                    }
                    op = op.next;
                    continue block32;
                }
                case 9: {
                    int n16 = this.matchCharArray(context, op.getChild(), n2, n3, n4);
                    if (n16 >= 0) {
                        return n16;
                    }
                    op = op.next;
                    continue block32;
                }
                case 8: 
                case 10: {
                    int n17 = this.matchCharArray(context, op.next, n2, n3, n4);
                    if (n17 >= 0) {
                        return n17;
                    }
                    op = op.getChild();
                    continue block32;
                }
                case 11: {
                    char c2;
                    int n18 = 0;
                    while (n18 < op.size()) {
                        c2 = this.matchCharArray(context, op.elementAt(n18), n2, n3, n4);
                        if (c2 >= '\u0000') {
                            return c2;
                        }
                        ++n18;
                    }
                    return -1;
                }
                case 15: {
                    int n19;
                    char c2 = op.getData();
                    if (context.match != null && c2 > '\u0000') {
                        int n20 = context.match.getBeginning(c2);
                        context.match.setBeginning(c2, n2);
                        n19 = this.matchCharArray(context, op.next, n2, n3, n4);
                        if (n19 < 0) {
                            context.match.setBeginning(c2, n20);
                        }
                        return n19;
                    }
                    if (context.match != null && c2 < '\u0000') {
                        char c5 = -c2;
                        n19 = context.match.getEnd(c5);
                        context.match.setEnd(c5, n2);
                        int n21 = this.matchCharArray(context, op.next, n2, n3, n4);
                        if (n21 < 0) {
                            context.match.setEnd(c5, n19);
                        }
                        return n21;
                    }
                    op = op.next;
                    continue block32;
                }
                case 20: {
                    if (0 > this.matchCharArray(context, op.getChild(), n2, 1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 21: {
                    if (0 <= this.matchCharArray(context, op.getChild(), n2, 1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 22: {
                    if (0 > this.matchCharArray(context, op.getChild(), n2, -1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 23: {
                    if (0 <= this.matchCharArray(context, op.getChild(), n2, -1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 24: {
                    int n22 = this.matchCharArray(context, op.getChild(), n2, n3, n4);
                    if (n22 < 0) {
                        return n22;
                    }
                    n2 = n22;
                    op = op.next;
                    continue block32;
                }
                case 25: {
                    int n23 = n4;
                    n23 |= op.getData();
                    int n19 = this.matchCharArray(context, op.getChild(), n2, n3, n23 &= ~op.getData2());
                    if (n19 < 0) {
                        return n19;
                    }
                    n2 = n19;
                    op = op.next;
                    continue block32;
                }
                case 26: {
                    Op.ConditionOp conditionOp = (Op.ConditionOp)op;
                    int n19 = 0;
                    if (conditionOp.refNumber > 0) {
                        if (conditionOp.refNumber >= this.nofparen) {
                            throw new RuntimeException("Internal Error: Reference number must be more than zero: " + conditionOp.refNumber);
                        }
                        n19 = context.match.getBeginning(conditionOp.refNumber) >= 0 && context.match.getEnd(conditionOp.refNumber) >= 0 ? 1 : 0;
                    } else {
                        int n24 = n19 = 0 <= this.matchCharArray(context, conditionOp.condition, n2, n3, n4) ? 1 : 0;
                    }
                    if (n19 != 0) {
                        op = conditionOp.yes;
                        continue block32;
                    }
                    if (conditionOp.no != null) {
                        op = conditionOp.no;
                        continue block32;
                    }
                    op = conditionOp.next;
                    continue block32;
                }
            }
            break;
        }
        throw new RuntimeException("Unknown operation type: " + op.type);
    }

    private static final int getPreviousWordType(char[] cArray, int n2, int n3, int n4, int n5) {
        int n6 = RegularExpression.getWordType(cArray, n2, n3, --n4, n5);
        while (n6 == 0) {
            n6 = RegularExpression.getWordType(cArray, n2, n3, --n4, n5);
        }
        return n6;
    }

    private static final int getWordType(char[] cArray, int n2, int n3, int n4, int n5) {
        if (n4 < n2 || n4 >= n3) {
            return 2;
        }
        return RegularExpression.getWordType0(cArray[n4], n5);
    }

    private static final boolean regionMatches(char[] cArray, int n2, int n3, String string2, int n4) {
        if (n2 < 0) {
            return false;
        }
        if (n3 - n2 < n4) {
            return false;
        }
        int n5 = 0;
        while (n4-- > 0) {
            if (cArray[n2++] == string2.charAt(n5++)) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatches(char[] cArray, int n2, int n3, int n4, int n5) {
        if (n2 < 0) {
            return false;
        }
        if (n3 - n2 < n5) {
            return false;
        }
        int n6 = n4;
        while (n5-- > 0) {
            if (cArray[n2++] == cArray[n6++]) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatchesIgnoreCase(char[] cArray, int n2, int n3, String string2, int n4) {
        if (n2 < 0) {
            return false;
        }
        if (n3 - n2 < n4) {
            return false;
        }
        int n5 = 0;
        while (n4-- > 0) {
            char c2;
            char c3;
            char c4;
            char c5;
            if ((c5 = cArray[n2++]) == (c4 = string2.charAt(n5++)) || (c3 = Character.toUpperCase(c5)) == (c2 = Character.toUpperCase(c4)) || Character.toLowerCase(c3) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatchesIgnoreCase(char[] cArray, int n2, int n3, int n4, int n5) {
        if (n2 < 0) {
            return false;
        }
        if (n3 - n2 < n5) {
            return false;
        }
        int n6 = n4;
        while (n5-- > 0) {
            char c2;
            char c3;
            char c4;
            char c5;
            if ((c5 = cArray[n2++]) == (c4 = cArray[n6++]) || (c3 = Character.toUpperCase(c5)) == (c2 = Character.toUpperCase(c4)) || Character.toLowerCase(c3) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(String string2) {
        return this.matches(string2, 0, string2.length(), (Match)null);
    }

    public boolean matches(String string2, int n2, int n3) {
        return this.matches(string2, n2, n3, (Match)null);
    }

    public boolean matches(String string2, Match match) {
        return this.matches(string2, 0, string2.length(), match);
    }

    public boolean matches(String string2, int n2, int n3, Match match) {
        int n4;
        int n5;
        RegularExpression regularExpression = this;
        synchronized (regularExpression) {
            if (this.operations == null) {
                this.prepare();
            }
            if (this.context == null) {
                this.context = new Context();
            }
        }
        Context context = null;
        Context context2 = this.context;
        synchronized (context2) {
            context = this.context.inuse ? new Context() : this.context;
            context.reset(string2, n2, n3, this.numberOfClosures);
        }
        if (match != null) {
            match.setNumberOfGroups(this.nofparen);
            match.setSource(string2);
        } else if (this.hasBackReferences) {
            match = new Match();
            match.setNumberOfGroups(this.nofparen);
        }
        context.match = match;
        if (RegularExpression.isSet(this.options, 512)) {
            int n6 = this.matchString(context, this.operations, context.start, 1, this.options);
            if (n6 == context.limit) {
                if (context.match != null) {
                    context.match.setBeginning(0, context.start);
                    context.match.setEnd(0, n6);
                }
                context.inuse = false;
                return true;
            }
            return false;
        }
        if (this.fixedStringOnly) {
            int n7 = this.fixedStringTable.matches(string2, context.start, context.limit);
            if (n7 >= 0) {
                if (context.match != null) {
                    context.match.setBeginning(0, n7);
                    context.match.setEnd(0, n7 + this.fixedString.length());
                }
                context.inuse = false;
                return true;
            }
            context.inuse = false;
            return false;
        }
        if (this.fixedString != null && (n5 = this.fixedStringTable.matches(string2, context.start, context.limit)) < 0) {
            context.inuse = false;
            return false;
        }
        n5 = context.limit - this.minlength;
        int n8 = -1;
        if (this.operations != null && this.operations.type == 7 && this.operations.getChild().type == 0) {
            if (RegularExpression.isSet(this.options, 4)) {
                n4 = context.start;
                n8 = this.matchString(context, this.operations, context.start, 1, this.options);
            } else {
                boolean bl2 = true;
                n4 = context.start;
                while (n4 <= n5) {
                    char c2 = string2.charAt(n4);
                    if (RegularExpression.isEOLChar(c2)) {
                        bl2 = true;
                    } else {
                        if (bl2 && 0 <= (n8 = this.matchString(context, this.operations, n4, 1, this.options))) break;
                        bl2 = false;
                    }
                    ++n4;
                }
            }
        } else if (this.firstChar != null) {
            RangeToken rangeToken = this.firstChar;
            if (RegularExpression.isSet(this.options, 2)) {
                rangeToken = this.firstChar.getCaseInsensitiveToken();
                n4 = context.start;
                while (n4 <= n5) {
                    char c3;
                    int n9 = string2.charAt(n4);
                    if (!(!REUtil.isHighSurrogate(n9) || n4 + 1 >= context.limit ? !rangeToken.match(n9) && !rangeToken.match(c3 = Character.toUpperCase((char)n9)) && !rangeToken.match(Character.toLowerCase(c3)) : !rangeToken.match(n9 = REUtil.composeFromSurrogates(n9, string2.charAt(n4 + 1))))) {
                        n8 = this.matchString(context, this.operations, n4, 1, this.options);
                        if (0 <= n8) break;
                    }
                    ++n4;
                }
            } else {
                n4 = context.start;
                while (n4 <= n5) {
                    int n10 = string2.charAt(n4);
                    if (REUtil.isHighSurrogate(n10) && n4 + 1 < context.limit) {
                        n10 = REUtil.composeFromSurrogates(n10, string2.charAt(n4 + 1));
                    }
                    if (!rangeToken.match(n10) || 0 > (n8 = this.matchString(context, this.operations, n4, 1, this.options))) {
                        ++n4;
                        continue;
                    }
                    break;
                }
            }
        } else {
            n4 = context.start;
            while (n4 <= n5) {
                n8 = this.matchString(context, this.operations, n4, 1, this.options);
                if (0 > n8) {
                    ++n4;
                    continue;
                }
                break;
            }
        }
        if (n8 >= 0) {
            if (context.match != null) {
                context.match.setBeginning(0, n4);
                context.match.setEnd(0, n8);
            }
            context.inuse = false;
            return true;
        }
        context.inuse = false;
        return false;
    }

    /*
     * Could not resolve type clashes
     */
    private int matchString(Context context, Op op, int n2, int n3, int n4) {
        String string2 = context.strTarget;
        block32: while (true) {
            if (op == null) {
                return RegularExpression.isSet(n4, 512) && n2 != context.limit ? -1 : n2;
            }
            if (n2 > context.limit || n2 < context.start) {
                return -1;
            }
            switch (op.type) {
                case 1: {
                    int n5;
                    if (RegularExpression.isSet(n4, 2)) {
                        n5 = op.getData();
                        if (n3 > 0) {
                            if (n2 >= context.limit || !RegularExpression.matchIgnoreCase(n5, string2.charAt(n2))) {
                                return -1;
                            }
                            ++n2;
                        } else {
                            int n6 = n2 - 1;
                            if (n6 >= context.limit || n6 < 0 || !RegularExpression.matchIgnoreCase(n5, string2.charAt(n6))) {
                                return -1;
                            }
                            n2 = n6;
                        }
                    } else {
                        n5 = op.getData();
                        if (n3 > 0) {
                            if (n2 >= context.limit || n5 != string2.charAt(n2)) {
                                return -1;
                            }
                            ++n2;
                        } else {
                            int n7 = n2 - 1;
                            if (n7 >= context.limit || n7 < 0 || n5 != string2.charAt(n7)) {
                                return -1;
                            }
                            n2 = n7;
                        }
                    }
                    op = op.next;
                    continue block32;
                }
                case 0: {
                    int n5;
                    if (n3 > 0) {
                        if (n2 >= context.limit) {
                            return -1;
                        }
                        n5 = string2.charAt(n2);
                        if (RegularExpression.isSet(n4, 4)) {
                            if (REUtil.isHighSurrogate(n5) && n2 + 1 < context.limit) {
                                ++n2;
                            }
                        } else {
                            if (REUtil.isHighSurrogate(n5) && n2 + 1 < context.limit) {
                                n5 = REUtil.composeFromSurrogates(n5, string2.charAt(++n2));
                            }
                            if (RegularExpression.isEOLChar(n5)) {
                                return -1;
                            }
                        }
                        ++n2;
                    } else {
                        n5 = n2 - 1;
                        if (n5 >= context.limit || n5 < 0) {
                            return -1;
                        }
                        int n8 = string2.charAt(n5);
                        if (RegularExpression.isSet(n4, 4)) {
                            if (REUtil.isLowSurrogate(n8) && n5 - 1 >= 0) {
                                // empty if block
                            }
                        } else {
                            if (REUtil.isLowSurrogate(n8) && n5 - 1 >= 0) {
                                n8 = REUtil.composeFromSurrogates(string2.charAt(--n5), n8);
                            }
                            if (!RegularExpression.isEOLChar(n8)) {
                                return -1;
                            }
                        }
                        n2 = --n5;
                    }
                    op = op.next;
                    continue block32;
                }
                case 3: 
                case 4: {
                    char c2;
                    int n5;
                    if (n3 > 0) {
                        if (n2 >= context.limit) {
                            return -1;
                        }
                        n5 = string2.charAt(n2);
                        if (REUtil.isHighSurrogate(n5) && n2 + 1 < context.limit) {
                            n5 = REUtil.composeFromSurrogates(n5, string2.charAt(++n2));
                        }
                        RangeToken rangeToken = op.getToken();
                        if (RegularExpression.isSet(n4, 2)) {
                            if (!(rangeToken = rangeToken.getCaseInsensitiveToken()).match(n5)) {
                                if (n5 >= 65536) {
                                    return -1;
                                }
                                char c3 = Character.toUpperCase((char)n5);
                                c2 = c3;
                                if (!rangeToken.match(c3) && !rangeToken.match(Character.toLowerCase(c2))) {
                                    return -1;
                                }
                            }
                        } else if (!rangeToken.match(n5)) {
                            return -1;
                        }
                        ++n2;
                    } else {
                        n5 = n2 - 1;
                        if (n5 >= context.limit || n5 < 0) {
                            return -1;
                        }
                        int n9 = string2.charAt(n5);
                        if (REUtil.isLowSurrogate(n9) && n5 - 1 >= 0) {
                            n9 = REUtil.composeFromSurrogates(string2.charAt(--n5), n9);
                        }
                        RangeToken rangeToken = op.getToken();
                        if (RegularExpression.isSet(n4, 2)) {
                            if (!(rangeToken = rangeToken.getCaseInsensitiveToken()).match(n9)) {
                                if (n9 >= 65536) {
                                    return -1;
                                }
                                char c4 = Character.toUpperCase((char)n9);
                                if (!rangeToken.match(c4) && !rangeToken.match(Character.toLowerCase(c4))) {
                                    return -1;
                                }
                            }
                        } else if (!rangeToken.match(n9)) {
                            return -1;
                        }
                        n2 = n5;
                    }
                    op = op.next;
                    continue block32;
                }
                case 5: {
                    char c2;
                    int n5 = 0;
                    switch (op.getData()) {
                        case 94: {
                            if (!(RegularExpression.isSet(n4, 8) ? n2 != context.start && (n2 <= context.start || !RegularExpression.isEOLChar(string2.charAt(n2 - 1))) : n2 != context.start)) break;
                            return -1;
                        }
                        case 64: {
                            if (n2 == context.start || n2 > context.start && RegularExpression.isEOLChar(string2.charAt(n2 - 1))) break;
                            return -1;
                        }
                        case 36: {
                            if (!(RegularExpression.isSet(n4, 8) ? n2 != context.limit && (n2 >= context.limit || !RegularExpression.isEOLChar(string2.charAt(n2))) : !(n2 == context.limit || n2 + 1 == context.limit && RegularExpression.isEOLChar(string2.charAt(n2)) || n2 + 2 == context.limit && string2.charAt(n2) == '\r' && string2.charAt(n2 + 1) == '\n'))) break;
                            return -1;
                        }
                        case 65: {
                            if (n2 == context.start) break;
                            return -1;
                        }
                        case 90: {
                            if (n2 == context.limit || n2 + 1 == context.limit && RegularExpression.isEOLChar(string2.charAt(n2)) || n2 + 2 == context.limit && string2.charAt(n2) == '\r' && string2.charAt(n2 + 1) == '\n') break;
                            return -1;
                        }
                        case 122: {
                            if (n2 == context.limit) break;
                            return -1;
                        }
                        case 98: {
                            if (context.length == 0) {
                                return -1;
                            }
                            int n10 = RegularExpression.getWordType(string2, context.start, context.limit, n2, n4);
                            if (n10 == 0) {
                                return -1;
                            }
                            c2 = RegularExpression.getPreviousWordType(string2, context.start, context.limit, n2, n4);
                            if (n10 != c2) break;
                            return -1;
                        }
                        case 66: {
                            if (context.length == 0) {
                                n5 = 1;
                            } else {
                                int n11 = RegularExpression.getWordType(string2, context.start, context.limit, n2, n4);
                                int n12 = n5 = n11 == 0 || n11 == RegularExpression.getPreviousWordType(string2, context.start, context.limit, n2, n4) ? 1 : 0;
                            }
                            if (n5 != 0) break;
                            return -1;
                        }
                        case 60: {
                            if (context.length == 0 || n2 == context.limit) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(string2, context.start, context.limit, n2, n4) == 1 && RegularExpression.getPreviousWordType(string2, context.start, context.limit, n2, n4) == 2) break;
                            return -1;
                        }
                        case 62: {
                            if (context.length == 0 || n2 == context.start) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(string2, context.start, context.limit, n2, n4) == 2 && RegularExpression.getPreviousWordType(string2, context.start, context.limit, n2, n4) == 1) break;
                            return -1;
                        }
                    }
                    op = op.next;
                    continue block32;
                }
                case 16: {
                    int n13 = op.getData();
                    if (n13 <= 0 || n13 >= this.nofparen) {
                        throw new RuntimeException("Internal Error: Reference number must be more than zero: " + n13);
                    }
                    if (context.match.getBeginning(n13) < 0 || context.match.getEnd(n13) < 0) {
                        return -1;
                    }
                    char c2 = context.match.getBeginning(n13);
                    int n14 = context.match.getEnd(n13) - c2;
                    if (!RegularExpression.isSet(n4, 2)) {
                        if (n3 > 0) {
                            if (!RegularExpression.regionMatches(string2, n2, context.limit, (int)c2, n14)) {
                                return -1;
                            }
                            n2 += n14;
                        } else {
                            if (!RegularExpression.regionMatches(string2, n2 - n14, context.limit, (int)c2, n14)) {
                                return -1;
                            }
                            n2 -= n14;
                        }
                    } else if (n3 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(string2, n2, context.limit, (int)c2, n14)) {
                            return -1;
                        }
                        n2 += n14;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(string2, n2 - n14, context.limit, (int)c2, n14)) {
                            return -1;
                        }
                        n2 -= n14;
                    }
                    op = op.next;
                    continue block32;
                }
                case 6: {
                    String string3 = op.getString();
                    char c2 = string3.length();
                    if (!RegularExpression.isSet(n4, 2)) {
                        if (n3 > 0) {
                            if (!RegularExpression.regionMatches(string2, n2, context.limit, string3, (int)c2)) {
                                return -1;
                            }
                            n2 += c2;
                        } else {
                            if (!RegularExpression.regionMatches(string2, n2 - c2, context.limit, string3, (int)c2)) {
                                return -1;
                            }
                            n2 -= c2;
                        }
                    } else if (n3 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(string2, n2, context.limit, string3, (int)c2)) {
                            return -1;
                        }
                        n2 += c2;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(string2, n2 - c2, context.limit, string3, (int)c2)) {
                            return -1;
                        }
                        n2 -= c2;
                    }
                    op = op.next;
                    continue block32;
                }
                case 7: {
                    char c2;
                    int n15 = op.getData();
                    if (n15 >= 0) {
                        c2 = context.offsets[n15];
                        if (c2 < '\u0000' || c2 != n2) {
                            context.offsets[n15] = n2;
                        } else {
                            context.offsets[n15] = -1;
                            op = op.next;
                            continue block32;
                        }
                    }
                    c2 = this.matchString(context, op.getChild(), n2, n3, n4);
                    if (n15 >= 0) {
                        context.offsets[n15] = -1;
                    }
                    if (c2 >= '\u0000') {
                        return c2;
                    }
                    op = op.next;
                    continue block32;
                }
                case 9: {
                    int n16 = this.matchString(context, op.getChild(), n2, n3, n4);
                    if (n16 >= 0) {
                        return n16;
                    }
                    op = op.next;
                    continue block32;
                }
                case 8: 
                case 10: {
                    int n17 = this.matchString(context, op.next, n2, n3, n4);
                    if (n17 >= 0) {
                        return n17;
                    }
                    op = op.getChild();
                    continue block32;
                }
                case 11: {
                    char c2;
                    int n18 = 0;
                    while (n18 < op.size()) {
                        c2 = this.matchString(context, op.elementAt(n18), n2, n3, n4);
                        if (c2 >= '\u0000') {
                            return c2;
                        }
                        ++n18;
                    }
                    return -1;
                }
                case 15: {
                    int n19;
                    char c2 = op.getData();
                    if (context.match != null && c2 > '\u0000') {
                        int n20 = context.match.getBeginning(c2);
                        context.match.setBeginning(c2, n2);
                        n19 = this.matchString(context, op.next, n2, n3, n4);
                        if (n19 < 0) {
                            context.match.setBeginning(c2, n20);
                        }
                        return n19;
                    }
                    if (context.match != null && c2 < '\u0000') {
                        char c5 = -c2;
                        n19 = context.match.getEnd(c5);
                        context.match.setEnd(c5, n2);
                        int n21 = this.matchString(context, op.next, n2, n3, n4);
                        if (n21 < 0) {
                            context.match.setEnd(c5, n19);
                        }
                        return n21;
                    }
                    op = op.next;
                    continue block32;
                }
                case 20: {
                    if (0 > this.matchString(context, op.getChild(), n2, 1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 21: {
                    if (0 <= this.matchString(context, op.getChild(), n2, 1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 22: {
                    if (0 > this.matchString(context, op.getChild(), n2, -1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 23: {
                    if (0 <= this.matchString(context, op.getChild(), n2, -1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 24: {
                    int n22 = this.matchString(context, op.getChild(), n2, n3, n4);
                    if (n22 < 0) {
                        return n22;
                    }
                    n2 = n22;
                    op = op.next;
                    continue block32;
                }
                case 25: {
                    int n23 = n4;
                    n23 |= op.getData();
                    int n19 = this.matchString(context, op.getChild(), n2, n3, n23 &= ~op.getData2());
                    if (n19 < 0) {
                        return n19;
                    }
                    n2 = n19;
                    op = op.next;
                    continue block32;
                }
                case 26: {
                    Op.ConditionOp conditionOp = (Op.ConditionOp)op;
                    int n19 = 0;
                    if (conditionOp.refNumber > 0) {
                        if (conditionOp.refNumber >= this.nofparen) {
                            throw new RuntimeException("Internal Error: Reference number must be more than zero: " + conditionOp.refNumber);
                        }
                        n19 = context.match.getBeginning(conditionOp.refNumber) >= 0 && context.match.getEnd(conditionOp.refNumber) >= 0 ? 1 : 0;
                    } else {
                        int n24 = n19 = 0 <= this.matchString(context, conditionOp.condition, n2, n3, n4) ? 1 : 0;
                    }
                    if (n19 != 0) {
                        op = conditionOp.yes;
                        continue block32;
                    }
                    if (conditionOp.no != null) {
                        op = conditionOp.no;
                        continue block32;
                    }
                    op = conditionOp.next;
                    continue block32;
                }
            }
            break;
        }
        throw new RuntimeException("Unknown operation type: " + op.type);
    }

    private static final int getPreviousWordType(String string2, int n2, int n3, int n4, int n5) {
        int n6 = RegularExpression.getWordType(string2, n2, n3, --n4, n5);
        while (n6 == 0) {
            n6 = RegularExpression.getWordType(string2, n2, n3, --n4, n5);
        }
        return n6;
    }

    private static final int getWordType(String string2, int n2, int n3, int n4, int n5) {
        if (n4 < n2 || n4 >= n3) {
            return 2;
        }
        return RegularExpression.getWordType0(string2.charAt(n4), n5);
    }

    private static final boolean regionMatches(String string2, int n2, int n3, String string3, int n4) {
        if (n3 - n2 < n4) {
            return false;
        }
        return string2.regionMatches(n2, string3, 0, n4);
    }

    private static final boolean regionMatches(String string2, int n2, int n3, int n4, int n5) {
        if (n3 - n2 < n5) {
            return false;
        }
        return string2.regionMatches(n2, string2, n4, n5);
    }

    private static final boolean regionMatchesIgnoreCase(String string2, int n2, int n3, String string3, int n4) {
        return string2.regionMatches(true, n2, string3, 0, n4);
    }

    private static final boolean regionMatchesIgnoreCase(String string2, int n2, int n3, int n4, int n5) {
        if (n3 - n2 < n5) {
            return false;
        }
        return string2.regionMatches(true, n2, string2, n4, n5);
    }

    public boolean matches(CharacterIterator characterIterator) {
        return this.matches(characterIterator, (Match)null);
    }

    public boolean matches(CharacterIterator characterIterator, Match match) {
        int n2;
        int n3;
        int n4 = characterIterator.getBeginIndex();
        int n5 = characterIterator.getEndIndex();
        RegularExpression regularExpression = this;
        synchronized (regularExpression) {
            if (this.operations == null) {
                this.prepare();
            }
            if (this.context == null) {
                this.context = new Context();
            }
        }
        Context context = null;
        Context context2 = this.context;
        synchronized (context2) {
            context = this.context.inuse ? new Context() : this.context;
            context.reset(characterIterator, n4, n5, this.numberOfClosures);
        }
        if (match != null) {
            match.setNumberOfGroups(this.nofparen);
            match.setSource(characterIterator);
        } else if (this.hasBackReferences) {
            match = new Match();
            match.setNumberOfGroups(this.nofparen);
        }
        context.match = match;
        if (RegularExpression.isSet(this.options, 512)) {
            int n6 = this.matchCharacterIterator(context, this.operations, context.start, 1, this.options);
            if (n6 == context.limit) {
                if (context.match != null) {
                    context.match.setBeginning(0, context.start);
                    context.match.setEnd(0, n6);
                }
                context.inuse = false;
                return true;
            }
            return false;
        }
        if (this.fixedStringOnly) {
            int n7 = this.fixedStringTable.matches(characterIterator, context.start, context.limit);
            if (n7 >= 0) {
                if (context.match != null) {
                    context.match.setBeginning(0, n7);
                    context.match.setEnd(0, n7 + this.fixedString.length());
                }
                context.inuse = false;
                return true;
            }
            context.inuse = false;
            return false;
        }
        if (this.fixedString != null && (n3 = this.fixedStringTable.matches(characterIterator, context.start, context.limit)) < 0) {
            context.inuse = false;
            return false;
        }
        n3 = context.limit - this.minlength;
        int n8 = -1;
        if (this.operations != null && this.operations.type == 7 && this.operations.getChild().type == 0) {
            if (RegularExpression.isSet(this.options, 4)) {
                n2 = context.start;
                n8 = this.matchCharacterIterator(context, this.operations, context.start, 1, this.options);
            } else {
                boolean bl2 = true;
                n2 = context.start;
                while (n2 <= n3) {
                    char c2 = characterIterator.setIndex(n2);
                    if (RegularExpression.isEOLChar(c2)) {
                        bl2 = true;
                    } else {
                        if (bl2 && 0 <= (n8 = this.matchCharacterIterator(context, this.operations, n2, 1, this.options))) break;
                        bl2 = false;
                    }
                    ++n2;
                }
            }
        } else if (this.firstChar != null) {
            RangeToken rangeToken = this.firstChar;
            if (RegularExpression.isSet(this.options, 2)) {
                rangeToken = this.firstChar.getCaseInsensitiveToken();
                n2 = context.start;
                while (n2 <= n3) {
                    char c3;
                    int n9 = characterIterator.setIndex(n2);
                    if (!(!REUtil.isHighSurrogate(n9) || n2 + 1 >= context.limit ? !rangeToken.match(n9) && !rangeToken.match(c3 = Character.toUpperCase((char)n9)) && !rangeToken.match(Character.toLowerCase(c3)) : !rangeToken.match(n9 = REUtil.composeFromSurrogates(n9, characterIterator.setIndex(n2 + 1))))) {
                        n8 = this.matchCharacterIterator(context, this.operations, n2, 1, this.options);
                        if (0 <= n8) break;
                    }
                    ++n2;
                }
            } else {
                n2 = context.start;
                while (n2 <= n3) {
                    int n10 = characterIterator.setIndex(n2);
                    if (REUtil.isHighSurrogate(n10) && n2 + 1 < context.limit) {
                        n10 = REUtil.composeFromSurrogates(n10, characterIterator.setIndex(n2 + 1));
                    }
                    if (!rangeToken.match(n10) || 0 > (n8 = this.matchCharacterIterator(context, this.operations, n2, 1, this.options))) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
        } else {
            n2 = context.start;
            while (n2 <= n3) {
                n8 = this.matchCharacterIterator(context, this.operations, n2, 1, this.options);
                if (0 > n8) {
                    ++n2;
                    continue;
                }
                break;
            }
        }
        if (n8 >= 0) {
            if (context.match != null) {
                context.match.setBeginning(0, n2);
                context.match.setEnd(0, n8);
            }
            context.inuse = false;
            return true;
        }
        context.inuse = false;
        return false;
    }

    /*
     * Could not resolve type clashes
     */
    private int matchCharacterIterator(Context context, Op op, int n2, int n3, int n4) {
        CharacterIterator characterIterator = context.ciTarget;
        block32: while (true) {
            if (op == null) {
                return RegularExpression.isSet(n4, 512) && n2 != context.limit ? -1 : n2;
            }
            if (n2 > context.limit || n2 < context.start) {
                return -1;
            }
            switch (op.type) {
                case 1: {
                    int n5;
                    if (RegularExpression.isSet(n4, 2)) {
                        n5 = op.getData();
                        if (n3 > 0) {
                            if (n2 >= context.limit || !RegularExpression.matchIgnoreCase(n5, characterIterator.setIndex(n2))) {
                                return -1;
                            }
                            ++n2;
                        } else {
                            int n6 = n2 - 1;
                            if (n6 >= context.limit || n6 < 0 || !RegularExpression.matchIgnoreCase(n5, characterIterator.setIndex(n6))) {
                                return -1;
                            }
                            n2 = n6;
                        }
                    } else {
                        n5 = op.getData();
                        if (n3 > 0) {
                            if (n2 >= context.limit || n5 != characterIterator.setIndex(n2)) {
                                return -1;
                            }
                            ++n2;
                        } else {
                            int n7 = n2 - 1;
                            if (n7 >= context.limit || n7 < 0 || n5 != characterIterator.setIndex(n7)) {
                                return -1;
                            }
                            n2 = n7;
                        }
                    }
                    op = op.next;
                    continue block32;
                }
                case 0: {
                    int n5;
                    if (n3 > 0) {
                        if (n2 >= context.limit) {
                            return -1;
                        }
                        n5 = characterIterator.setIndex(n2);
                        if (RegularExpression.isSet(n4, 4)) {
                            if (REUtil.isHighSurrogate(n5) && n2 + 1 < context.limit) {
                                ++n2;
                            }
                        } else {
                            if (REUtil.isHighSurrogate(n5) && n2 + 1 < context.limit) {
                                n5 = REUtil.composeFromSurrogates(n5, characterIterator.setIndex(++n2));
                            }
                            if (RegularExpression.isEOLChar(n5)) {
                                return -1;
                            }
                        }
                        ++n2;
                    } else {
                        n5 = n2 - 1;
                        if (n5 >= context.limit || n5 < 0) {
                            return -1;
                        }
                        int n8 = characterIterator.setIndex(n5);
                        if (RegularExpression.isSet(n4, 4)) {
                            if (REUtil.isLowSurrogate(n8) && n5 - 1 >= 0) {
                                // empty if block
                            }
                        } else {
                            if (REUtil.isLowSurrogate(n8) && n5 - 1 >= 0) {
                                n8 = REUtil.composeFromSurrogates(characterIterator.setIndex(--n5), n8);
                            }
                            if (!RegularExpression.isEOLChar(n8)) {
                                return -1;
                            }
                        }
                        n2 = --n5;
                    }
                    op = op.next;
                    continue block32;
                }
                case 3: 
                case 4: {
                    char c2;
                    int n5;
                    if (n3 > 0) {
                        if (n2 >= context.limit) {
                            return -1;
                        }
                        n5 = characterIterator.setIndex(n2);
                        if (REUtil.isHighSurrogate(n5) && n2 + 1 < context.limit) {
                            n5 = REUtil.composeFromSurrogates(n5, characterIterator.setIndex(++n2));
                        }
                        RangeToken rangeToken = op.getToken();
                        if (RegularExpression.isSet(n4, 2)) {
                            if (!(rangeToken = rangeToken.getCaseInsensitiveToken()).match(n5)) {
                                if (n5 >= 65536) {
                                    return -1;
                                }
                                char c3 = Character.toUpperCase((char)n5);
                                c2 = c3;
                                if (!rangeToken.match(c3) && !rangeToken.match(Character.toLowerCase(c2))) {
                                    return -1;
                                }
                            }
                        } else if (!rangeToken.match(n5)) {
                            return -1;
                        }
                        ++n2;
                    } else {
                        n5 = n2 - 1;
                        if (n5 >= context.limit || n5 < 0) {
                            return -1;
                        }
                        int n9 = characterIterator.setIndex(n5);
                        if (REUtil.isLowSurrogate(n9) && n5 - 1 >= 0) {
                            n9 = REUtil.composeFromSurrogates(characterIterator.setIndex(--n5), n9);
                        }
                        RangeToken rangeToken = op.getToken();
                        if (RegularExpression.isSet(n4, 2)) {
                            if (!(rangeToken = rangeToken.getCaseInsensitiveToken()).match(n9)) {
                                if (n9 >= 65536) {
                                    return -1;
                                }
                                char c4 = Character.toUpperCase((char)n9);
                                if (!rangeToken.match(c4) && !rangeToken.match(Character.toLowerCase(c4))) {
                                    return -1;
                                }
                            }
                        } else if (!rangeToken.match(n9)) {
                            return -1;
                        }
                        n2 = n5;
                    }
                    op = op.next;
                    continue block32;
                }
                case 5: {
                    char c2;
                    int n5 = 0;
                    switch (op.getData()) {
                        case 94: {
                            if (!(RegularExpression.isSet(n4, 8) ? n2 != context.start && (n2 <= context.start || !RegularExpression.isEOLChar(characterIterator.setIndex(n2 - 1))) : n2 != context.start)) break;
                            return -1;
                        }
                        case 64: {
                            if (n2 == context.start || n2 > context.start && RegularExpression.isEOLChar(characterIterator.setIndex(n2 - 1))) break;
                            return -1;
                        }
                        case 36: {
                            if (!(RegularExpression.isSet(n4, 8) ? n2 != context.limit && (n2 >= context.limit || !RegularExpression.isEOLChar(characterIterator.setIndex(n2))) : !(n2 == context.limit || n2 + 1 == context.limit && RegularExpression.isEOLChar(characterIterator.setIndex(n2)) || n2 + 2 == context.limit && characterIterator.setIndex(n2) == '\r' && characterIterator.setIndex(n2 + 1) == '\n'))) break;
                            return -1;
                        }
                        case 65: {
                            if (n2 == context.start) break;
                            return -1;
                        }
                        case 90: {
                            if (n2 == context.limit || n2 + 1 == context.limit && RegularExpression.isEOLChar(characterIterator.setIndex(n2)) || n2 + 2 == context.limit && characterIterator.setIndex(n2) == '\r' && characterIterator.setIndex(n2 + 1) == '\n') break;
                            return -1;
                        }
                        case 122: {
                            if (n2 == context.limit) break;
                            return -1;
                        }
                        case 98: {
                            if (context.length == 0) {
                                return -1;
                            }
                            int n10 = RegularExpression.getWordType(characterIterator, context.start, context.limit, n2, n4);
                            if (n10 == 0) {
                                return -1;
                            }
                            c2 = RegularExpression.getPreviousWordType(characterIterator, context.start, context.limit, n2, n4);
                            if (n10 != c2) break;
                            return -1;
                        }
                        case 66: {
                            if (context.length == 0) {
                                n5 = 1;
                            } else {
                                int n11 = RegularExpression.getWordType(characterIterator, context.start, context.limit, n2, n4);
                                int n12 = n5 = n11 == 0 || n11 == RegularExpression.getPreviousWordType(characterIterator, context.start, context.limit, n2, n4) ? 1 : 0;
                            }
                            if (n5 != 0) break;
                            return -1;
                        }
                        case 60: {
                            if (context.length == 0 || n2 == context.limit) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(characterIterator, context.start, context.limit, n2, n4) == 1 && RegularExpression.getPreviousWordType(characterIterator, context.start, context.limit, n2, n4) == 2) break;
                            return -1;
                        }
                        case 62: {
                            if (context.length == 0 || n2 == context.start) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(characterIterator, context.start, context.limit, n2, n4) == 2 && RegularExpression.getPreviousWordType(characterIterator, context.start, context.limit, n2, n4) == 1) break;
                            return -1;
                        }
                    }
                    op = op.next;
                    continue block32;
                }
                case 16: {
                    int n13 = op.getData();
                    if (n13 <= 0 || n13 >= this.nofparen) {
                        throw new RuntimeException("Internal Error: Reference number must be more than zero: " + n13);
                    }
                    if (context.match.getBeginning(n13) < 0 || context.match.getEnd(n13) < 0) {
                        return -1;
                    }
                    char c2 = context.match.getBeginning(n13);
                    int n14 = context.match.getEnd(n13) - c2;
                    if (!RegularExpression.isSet(n4, 2)) {
                        if (n3 > 0) {
                            if (!RegularExpression.regionMatches(characterIterator, n2, context.limit, (int)c2, n14)) {
                                return -1;
                            }
                            n2 += n14;
                        } else {
                            if (!RegularExpression.regionMatches(characterIterator, n2 - n14, context.limit, (int)c2, n14)) {
                                return -1;
                            }
                            n2 -= n14;
                        }
                    } else if (n3 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(characterIterator, n2, context.limit, (int)c2, n14)) {
                            return -1;
                        }
                        n2 += n14;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(characterIterator, n2 - n14, context.limit, (int)c2, n14)) {
                            return -1;
                        }
                        n2 -= n14;
                    }
                    op = op.next;
                    continue block32;
                }
                case 6: {
                    String string2 = op.getString();
                    char c2 = string2.length();
                    if (!RegularExpression.isSet(n4, 2)) {
                        if (n3 > 0) {
                            if (!RegularExpression.regionMatches(characterIterator, n2, context.limit, string2, (int)c2)) {
                                return -1;
                            }
                            n2 += c2;
                        } else {
                            if (!RegularExpression.regionMatches(characterIterator, n2 - c2, context.limit, string2, (int)c2)) {
                                return -1;
                            }
                            n2 -= c2;
                        }
                    } else if (n3 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(characterIterator, n2, context.limit, string2, (int)c2)) {
                            return -1;
                        }
                        n2 += c2;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(characterIterator, n2 - c2, context.limit, string2, (int)c2)) {
                            return -1;
                        }
                        n2 -= c2;
                    }
                    op = op.next;
                    continue block32;
                }
                case 7: {
                    char c2;
                    int n15 = op.getData();
                    if (n15 >= 0) {
                        c2 = context.offsets[n15];
                        if (c2 < '\u0000' || c2 != n2) {
                            context.offsets[n15] = n2;
                        } else {
                            context.offsets[n15] = -1;
                            op = op.next;
                            continue block32;
                        }
                    }
                    c2 = this.matchCharacterIterator(context, op.getChild(), n2, n3, n4);
                    if (n15 >= 0) {
                        context.offsets[n15] = -1;
                    }
                    if (c2 >= '\u0000') {
                        return c2;
                    }
                    op = op.next;
                    continue block32;
                }
                case 9: {
                    int n16 = this.matchCharacterIterator(context, op.getChild(), n2, n3, n4);
                    if (n16 >= 0) {
                        return n16;
                    }
                    op = op.next;
                    continue block32;
                }
                case 8: 
                case 10: {
                    int n17 = this.matchCharacterIterator(context, op.next, n2, n3, n4);
                    if (n17 >= 0) {
                        return n17;
                    }
                    op = op.getChild();
                    continue block32;
                }
                case 11: {
                    char c2;
                    int n18 = 0;
                    while (n18 < op.size()) {
                        c2 = this.matchCharacterIterator(context, op.elementAt(n18), n2, n3, n4);
                        if (c2 >= '\u0000') {
                            return c2;
                        }
                        ++n18;
                    }
                    return -1;
                }
                case 15: {
                    int n19;
                    char c2 = op.getData();
                    if (context.match != null && c2 > '\u0000') {
                        int n20 = context.match.getBeginning(c2);
                        context.match.setBeginning(c2, n2);
                        n19 = this.matchCharacterIterator(context, op.next, n2, n3, n4);
                        if (n19 < 0) {
                            context.match.setBeginning(c2, n20);
                        }
                        return n19;
                    }
                    if (context.match != null && c2 < '\u0000') {
                        char c5 = -c2;
                        n19 = context.match.getEnd(c5);
                        context.match.setEnd(c5, n2);
                        int n21 = this.matchCharacterIterator(context, op.next, n2, n3, n4);
                        if (n21 < 0) {
                            context.match.setEnd(c5, n19);
                        }
                        return n21;
                    }
                    op = op.next;
                    continue block32;
                }
                case 20: {
                    if (0 > this.matchCharacterIterator(context, op.getChild(), n2, 1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 21: {
                    if (0 <= this.matchCharacterIterator(context, op.getChild(), n2, 1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 22: {
                    if (0 > this.matchCharacterIterator(context, op.getChild(), n2, -1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 23: {
                    if (0 <= this.matchCharacterIterator(context, op.getChild(), n2, -1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 24: {
                    int n22 = this.matchCharacterIterator(context, op.getChild(), n2, n3, n4);
                    if (n22 < 0) {
                        return n22;
                    }
                    n2 = n22;
                    op = op.next;
                    continue block32;
                }
                case 25: {
                    int n23 = n4;
                    n23 |= op.getData();
                    int n19 = this.matchCharacterIterator(context, op.getChild(), n2, n3, n23 &= ~op.getData2());
                    if (n19 < 0) {
                        return n19;
                    }
                    n2 = n19;
                    op = op.next;
                    continue block32;
                }
                case 26: {
                    Op.ConditionOp conditionOp = (Op.ConditionOp)op;
                    int n19 = 0;
                    if (conditionOp.refNumber > 0) {
                        if (conditionOp.refNumber >= this.nofparen) {
                            throw new RuntimeException("Internal Error: Reference number must be more than zero: " + conditionOp.refNumber);
                        }
                        n19 = context.match.getBeginning(conditionOp.refNumber) >= 0 && context.match.getEnd(conditionOp.refNumber) >= 0 ? 1 : 0;
                    } else {
                        int n24 = n19 = 0 <= this.matchCharacterIterator(context, conditionOp.condition, n2, n3, n4) ? 1 : 0;
                    }
                    if (n19 != 0) {
                        op = conditionOp.yes;
                        continue block32;
                    }
                    if (conditionOp.no != null) {
                        op = conditionOp.no;
                        continue block32;
                    }
                    op = conditionOp.next;
                    continue block32;
                }
            }
            break;
        }
        throw new RuntimeException("Unknown operation type: " + op.type);
    }

    private static final int getPreviousWordType(CharacterIterator characterIterator, int n2, int n3, int n4, int n5) {
        int n6 = RegularExpression.getWordType(characterIterator, n2, n3, --n4, n5);
        while (n6 == 0) {
            n6 = RegularExpression.getWordType(characterIterator, n2, n3, --n4, n5);
        }
        return n6;
    }

    private static final int getWordType(CharacterIterator characterIterator, int n2, int n3, int n4, int n5) {
        if (n4 < n2 || n4 >= n3) {
            return 2;
        }
        return RegularExpression.getWordType0(characterIterator.setIndex(n4), n5);
    }

    private static final boolean regionMatches(CharacterIterator characterIterator, int n2, int n3, String string2, int n4) {
        if (n2 < 0) {
            return false;
        }
        if (n3 - n2 < n4) {
            return false;
        }
        int n5 = 0;
        while (n4-- > 0) {
            if (characterIterator.setIndex(n2++) == string2.charAt(n5++)) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatches(CharacterIterator characterIterator, int n2, int n3, int n4, int n5) {
        if (n2 < 0) {
            return false;
        }
        if (n3 - n2 < n5) {
            return false;
        }
        int n6 = n4;
        while (n5-- > 0) {
            if (characterIterator.setIndex(n2++) == characterIterator.setIndex(n6++)) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatchesIgnoreCase(CharacterIterator characterIterator, int n2, int n3, String string2, int n4) {
        if (n2 < 0) {
            return false;
        }
        if (n3 - n2 < n4) {
            return false;
        }
        int n5 = 0;
        while (n4-- > 0) {
            char c2;
            char c3;
            char c4;
            char c5;
            if ((c5 = characterIterator.setIndex(n2++)) == (c4 = string2.charAt(n5++)) || (c3 = Character.toUpperCase(c5)) == (c2 = Character.toUpperCase(c4)) || Character.toLowerCase(c3) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatchesIgnoreCase(CharacterIterator characterIterator, int n2, int n3, int n4, int n5) {
        if (n2 < 0) {
            return false;
        }
        if (n3 - n2 < n5) {
            return false;
        }
        int n6 = n4;
        while (n5-- > 0) {
            char c2;
            char c3;
            char c4;
            char c5;
            if ((c5 = characterIterator.setIndex(n2++)) == (c4 = characterIterator.setIndex(n6++)) || (c3 = Character.toUpperCase(c5)) == (c2 = Character.toUpperCase(c4)) || Character.toLowerCase(c3) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    void prepare() {
        Object object;
        int n2;
        this.compile(this.tokentree);
        this.minlength = this.tokentree.getMinLength();
        this.firstChar = null;
        if (!RegularExpression.isSet(this.options, 128) && !RegularExpression.isSet(this.options, 512) && (n2 = this.tokentree.analyzeFirstCharacter((RangeToken)(object = Token.createRange()), this.options)) == 1) {
            ((RangeToken)object).compactRanges();
            this.firstChar = object;
        }
        if (this.operations != null && (this.operations.type == 6 || this.operations.type == 1) && this.operations.next == null) {
            this.fixedStringOnly = true;
            if (this.operations.type == 6) {
                this.fixedString = this.operations.getString();
            } else if (this.operations.getData() >= 65536) {
                this.fixedString = REUtil.decomposeToSurrogates(this.operations.getData());
            } else {
                object = new char[1];
                object[0] = (char)this.operations.getData();
                this.fixedString = new String((char[])object);
            }
            this.fixedStringOptions = this.options;
            this.fixedStringTable = new BMPattern(this.fixedString, 256, RegularExpression.isSet(this.fixedStringOptions, 2));
        } else if (!RegularExpression.isSet(this.options, 256) && !RegularExpression.isSet(this.options, 512)) {
            object = new Token.FixedStringContainer();
            this.tokentree.findFixedString((Token.FixedStringContainer)object, this.options);
            this.fixedString = ((Token.FixedStringContainer)object).token == null ? null : ((Token.FixedStringContainer)object).token.getString();
            this.fixedStringOptions = ((Token.FixedStringContainer)object).options;
            if (this.fixedString != null && this.fixedString.length() < 2) {
                this.fixedString = null;
            }
            if (this.fixedString != null) {
                this.fixedStringTable = new BMPattern(this.fixedString, 256, RegularExpression.isSet(this.fixedStringOptions, 2));
            }
        }
    }

    private static final boolean isSet(int n2, int n3) {
        return (n2 & n3) == n3;
    }

    public RegularExpression(String string2) throws ParseException {
        this.setPattern(string2, null);
    }

    public RegularExpression(String string2, String string3) throws ParseException {
        this.setPattern(string2, string3);
    }

    RegularExpression(String string2, Token token2, int n2, boolean bl2, int n3) {
        this.regex = string2;
        this.tokentree = token2;
        this.nofparen = n2;
        this.options = n3;
        this.hasBackReferences = bl2;
    }

    public void setPattern(String string2) throws ParseException {
        this.setPattern(string2, this.options);
    }

    private void setPattern(String string2, int n2) throws ParseException {
        this.regex = string2;
        this.options = n2;
        RegexParser regexParser = RegularExpression.isSet(this.options, 512) ? new ParserForXMLSchema() : new RegexParser();
        this.tokentree = regexParser.parse(this.regex, this.options);
        this.nofparen = regexParser.parennumber;
        this.hasBackReferences = regexParser.hasBackReferences;
        this.operations = null;
        this.context = null;
    }

    public void setPattern(String string2, String string3) throws ParseException {
        this.setPattern(string2, REUtil.parseOptions(string3));
    }

    public String getPattern() {
        return this.regex;
    }

    public String toString() {
        return this.tokentree.toString(this.options);
    }

    public String getOptions() {
        return REUtil.createOptionString(this.options);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof RegularExpression)) {
            return false;
        }
        RegularExpression regularExpression = (RegularExpression)object;
        return this.regex.equals(regularExpression.regex) && this.options == regularExpression.options;
    }

    boolean equals(String string2, int n2) {
        return this.regex.equals(string2) && this.options == n2;
    }

    public int hashCode() {
        return (this.regex + "/" + this.getOptions()).hashCode();
    }

    public int getNumberOfGroups() {
        return this.nofparen;
    }

    private static final int getWordType0(char c2, int n2) {
        if (!RegularExpression.isSet(n2, 64)) {
            if (RegularExpression.isSet(n2, 32)) {
                return Token.getRange("IsWord", true).match(c2) ? 1 : 2;
            }
            return RegularExpression.isWordChar(c2) ? 1 : 2;
        }
        switch (Character.getType(c2)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return 1;
            }
            case 6: 
            case 7: 
            case 16: {
                return 0;
            }
            case 15: {
                switch (c2) {
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': {
                        return 2;
                    }
                }
                return 0;
            }
        }
        return 2;
    }

    private static final boolean isEOLChar(int n2) {
        return n2 == 10 || n2 == 13 || n2 == 8232 || n2 == 8233;
    }

    private static final boolean isWordChar(int n2) {
        if (n2 == 95) {
            return true;
        }
        if (n2 < 48) {
            return false;
        }
        if (n2 > 122) {
            return false;
        }
        if (n2 <= 57) {
            return true;
        }
        if (n2 < 65) {
            return false;
        }
        if (n2 <= 90) {
            return true;
        }
        return n2 >= 97;
    }

    private static final boolean matchIgnoreCase(int n2, int n3) {
        char c2;
        if (n2 == n3) {
            return true;
        }
        if (n2 > 65535 || n3 > 65535) {
            return false;
        }
        char c3 = Character.toUpperCase((char)n2);
        if (c3 == (c2 = Character.toUpperCase((char)n3))) {
            return true;
        }
        return Character.toLowerCase(c3) == Character.toLowerCase(c2);
    }

    static final class Context {
        CharacterIterator ciTarget;
        String strTarget;
        char[] charTarget;
        int start;
        int limit;
        int length;
        Match match;
        boolean inuse = false;
        int[] offsets;

        Context() {
        }

        private void resetCommon(int n2) {
            this.length = this.limit - this.start;
            this.inuse = true;
            this.match = null;
            if (this.offsets == null || this.offsets.length != n2) {
                this.offsets = new int[n2];
            }
            int n3 = 0;
            while (n3 < n2) {
                this.offsets[n3] = -1;
                ++n3;
            }
        }

        void reset(CharacterIterator characterIterator, int n2, int n3, int n4) {
            this.ciTarget = characterIterator;
            this.start = n2;
            this.limit = n3;
            this.resetCommon(n4);
        }

        void reset(String string2, int n2, int n3, int n4) {
            this.strTarget = string2;
            this.start = n2;
            this.limit = n3;
            this.resetCommon(n4);
        }

        void reset(char[] cArray, int n2, int n3, int n4) {
            this.charTarget = cArray;
            this.start = n2;
            this.limit = n3;
            this.resetCommon(n4);
        }
    }
}

