/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.impl.dv.xs;

import javax.xml.datatype.XMLGregorianCalendar;
import org.python.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.python.apache.xerces.impl.dv.ValidationContext;
import org.python.apache.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.python.apache.xerces.impl.dv.xs.SchemaDateTimeException;

public class MonthDV
extends AbstractDateTimeDV {
    public Object getActualValue(String string2, ValidationContext validationContext) throws InvalidDatatypeValueException {
        try {
            return this.parse(string2);
        }
        catch (Exception exception) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string2, "gMonth"});
        }
    }

    protected AbstractDateTimeDV.DateTimeData parse(String string2) throws SchemaDateTimeException {
        AbstractDateTimeDV.DateTimeData dateTimeData = new AbstractDateTimeDV.DateTimeData(string2, this);
        int n2 = string2.length();
        dateTimeData.year = 2000;
        dateTimeData.day = 1;
        if (string2.charAt(0) != '-' || string2.charAt(1) != '-') {
            throw new SchemaDateTimeException("Invalid format for gMonth: " + string2);
        }
        int n3 = 4;
        dateTimeData.month = this.parseInt(string2, 2, n3);
        if (string2.length() >= n3 + 2 && string2.charAt(n3) == '-' && string2.charAt(n3 + 1) == '-') {
            n3 += 2;
        }
        if (n3 < n2) {
            if (!this.isNextCharUTCSign(string2, n3, n2)) {
                throw new SchemaDateTimeException("Error in month parsing: " + string2);
            }
            this.getTimeZone(string2, dateTimeData, n3, n2);
        }
        this.validateDateTime(dateTimeData);
        this.saveUnnormalized(dateTimeData);
        if (dateTimeData.utc != 0 && dateTimeData.utc != 90) {
            this.normalize(dateTimeData);
        }
        dateTimeData.position = 1;
        return dateTimeData;
    }

    protected String dateToString(AbstractDateTimeDV.DateTimeData dateTimeData) {
        StringBuffer stringBuffer = new StringBuffer(5);
        stringBuffer.append('-');
        stringBuffer.append('-');
        this.append(stringBuffer, dateTimeData.month, 2);
        this.append(stringBuffer, (char)dateTimeData.utc, 0);
        return stringBuffer.toString();
    }

    protected XMLGregorianCalendar getXMLGregorianCalendar(AbstractDateTimeDV.DateTimeData dateTimeData) {
        return this.factory.newXMLGregorianCalendar(Integer.MIN_VALUE, dateTimeData.unNormMonth, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, dateTimeData.timezoneHr * 60 + dateTimeData.timezoneMin);
    }
}

