/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.impl.dv.xs;

import org.python.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.python.apache.xerces.impl.dv.ValidationContext;
import org.python.apache.xerces.impl.dv.xs.DoubleDV;
import org.python.apache.xerces.impl.dv.xs.TypeValidator;
import org.python.apache.xerces.xs.datatypes.XSFloat;

public class FloatDV
extends TypeValidator {
    public short getAllowedFacets() {
        return 2552;
    }

    public Object getActualValue(String string2, ValidationContext validationContext) throws InvalidDatatypeValueException {
        try {
            return new XFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string2, "float"});
        }
    }

    public int compare(Object object, Object object2) {
        return ((XFloat)object).compareTo((XFloat)object2);
    }

    public boolean isIdentical(Object object, Object object2) {
        if (object2 instanceof XFloat) {
            return ((XFloat)object).isIdentical((XFloat)object2);
        }
        return false;
    }

    private static final class XFloat
    implements XSFloat {
        private final float value;
        private String canonical;

        public XFloat(String string2) throws NumberFormatException {
            if (DoubleDV.isPossibleFP(string2)) {
                this.value = Float.parseFloat(string2);
            } else if (string2.equals("INF")) {
                this.value = Float.POSITIVE_INFINITY;
            } else if (string2.equals("-INF")) {
                this.value = Float.NEGATIVE_INFINITY;
            } else if (string2.equals("NaN")) {
                this.value = Float.NaN;
            } else {
                throw new NumberFormatException(string2);
            }
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof XFloat)) {
                return false;
            }
            XFloat xFloat = (XFloat)object;
            if (this.value == xFloat.value) {
                return true;
            }
            return this.value != this.value && xFloat.value != xFloat.value;
        }

        public int hashCode() {
            return this.value == 0.0f ? 0 : Float.floatToIntBits(this.value);
        }

        public boolean isIdentical(XFloat xFloat) {
            if (xFloat == this) {
                return true;
            }
            if (this.value == xFloat.value) {
                return this.value != 0.0f || Float.floatToIntBits(this.value) == Float.floatToIntBits(xFloat.value);
            }
            return this.value != this.value && xFloat.value != xFloat.value;
        }

        private int compareTo(XFloat xFloat) {
            float f2 = xFloat.value;
            if (this.value < f2) {
                return -1;
            }
            if (this.value > f2) {
                return 1;
            }
            if (this.value == f2) {
                return 0;
            }
            if (this.value != this.value) {
                if (f2 != f2) {
                    return 0;
                }
                return 2;
            }
            return 2;
        }

        public synchronized String toString() {
            if (this.canonical == null) {
                if (this.value == Float.POSITIVE_INFINITY) {
                    this.canonical = "INF";
                } else if (this.value == Float.NEGATIVE_INFINITY) {
                    this.canonical = "-INF";
                } else if (this.value != this.value) {
                    this.canonical = "NaN";
                } else if (this.value == 0.0f) {
                    this.canonical = "0.0E1";
                } else {
                    this.canonical = Float.toString(this.value);
                    if (this.canonical.indexOf(69) == -1) {
                        int n2;
                        int n3 = this.canonical.length();
                        char[] cArray = new char[n3 + 3];
                        this.canonical.getChars(0, n3, cArray, 0);
                        int n4 = n2 = cArray[0] == '-' ? 2 : 1;
                        if (this.value >= 1.0f || this.value <= -1.0f) {
                            int n5;
                            int n6 = n5 = this.canonical.indexOf(46);
                            while (n6 > n2) {
                                cArray[n6] = cArray[n6 - 1];
                                --n6;
                            }
                            cArray[n2] = 46;
                            while (cArray[n3 - 1] == '0') {
                                --n3;
                            }
                            if (cArray[n3 - 1] == '.') {
                                // empty if block
                            }
                            int n7 = ++n3;
                            cArray[n7] = 69;
                            int n8 = n5 - n2;
                            int n9 = ++n3;
                            ++n3;
                            cArray[n9] = (char)(n8 + 48);
                        } else {
                            int n10 = n2 + 1;
                            while (cArray[n10] == '0') {
                                ++n10;
                            }
                            cArray[n2 - 1] = cArray[n10];
                            cArray[n2] = 46;
                            int n11 = n10 + 1;
                            int n12 = n2 + 1;
                            while (n11 < n3) {
                                cArray[n12] = cArray[n11];
                                ++n11;
                                ++n12;
                            }
                            if ((n3 -= n10 - n2) == n2 + 1) {
                                cArray[n3++] = 48;
                            }
                            cArray[n3++] = 69;
                            cArray[n3++] = 45;
                            int n13 = n10 - n2;
                            cArray[n3++] = (char)(n13 + 48);
                        }
                        this.canonical = new String(cArray, 0, n3);
                    }
                }
            }
            return this.canonical;
        }

        public float getValue() {
            return this.value;
        }
    }
}

