/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.impl.dv.util;

public final class Base64 {
    private static final int BASELENGTH = 128;
    private static final int LOOKUPLENGTH = 64;
    private static final int TWENTYFOURBITGROUP = 24;
    private static final int EIGHTBIT = 8;
    private static final int SIXTEENBIT = 16;
    private static final int SIXBIT = 6;
    private static final int FOURBYTE = 4;
    private static final int SIGN = -128;
    private static final char PAD = '=';
    private static final boolean fDebug = false;
    private static final byte[] base64Alphabet = new byte[128];
    private static final char[] lookUpBase64Alphabet = new char[64];

    protected static boolean isWhiteSpace(char c2) {
        return c2 == ' ' || c2 == '\r' || c2 == '\n' || c2 == '\t';
    }

    protected static boolean isPad(char c2) {
        return c2 == '=';
    }

    protected static boolean isData(char c2) {
        return c2 < '\u0080' && base64Alphabet[c2] != -1;
    }

    protected static boolean isBase64(char c2) {
        return Base64.isWhiteSpace(c2) || Base64.isPad(c2) || Base64.isData(c2);
    }

    public static String encode(byte[] byArray) {
        byte by2;
        byte by3;
        if (byArray == null) {
            return null;
        }
        int n2 = byArray.length * 8;
        if (n2 == 0) {
            return "";
        }
        int n3 = n2 % 24;
        int n4 = n2 / 24;
        int n5 = n3 != 0 ? n4 + 1 : n4;
        char[] cArray = null;
        cArray = new char[n5 * 4];
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        byte by7 = 0;
        byte by8 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n4) {
            by6 = byArray[n7++];
            by7 = byArray[n7++];
            by8 = byArray[n7++];
            by5 = (byte)(by7 & 0xF);
            by4 = (byte)(by6 & 3);
            by3 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 2) : (byte)(by6 >> 2 ^ 0xC0);
            by2 = (by7 & 0xFFFFFF80) == 0 ? (byte)(by7 >> 4) : (byte)(by7 >> 4 ^ 0xF0);
            byte by9 = (by8 & 0xFFFFFF80) == 0 ? (byte)(by8 >> 6) : (byte)(by8 >> 6 ^ 0xFC);
            cArray[n6++] = lookUpBase64Alphabet[by3];
            cArray[n6++] = lookUpBase64Alphabet[by2 | by4 << 4];
            cArray[n6++] = lookUpBase64Alphabet[by5 << 2 | by9];
            cArray[n6++] = lookUpBase64Alphabet[by8 & 0x3F];
            ++n8;
        }
        if (n3 == 8) {
            by6 = byArray[n7];
            by4 = (byte)(by6 & 3);
            by3 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 2) : (byte)(by6 >> 2 ^ 0xC0);
            cArray[n6++] = lookUpBase64Alphabet[by3];
            cArray[n6++] = lookUpBase64Alphabet[by4 << 4];
            cArray[n6++] = 61;
            cArray[n6++] = 61;
        } else if (n3 == 16) {
            by6 = byArray[n7];
            by7 = byArray[n7 + 1];
            by5 = (byte)(by7 & 0xF);
            by4 = (byte)(by6 & 3);
            by3 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 2) : (byte)(by6 >> 2 ^ 0xC0);
            by2 = (by7 & 0xFFFFFF80) == 0 ? (byte)(by7 >> 4) : (byte)(by7 >> 4 ^ 0xF0);
            cArray[n6++] = lookUpBase64Alphabet[by3];
            cArray[n6++] = lookUpBase64Alphabet[by2 | by4 << 4];
            cArray[n6++] = lookUpBase64Alphabet[by5 << 2];
            cArray[n6++] = 61;
        }
        return new String(cArray);
    }

    public static byte[] decode(String string2) {
        if (string2 == null) {
            return null;
        }
        char[] cArray = string2.toCharArray();
        int n2 = Base64.removeWhiteSpace(cArray);
        if (n2 % 4 != 0) {
            return null;
        }
        int n3 = n2 / 4;
        if (n3 == 0) {
            return new byte[0];
        }
        byte[] byArray = null;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        char c2 = '\u0000';
        char c3 = '\u0000';
        char c4 = '\u0000';
        char c5 = '\u0000';
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        byArray = new byte[n3 * 3];
        while (n4 < n3 - 1) {
            if (!(Base64.isData(c2 = cArray[n6++]) && Base64.isData(c3 = cArray[n6++]) && Base64.isData(c4 = cArray[n6++]) && Base64.isData(c5 = cArray[n6++]))) {
                return null;
            }
            by2 = base64Alphabet[c2];
            by3 = base64Alphabet[c3];
            by4 = base64Alphabet[c4];
            by5 = base64Alphabet[c5];
            byArray[n5++] = (byte)(by2 << 2 | by3 >> 4);
            byArray[n5++] = (byte)((by3 & 0xF) << 4 | by4 >> 2 & 0xF);
            byArray[n5++] = (byte)(by4 << 6 | by5);
            ++n4;
        }
        if (!Base64.isData(c2 = cArray[n6++]) || !Base64.isData(c3 = cArray[n6++])) {
            return null;
        }
        by2 = base64Alphabet[c2];
        by3 = base64Alphabet[c3];
        c4 = cArray[n6++];
        c5 = cArray[n6++];
        if (!Base64.isData(c4) || !Base64.isData(c5)) {
            if (Base64.isPad(c4) && Base64.isPad(c5)) {
                if ((by3 & 0xF) != 0) {
                    return null;
                }
                byte[] byArray2 = new byte[n4 * 3 + 1];
                System.arraycopy(byArray, 0, byArray2, 0, n4 * 3);
                byArray2[n5] = (byte)(by2 << 2 | by3 >> 4);
                return byArray2;
            }
            if (!Base64.isPad(c4) && Base64.isPad(c5)) {
                by4 = base64Alphabet[c4];
                if ((by4 & 3) != 0) {
                    return null;
                }
                byte[] byArray3 = new byte[n4 * 3 + 2];
                System.arraycopy(byArray, 0, byArray3, 0, n4 * 3);
                byArray3[n5++] = (byte)(by2 << 2 | by3 >> 4);
                byArray3[n5] = (byte)((by3 & 0xF) << 4 | by4 >> 2 & 0xF);
                return byArray3;
            }
            return null;
        }
        by4 = base64Alphabet[c4];
        by5 = base64Alphabet[c5];
        byArray[n5++] = (byte)(by2 << 2 | by3 >> 4);
        byArray[n5++] = (byte)((by3 & 0xF) << 4 | by4 >> 2 & 0xF);
        byArray[n5++] = (byte)(by4 << 6 | by5);
        return byArray;
    }

    protected static int removeWhiteSpace(char[] cArray) {
        if (cArray == null) {
            return 0;
        }
        int n2 = 0;
        int n3 = cArray.length;
        int n4 = 0;
        while (n4 < n3) {
            if (!Base64.isWhiteSpace(cArray[n4])) {
                cArray[n2++] = cArray[n4];
            }
            ++n4;
        }
        return n2;
    }

    static {
        int n2 = 0;
        while (n2 < 128) {
            Base64.base64Alphabet[n2] = -1;
            ++n2;
        }
        int n3 = 90;
        while (n3 >= 65) {
            Base64.base64Alphabet[n3] = (byte)(n3 - 65);
            --n3;
        }
        int n4 = 122;
        while (n4 >= 97) {
            Base64.base64Alphabet[n4] = (byte)(n4 - 97 + 26);
            --n4;
        }
        int n5 = 57;
        while (n5 >= 48) {
            Base64.base64Alphabet[n5] = (byte)(n5 - 48 + 52);
            --n5;
        }
        Base64.base64Alphabet[43] = 62;
        Base64.base64Alphabet[47] = 63;
        int n6 = 0;
        while (n6 <= 25) {
            Base64.lookUpBase64Alphabet[n6] = (char)(65 + n6);
            ++n6;
        }
        int n7 = 26;
        int n8 = 0;
        while (n7 <= 51) {
            Base64.lookUpBase64Alphabet[n7] = (char)(97 + n8);
            ++n7;
            ++n8;
        }
        int n9 = 52;
        int n10 = 0;
        while (n9 <= 61) {
            Base64.lookUpBase64Alphabet[n9] = (char)(48 + n10);
            ++n9;
            ++n10;
        }
        Base64.lookUpBase64Alphabet[62] = 43;
        Base64.lookUpBase64Alphabet[63] = 47;
    }
}

