/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.impl.dtd;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.python.apache.xerces.impl.XMLErrorReporter;
import org.python.apache.xerces.impl.dtd.DTDGrammar;
import org.python.apache.xerces.impl.dtd.DTDGrammarBucket;
import org.python.apache.xerces.impl.dtd.XMLContentSpec;
import org.python.apache.xerces.impl.dtd.XMLDTDValidator;
import org.python.apache.xerces.impl.dtd.XMLEntityDecl;
import org.python.apache.xerces.util.SymbolTable;
import org.python.apache.xerces.util.XMLChar;
import org.python.apache.xerces.util.XMLSymbols;
import org.python.apache.xerces.xni.Augmentations;
import org.python.apache.xerces.xni.XMLDTDContentModelHandler;
import org.python.apache.xerces.xni.XMLDTDHandler;
import org.python.apache.xerces.xni.XMLLocator;
import org.python.apache.xerces.xni.XMLResourceIdentifier;
import org.python.apache.xerces.xni.XMLString;
import org.python.apache.xerces.xni.XNIException;
import org.python.apache.xerces.xni.grammars.Grammar;
import org.python.apache.xerces.xni.grammars.XMLGrammarPool;
import org.python.apache.xerces.xni.parser.XMLComponent;
import org.python.apache.xerces.xni.parser.XMLComponentManager;
import org.python.apache.xerces.xni.parser.XMLConfigurationException;
import org.python.apache.xerces.xni.parser.XMLDTDContentModelFilter;
import org.python.apache.xerces.xni.parser.XMLDTDContentModelSource;
import org.python.apache.xerces.xni.parser.XMLDTDFilter;
import org.python.apache.xerces.xni.parser.XMLDTDSource;

public class XMLDTDProcessor
implements XMLComponent,
XMLDTDFilter,
XMLDTDContentModelFilter {
    private static final int TOP_LEVEL_SCOPE = -1;
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String NOTIFY_CHAR_REFS = "http://apache.org/xml/features/scanner/notify-char-refs";
    protected static final String WARN_ON_DUPLICATE_ATTDEF = "http://apache.org/xml/features/validation/warn-on-duplicate-attdef";
    protected static final String WARN_ON_UNDECLARED_ELEMDEF = "http://apache.org/xml/features/validation/warn-on-undeclared-elemdef";
    protected static final String PARSER_SETTINGS = "http://apache.org/xml/features/internal/parser-settings";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    protected static final String DTD_VALIDATOR = "http://apache.org/xml/properties/internal/validator/dtd";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/validation", "http://apache.org/xml/features/validation/warn-on-duplicate-attdef", "http://apache.org/xml/features/validation/warn-on-undeclared-elemdef", "http://apache.org/xml/features/scanner/notify-char-refs"};
    private static final Boolean[] FEATURE_DEFAULTS = new Boolean[]{null, Boolean.FALSE, Boolean.FALSE, null};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/grammar-pool", "http://apache.org/xml/properties/internal/validator/dtd"};
    private static final Object[] PROPERTY_DEFAULTS = new Object[]{null, null, null, null};
    protected boolean fValidation;
    protected boolean fDTDValidation;
    protected boolean fWarnDuplicateAttdef;
    protected boolean fWarnOnUndeclaredElemdef;
    protected SymbolTable fSymbolTable;
    protected XMLErrorReporter fErrorReporter;
    protected DTDGrammarBucket fGrammarBucket;
    protected XMLDTDValidator fValidator;
    protected XMLGrammarPool fGrammarPool;
    protected Locale fLocale;
    protected XMLDTDHandler fDTDHandler;
    protected XMLDTDSource fDTDSource;
    protected XMLDTDContentModelHandler fDTDContentModelHandler;
    protected XMLDTDContentModelSource fDTDContentModelSource;
    protected DTDGrammar fDTDGrammar;
    private boolean fPerformValidation;
    protected boolean fInDTDIgnore;
    private boolean fMixed;
    private final XMLEntityDecl fEntityDecl = new XMLEntityDecl();
    private final Hashtable fNDataDeclNotations = new Hashtable();
    private String fDTDElementDeclName = null;
    private final Vector fMixedElementTypes = new Vector();
    private final Vector fDTDElementDecls = new Vector();
    private Hashtable fTableOfIDAttributeNames;
    private Hashtable fTableOfNOTATIONAttributeNames;
    private Hashtable fNotationEnumVals;

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        boolean bl2;
        try {
            bl2 = xMLComponentManager.getFeature(PARSER_SETTINGS);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            bl2 = true;
        }
        if (!bl2) {
            this.reset();
            return;
        }
        try {
            this.fValidation = xMLComponentManager.getFeature(VALIDATION);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fValidation = false;
        }
        try {
            this.fDTDValidation = !xMLComponentManager.getFeature("http://apache.org/xml/features/validation/schema");
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fDTDValidation = true;
        }
        try {
            this.fWarnDuplicateAttdef = xMLComponentManager.getFeature(WARN_ON_DUPLICATE_ATTDEF);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fWarnDuplicateAttdef = false;
        }
        try {
            this.fWarnOnUndeclaredElemdef = xMLComponentManager.getFeature(WARN_ON_UNDECLARED_ELEMDEF);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fWarnOnUndeclaredElemdef = false;
        }
        this.fErrorReporter = (XMLErrorReporter)xMLComponentManager.getProperty(ERROR_REPORTER);
        this.fSymbolTable = (SymbolTable)xMLComponentManager.getProperty(SYMBOL_TABLE);
        try {
            this.fGrammarPool = (XMLGrammarPool)xMLComponentManager.getProperty(GRAMMAR_POOL);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fGrammarPool = null;
        }
        try {
            this.fValidator = (XMLDTDValidator)xMLComponentManager.getProperty(DTD_VALIDATOR);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fValidator = null;
        }
        catch (ClassCastException classCastException) {
            this.fValidator = null;
        }
        this.fGrammarBucket = this.fValidator != null ? this.fValidator.getGrammarBucket() : null;
        this.reset();
    }

    protected void reset() {
        this.fDTDGrammar = null;
        this.fInDTDIgnore = false;
        this.fNDataDeclNotations.clear();
        if (this.fValidation) {
            if (this.fNotationEnumVals == null) {
                this.fNotationEnumVals = new Hashtable();
            }
            this.fNotationEnumVals.clear();
            this.fTableOfIDAttributeNames = new Hashtable();
            this.fTableOfNOTATIONAttributeNames = new Hashtable();
        }
    }

    public String[] getRecognizedFeatures() {
        return (String[])RECOGNIZED_FEATURES.clone();
    }

    public void setFeature(String string2, boolean bl2) throws XMLConfigurationException {
    }

    public String[] getRecognizedProperties() {
        return (String[])RECOGNIZED_PROPERTIES.clone();
    }

    public void setProperty(String string2, Object object) throws XMLConfigurationException {
    }

    public Boolean getFeatureDefault(String string2) {
        int n2 = 0;
        while (n2 < RECOGNIZED_FEATURES.length) {
            if (RECOGNIZED_FEATURES[n2].equals(string2)) {
                return FEATURE_DEFAULTS[n2];
            }
            ++n2;
        }
        return null;
    }

    public Object getPropertyDefault(String string2) {
        int n2 = 0;
        while (n2 < RECOGNIZED_PROPERTIES.length) {
            if (RECOGNIZED_PROPERTIES[n2].equals(string2)) {
                return PROPERTY_DEFAULTS[n2];
            }
            ++n2;
        }
        return null;
    }

    public void setDTDHandler(XMLDTDHandler xMLDTDHandler) {
        this.fDTDHandler = xMLDTDHandler;
    }

    public XMLDTDHandler getDTDHandler() {
        return this.fDTDHandler;
    }

    public void setDTDContentModelHandler(XMLDTDContentModelHandler xMLDTDContentModelHandler) {
        this.fDTDContentModelHandler = xMLDTDContentModelHandler;
    }

    public XMLDTDContentModelHandler getDTDContentModelHandler() {
        return this.fDTDContentModelHandler;
    }

    public void startExternalSubset(XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.startExternalSubset(xMLResourceIdentifier, augmentations);
        }
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startExternalSubset(xMLResourceIdentifier, augmentations);
        }
    }

    public void endExternalSubset(Augmentations augmentations) throws XNIException {
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.endExternalSubset(augmentations);
        }
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endExternalSubset(augmentations);
        }
    }

    protected static void checkStandaloneEntityRef(String string2, DTDGrammar dTDGrammar, XMLEntityDecl xMLEntityDecl, XMLErrorReporter xMLErrorReporter) throws XNIException {
        int n2 = dTDGrammar.getEntityDeclIndex(string2);
        if (n2 > -1) {
            dTDGrammar.getEntityDecl(n2, xMLEntityDecl);
            if (xMLEntityDecl.inExternal) {
                xMLErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_REFERENCE_TO_EXTERNALLY_DECLARED_ENTITY_WHEN_STANDALONE", new Object[]{string2}, (short)1);
            }
        }
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.comment(xMLString, augmentations);
        }
        if (this.fDTDHandler != null) {
            this.fDTDHandler.comment(xMLString, augmentations);
        }
    }

    public void processingInstruction(String string2, XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.processingInstruction(string2, xMLString, augmentations);
        }
        if (this.fDTDHandler != null) {
            this.fDTDHandler.processingInstruction(string2, xMLString, augmentations);
        }
    }

    public void startDTD(XMLLocator xMLLocator, Augmentations augmentations) throws XNIException {
        this.fNDataDeclNotations.clear();
        this.fDTDElementDecls.removeAllElements();
        if (!this.fGrammarBucket.getActiveGrammar().isImmutable()) {
            this.fDTDGrammar = this.fGrammarBucket.getActiveGrammar();
        }
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.startDTD(xMLLocator, augmentations);
        }
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startDTD(xMLLocator, augmentations);
        }
    }

    public void ignoredCharacters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.ignoredCharacters(xMLString, augmentations);
        }
        if (this.fDTDHandler != null) {
            this.fDTDHandler.ignoredCharacters(xMLString, augmentations);
        }
    }

    public void textDecl(String string2, String string3, Augmentations augmentations) throws XNIException {
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.textDecl(string2, string3, augmentations);
        }
        if (this.fDTDHandler != null) {
            this.fDTDHandler.textDecl(string2, string3, augmentations);
        }
    }

    public void startParameterEntity(String string2, XMLResourceIdentifier xMLResourceIdentifier, String string3, Augmentations augmentations) throws XNIException {
        if (this.fPerformValidation && this.fDTDGrammar != null && this.fGrammarBucket.getStandalone()) {
            XMLDTDProcessor.checkStandaloneEntityRef(string2, this.fDTDGrammar, this.fEntityDecl, this.fErrorReporter);
        }
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.startParameterEntity(string2, xMLResourceIdentifier, string3, augmentations);
        }
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startParameterEntity(string2, xMLResourceIdentifier, string3, augmentations);
        }
    }

    public void endParameterEntity(String string2, Augmentations augmentations) throws XNIException {
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.endParameterEntity(string2, augmentations);
        }
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endParameterEntity(string2, augmentations);
        }
    }

    public void elementDecl(String string2, String string3, Augmentations augmentations) throws XNIException {
        if (this.fValidation) {
            if (this.fDTDElementDecls.contains(string2)) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_ELEMENT_ALREADY_DECLARED", new Object[]{string2}, (short)1);
            } else {
                this.fDTDElementDecls.addElement(string2);
            }
        }
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.elementDecl(string2, string3, augmentations);
        }
        if (this.fDTDHandler != null) {
            this.fDTDHandler.elementDecl(string2, string3, augmentations);
        }
    }

    public void startAttlist(String string2, Augmentations augmentations) throws XNIException {
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.startAttlist(string2, augmentations);
        }
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startAttlist(string2, augmentations);
        }
    }

    public void attributeDecl(String string2, String string3, String string4, String[] stringArray, String string5, XMLString xMLString, XMLString xMLString2, Augmentations augmentations) throws XNIException {
        if (string4 != XMLSymbols.fCDATASymbol && xMLString != null) {
            this.normalizeDefaultAttrValue(xMLString);
        }
        if (this.fValidation) {
            String string6;
            int n2;
            boolean bl2 = false;
            DTDGrammar dTDGrammar = this.fDTDGrammar != null ? this.fDTDGrammar : this.fGrammarBucket.getActiveGrammar();
            if (dTDGrammar.getAttributeDeclIndex(n2 = dTDGrammar.getElementDeclIndex(string2), string3) != -1) {
                bl2 = true;
                if (this.fWarnDuplicateAttdef) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_DUPLICATE_ATTRIBUTE_DEFINITION", new Object[]{string2, string3}, (short)0);
                }
            }
            if (string4 == XMLSymbols.fIDSymbol) {
                if (xMLString != null && xMLString.length != 0 && (string5 == null || string5 != XMLSymbols.fIMPLIEDSymbol && string5 != XMLSymbols.fREQUIREDSymbol)) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "IDDefaultTypeInvalid", new Object[]{string3}, (short)1);
                }
                if (!this.fTableOfIDAttributeNames.containsKey(string2)) {
                    this.fTableOfIDAttributeNames.put(string2, string3);
                } else if (!bl2) {
                    String string7 = (String)this.fTableOfIDAttributeNames.get(string2);
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_MORE_THAN_ONE_ID_ATTRIBUTE", new Object[]{string2, string7, string3}, (short)1);
                }
            }
            if (string4 == XMLSymbols.fNOTATIONSymbol) {
                int n3 = 0;
                while (n3 < stringArray.length) {
                    this.fNotationEnumVals.put(stringArray[n3], string3);
                    ++n3;
                }
                if (!this.fTableOfNOTATIONAttributeNames.containsKey(string2)) {
                    this.fTableOfNOTATIONAttributeNames.put(string2, string3);
                } else if (!bl2) {
                    string6 = (String)this.fTableOfNOTATIONAttributeNames.get(string2);
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_MORE_THAN_ONE_NOTATION_ATTRIBUTE", new Object[]{string2, string6, string3}, (short)1);
                }
            }
            if (string4 == XMLSymbols.fENUMERATIONSymbol || string4 == XMLSymbols.fNOTATIONSymbol) {
                int n4 = 0;
                block1: while (n4 < stringArray.length) {
                    int n5 = n4 + 1;
                    while (n5 < stringArray.length) {
                        if (stringArray[n4].equals(stringArray[n5])) {
                            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", string4 == XMLSymbols.fENUMERATIONSymbol ? "MSG_DISTINCT_TOKENS_IN_ENUMERATION" : "MSG_DISTINCT_NOTATION_IN_ENUMERATION", new Object[]{string2, stringArray[n4], string3}, (short)1);
                            break block1;
                        }
                        ++n5;
                    }
                    ++n4;
                }
            }
            boolean bl3 = true;
            if (xMLString != null && (string5 == null || string5 != null && string5 == XMLSymbols.fFIXEDSymbol)) {
                string6 = xMLString.toString();
                if (string4 == XMLSymbols.fNMTOKENSSymbol || string4 == XMLSymbols.fENTITIESSymbol || string4 == XMLSymbols.fIDREFSSymbol) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string6, " ");
                    if (stringTokenizer.hasMoreTokens()) {
                        do {
                            String string8 = stringTokenizer.nextToken();
                            if (string4 == XMLSymbols.fNMTOKENSSymbol) {
                                if (this.isValidNmtoken(string8)) continue;
                                bl3 = false;
                            } else {
                                if (string4 != XMLSymbols.fENTITIESSymbol && string4 != XMLSymbols.fIDREFSSymbol || this.isValidName(string8)) continue;
                                bl3 = false;
                            }
                            break;
                        } while (stringTokenizer.hasMoreTokens());
                    }
                } else {
                    if (string4 == XMLSymbols.fENTITYSymbol || string4 == XMLSymbols.fIDSymbol || string4 == XMLSymbols.fIDREFSymbol || string4 == XMLSymbols.fNOTATIONSymbol) {
                        if (!this.isValidName(string6)) {
                            bl3 = false;
                        }
                    } else if (!(string4 != XMLSymbols.fNMTOKENSymbol && string4 != XMLSymbols.fENUMERATIONSymbol || this.isValidNmtoken(string6))) {
                        bl3 = false;
                    }
                    if (string4 == XMLSymbols.fNOTATIONSymbol || string4 == XMLSymbols.fENUMERATIONSymbol) {
                        bl3 = false;
                        int n6 = 0;
                        while (n6 < stringArray.length) {
                            if (xMLString.equals(stringArray[n6])) {
                                bl3 = true;
                            }
                            ++n6;
                        }
                    }
                }
                if (!bl3) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_ATT_DEFAULT_INVALID", new Object[]{string3, string6}, (short)1);
                }
            }
        }
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.attributeDecl(string2, string3, string4, stringArray, string5, xMLString, xMLString2, augmentations);
        }
        if (this.fDTDHandler != null) {
            this.fDTDHandler.attributeDecl(string2, string3, string4, stringArray, string5, xMLString, xMLString2, augmentations);
        }
    }

    public void endAttlist(Augmentations augmentations) throws XNIException {
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.endAttlist(augmentations);
        }
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endAttlist(augmentations);
        }
    }

    public void internalEntityDecl(String string2, XMLString xMLString, XMLString xMLString2, Augmentations augmentations) throws XNIException {
        DTDGrammar dTDGrammar = this.fDTDGrammar != null ? this.fDTDGrammar : this.fGrammarBucket.getActiveGrammar();
        int n2 = dTDGrammar.getEntityDeclIndex(string2);
        if (n2 == -1) {
            if (this.fDTDGrammar != null) {
                this.fDTDGrammar.internalEntityDecl(string2, xMLString, xMLString2, augmentations);
            }
            if (this.fDTDHandler != null) {
                this.fDTDHandler.internalEntityDecl(string2, xMLString, xMLString2, augmentations);
            }
        }
    }

    public void externalEntityDecl(String string2, XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
        DTDGrammar dTDGrammar = this.fDTDGrammar != null ? this.fDTDGrammar : this.fGrammarBucket.getActiveGrammar();
        int n2 = dTDGrammar.getEntityDeclIndex(string2);
        if (n2 == -1) {
            if (this.fDTDGrammar != null) {
                this.fDTDGrammar.externalEntityDecl(string2, xMLResourceIdentifier, augmentations);
            }
            if (this.fDTDHandler != null) {
                this.fDTDHandler.externalEntityDecl(string2, xMLResourceIdentifier, augmentations);
            }
        }
    }

    public void unparsedEntityDecl(String string2, XMLResourceIdentifier xMLResourceIdentifier, String string3, Augmentations augmentations) throws XNIException {
        if (this.fValidation) {
            this.fNDataDeclNotations.put(string2, string3);
        }
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.unparsedEntityDecl(string2, xMLResourceIdentifier, string3, augmentations);
        }
        if (this.fDTDHandler != null) {
            this.fDTDHandler.unparsedEntityDecl(string2, xMLResourceIdentifier, string3, augmentations);
        }
    }

    public void notationDecl(String string2, XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
        if (this.fValidation) {
            DTDGrammar dTDGrammar;
            DTDGrammar dTDGrammar2 = dTDGrammar = this.fDTDGrammar != null ? this.fDTDGrammar : this.fGrammarBucket.getActiveGrammar();
            if (dTDGrammar.getNotationDeclIndex(string2) != -1) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "UniqueNotationName", new Object[]{string2}, (short)1);
            }
        }
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.notationDecl(string2, xMLResourceIdentifier, augmentations);
        }
        if (this.fDTDHandler != null) {
            this.fDTDHandler.notationDecl(string2, xMLResourceIdentifier, augmentations);
        }
    }

    public void startConditional(short s2, Augmentations augmentations) throws XNIException {
        boolean bl2 = this.fInDTDIgnore = s2 == 1;
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.startConditional(s2, augmentations);
        }
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startConditional(s2, augmentations);
        }
    }

    public void endConditional(Augmentations augmentations) throws XNIException {
        this.fInDTDIgnore = false;
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.endConditional(augmentations);
        }
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endConditional(augmentations);
        }
    }

    public void endDTD(Augmentations augmentations) throws XNIException {
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.endDTD(augmentations);
            if (this.fGrammarPool != null) {
                this.fGrammarPool.cacheGrammars("http://www.w3.org/TR/REC-xml", new Grammar[]{this.fDTDGrammar});
            }
        }
        if (this.fValidation) {
            String string2;
            Object object;
            Object object2;
            DTDGrammar dTDGrammar = this.fDTDGrammar != null ? this.fDTDGrammar : this.fGrammarBucket.getActiveGrammar();
            Enumeration enumeration = this.fNDataDeclNotations.keys();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                object = (String)this.fNDataDeclNotations.get(object2);
                if (dTDGrammar.getNotationDeclIndex((String)object) != -1) continue;
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_NOTATION_NOT_DECLARED_FOR_UNPARSED_ENTITYDECL", new Object[]{object2, object}, (short)1);
            }
            object2 = this.fNotationEnumVals.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                string2 = (String)this.fNotationEnumVals.get(object);
                if (dTDGrammar.getNotationDeclIndex((String)object) != -1) continue;
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_NOTATION_NOT_DECLARED_FOR_NOTATIONTYPE_ATTRIBUTE", new Object[]{string2, object}, (short)1);
            }
            object = this.fTableOfNOTATIONAttributeNames.keys();
            while (object.hasMoreElements()) {
                string2 = (String)object.nextElement();
                int n2 = dTDGrammar.getElementDeclIndex(string2);
                if (dTDGrammar.getContentSpecType(n2) != 1) continue;
                String string3 = (String)this.fTableOfNOTATIONAttributeNames.get(string2);
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "NoNotationOnEmptyElement", new Object[]{string2, string3}, (short)1);
            }
            this.fTableOfIDAttributeNames = null;
            this.fTableOfNOTATIONAttributeNames = null;
            if (this.fWarnOnUndeclaredElemdef) {
                this.checkDeclaredElements(dTDGrammar);
            }
        }
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endDTD(augmentations);
        }
    }

    public void setDTDSource(XMLDTDSource xMLDTDSource) {
        this.fDTDSource = xMLDTDSource;
    }

    public XMLDTDSource getDTDSource() {
        return this.fDTDSource;
    }

    public void setDTDContentModelSource(XMLDTDContentModelSource xMLDTDContentModelSource) {
        this.fDTDContentModelSource = xMLDTDContentModelSource;
    }

    public XMLDTDContentModelSource getDTDContentModelSource() {
        return this.fDTDContentModelSource;
    }

    public void startContentModel(String string2, Augmentations augmentations) throws XNIException {
        if (this.fValidation) {
            this.fDTDElementDeclName = string2;
            this.fMixedElementTypes.removeAllElements();
        }
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.startContentModel(string2, augmentations);
        }
        if (this.fDTDContentModelHandler != null) {
            this.fDTDContentModelHandler.startContentModel(string2, augmentations);
        }
    }

    public void any(Augmentations augmentations) throws XNIException {
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.any(augmentations);
        }
        if (this.fDTDContentModelHandler != null) {
            this.fDTDContentModelHandler.any(augmentations);
        }
    }

    public void empty(Augmentations augmentations) throws XNIException {
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.empty(augmentations);
        }
        if (this.fDTDContentModelHandler != null) {
            this.fDTDContentModelHandler.empty(augmentations);
        }
    }

    public void startGroup(Augmentations augmentations) throws XNIException {
        this.fMixed = false;
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.startGroup(augmentations);
        }
        if (this.fDTDContentModelHandler != null) {
            this.fDTDContentModelHandler.startGroup(augmentations);
        }
    }

    public void pcdata(Augmentations augmentations) {
        this.fMixed = true;
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.pcdata(augmentations);
        }
        if (this.fDTDContentModelHandler != null) {
            this.fDTDContentModelHandler.pcdata(augmentations);
        }
    }

    public void element(String string2, Augmentations augmentations) throws XNIException {
        if (this.fMixed && this.fValidation) {
            if (this.fMixedElementTypes.contains(string2)) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "DuplicateTypeInMixedContent", new Object[]{this.fDTDElementDeclName, string2}, (short)1);
            } else {
                this.fMixedElementTypes.addElement(string2);
            }
        }
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.element(string2, augmentations);
        }
        if (this.fDTDContentModelHandler != null) {
            this.fDTDContentModelHandler.element(string2, augmentations);
        }
    }

    public void separator(short s2, Augmentations augmentations) throws XNIException {
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.separator(s2, augmentations);
        }
        if (this.fDTDContentModelHandler != null) {
            this.fDTDContentModelHandler.separator(s2, augmentations);
        }
    }

    public void occurrence(short s2, Augmentations augmentations) throws XNIException {
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.occurrence(s2, augmentations);
        }
        if (this.fDTDContentModelHandler != null) {
            this.fDTDContentModelHandler.occurrence(s2, augmentations);
        }
    }

    public void endGroup(Augmentations augmentations) throws XNIException {
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.endGroup(augmentations);
        }
        if (this.fDTDContentModelHandler != null) {
            this.fDTDContentModelHandler.endGroup(augmentations);
        }
    }

    public void endContentModel(Augmentations augmentations) throws XNIException {
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.endContentModel(augmentations);
        }
        if (this.fDTDContentModelHandler != null) {
            this.fDTDContentModelHandler.endContentModel(augmentations);
        }
    }

    private boolean normalizeDefaultAttrValue(XMLString xMLString) {
        boolean bl2 = true;
        int n2 = xMLString.offset;
        int n3 = xMLString.offset + xMLString.length;
        int n4 = xMLString.offset;
        while (n4 < n3) {
            if (xMLString.ch[n4] == ' ') {
                if (!bl2) {
                    xMLString.ch[n2++] = 32;
                    bl2 = true;
                }
            } else {
                if (n2 != n4) {
                    xMLString.ch[n2] = xMLString.ch[n4];
                }
                ++n2;
                bl2 = false;
            }
            ++n4;
        }
        if (n2 != n3) {
            if (bl2) {
                --n2;
            }
            xMLString.length = n2 - xMLString.offset;
            return true;
        }
        return false;
    }

    protected boolean isValidNmtoken(String string2) {
        return XMLChar.isValidNmtoken(string2);
    }

    protected boolean isValidName(String string2) {
        return XMLChar.isValidName(string2);
    }

    private void checkDeclaredElements(DTDGrammar dTDGrammar) {
        int n2 = dTDGrammar.getFirstElementDeclIndex();
        XMLContentSpec xMLContentSpec = new XMLContentSpec();
        while (n2 >= 0) {
            short s2 = dTDGrammar.getContentSpecType(n2);
            if (s2 == 3 || s2 == 2) {
                this.checkDeclaredElements(dTDGrammar, n2, dTDGrammar.getContentSpecIndex(n2), xMLContentSpec);
            }
            n2 = dTDGrammar.getNextElementDeclIndex(n2);
        }
    }

    private void checkDeclaredElements(DTDGrammar dTDGrammar, int n2, int n3, XMLContentSpec xMLContentSpec) {
        dTDGrammar.getContentSpec(n3, xMLContentSpec);
        if (xMLContentSpec.type == 0) {
            String string2 = (String)xMLContentSpec.value;
            if (string2 != null && dTDGrammar.getElementDeclIndex(string2) == -1) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "UndeclaredElementInContentSpec", new Object[]{dTDGrammar.getElementDeclName((int)n2).rawname, string2}, (short)0);
            }
        } else if (xMLContentSpec.type == 4 || xMLContentSpec.type == 5) {
            int n4 = ((int[])xMLContentSpec.value)[0];
            int n5 = ((int[])xMLContentSpec.otherValue)[0];
            this.checkDeclaredElements(dTDGrammar, n2, n4, xMLContentSpec);
            this.checkDeclaredElements(dTDGrammar, n2, n5, xMLContentSpec);
        } else if (xMLContentSpec.type == 2 || xMLContentSpec.type == 1 || xMLContentSpec.type == 3) {
            int n6 = ((int[])xMLContentSpec.value)[0];
            this.checkDeclaredElements(dTDGrammar, n2, n6, xMLContentSpec);
        }
    }
}

