/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.dom;

import java.util.Vector;
import org.python.apache.xerces.dom.AttrImpl;
import org.python.apache.xerces.dom.AttrNSImpl;
import org.python.apache.xerces.dom.CoreDocumentImpl;
import org.python.apache.xerces.dom.DOMMessageFormatter;
import org.python.apache.xerces.dom.ElementImpl;
import org.python.apache.xerces.dom.NamedNodeMapImpl;
import org.python.apache.xerces.dom.NodeImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class AttributeMap
extends NamedNodeMapImpl {
    static final long serialVersionUID = 8872606282138665383L;

    protected AttributeMap(ElementImpl elementImpl, NamedNodeMapImpl namedNodeMapImpl) {
        super(elementImpl);
        if (namedNodeMapImpl != null) {
            this.cloneContent(namedNodeMapImpl);
            if (this.nodes != null) {
                this.hasDefaults(true);
            }
        }
    }

    public Node setNamedItem(Node node) throws DOMException {
        AttrImpl attrImpl;
        boolean bl2 = this.ownerNode.ownerDocument().errorChecking;
        if (bl2) {
            if (this.isReadOnly()) {
                String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, string2);
            }
            if (node.getOwnerDocument() != this.ownerNode.ownerDocument()) {
                String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
                throw new DOMException(4, string3);
            }
            if (node.getNodeType() != 2) {
                String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null);
                throw new DOMException(3, string4);
            }
        }
        if ((attrImpl = (AttrImpl)node).isOwned()) {
            if (bl2 && attrImpl.getOwnerElement() != this.ownerNode) {
                String string5 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INUSE_ATTRIBUTE_ERR", null);
                throw new DOMException(10, string5);
            }
            return node;
        }
        attrImpl.ownerNode = this.ownerNode;
        attrImpl.isOwned(true);
        int n2 = this.findNamePoint(attrImpl.getNodeName(), 0);
        AttrImpl attrImpl2 = null;
        if (n2 >= 0) {
            attrImpl2 = (AttrImpl)this.nodes.elementAt(n2);
            this.nodes.setElementAt(node, n2);
            attrImpl2.ownerNode = this.ownerNode.ownerDocument();
            attrImpl2.isOwned(false);
            attrImpl2.isSpecified(true);
        } else {
            n2 = -1 - n2;
            if (null == this.nodes) {
                this.nodes = new Vector(5, 10);
            }
            this.nodes.insertElementAt(node, n2);
        }
        this.ownerNode.ownerDocument().setAttrNode(attrImpl, attrImpl2);
        if (!attrImpl.isNormalized()) {
            this.ownerNode.isNormalized(false);
        }
        return attrImpl2;
    }

    public Node setNamedItemNS(Node node) throws DOMException {
        AttrImpl attrImpl;
        boolean bl2 = this.ownerNode.ownerDocument().errorChecking;
        if (bl2) {
            if (this.isReadOnly()) {
                String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, string2);
            }
            if (node.getOwnerDocument() != this.ownerNode.ownerDocument()) {
                String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
                throw new DOMException(4, string3);
            }
            if (node.getNodeType() != 2) {
                String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null);
                throw new DOMException(3, string4);
            }
        }
        if ((attrImpl = (AttrImpl)node).isOwned()) {
            if (bl2 && attrImpl.getOwnerElement() != this.ownerNode) {
                String string5 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INUSE_ATTRIBUTE_ERR", null);
                throw new DOMException(10, string5);
            }
            return node;
        }
        attrImpl.ownerNode = this.ownerNode;
        attrImpl.isOwned(true);
        int n2 = this.findNamePoint(attrImpl.getNamespaceURI(), attrImpl.getLocalName());
        AttrImpl attrImpl2 = null;
        if (n2 >= 0) {
            attrImpl2 = (AttrImpl)this.nodes.elementAt(n2);
            this.nodes.setElementAt(node, n2);
            attrImpl2.ownerNode = this.ownerNode.ownerDocument();
            attrImpl2.isOwned(false);
            attrImpl2.isSpecified(true);
        } else {
            n2 = this.findNamePoint(node.getNodeName(), 0);
            if (n2 >= 0) {
                attrImpl2 = (AttrImpl)this.nodes.elementAt(n2);
                this.nodes.insertElementAt(node, n2);
            } else {
                n2 = -1 - n2;
                if (null == this.nodes) {
                    this.nodes = new Vector(5, 10);
                }
                this.nodes.insertElementAt(node, n2);
            }
        }
        this.ownerNode.ownerDocument().setAttrNode(attrImpl, attrImpl2);
        if (!attrImpl.isNormalized()) {
            this.ownerNode.isNormalized(false);
        }
        return attrImpl2;
    }

    public Node removeNamedItem(String string2) throws DOMException {
        return this.internalRemoveNamedItem(string2, true);
    }

    Node safeRemoveNamedItem(String string2) {
        return this.internalRemoveNamedItem(string2, false);
    }

    protected Node removeItem(Node node, boolean bl2) throws DOMException {
        int n2 = -1;
        if (this.nodes != null) {
            int n3 = 0;
            while (n3 < this.nodes.size()) {
                if (this.nodes.elementAt(n3) == node) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
        }
        if (n2 < 0) {
            String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
            throw new DOMException(8, string2);
        }
        return this.remove((AttrImpl)node, n2, bl2);
    }

    protected final Node internalRemoveNamedItem(String string2, boolean bl2) {
        if (this.isReadOnly()) {
            String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, string3);
        }
        int n2 = this.findNamePoint(string2, 0);
        if (n2 < 0) {
            if (bl2) {
                String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
                throw new DOMException(8, string4);
            }
            return null;
        }
        return this.remove((AttrImpl)this.nodes.elementAt(n2), n2, true);
    }

    private final Node remove(AttrImpl attrImpl, int n2, boolean bl2) {
        CoreDocumentImpl coreDocumentImpl = this.ownerNode.ownerDocument();
        String string2 = attrImpl.getNodeName();
        if (attrImpl.isIdAttribute()) {
            coreDocumentImpl.removeIdentifier(attrImpl.getValue());
        }
        if (this.hasDefaults() && bl2) {
            Node node;
            NamedNodeMapImpl namedNodeMapImpl = ((ElementImpl)this.ownerNode).getDefaultAttributes();
            if (namedNodeMapImpl != null && (node = namedNodeMapImpl.getNamedItem(string2)) != null && this.findNamePoint(string2, n2 + 1) < 0) {
                NodeImpl nodeImpl = (NodeImpl)node.cloneNode(true);
                if (node.getLocalName() != null) {
                    ((AttrNSImpl)nodeImpl).namespaceURI = attrImpl.getNamespaceURI();
                }
                nodeImpl.ownerNode = this.ownerNode;
                nodeImpl.isOwned(true);
                nodeImpl.isSpecified(false);
                this.nodes.setElementAt(nodeImpl, n2);
                if (attrImpl.isIdAttribute()) {
                    coreDocumentImpl.putIdentifier(nodeImpl.getNodeValue(), (ElementImpl)this.ownerNode);
                }
            } else {
                this.nodes.removeElementAt(n2);
            }
        } else {
            this.nodes.removeElementAt(n2);
        }
        attrImpl.ownerNode = coreDocumentImpl;
        attrImpl.isOwned(false);
        attrImpl.isSpecified(true);
        attrImpl.isIdAttribute(false);
        coreDocumentImpl.removedAttrNode(attrImpl, this.ownerNode, string2);
        return attrImpl;
    }

    public Node removeNamedItemNS(String string2, String string3) throws DOMException {
        return this.internalRemoveNamedItemNS(string2, string3, true);
    }

    Node safeRemoveNamedItemNS(String string2, String string3) {
        return this.internalRemoveNamedItemNS(string2, string3, false);
    }

    protected final Node internalRemoveNamedItemNS(String string2, String string3, boolean bl2) {
        CoreDocumentImpl coreDocumentImpl = this.ownerNode.ownerDocument();
        if (coreDocumentImpl.errorChecking && this.isReadOnly()) {
            String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, string4);
        }
        int n2 = this.findNamePoint(string2, string3);
        if (n2 < 0) {
            if (bl2) {
                String string5 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
                throw new DOMException(8, string5);
            }
            return null;
        }
        AttrImpl attrImpl = (AttrImpl)this.nodes.elementAt(n2);
        if (attrImpl.isIdAttribute()) {
            coreDocumentImpl.removeIdentifier(attrImpl.getValue());
        }
        String string6 = attrImpl.getNodeName();
        if (this.hasDefaults()) {
            Node node;
            NamedNodeMapImpl namedNodeMapImpl = ((ElementImpl)this.ownerNode).getDefaultAttributes();
            if (namedNodeMapImpl != null && (node = namedNodeMapImpl.getNamedItem(string6)) != null) {
                int n3 = this.findNamePoint(string6, 0);
                if (n3 >= 0 && this.findNamePoint(string6, n3 + 1) < 0) {
                    NodeImpl nodeImpl = (NodeImpl)node.cloneNode(true);
                    nodeImpl.ownerNode = this.ownerNode;
                    if (node.getLocalName() != null) {
                        ((AttrNSImpl)nodeImpl).namespaceURI = string2;
                    }
                    nodeImpl.isOwned(true);
                    nodeImpl.isSpecified(false);
                    this.nodes.setElementAt(nodeImpl, n2);
                    if (nodeImpl.isIdAttribute()) {
                        coreDocumentImpl.putIdentifier(nodeImpl.getNodeValue(), (ElementImpl)this.ownerNode);
                    }
                } else {
                    this.nodes.removeElementAt(n2);
                }
            } else {
                this.nodes.removeElementAt(n2);
            }
        } else {
            this.nodes.removeElementAt(n2);
        }
        attrImpl.ownerNode = coreDocumentImpl;
        attrImpl.isOwned(false);
        attrImpl.isSpecified(true);
        attrImpl.isIdAttribute(false);
        coreDocumentImpl.removedAttrNode(attrImpl, this.ownerNode, string3);
        return attrImpl;
    }

    public NamedNodeMapImpl cloneMap(NodeImpl nodeImpl) {
        AttributeMap attributeMap = new AttributeMap((ElementImpl)nodeImpl, null);
        attributeMap.hasDefaults(this.hasDefaults());
        attributeMap.cloneContent(this);
        return attributeMap;
    }

    protected void cloneContent(NamedNodeMapImpl namedNodeMapImpl) {
        int n2;
        Vector vector = namedNodeMapImpl.nodes;
        if (vector != null && (n2 = vector.size()) != 0) {
            if (this.nodes == null) {
                this.nodes = new Vector(n2);
            }
            this.nodes.setSize(n2);
            int n3 = 0;
            while (n3 < n2) {
                NodeImpl nodeImpl = (NodeImpl)vector.elementAt(n3);
                NodeImpl nodeImpl2 = (NodeImpl)nodeImpl.cloneNode(true);
                nodeImpl2.isSpecified(nodeImpl.isSpecified());
                this.nodes.setElementAt(nodeImpl2, n3);
                nodeImpl2.ownerNode = this.ownerNode;
                nodeImpl2.isOwned(true);
                ++n3;
            }
        }
    }

    void moveSpecifiedAttributes(AttributeMap attributeMap) {
        int n2 = attributeMap.nodes != null ? attributeMap.nodes.size() : 0;
        int n3 = n2 - 1;
        while (n3 >= 0) {
            AttrImpl attrImpl = (AttrImpl)attributeMap.nodes.elementAt(n3);
            if (attrImpl.isSpecified()) {
                attributeMap.remove(attrImpl, n3, false);
                if (attrImpl.getLocalName() != null) {
                    this.setNamedItem(attrImpl);
                } else {
                    this.setNamedItemNS(attrImpl);
                }
            }
            --n3;
        }
    }

    protected void reconcileDefaults(NamedNodeMapImpl namedNodeMapImpl) {
        int n2 = this.nodes != null ? this.nodes.size() : 0;
        int n3 = n2 - 1;
        while (n3 >= 0) {
            AttrImpl attrImpl = (AttrImpl)this.nodes.elementAt(n3);
            if (!attrImpl.isSpecified()) {
                this.remove(attrImpl, n3, false);
            }
            --n3;
        }
        if (namedNodeMapImpl == null) {
            return;
        }
        if (this.nodes == null || this.nodes.size() == 0) {
            this.cloneContent(namedNodeMapImpl);
        } else {
            int n4 = namedNodeMapImpl.nodes.size();
            int n5 = 0;
            while (n5 < n4) {
                AttrImpl attrImpl = (AttrImpl)namedNodeMapImpl.nodes.elementAt(n5);
                int n6 = this.findNamePoint(attrImpl.getNodeName(), 0);
                if (n6 < 0) {
                    n6 = -1 - n6;
                    NodeImpl nodeImpl = (NodeImpl)attrImpl.cloneNode(true);
                    nodeImpl.ownerNode = this.ownerNode;
                    nodeImpl.isOwned(true);
                    nodeImpl.isSpecified(false);
                    this.nodes.insertElementAt(nodeImpl, n6);
                }
                ++n5;
            }
        }
    }

    protected final int addItem(Node node) {
        AttrImpl attrImpl = (AttrImpl)node;
        attrImpl.ownerNode = this.ownerNode;
        attrImpl.isOwned(true);
        int n2 = this.findNamePoint(attrImpl.getNamespaceURI(), attrImpl.getLocalName());
        if (n2 >= 0) {
            this.nodes.setElementAt(node, n2);
        } else {
            n2 = this.findNamePoint(attrImpl.getNodeName(), 0);
            if (n2 >= 0) {
                this.nodes.insertElementAt(node, n2);
            } else {
                n2 = -1 - n2;
                if (null == this.nodes) {
                    this.nodes = new Vector(5, 10);
                }
                this.nodes.insertElementAt(node, n2);
            }
        }
        this.ownerNode.ownerDocument().setAttrNode(attrImpl, null);
        return n2;
    }
}

