/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.util.ArrayList;
import java.util.List;

public class PGtokenizer {
    protected List tokens;

    public PGtokenizer(String string2, char delim) {
        this.tokenize(string2, delim);
    }

    public int tokenize(String string2, char delim) {
        this.tokens = new ArrayList();
        int nest = 0;
        boolean skipChar = false;
        boolean nestedDoubleQuote = false;
        int s2 = 0;
        for (int p2 = 0; p2 < string2.length(); ++p2) {
            char c2 = string2.charAt(p2);
            if (c2 == '(' || c2 == '[' || c2 == '<' || !nestedDoubleQuote && !skipChar && c2 == '\"') {
                ++nest;
                if (c2 == '\"') {
                    nestedDoubleQuote = true;
                    skipChar = true;
                }
            }
            if (c2 == ')' || c2 == ']' || c2 == '>' || nestedDoubleQuote && !skipChar && c2 == '\"') {
                --nest;
                if (c2 == '\"') {
                    nestedDoubleQuote = false;
                }
            }
            skipChar = c2 == '\\';
            if (nest != 0 || c2 != delim) continue;
            this.tokens.add(string2.substring(s2, p2));
            s2 = p2 + 1;
        }
        if (s2 < string2.length()) {
            this.tokens.add(string2.substring(s2));
        }
        return this.tokens.size();
    }

    public int getSize() {
        return this.tokens.size();
    }

    public String getToken(int n2) {
        return (String)this.tokens.get(n2);
    }

    public PGtokenizer tokenizeToken(int n2, char delim) {
        return new PGtokenizer(this.getToken(n2), delim);
    }

    public static String remove(String s2, String l2, String t2) {
        if (s2.startsWith(l2)) {
            s2 = s2.substring(l2.length());
        }
        if (s2.endsWith(t2)) {
            s2 = s2.substring(0, s2.length() - t2.length());
        }
        return s2;
    }

    public void remove(String l2, String t2) {
        for (int i2 = 0; i2 < this.tokens.size(); ++i2) {
            this.tokens.set(i2, PGtokenizer.remove((String)this.tokens.get(i2), l2, t2));
        }
    }

    public static String removePara(String s2) {
        return PGtokenizer.remove(s2, "(", ")");
    }

    public void removePara() {
        this.remove("(", ")");
    }

    public static String removeBox(String s2) {
        return PGtokenizer.remove(s2, "[", "]");
    }

    public void removeBox() {
        this.remove("[", "]");
    }

    public static String removeAngle(String s2) {
        return PGtokenizer.remove(s2, "<", ">");
    }

    public void removeAngle() {
        this.remove("<", ">");
    }
}

