/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.ssl.jdbc4;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.x500.X500Principal;
import org.postgresql.ssl.jdbc4.LibPQFactory;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class LazyKeyManager
implements X509KeyManager {
    private X509Certificate[] cert = null;
    private PrivateKey key = null;
    private String certfile;
    private String keyfile;
    private CallbackHandler cbh;
    private boolean defaultfile;
    private PSQLException error = null;

    public LazyKeyManager(String certfile, String keyfile, CallbackHandler cbh, boolean defaultfile) {
        this.certfile = certfile;
        this.keyfile = keyfile;
        this.cbh = cbh;
        this.defaultfile = defaultfile;
    }

    public void throwKeyManagerException() throws PSQLException {
        if (this.error != null) {
            throw this.error;
        }
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket2) {
        if (this.certfile == null) {
            return null;
        }
        if (issuers == null || issuers.length == 0) {
            return "user";
        }
        X509Certificate[] certchain = this.getCertificateChain("user");
        if (certchain == null) {
            return null;
        }
        X500Principal ourissuer = certchain[certchain.length - 1].getIssuerX500Principal();
        boolean found = false;
        for (int i2 = 0; i2 < issuers.length; ++i2) {
            if (!ourissuer.equals(issuers[i2])) continue;
            found = true;
        }
        return found ? "user" : null;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket2) {
        return null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias2) {
        if (this.cert == null && this.certfile != null) {
            Collection<? extends Certificate> certs;
            CertificateFactory cf2;
            try {
                cf2 = CertificateFactory.getInstance("X.509");
            }
            catch (CertificateException ex) {
                this.error = new PSQLException(GT.tr("Could not find a java cryptographic algorithm: X.509 CertificateFactory not available.", null), PSQLState.CONNECTION_FAILURE, (Throwable)ex);
                return null;
            }
            try {
                certs = cf2.generateCertificates(new FileInputStream(this.certfile));
            }
            catch (FileNotFoundException ioex) {
                if (!this.defaultfile) {
                    this.error = new PSQLException(GT.tr("Could not open SSL certificate file {0}.", new Object[]{this.certfile}), PSQLState.CONNECTION_FAILURE, (Throwable)ioex);
                }
                return null;
            }
            catch (CertificateException gsex) {
                this.error = new PSQLException(GT.tr("Loading the SSL certificate {0} into a KeyManager failed.", new Object[]{this.certfile}), PSQLState.CONNECTION_FAILURE, (Throwable)gsex);
                return null;
            }
            this.cert = certs.toArray(new X509Certificate[certs.size()]);
        }
        return this.cert;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        String[] stringArray;
        String alias2 = this.chooseClientAlias(new String[]{keyType}, issuers, null);
        if (alias2 == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = alias2;
        }
        return stringArray;
    }

    @Override
    public PrivateKey getPrivateKey(String alias2) {
        block18: {
            RandomAccessFile raf = null;
            try {
                if (this.key != null || this.keyfile == null) break block18;
                if (this.cert == null && this.getCertificateChain("user") == null) {
                    return null;
                }
                try {
                    raf = new RandomAccessFile(new File(this.keyfile), "r");
                }
                catch (FileNotFoundException ex) {
                    if (!this.defaultfile) {
                        throw ex;
                    }
                    return null;
                }
                byte[] keydata = new byte[(int)raf.length()];
                raf.readFully(keydata);
                raf.close();
                raf = null;
                KeyFactory kf = KeyFactory.getInstance(this.cert[0].getPublicKey().getAlgorithm());
                try {
                    PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keydata);
                    this.key = kf.generatePrivate(pkcs8KeySpec);
                }
                catch (InvalidKeySpecException ex) {
                    Cipher cipher;
                    EncryptedPrivateKeyInfo ePKInfo = new EncryptedPrivateKeyInfo(keydata);
                    try {
                        cipher = Cipher.getInstance(ePKInfo.getAlgName());
                    }
                    catch (NoSuchPaddingException npex) {
                        throw new NoSuchAlgorithmException(npex.getMessage(), npex);
                    }
                    PasswordCallback pwdcb = new PasswordCallback(GT.tr("Enter SSL password: "), false);
                    try {
                        this.cbh.handle(new Callback[]{pwdcb});
                    }
                    catch (UnsupportedCallbackException ucex) {
                        this.error = this.cbh instanceof LibPQFactory.ConsoleCallbackHandler && "Console is not available".equals(ucex.getMessage()) ? new PSQLException(GT.tr("Could not read password for SSL key file, console is not available.", null), PSQLState.CONNECTION_FAILURE, (Throwable)ucex) : new PSQLException(GT.tr("Could not read password for SSL key file by callbackhandler {0}.", new Object[]{this.cbh.getClass().getName()}), PSQLState.CONNECTION_FAILURE, (Throwable)ucex);
                        return null;
                    }
                    try {
                        PBEKeySpec pbeKeySpec = new PBEKeySpec(pwdcb.getPassword());
                        SecretKeyFactory skFac = SecretKeyFactory.getInstance(ePKInfo.getAlgName());
                        SecretKey pbeKey = skFac.generateSecret(pbeKeySpec);
                        AlgorithmParameters algParams = ePKInfo.getAlgParameters();
                        cipher.init(2, (Key)pbeKey, algParams);
                        PKCS8EncodedKeySpec pkcs8KeySpec = ePKInfo.getKeySpec(cipher);
                        this.key = kf.generatePrivate(pkcs8KeySpec);
                    }
                    catch (GeneralSecurityException ikex) {
                        this.error = new PSQLException(GT.tr("Could not decrypt SSL key file {0}.", new Object[]{this.keyfile}), PSQLState.CONNECTION_FAILURE, (Throwable)ikex);
                        return null;
                    }
                }
            }
            catch (IOException ioex) {
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                this.error = new PSQLException(GT.tr("Could not read SSL key file {0}.", new Object[]{this.keyfile}), PSQLState.CONNECTION_FAILURE, (Throwable)ioex);
            }
            catch (NoSuchAlgorithmException ex) {
                this.error = new PSQLException(GT.tr("Could not find a java cryptographic algorithm: {0}.", new Object[]{ex.getMessage()}), PSQLState.CONNECTION_FAILURE, (Throwable)ex);
                return null;
            }
        }
        return this.key;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return new String[0];
    }
}

