/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc4;

import java.lang.reflect.Array;
import java.sql.Blob;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.postgresql.Driver;
import org.postgresql.PGProperty;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.TypeInfo;
import org.postgresql.core.Utils;
import org.postgresql.jdbc2.AbstractJdbc2Array;
import org.postgresql.jdbc3g.AbstractJdbc3gConnection;
import org.postgresql.jdbc4.Jdbc4Array;
import org.postgresql.jdbc4.Jdbc4SQLXML;
import org.postgresql.util.GT;
import org.postgresql.util.HostSpec;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

abstract class AbstractJdbc4Connection
extends AbstractJdbc3gConnection {
    private static final SQLPermission SQL_PERMISSION_ABORT = new SQLPermission("callAbort");
    private static final Pattern PATTERN_GET_SCHEMA = Pattern.compile("^\\\"(.*)\\\"(?!\\\")");
    private final Properties _clientInfo;

    public AbstractJdbc4Connection(HostSpec[] hostSpecs, String user2, String database, Properties info, String url) throws SQLException {
        super(hostSpecs, user2, database, info, url);
        TypeInfo types2 = this.getTypeInfo();
        if (this.haveMinimumServerVersion("8.3")) {
            types2.addCoreType("xml", 142, 2009, "java.sql.SQLXML", 143);
        }
        this._clientInfo = new Properties();
        if (this.haveMinimumServerVersion("9.0")) {
            String appName = PGProperty.APPLICATION_NAME.get(info);
            if (appName == null) {
                appName = "";
            }
            this._clientInfo.put("ApplicationName", appName);
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "createClob()");
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "createBlob()");
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "createNClob()");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkClosed();
        return new Jdbc4SQLXML(this);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "createStruct(String, Object[])");
    }

    @Override
    public java.sql.Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkClosed();
        int oid = this.getTypeInfo().getPGArrayType(typeName);
        if (oid == 0) {
            throw new PSQLException(GT.tr("Unable to find server array type for provided name {0}.", typeName), PSQLState.INVALID_NAME);
        }
        char delim = this.getTypeInfo().getArrayDelimiter(oid);
        StringBuilder sb = new StringBuilder();
        AbstractJdbc4Connection.appendArray(sb, elements, delim);
        return new Jdbc4Array((BaseConnection)this, oid, sb.toString());
    }

    private static void appendArray(StringBuilder sb, Object elements, char delim) {
        sb.append('{');
        int nElements = Array.getLength(elements);
        for (int i2 = 0; i2 < nElements; ++i2) {
            Object o2;
            if (i2 > 0) {
                sb.append(delim);
            }
            if ((o2 = Array.get(elements, i2)) == null) {
                sb.append("NULL");
                continue;
            }
            if (o2.getClass().isArray()) {
                AbstractJdbc4Connection.appendArray(sb, o2, delim);
                continue;
            }
            String s2 = o2.toString();
            AbstractJdbc2Array.escapeArrayElement(sb, s2);
        }
        sb.append('}');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (this.isClosed()) {
            return false;
        }
        if (timeout < 0) {
            throw new PSQLException(GT.tr("Invalid timeout ({0}<0).", timeout), PSQLState.INVALID_PARAMETER_VALUE);
        }
        boolean valid = false;
        Statement stmt2 = null;
        try {
            if (!this.isClosed()) {
                stmt2 = this.createStatement();
                stmt2.setQueryTimeout(timeout);
                stmt2.executeUpdate("");
                valid = true;
            }
        }
        catch (SQLException e2) {
            this.getLogger().log(GT.tr("Validating connection."), e2);
        }
        finally {
            if (stmt2 != null) {
                try {
                    stmt2.close();
                }
                catch (Exception ex) {}
            }
        }
        return valid;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.checkClosed();
        }
        catch (SQLException cause) {
            HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
            failures.put(name, ClientInfoStatus.REASON_UNKNOWN);
            throw new SQLClientInfoException(GT.tr("This connection has been closed."), failures, (Throwable)cause);
        }
        if (this.haveMinimumServerVersion("9.0") && "ApplicationName".equals(name)) {
            if (value == null) {
                value = "";
            }
            try {
                StringBuilder sql = new StringBuilder("SET application_name = '");
                Utils.escapeLiteral(sql, value, this.getStandardConformingStrings());
                sql.append("'");
                this.execSQLUpdate(sql.toString());
            }
            catch (SQLException sqle) {
                HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
                failures.put(name, ClientInfoStatus.REASON_UNKNOWN);
                throw new SQLClientInfoException(GT.tr("Failed to set ClientInfo property: {0}", "ApplicationName"), sqle.getSQLState(), failures, (Throwable)sqle);
            }
            this._clientInfo.put(name, value);
            return;
        }
        this.addWarning(new SQLWarning(GT.tr("ClientInfo property not supported."), PSQLState.NOT_IMPLEMENTED.getState()));
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.checkClosed();
        }
        catch (SQLException cause) {
            HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
            for (Map.Entry<Object, Object> e2 : properties.entrySet()) {
                failures.put((String)e2.getKey(), ClientInfoStatus.REASON_UNKNOWN);
            }
            throw new SQLClientInfoException(GT.tr("This connection has been closed."), failures, (Throwable)cause);
        }
        HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
        for (String name : new String[]{"ApplicationName"}) {
            try {
                this.setClientInfo(name, properties.getProperty(name, null));
            }
            catch (SQLClientInfoException e3) {
                failures.putAll(e3.getFailedProperties());
            }
        }
        if (!failures.isEmpty()) {
            throw new SQLClientInfoException(GT.tr("One ore more ClientInfo failed."), PSQLState.NOT_IMPLEMENTED.getState(), failures);
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkClosed();
        return this._clientInfo.getProperty(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        return this._clientInfo;
    }

    public <T> T createQueryObject(Class<T> ifc) throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "createQueryObject(Class<T>)");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkClosed();
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkClosed();
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchema() throws SQLException {
        String searchPath;
        this.checkClosed();
        try (Statement stmt2 = this.createStatement();
             ResultSet rs = stmt2.executeQuery("SHOW search_path");){
            if (!rs.next()) {
                String string2 = null;
                return string2;
            }
            searchPath = rs.getString(1);
        }
        if (searchPath.startsWith("\"")) {
            Matcher matcher = PATTERN_GET_SCHEMA.matcher(searchPath);
            matcher.find();
            return matcher.group(1).replaceAll("\"\"", "\"");
        }
        int commaIndex = searchPath.indexOf(44);
        if (commaIndex == -1) {
            return searchPath;
        }
        return searchPath.substring(0, commaIndex);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (this.isClosed()) {
            return;
        }
        SQL_PERMISSION_ABORT.checkGuard(this);
        AbortCommand command2 = new AbortCommand();
        if (executor != null) {
            executor.execute(command2);
        } else {
            command2.run();
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNetworkTimeout(Executor, int)");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNetworkTimeout()");
    }

    public class AbortCommand
    implements Runnable {
        @Override
        public void run() {
            AbstractJdbc4Connection.this.abort();
        }
    }
}

