/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.gss;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class GSSCallbackHandler
implements CallbackHandler {
    private final String user;
    private final String password;

    public GSSCallbackHandler(String user2, String password) {
        this.user = user2;
        this.password = password;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i2 = 0; i2 < callbacks.length; ++i2) {
            if (callbacks[i2] instanceof TextOutputCallback) {
                TextOutputCallback toc = (TextOutputCallback)callbacks[i2];
                switch (toc.getMessageType()) {
                    case 0: {
                        System.out.println("INFO: " + toc.getMessage());
                        break;
                    }
                    case 2: {
                        System.out.println("ERROR: " + toc.getMessage());
                        break;
                    }
                    case 1: {
                        System.out.println("WARNING: " + toc.getMessage());
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported message type: " + toc.getMessageType());
                    }
                }
                continue;
            }
            if (callbacks[i2] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callbacks[i2];
                nc.setName(this.user);
                continue;
            }
            if (callbacks[i2] instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callbacks[i2];
                if (this.password == null) {
                    throw new IOException("No cached kerberos ticket found and no password supplied.");
                }
                pc.setPassword(this.password.toCharArray());
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i2], "Unrecognized Callback");
        }
    }
}

