/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.geometric;

import java.io.Serializable;
import java.sql.SQLException;
import org.postgresql.geometric.PGpoint;
import org.postgresql.util.GT;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class PGcircle
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint center;
    public double radius;

    public PGcircle(double x2, double y2, double r2) {
        this(new PGpoint(x2, y2), r2);
    }

    public PGcircle(PGpoint c2, double r2) {
        this();
        this.center = c2;
        this.radius = r2;
    }

    public PGcircle(String s2) throws SQLException {
        this();
        this.setValue(s2);
    }

    public PGcircle() {
        this.setType("circle");
    }

    @Override
    public void setValue(String s2) throws SQLException {
        PGtokenizer t2 = new PGtokenizer(PGtokenizer.removeAngle(s2), ',');
        if (t2.getSize() != 2) {
            throw new PSQLException(GT.tr("Conversion to type {0} failed: {1}.", new Object[]{this.type, s2}), PSQLState.DATA_TYPE_MISMATCH);
        }
        try {
            this.center = new PGpoint(t2.getToken(0));
            this.radius = Double.parseDouble(t2.getToken(1));
        }
        catch (NumberFormatException e2) {
            throw new PSQLException(GT.tr("Conversion to type {0} failed: {1}.", new Object[]{this.type, s2}), PSQLState.DATA_TYPE_MISMATCH, (Throwable)e2);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PGcircle) {
            PGcircle p2 = (PGcircle)obj;
            return p2.center.equals(this.center) && p2.radius == this.radius;
        }
        return false;
    }

    @Override
    public int hashCode() {
        long v2 = Double.doubleToLongBits(this.radius);
        return (int)((long)this.center.hashCode() ^ v2 ^ v2 >>> 32);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PGcircle newPGcircle = (PGcircle)super.clone();
        if (newPGcircle.center != null) {
            newPGcircle.center = (PGpoint)newPGcircle.center.clone();
        }
        return newPGcircle;
    }

    @Override
    public String getValue() {
        return "<" + this.center + "," + this.radius + ">";
    }
}

