/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.io.IOException;
import org.postgresql.core.Encoding;
import org.postgresql.util.GT;

class UTF8Encoding
extends Encoding {
    private static final int MIN_2_BYTES = 128;
    private static final int MIN_3_BYTES = 2048;
    private static final int MIN_4_BYTES = 65536;
    private static final int MAX_CODE_POINT = 0x10FFFF;
    private char[] decoderArray = new char[1024];

    UTF8Encoding(String jvmEncoding) {
        super(jvmEncoding);
    }

    private static final void checkByte(int ch2, int pos, int len) throws IOException {
        if ((ch2 & 0xC0) != 128) {
            throw new IOException(GT.tr("Illegal UTF-8 sequence: byte {0} of {1} byte sequence is not 10xxxxxx: {2}", new Object[]{new Integer(pos), new Integer(len), new Integer(ch2)}));
        }
    }

    private static final void checkMinimal(int ch2, int minValue) throws IOException {
        int expectedLen;
        int actualLen;
        if (ch2 >= minValue) {
            return;
        }
        switch (minValue) {
            case 128: {
                actualLen = 2;
                break;
            }
            case 2048: {
                actualLen = 3;
                break;
            }
            case 65536: {
                actualLen = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected minValue passed to checkMinimal: " + minValue);
            }
        }
        if (ch2 < 128) {
            expectedLen = 1;
        } else if (ch2 < 2048) {
            expectedLen = 2;
        } else if (ch2 < 65536) {
            expectedLen = 3;
        } else {
            throw new IllegalArgumentException("unexpected ch passed to checkMinimal: " + ch2);
        }
        throw new IOException(GT.tr("Illegal UTF-8 sequence: {0} bytes used to encode a {1} byte value: {2}", new Object[]{new Integer(actualLen), new Integer(expectedLen), new Integer(ch2)}));
    }

    @Override
    public synchronized String decode(byte[] data, int offset, int length) throws IOException {
        char[] cdata = this.decoderArray;
        if (cdata.length < length) {
            cdata = this.decoderArray = new char[length];
        }
        int in = offset;
        int out = 0;
        int end = length + offset;
        try {
            while (in < end) {
                int ch2;
                if ((ch2 = data[in++] & 0xFF) >= 128) {
                    if (ch2 < 192) {
                        throw new IOException(GT.tr("Illegal UTF-8 sequence: initial byte is {0}: {1}", new Object[]{"10xxxxxx", new Integer(ch2)}));
                    }
                    if (ch2 < 224) {
                        ch2 = (ch2 & 0x1F) << 6;
                        UTF8Encoding.checkByte(data[in], 2, 2);
                        UTF8Encoding.checkMinimal(ch2 |= data[in++] & 0x3F, 128);
                    } else if (ch2 < 240) {
                        ch2 = (ch2 & 0xF) << 12;
                        UTF8Encoding.checkByte(data[in], 2, 3);
                        ch2 |= (data[in++] & 0x3F) << 6;
                        UTF8Encoding.checkByte(data[in], 3, 3);
                        UTF8Encoding.checkMinimal(ch2 |= data[in++] & 0x3F, 2048);
                    } else if (ch2 < 248) {
                        ch2 = (ch2 & 7) << 18;
                        UTF8Encoding.checkByte(data[in], 2, 4);
                        ch2 |= (data[in++] & 0x3F) << 12;
                        UTF8Encoding.checkByte(data[in], 3, 4);
                        ch2 |= (data[in++] & 0x3F) << 6;
                        UTF8Encoding.checkByte(data[in], 4, 4);
                        UTF8Encoding.checkMinimal(ch2 |= data[in++] & 0x3F, 65536);
                    } else {
                        throw new IOException(GT.tr("Illegal UTF-8 sequence: initial byte is {0}: {1}", new Object[]{"11111xxx", new Integer(ch2)}));
                    }
                }
                if (ch2 > 0x10FFFF) {
                    throw new IOException(GT.tr("Illegal UTF-8 sequence: final value is out of range: {0}", new Integer(ch2)));
                }
                if (ch2 > 65535) {
                    cdata[out++] = (char)(55296 + ((ch2 -= 65536) >> 10));
                    cdata[out++] = (char)(56320 + (ch2 & 0x3FF));
                    continue;
                }
                if (ch2 >= 55296 && ch2 < 57344) {
                    throw new IOException(GT.tr("Illegal UTF-8 sequence: final value is a surrogate value: {0}", new Integer(ch2)));
                }
                cdata[out++] = (char)ch2;
            }
        }
        catch (ArrayIndexOutOfBoundsException a2) {
            throw new IOException("Illegal UTF-8 sequence: multibyte sequence was truncated");
        }
        if (in > end) {
            throw new IOException("Illegal UTF-8 sequence: multibyte sequence was truncated");
        }
        return new String(cdata, 0, out);
    }
}

