/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.resources;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.batik.util.resources.ResourceFormatException;

public class ResourceManager {
    protected ResourceBundle bundle;

    public ResourceManager(ResourceBundle resourceBundle) {
        this.bundle = resourceBundle;
    }

    public String getString(String string2) throws MissingResourceException {
        return this.bundle.getString(string2);
    }

    public List getStringList(String string2) throws MissingResourceException {
        return this.getStringList(string2, " \t\n\r\f", false);
    }

    public List getStringList(String string2, String string3) throws MissingResourceException {
        return this.getStringList(string2, string3, false);
    }

    public List getStringList(String string2, String string3, boolean bl2) throws MissingResourceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.getString(string2), string3, bl2);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public boolean getBoolean(String string2) throws MissingResourceException, ResourceFormatException {
        String string3 = this.getString(string2);
        if (string3.equals("true")) {
            return true;
        }
        if (string3.equals("false")) {
            return false;
        }
        throw new ResourceFormatException("Malformed boolean", this.bundle.getClass().getName(), string2);
    }

    public int getInteger(String string2) throws MissingResourceException, ResourceFormatException {
        String string3 = this.getString(string2);
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ResourceFormatException("Malformed integer", this.bundle.getClass().getName(), string2);
        }
    }

    public int getCharacter(String string2) throws MissingResourceException, ResourceFormatException {
        String string3 = this.getString(string2);
        if (string3 == null || string3.length() == 0) {
            throw new ResourceFormatException("Malformed character", this.bundle.getClass().getName(), string2);
        }
        return string3.charAt(0);
    }
}

