/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class PreferenceManager {
    protected Properties internal = null;
    protected Map defaults = null;
    protected String prefFileName = null;
    protected String fullName = null;
    protected static final String USER_HOME = PreferenceManager.getSystemProperty("user.home");
    protected static final String USER_DIR = PreferenceManager.getSystemProperty("user.dir");
    protected static final String FILE_SEP = PreferenceManager.getSystemProperty("file.separator");
    private static String PREF_DIR = null;

    protected static String getSystemProperty(String string2) {
        try {
            return System.getProperty(string2);
        }
        catch (AccessControlException accessControlException) {
            return "";
        }
    }

    public PreferenceManager(String string2) {
        this(string2, null);
    }

    public PreferenceManager(String string2, Map map) {
        this.prefFileName = string2;
        this.defaults = map;
        this.internal = new Properties();
    }

    public static void setPreferenceDirectory(String string2) {
        PREF_DIR = string2;
    }

    public static String getPreferenceDirectory() {
        return PREF_DIR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        FileInputStream fileInputStream = null;
        if (this.fullName != null) {
            try {
                fileInputStream = new FileInputStream(this.fullName);
            }
            catch (IOException iOException) {
                this.fullName = null;
            }
        }
        if (this.fullName == null) {
            if (PREF_DIR != null) {
                try {
                    this.fullName = PREF_DIR + FILE_SEP + this.prefFileName;
                    fileInputStream = new FileInputStream(this.fullName);
                }
                catch (IOException iOException) {
                    this.fullName = null;
                }
            }
            if (this.fullName == null) {
                try {
                    this.fullName = USER_HOME + FILE_SEP + this.prefFileName;
                    fileInputStream = new FileInputStream(this.fullName);
                }
                catch (IOException iOException) {
                    try {
                        this.fullName = USER_DIR + FILE_SEP + this.prefFileName;
                        fileInputStream = new FileInputStream(this.fullName);
                    }
                    catch (IOException iOException2) {
                        this.fullName = null;
                    }
                }
            }
        }
        if (this.fullName != null) {
            try {
                this.internal.load(fileInputStream);
            }
            finally {
                fileInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        FileOutputStream fileOutputStream = null;
        if (this.fullName != null) {
            try {
                fileOutputStream = new FileOutputStream(this.fullName);
            }
            catch (IOException iOException) {
                this.fullName = null;
            }
        }
        if (this.fullName == null) {
            if (PREF_DIR != null) {
                try {
                    this.fullName = PREF_DIR + FILE_SEP + this.prefFileName;
                    fileOutputStream = new FileOutputStream(this.fullName);
                }
                catch (IOException iOException) {
                    this.fullName = null;
                }
            }
            if (this.fullName == null) {
                try {
                    this.fullName = USER_HOME + FILE_SEP + this.prefFileName;
                    fileOutputStream = new FileOutputStream(this.fullName);
                }
                catch (IOException iOException) {
                    this.fullName = null;
                    throw iOException;
                }
            }
        }
        try {
            this.internal.store(fileOutputStream, this.prefFileName);
        }
        finally {
            fileOutputStream.close();
        }
    }

    private Object getDefault(String string2) {
        if (this.defaults != null) {
            return this.defaults.get(string2);
        }
        return null;
    }

    public Rectangle getRectangle(String string2) {
        Rectangle rectangle = (Rectangle)this.getDefault(string2);
        String string3 = this.internal.getProperty(string2);
        if (string3 == null) {
            return rectangle;
        }
        Rectangle rectangle2 = new Rectangle();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, " ", false);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string2);
                return rectangle;
            }
            String string4 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(string4);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string2);
                return rectangle;
            }
            string4 = stringTokenizer.nextToken();
            int n3 = Integer.parseInt(string4);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string2);
                return rectangle;
            }
            string4 = stringTokenizer.nextToken();
            int n4 = Integer.parseInt(string4);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string2);
                return rectangle;
            }
            string4 = stringTokenizer.nextToken();
            int n5 = Integer.parseInt(string4);
            rectangle2.setBounds(n2, n3, n4, n5);
            return rectangle2;
        }
        catch (NumberFormatException numberFormatException) {
            this.internal.remove(string2);
            return rectangle;
        }
    }

    public Dimension getDimension(String string2) {
        Dimension dimension = (Dimension)this.getDefault(string2);
        String string3 = this.internal.getProperty(string2);
        if (string3 == null) {
            return dimension;
        }
        Dimension dimension2 = new Dimension();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, " ", false);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string2);
                return dimension;
            }
            String string4 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(string4);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string2);
                return dimension;
            }
            string4 = stringTokenizer.nextToken();
            int n3 = Integer.parseInt(string4);
            dimension2.setSize(n2, n3);
            return dimension2;
        }
        catch (NumberFormatException numberFormatException) {
            this.internal.remove(string2);
            return dimension;
        }
    }

    public Point getPoint(String string2) {
        Point point = (Point)this.getDefault(string2);
        String string3 = this.internal.getProperty(string2);
        if (string3 == null) {
            return point;
        }
        Point point2 = new Point();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, " ", false);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string2);
                return point;
            }
            String string4 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(string4);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string2);
                return point;
            }
            string4 = stringTokenizer.nextToken();
            int n3 = Integer.parseInt(string4);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string2);
                return point;
            }
            point2.setLocation(n2, n3);
            return point2;
        }
        catch (NumberFormatException numberFormatException) {
            this.internal.remove(string2);
            return point;
        }
    }

    public Color getColor(String string2) {
        Color color = (Color)this.getDefault(string2);
        String string3 = this.internal.getProperty(string2);
        if (string3 == null) {
            return color;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, " ", false);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string2);
                return color;
            }
            String string4 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(string4);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string2);
                return color;
            }
            string4 = stringTokenizer.nextToken();
            int n3 = Integer.parseInt(string4);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string2);
                return color;
            }
            string4 = stringTokenizer.nextToken();
            int n4 = Integer.parseInt(string4);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string2);
                return color;
            }
            string4 = stringTokenizer.nextToken();
            int n5 = Integer.parseInt(string4);
            return new Color(n2, n3, n4, n5);
        }
        catch (NumberFormatException numberFormatException) {
            this.internal.remove(string2);
            return color;
        }
    }

    public Font getFont(String string2) {
        Font font = (Font)this.getDefault(string2);
        String string3 = this.internal.getProperty(string2);
        if (string3 == null) {
            return font;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, " ", false);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string2);
                return font;
            }
            String string4 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string2);
                return font;
            }
            String string5 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(string5);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string2);
                return font;
            }
            string5 = stringTokenizer.nextToken();
            int n3 = Integer.parseInt(string5);
            return new Font(string4, n3, n2);
        }
        catch (NumberFormatException numberFormatException) {
            this.internal.remove(string2);
            return font;
        }
    }

    public String getString(String string2) {
        String string3 = this.internal.getProperty(string2);
        if (string3 == null) {
            string3 = (String)this.getDefault(string2);
        }
        return string3;
    }

    public String[] getStrings(String string2) {
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (true) {
            String string3 = this.getString(string2 + n2);
            ++n2;
            if (string3 == null) break;
            arrayList.add(string3);
        }
        if (arrayList.size() != 0) {
            String[] stringArray = new String[arrayList.size()];
            return arrayList.toArray(stringArray);
        }
        return (String[])this.getDefault(string2);
    }

    public URL getURL(String string2) {
        URL uRL = (URL)this.getDefault(string2);
        String string3 = this.internal.getProperty(string2);
        if (string3 == null) {
            return uRL;
        }
        URL uRL2 = null;
        try {
            uRL2 = new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            this.internal.remove(string2);
            return uRL;
        }
        return uRL2;
    }

    public URL[] getURLs(String string2) {
        int n2 = 0;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        while (true) {
            URL uRL = this.getURL(string2 + n2);
            ++n2;
            if (uRL == null) break;
            arrayList.add(uRL);
        }
        if (arrayList.size() != 0) {
            URL[] uRLArray = new URL[arrayList.size()];
            return arrayList.toArray(uRLArray);
        }
        return (URL[])this.getDefault(string2);
    }

    public File getFile(String string2) {
        File file = (File)this.getDefault(string2);
        String string3 = this.internal.getProperty(string2);
        if (string3 == null) {
            return file;
        }
        File file2 = new File(string3);
        if (file2.exists()) {
            return file2;
        }
        this.internal.remove(string2);
        return file;
    }

    public File[] getFiles(String string2) {
        int n2 = 0;
        ArrayList<File> arrayList = new ArrayList<File>();
        while (true) {
            File file = this.getFile(string2 + n2);
            ++n2;
            if (file == null) break;
            arrayList.add(file);
        }
        if (arrayList.size() != 0) {
            File[] fileArray = new File[arrayList.size()];
            return arrayList.toArray(fileArray);
        }
        return (File[])this.getDefault(string2);
    }

    public int getInteger(String string2) {
        int n2;
        String string3;
        int n3 = 0;
        if (this.getDefault(string2) != null) {
            n3 = (Integer)this.getDefault(string2);
        }
        if ((string3 = this.internal.getProperty(string2)) == null) {
            return n3;
        }
        try {
            n2 = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            this.internal.remove(string2);
            return n3;
        }
        return n2;
    }

    public float getFloat(String string2) {
        float f2;
        String string3;
        float f3 = 0.0f;
        if (this.getDefault(string2) != null) {
            f3 = ((Float)this.getDefault(string2)).floatValue();
        }
        if ((string3 = this.internal.getProperty(string2)) == null) {
            return f3;
        }
        try {
            f2 = Float.parseFloat(string3);
        }
        catch (NumberFormatException numberFormatException) {
            this.setFloat(string2, f3);
            return f3;
        }
        return f2;
    }

    public boolean getBoolean(String string2) {
        if (this.internal.getProperty(string2) != null) {
            return this.internal.getProperty(string2).equals("true");
        }
        if (this.getDefault(string2) != null) {
            return (Boolean)this.getDefault(string2);
        }
        return false;
    }

    public void setRectangle(String string2, Rectangle rectangle) {
        if (rectangle != null && !rectangle.equals(this.getDefault(string2))) {
            this.internal.setProperty(string2, rectangle.x + " " + rectangle.y + " " + rectangle.width + ' ' + rectangle.height);
        } else {
            this.internal.remove(string2);
        }
    }

    public void setDimension(String string2, Dimension dimension) {
        if (dimension != null && !dimension.equals(this.getDefault(string2))) {
            this.internal.setProperty(string2, dimension.width + " " + dimension.height);
        } else {
            this.internal.remove(string2);
        }
    }

    public void setPoint(String string2, Point point) {
        if (point != null && !point.equals(this.getDefault(string2))) {
            this.internal.setProperty(string2, point.x + " " + point.y);
        } else {
            this.internal.remove(string2);
        }
    }

    public void setColor(String string2, Color color) {
        if (color != null && !color.equals(this.getDefault(string2))) {
            this.internal.setProperty(string2, color.getRed() + " " + color.getGreen() + " " + color.getBlue() + " " + color.getAlpha());
        } else {
            this.internal.remove(string2);
        }
    }

    public void setFont(String string2, Font font) {
        if (font != null && !font.equals(this.getDefault(string2))) {
            this.internal.setProperty(string2, font.getName() + " " + font.getSize() + " " + font.getStyle());
        } else {
            this.internal.remove(string2);
        }
    }

    public void setString(String string2, String string3) {
        if (string3 != null && !string3.equals(this.getDefault(string2))) {
            this.internal.setProperty(string2, string3);
        } else {
            this.internal.remove(string2);
        }
    }

    public void setStrings(String string2, String[] stringArray) {
        String string3;
        int n2 = 0;
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2] == null) continue;
                this.setString(string2 + n2, stringArray[i2]);
                ++n2;
            }
        }
        while ((string3 = this.getString(string2 + n2)) != null) {
            this.setString(string2 + n2, null);
            ++n2;
        }
    }

    public void setURL(String string2, URL uRL) {
        if (uRL != null && !uRL.equals(this.getDefault(string2))) {
            this.internal.setProperty(string2, uRL.toString());
        } else {
            this.internal.remove(string2);
        }
    }

    public void setURLs(String string2, URL[] uRLArray) {
        String string3;
        int n2 = 0;
        if (uRLArray != null) {
            for (int i2 = 0; i2 < uRLArray.length; ++i2) {
                if (uRLArray[i2] == null) continue;
                this.setURL(string2 + n2, uRLArray[i2]);
                ++n2;
            }
        }
        while ((string3 = this.getString(string2 + n2)) != null) {
            this.setString(string2 + n2, null);
            ++n2;
        }
    }

    public void setFile(String string2, File file) {
        if (file != null && !file.equals(this.getDefault(string2))) {
            this.internal.setProperty(string2, file.getAbsolutePath());
        } else {
            this.internal.remove(string2);
        }
    }

    public void setFiles(String string2, File[] fileArray) {
        String string3;
        int n2 = 0;
        if (fileArray != null) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                if (fileArray[i2] == null) continue;
                this.setFile(string2 + n2, fileArray[i2]);
                ++n2;
            }
        }
        while ((string3 = this.getString(string2 + n2)) != null) {
            this.setString(string2 + n2, null);
            ++n2;
        }
    }

    public void setInteger(String string2, int n2) {
        if (this.getDefault(string2) != null && (Integer)this.getDefault(string2) != n2) {
            this.internal.setProperty(string2, Integer.toString(n2));
        } else {
            this.internal.remove(string2);
        }
    }

    public void setFloat(String string2, float f2) {
        if (this.getDefault(string2) != null && ((Float)this.getDefault(string2)).floatValue() != f2) {
            this.internal.setProperty(string2, Float.toString(f2));
        } else {
            this.internal.remove(string2);
        }
    }

    public void setBoolean(String string2, boolean bl2) {
        if (this.getDefault(string2) != null && (Boolean)this.getDefault(string2) != bl2) {
            this.internal.setProperty(string2, bl2 ? "true" : "false");
        } else {
            this.internal.remove(string2);
        }
    }
}

