/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.batik.Version;
import org.apache.batik.util.ParsedURLData;
import org.apache.batik.util.ParsedURLDataProtocolHandler;
import org.apache.batik.util.ParsedURLDefaultProtocolHandler;
import org.apache.batik.util.ParsedURLJarProtocolHandler;
import org.apache.batik.util.ParsedURLProtocolHandler;
import org.apache.batik.util.Service;

public class ParsedURL {
    ParsedURLData data;
    String userAgent;
    private static Map handlersMap = null;
    private static ParsedURLProtocolHandler defaultHandler = new ParsedURLDefaultProtocolHandler();
    private static String globalUserAgent = "Batik/" + Version.getVersion();

    public static String getGlobalUserAgent() {
        return globalUserAgent;
    }

    public static void setGlobalUserAgent(String string2) {
        globalUserAgent = string2;
    }

    private static synchronized Map getHandlersMap() {
        if (handlersMap != null) {
            return handlersMap;
        }
        handlersMap = new HashMap();
        ParsedURL.registerHandler(new ParsedURLDataProtocolHandler());
        ParsedURL.registerHandler(new ParsedURLJarProtocolHandler());
        Iterator iterator = Service.providers(ParsedURLProtocolHandler.class);
        while (iterator.hasNext()) {
            ParsedURLProtocolHandler parsedURLProtocolHandler = (ParsedURLProtocolHandler)iterator.next();
            ParsedURL.registerHandler(parsedURLProtocolHandler);
        }
        return handlersMap;
    }

    public static synchronized ParsedURLProtocolHandler getHandler(String string2) {
        if (string2 == null) {
            return defaultHandler;
        }
        Map map = ParsedURL.getHandlersMap();
        ParsedURLProtocolHandler parsedURLProtocolHandler = (ParsedURLProtocolHandler)map.get(string2);
        if (parsedURLProtocolHandler == null) {
            parsedURLProtocolHandler = defaultHandler;
        }
        return parsedURLProtocolHandler;
    }

    public static synchronized void registerHandler(ParsedURLProtocolHandler parsedURLProtocolHandler) {
        if (parsedURLProtocolHandler.getProtocolHandled() == null) {
            defaultHandler = parsedURLProtocolHandler;
            return;
        }
        Map map = ParsedURL.getHandlersMap();
        map.put(parsedURLProtocolHandler.getProtocolHandled(), parsedURLProtocolHandler);
    }

    public static InputStream checkGZIP(InputStream inputStream) throws IOException {
        return ParsedURLData.checkGZIP(inputStream);
    }

    public ParsedURL(String string2) {
        this.userAgent = ParsedURL.getGlobalUserAgent();
        this.data = ParsedURL.parseURL(string2);
    }

    public ParsedURL(URL uRL) {
        this.userAgent = ParsedURL.getGlobalUserAgent();
        this.data = new ParsedURLData(uRL);
    }

    public ParsedURL(String string2, String string3) {
        this.userAgent = ParsedURL.getGlobalUserAgent();
        this.data = string2 != null ? ParsedURL.parseURL(string2, string3) : ParsedURL.parseURL(string3);
    }

    public ParsedURL(URL uRL, String string2) {
        this.userAgent = ParsedURL.getGlobalUserAgent();
        this.data = uRL != null ? ParsedURL.parseURL(new ParsedURL(uRL), string2) : ParsedURL.parseURL(string2);
    }

    public ParsedURL(ParsedURL parsedURL, String string2) {
        if (parsedURL != null) {
            this.userAgent = parsedURL.getUserAgent();
            this.data = ParsedURL.parseURL(parsedURL, string2);
        } else {
            this.data = ParsedURL.parseURL(string2);
        }
    }

    public String toString() {
        return this.data.toString();
    }

    public String getPostConnectionURL() {
        return this.data.getPostConnectionURL();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ParsedURL)) {
            return false;
        }
        ParsedURL parsedURL = (ParsedURL)object;
        return this.data.equals(parsedURL.data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public boolean complete() {
        return this.data.complete();
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String string2) {
        this.userAgent = string2;
    }

    public String getProtocol() {
        if (this.data.protocol == null) {
            return null;
        }
        return this.data.protocol;
    }

    public String getHost() {
        if (this.data.host == null) {
            return null;
        }
        return this.data.host;
    }

    public int getPort() {
        return this.data.port;
    }

    public String getPath() {
        if (this.data.path == null) {
            return null;
        }
        return this.data.path;
    }

    public String getRef() {
        if (this.data.ref == null) {
            return null;
        }
        return this.data.ref;
    }

    public String getPortStr() {
        return this.data.getPortStr();
    }

    public String getContentType() {
        return this.data.getContentType(this.userAgent);
    }

    public String getContentTypeMediaType() {
        return this.data.getContentTypeMediaType(this.userAgent);
    }

    public String getContentTypeCharset() {
        return this.data.getContentTypeCharset(this.userAgent);
    }

    public boolean hasContentTypeParameter(String string2) {
        return this.data.hasContentTypeParameter(this.userAgent, string2);
    }

    public String getContentEncoding() {
        return this.data.getContentEncoding(this.userAgent);
    }

    public InputStream openStream() throws IOException {
        return this.data.openStream(this.userAgent, null);
    }

    public InputStream openStream(String string2) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string2);
        return this.data.openStream(this.userAgent, arrayList.iterator());
    }

    public InputStream openStream(String[] stringArray) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.add(stringArray[i2]);
        }
        return this.data.openStream(this.userAgent, arrayList.iterator());
    }

    public InputStream openStream(Iterator iterator) throws IOException {
        return this.data.openStream(this.userAgent, iterator);
    }

    public InputStream openStreamRaw() throws IOException {
        return this.data.openStreamRaw(this.userAgent, null);
    }

    public InputStream openStreamRaw(String string2) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string2);
        return this.data.openStreamRaw(this.userAgent, arrayList.iterator());
    }

    public InputStream openStreamRaw(String[] stringArray) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        arrayList.addAll(Arrays.asList(stringArray));
        return this.data.openStreamRaw(this.userAgent, arrayList.iterator());
    }

    public InputStream openStreamRaw(Iterator iterator) throws IOException {
        return this.data.openStreamRaw(this.userAgent, iterator);
    }

    public boolean sameFile(ParsedURL parsedURL) {
        return this.data.sameFile(parsedURL.data);
    }

    protected static String getProtocol(String string2) {
        if (string2 == null) {
            return null;
        }
        int n2 = 0;
        int n3 = string2.length();
        if (n3 == 0) {
            return null;
        }
        char c2 = string2.charAt(n2);
        while (c2 == '-' || c2 == '+' || c2 == '.' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z') {
            if (++n2 == n3) {
                c2 = '\u0000';
                break;
            }
            c2 = string2.charAt(n2);
        }
        if (c2 == ':') {
            return string2.substring(0, n2).toLowerCase();
        }
        return null;
    }

    public static ParsedURLData parseURL(String string2) {
        if (string2 != null && !string2.contains(":") && !string2.startsWith("#")) {
            string2 = "file:" + string2;
        }
        ParsedURLProtocolHandler parsedURLProtocolHandler = ParsedURL.getHandler(ParsedURL.getProtocol(string2));
        return parsedURLProtocolHandler.parseURL(string2);
    }

    public static ParsedURLData parseURL(String string2, String string3) {
        if (string2 == null) {
            return ParsedURL.parseURL(string3);
        }
        ParsedURL parsedURL = new ParsedURL(string2);
        return ParsedURL.parseURL(parsedURL, string3);
    }

    public static ParsedURLData parseURL(ParsedURL parsedURL, String string2) {
        if (parsedURL == null) {
            return ParsedURL.parseURL(string2);
        }
        String string3 = ParsedURL.getProtocol(string2);
        if (string3 == null) {
            string3 = parsedURL.getProtocol();
        }
        ParsedURLProtocolHandler parsedURLProtocolHandler = ParsedURL.getHandler(string3);
        return parsedURLProtocolHandler.parseURL(parsedURL, string2);
    }
}

