/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.net.URL;
import java.security.Policy;
import org.apache.batik.util.BatikSecurityManager;
import org.apache.batik.util.Messages;

public class ApplicationSecurityEnforcer {
    public static final String EXCEPTION_ALIEN_SECURITY_MANAGER = "ApplicationSecurityEnforcer.message.security.exception.alien.security.manager";
    public static final String EXCEPTION_NO_POLICY_FILE = "ApplicationSecurityEnforcer.message.null.pointer.exception.no.policy.file";
    public static final String PROPERTY_JAVA_SECURITY_POLICY = "java.security.policy";
    public static final String JAR_PROTOCOL = "jar:";
    public static final String JAR_URL_FILE_SEPARATOR = "!/";
    public static final String PROPERTY_APP_DEV_BASE = "app.dev.base";
    public static final String PROPERTY_APP_JAR_BASE = "app.jar.base";
    public static final String APP_MAIN_CLASS_DIR = "classes/";
    protected Class appMainClass;
    protected String securityPolicy;
    protected String appMainClassRelativeURL;
    protected BatikSecurityManager lastSecurityManagerInstalled;

    public ApplicationSecurityEnforcer(Class clazz, String string2, String string3) {
        this(clazz, string2);
    }

    public ApplicationSecurityEnforcer(Class clazz, String string2) {
        this.appMainClass = clazz;
        this.securityPolicy = string2;
        this.appMainClassRelativeURL = clazz.getName().replace('.', '/') + ".class";
    }

    public void enforceSecurity(boolean bl2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && securityManager != this.lastSecurityManagerInstalled) {
            throw new SecurityException(Messages.getString(EXCEPTION_ALIEN_SECURITY_MANAGER));
        }
        if (bl2) {
            System.setSecurityManager(null);
            this.installSecurityManager();
        } else if (securityManager != null) {
            System.setSecurityManager(null);
            this.lastSecurityManagerInstalled = null;
        }
    }

    public URL getPolicyURL() {
        ClassLoader classLoader = this.appMainClass.getClassLoader();
        URL uRL = classLoader.getResource(this.securityPolicy);
        if (uRL == null) {
            throw new NullPointerException(Messages.formatMessage(EXCEPTION_NO_POLICY_FILE, new Object[]{this.securityPolicy}));
        }
        return uRL;
    }

    public void installSecurityManager() {
        URL uRL;
        Policy policy = Policy.getPolicy();
        BatikSecurityManager batikSecurityManager = new BatikSecurityManager();
        ClassLoader classLoader = this.appMainClass.getClassLoader();
        String string2 = System.getProperty(PROPERTY_JAVA_SECURITY_POLICY);
        if (string2 == null || string2.equals("")) {
            uRL = this.getPolicyURL();
            System.setProperty(PROPERTY_JAVA_SECURITY_POLICY, uRL.toString());
        }
        if ((uRL = classLoader.getResource(this.appMainClassRelativeURL)) == null) {
            throw new Error(this.appMainClassRelativeURL);
        }
        String string3 = uRL.toString();
        if (string3.startsWith(JAR_PROTOCOL)) {
            this.setJarBase(string3);
        } else {
            this.setDevBase(string3);
        }
        System.setSecurityManager(batikSecurityManager);
        this.lastSecurityManagerInstalled = batikSecurityManager;
        policy.refresh();
        if (string2 == null || string2.equals("")) {
            System.setProperty(PROPERTY_JAVA_SECURITY_POLICY, "");
        }
    }

    private void setJarBase(String string2) {
        String string3 = System.getProperty(PROPERTY_APP_JAR_BASE);
        if (string3 == null) {
            int n2 = (string2 = string2.substring(JAR_PROTOCOL.length())).indexOf(JAR_URL_FILE_SEPARATOR + this.appMainClassRelativeURL);
            if (n2 == -1) {
                throw new Error();
            }
            String string4 = string2.substring(0, n2);
            string4 = (n2 = string4.lastIndexOf(47)) == -1 ? "" : string4.substring(0, n2);
            System.setProperty(PROPERTY_APP_JAR_BASE, string4);
        }
    }

    private void setDevBase(String string2) {
        String string3 = System.getProperty(PROPERTY_APP_DEV_BASE);
        if (string3 == null) {
            int n2 = string2.indexOf(APP_MAIN_CLASS_DIR + this.appMainClassRelativeURL);
            if (n2 == -1) {
                throw new Error();
            }
            String string4 = string2.substring(0, n2);
            System.setProperty(PROPERTY_APP_DEV_BASE, string4);
        }
    }
}

