/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.Coverage;
import org.apache.batik.svggen.font.table.SingleSubst;

public class SingleSubstFormat2
extends SingleSubst {
    private int coverageOffset;
    private int glyphCount;
    private int[] substitutes;
    private Coverage coverage;

    protected SingleSubstFormat2(RandomAccessFile randomAccessFile, int n2) throws IOException {
        this.coverageOffset = randomAccessFile.readUnsignedShort();
        this.glyphCount = randomAccessFile.readUnsignedShort();
        this.substitutes = new int[this.glyphCount];
        for (int i2 = 0; i2 < this.glyphCount; ++i2) {
            this.substitutes[i2] = randomAccessFile.readUnsignedShort();
        }
        randomAccessFile.seek(n2 + this.coverageOffset);
        this.coverage = Coverage.read(randomAccessFile);
    }

    @Override
    public int getFormat() {
        return 2;
    }

    @Override
    public int substitute(int n2) {
        int n3 = this.coverage.findGlyph(n2);
        if (n3 > -1) {
            return this.substitutes[n3];
        }
        return n2;
    }
}

