/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.Feature;
import org.apache.batik.svggen.font.table.FeatureRecord;
import org.apache.batik.svggen.font.table.LangSys;

public class FeatureList {
    private int featureCount;
    private FeatureRecord[] featureRecords;
    private Feature[] features;

    public FeatureList(RandomAccessFile randomAccessFile, int n2) throws IOException {
        int n3;
        randomAccessFile.seek(n2);
        this.featureCount = randomAccessFile.readUnsignedShort();
        this.featureRecords = new FeatureRecord[this.featureCount];
        this.features = new Feature[this.featureCount];
        for (n3 = 0; n3 < this.featureCount; ++n3) {
            this.featureRecords[n3] = new FeatureRecord(randomAccessFile);
        }
        for (n3 = 0; n3 < this.featureCount; ++n3) {
            this.features[n3] = new Feature(randomAccessFile, n2 + this.featureRecords[n3].getOffset());
        }
    }

    public Feature findFeature(LangSys langSys, String string2) {
        if (string2.length() != 4) {
            return null;
        }
        int n2 = string2.charAt(0) << 24 | string2.charAt(1) << 16 | string2.charAt(2) << 8 | string2.charAt(3);
        for (int i2 = 0; i2 < this.featureCount; ++i2) {
            if (this.featureRecords[i2].getTag() != n2 || !langSys.isFeatureIndexed(i2)) continue;
            return this.features[i2];
        }
        return null;
    }
}

