/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;

public class CmapIndexEntry {
    private int platformId;
    private int encodingId;
    private int offset;

    protected CmapIndexEntry(RandomAccessFile randomAccessFile) throws IOException {
        this.platformId = randomAccessFile.readUnsignedShort();
        this.encodingId = randomAccessFile.readUnsignedShort();
        this.offset = randomAccessFile.readInt();
    }

    public int getEncodingId() {
        return this.encodingId;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getPlatformId() {
        return this.platformId;
    }

    public String toString() {
        String string2;
        String string3 = "";
        switch (this.platformId) {
            case 1: {
                string2 = " (Macintosh)";
                break;
            }
            case 3: {
                string2 = " (Windows)";
                break;
            }
            default: {
                string2 = "";
            }
        }
        if (this.platformId == 3) {
            switch (this.encodingId) {
                case 0: {
                    string3 = " (Symbol)";
                    break;
                }
                case 1: {
                    string3 = " (Unicode)";
                    break;
                }
                case 2: {
                    string3 = " (ShiftJIS)";
                    break;
                }
                case 3: {
                    string3 = " (Big5)";
                    break;
                }
                case 4: {
                    string3 = " (PRC)";
                    break;
                }
                case 5: {
                    string3 = " (Wansung)";
                    break;
                }
                case 6: {
                    string3 = " (Johab)";
                    break;
                }
                default: {
                    string3 = "";
                }
            }
        }
        return new StringBuffer().append("platform id: ").append(this.platformId).append(string2).append(", encoding id: ").append(this.encodingId).append(string3).append(", offset: ").append(this.offset).toString();
    }
}

