/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.CmapFormat;

public class CmapFormat4
extends CmapFormat {
    public int language;
    private int segCountX2;
    private int searchRange;
    private int entrySelector;
    private int rangeShift;
    private int[] endCode;
    private int[] startCode;
    private int[] idDelta;
    private int[] idRangeOffset;
    private int[] glyphIdArray;
    private int segCount;
    private int first;
    private int last;

    protected CmapFormat4(RandomAccessFile randomAccessFile) throws IOException {
        super(randomAccessFile);
        int n2;
        this.format = 4;
        this.segCountX2 = randomAccessFile.readUnsignedShort();
        this.segCount = this.segCountX2 / 2;
        this.endCode = new int[this.segCount];
        this.startCode = new int[this.segCount];
        this.idDelta = new int[this.segCount];
        this.idRangeOffset = new int[this.segCount];
        this.searchRange = randomAccessFile.readUnsignedShort();
        this.entrySelector = randomAccessFile.readUnsignedShort();
        this.rangeShift = randomAccessFile.readUnsignedShort();
        this.last = -1;
        for (n2 = 0; n2 < this.segCount; ++n2) {
            this.endCode[n2] = randomAccessFile.readUnsignedShort();
            if (this.endCode[n2] <= this.last) continue;
            this.last = this.endCode[n2];
        }
        randomAccessFile.readUnsignedShort();
        for (n2 = 0; n2 < this.segCount; ++n2) {
            this.startCode[n2] = randomAccessFile.readUnsignedShort();
            if (n2 != 0 && this.startCode[n2] >= this.first) continue;
            this.first = this.startCode[n2];
        }
        for (n2 = 0; n2 < this.segCount; ++n2) {
            this.idDelta[n2] = randomAccessFile.readUnsignedShort();
        }
        for (n2 = 0; n2 < this.segCount; ++n2) {
            this.idRangeOffset[n2] = randomAccessFile.readUnsignedShort();
        }
        n2 = (this.length - 16 - this.segCount * 8) / 2;
        this.glyphIdArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.glyphIdArray[i2] = randomAccessFile.readUnsignedShort();
        }
    }

    @Override
    public int getFirst() {
        return this.first;
    }

    @Override
    public int getLast() {
        return this.last;
    }

    @Override
    public int mapCharCode(int n2) {
        try {
            if (n2 < 0 || n2 >= 65534) {
                return 0;
            }
            for (int i2 = 0; i2 < this.segCount; ++i2) {
                if (this.endCode[i2] < n2) continue;
                if (this.startCode[i2] <= n2) {
                    if (this.idRangeOffset[i2] > 0) {
                        return this.glyphIdArray[this.idRangeOffset[i2] / 2 + (n2 - this.startCode[i2]) - (this.segCount - i2)];
                    }
                    return (this.idDelta[i2] + n2) % 65536;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("error: Array out of bounds - " + arrayIndexOutOfBoundsException.getMessage());
        }
        return 0;
    }

    @Override
    public String toString() {
        return new StringBuffer(80).append(super.toString()).append(", segCountX2: ").append(this.segCountX2).append(", searchRange: ").append(this.searchRange).append(", entrySelector: ").append(this.entrySelector).append(", rangeShift: ").append(this.rangeShift).append(", endCode: ").append(CmapFormat4.intToStr(this.endCode)).append(", startCode: ").append(CmapFormat4.intToStr(this.startCode)).append(", idDelta: ").append(CmapFormat4.intToStr(this.idDelta)).append(", idRangeOffset: ").append(CmapFormat4.intToStr(this.idRangeOffset)).toString();
    }

    private static String intToStr(int[] nArray) {
        int n2 = nArray.length;
        StringBuffer stringBuffer = new StringBuffer(n2 * 8);
        stringBuffer.append('[');
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(nArray[i2]);
            if (i2 >= n2 - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

