/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import org.apache.batik.svggen.DOMTreeManager;
import org.apache.batik.svggen.ErrorConstants;
import org.apache.batik.svggen.GenericImageHandler;
import org.apache.batik.svggen.ImageHandler;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGSyntax;
import org.w3c.dom.Element;

public class SimpleImageHandler
implements GenericImageHandler,
SVGSyntax,
ErrorConstants {
    static final String XLINK_NAMESPACE_URI = "http://www.w3.org/1999/xlink";
    protected ImageHandler imageHandler;

    public SimpleImageHandler(ImageHandler imageHandler) {
        if (imageHandler == null) {
            throw new IllegalArgumentException();
        }
        this.imageHandler = imageHandler;
    }

    @Override
    public void setDOMTreeManager(DOMTreeManager dOMTreeManager) {
    }

    @Override
    public Element createElement(SVGGeneratorContext sVGGeneratorContext) {
        Element element = sVGGeneratorContext.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "image");
        return element;
    }

    @Override
    public AffineTransform handleImage(Image image2, Element element, int n2, int n3, int n4, int n5, SVGGeneratorContext sVGGeneratorContext) {
        int n6 = image2.getWidth(null);
        int n7 = image2.getHeight(null);
        if (n6 == 0 || n7 == 0 || n4 == 0 || n5 == 0) {
            this.handleEmptyImage(element);
        } else {
            this.imageHandler.handleImage(image2, element, sVGGeneratorContext);
            this.setImageAttributes(element, n2, n3, n4, n5, sVGGeneratorContext);
        }
        return null;
    }

    @Override
    public AffineTransform handleImage(RenderedImage renderedImage, Element element, int n2, int n3, int n4, int n5, SVGGeneratorContext sVGGeneratorContext) {
        int n6 = renderedImage.getWidth();
        int n7 = renderedImage.getHeight();
        if (n6 == 0 || n7 == 0 || n4 == 0 || n5 == 0) {
            this.handleEmptyImage(element);
        } else {
            this.imageHandler.handleImage(renderedImage, element, sVGGeneratorContext);
            this.setImageAttributes(element, n2, n3, n4, n5, sVGGeneratorContext);
        }
        return null;
    }

    @Override
    public AffineTransform handleImage(RenderableImage renderableImage, Element element, double d2, double d3, double d4, double d5, SVGGeneratorContext sVGGeneratorContext) {
        double d6 = renderableImage.getWidth();
        double d7 = renderableImage.getHeight();
        if (d6 == 0.0 || d7 == 0.0 || d4 == 0.0 || d5 == 0.0) {
            this.handleEmptyImage(element);
        } else {
            this.imageHandler.handleImage(renderableImage, element, sVGGeneratorContext);
            this.setImageAttributes(element, d2, d3, d4, d5, sVGGeneratorContext);
        }
        return null;
    }

    protected void setImageAttributes(Element element, double d2, double d3, double d4, double d5, SVGGeneratorContext sVGGeneratorContext) {
        element.setAttributeNS(null, "x", sVGGeneratorContext.doubleString(d2));
        element.setAttributeNS(null, "y", sVGGeneratorContext.doubleString(d3));
        element.setAttributeNS(null, "width", sVGGeneratorContext.doubleString(d4));
        element.setAttributeNS(null, "height", sVGGeneratorContext.doubleString(d5));
        element.setAttributeNS(null, "preserveAspectRatio", "none");
    }

    protected void handleEmptyImage(Element element) {
        element.setAttributeNS(XLINK_NAMESPACE_URI, "xlink:href", "");
        element.setAttributeNS(null, "width", "0");
        element.setAttributeNS(null, "height", "0");
    }
}

