/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.geom.Point2D;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.svggen.AbstractSVGConverter;
import org.apache.batik.svggen.SVGColor;
import org.apache.batik.svggen.SVGDescriptor;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGPaintDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGLinearGradient
extends AbstractSVGConverter {
    public SVGLinearGradient(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
    }

    @Override
    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        Paint paint = graphicContext.getPaint();
        return this.toSVG((GradientPaint)paint);
    }

    public SVGPaintDescriptor toSVG(GradientPaint gradientPaint) {
        SVGPaintDescriptor sVGPaintDescriptor = (SVGPaintDescriptor)this.descMap.get(gradientPaint);
        Document document = this.generatorContext.domFactory;
        if (sVGPaintDescriptor == null) {
            Element element = document.createElementNS("http://www.w3.org/2000/svg", "linearGradient");
            element.setAttributeNS(null, "gradientUnits", "userSpaceOnUse");
            Point2D point2D = gradientPaint.getPoint1();
            Point2D point2D2 = gradientPaint.getPoint2();
            element.setAttributeNS(null, "x1", this.doubleString(point2D.getX()));
            element.setAttributeNS(null, "y1", this.doubleString(point2D.getY()));
            element.setAttributeNS(null, "x2", this.doubleString(point2D2.getX()));
            element.setAttributeNS(null, "y2", this.doubleString(point2D2.getY()));
            String string2 = "pad";
            if (gradientPaint.isCyclic()) {
                string2 = "reflect";
            }
            element.setAttributeNS(null, "spreadMethod", string2);
            Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "stop");
            element2.setAttributeNS(null, "offset", "0%");
            SVGPaintDescriptor sVGPaintDescriptor2 = SVGColor.toSVG(gradientPaint.getColor1(), this.generatorContext);
            element2.setAttributeNS(null, "stop-color", sVGPaintDescriptor2.getPaintValue());
            element2.setAttributeNS(null, "stop-opacity", sVGPaintDescriptor2.getOpacityValue());
            element.appendChild(element2);
            element2 = document.createElementNS("http://www.w3.org/2000/svg", "stop");
            element2.setAttributeNS(null, "offset", "100%");
            sVGPaintDescriptor2 = SVGColor.toSVG(gradientPaint.getColor2(), this.generatorContext);
            element2.setAttributeNS(null, "stop-color", sVGPaintDescriptor2.getPaintValue());
            element2.setAttributeNS(null, "stop-opacity", sVGPaintDescriptor2.getOpacityValue());
            element.appendChild(element2);
            element.setAttributeNS(null, "id", this.generatorContext.idGenerator.generateID("linearGradient"));
            StringBuffer stringBuffer = new StringBuffer("url(");
            stringBuffer.append("#");
            stringBuffer.append(element.getAttributeNS(null, "id"));
            stringBuffer.append(")");
            sVGPaintDescriptor = new SVGPaintDescriptor(stringBuffer.toString(), "1", element);
            this.descMap.put(gradientPaint, sVGPaintDescriptor);
            this.defSet.add(element);
        }
        return sVGPaintDescriptor;
    }
}

