/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.util.HashMap;
import java.util.Map;
import org.apache.batik.ext.awt.g2d.TransformStackElement;
import org.apache.batik.svggen.ErrorConstants;
import org.apache.batik.svggen.SVGGraphics2DRuntimeException;
import org.apache.batik.util.SVGConstants;

public class SVGGraphicContext
implements SVGConstants,
ErrorConstants {
    private static final String[] leafOnlyAttributes = new String[]{"opacity", "filter", "clip-path"};
    private static final String[] defaultValues = new String[]{"1", "none", "none"};
    private Map context;
    private Map groupContext;
    private Map graphicElementContext;
    private TransformStackElement[] transformStack;

    public SVGGraphicContext(Map map, TransformStackElement[] transformStackElementArray) {
        if (map == null) {
            throw new SVGGraphics2DRuntimeException("context map(s) should not be null");
        }
        if (transformStackElementArray == null) {
            throw new SVGGraphics2DRuntimeException("transformer stack should not be null");
        }
        this.context = map;
        this.transformStack = transformStackElementArray;
        this.computeGroupAndGraphicElementContext();
    }

    public SVGGraphicContext(Map map, Map map2, TransformStackElement[] transformStackElementArray) {
        if (map == null || map2 == null) {
            throw new SVGGraphics2DRuntimeException("context map(s) should not be null");
        }
        if (transformStackElementArray == null) {
            throw new SVGGraphics2DRuntimeException("transformer stack should not be null");
        }
        this.groupContext = map;
        this.graphicElementContext = map2;
        this.transformStack = transformStackElementArray;
        this.computeContext();
    }

    public Map getContext() {
        return this.context;
    }

    public Map getGroupContext() {
        return this.groupContext;
    }

    public Map getGraphicElementContext() {
        return this.graphicElementContext;
    }

    public TransformStackElement[] getTransformStack() {
        return this.transformStack;
    }

    private void computeContext() {
        if (this.context != null) {
            return;
        }
        this.context = new HashMap(this.groupContext);
        this.context.putAll(this.graphicElementContext);
    }

    private void computeGroupAndGraphicElementContext() {
        if (this.groupContext != null) {
            return;
        }
        this.groupContext = new HashMap(this.context);
        this.graphicElementContext = new HashMap();
        for (int i2 = 0; i2 < leafOnlyAttributes.length; ++i2) {
            Object v2 = this.groupContext.get(leafOnlyAttributes[i2]);
            if (v2 == null) continue;
            if (!v2.equals(defaultValues[i2])) {
                this.graphicElementContext.put(leafOnlyAttributes[i2], v2);
            }
            this.groupContext.remove(leafOnlyAttributes[i2]);
        }
    }
}

