/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.spi.ImageWriter;
import org.apache.batik.ext.awt.image.spi.ImageWriterRegistry;
import org.apache.batik.svggen.DefaultCachedImageHandler;
import org.apache.batik.svggen.ImageCacher;
import org.apache.batik.svggen.SVGGraphics2DIOException;

public class CachedImageHandlerPNGEncoder
extends DefaultCachedImageHandler {
    public static final String CACHED_PNG_PREFIX = "pngImage";
    public static final String CACHED_PNG_SUFFIX = ".png";
    protected String refPrefix = "";

    public CachedImageHandlerPNGEncoder(String string2, String string3) throws SVGGraphics2DIOException {
        this.refPrefix = string3 + "/";
        this.setImageCacher(new ImageCacher.External(string2, CACHED_PNG_PREFIX, CACHED_PNG_SUFFIX));
    }

    @Override
    public void encodeImage(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        ImageWriter imageWriter = ImageWriterRegistry.getInstance().getWriterFor("image/png");
        imageWriter.writeImage(bufferedImage, outputStream);
    }

    @Override
    public int getBufferedImageType() {
        return 2;
    }

    @Override
    public String getRefPrefix() {
        return this.refPrefix;
    }
}

