/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import org.apache.batik.ext.awt.image.spi.AbstractRegistryEntry;
import org.apache.batik.ext.awt.image.spi.StreamRegistryEntry;

public abstract class MagicNumberRegistryEntry
extends AbstractRegistryEntry
implements StreamRegistryEntry {
    public static final float PRIORITY = 1000.0f;
    MagicNumber[] magicNumbers;

    public MagicNumberRegistryEntry(String string2, float f2, String string3, String string4, int n2, byte[] byArray) {
        super(string2, f2, string3, string4);
        this.magicNumbers = new MagicNumber[1];
        this.magicNumbers[0] = new MagicNumber(n2, byArray);
    }

    public MagicNumberRegistryEntry(String string2, String string3, String string4, int n2, byte[] byArray) {
        this(string2, 1000.0f, string3, string4, n2, byArray);
    }

    public MagicNumberRegistryEntry(String string2, float f2, String string3, String string4, MagicNumber[] magicNumberArray) {
        super(string2, f2, string3, string4);
        this.magicNumbers = magicNumberArray;
    }

    public MagicNumberRegistryEntry(String string2, String string3, String string4, MagicNumber[] magicNumberArray) {
        this(string2, 1000.0f, string3, string4, magicNumberArray);
    }

    public MagicNumberRegistryEntry(String string2, float f2, String[] stringArray, String[] stringArray2, int n2, byte[] byArray) {
        super(string2, f2, stringArray, stringArray2);
        this.magicNumbers = new MagicNumber[1];
        this.magicNumbers[0] = new MagicNumber(n2, byArray);
    }

    public MagicNumberRegistryEntry(String string2, String[] stringArray, String[] stringArray2, int n2, byte[] byArray) {
        this(string2, 1000.0f, stringArray, stringArray2, n2, byArray);
    }

    public MagicNumberRegistryEntry(String string2, float f2, String[] stringArray, String[] stringArray2, MagicNumber[] magicNumberArray) {
        super(string2, f2, stringArray, stringArray2);
        this.magicNumbers = magicNumberArray;
    }

    public MagicNumberRegistryEntry(String string2, String[] stringArray, String[] stringArray2, MagicNumber[] magicNumberArray) {
        this(string2, 1000.0f, stringArray, stringArray2, magicNumberArray);
    }

    public MagicNumberRegistryEntry(String string2, String[] stringArray, String[] stringArray2, MagicNumber[] magicNumberArray, float f2) {
        super(string2, f2, stringArray, stringArray2);
        this.magicNumbers = magicNumberArray;
    }

    @Override
    public int getReadlimit() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.magicNumbers.length; ++i2) {
            int n3 = this.magicNumbers[i2].getReadlimit();
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    @Override
    public boolean isCompatibleStream(InputStream inputStream) throws StreamCorruptedException {
        for (int i2 = 0; i2 < this.magicNumbers.length; ++i2) {
            if (!this.magicNumbers[i2].isMatch(inputStream)) continue;
            return true;
        }
        return false;
    }

    public static class MagicNumber {
        int offset;
        byte[] magicNumber;
        byte[] buffer;

        public MagicNumber(int n2, byte[] byArray) {
            this.offset = n2;
            this.magicNumber = (byte[])byArray.clone();
            this.buffer = new byte[byArray.length];
        }

        int getReadlimit() {
            return this.offset + this.magicNumber.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isMatch(InputStream inputStream) throws StreamCorruptedException {
            inputStream.mark(this.getReadlimit());
            try {
                int n2;
                int n3;
                for (n2 = 0; n2 < this.offset; n2 += n3) {
                    n3 = (int)inputStream.skip(this.offset - n2);
                    if (n3 != -1) continue;
                    boolean bl2 = false;
                    return bl2;
                }
                for (n2 = 0; n2 < this.buffer.length; n2 += n3) {
                    n3 = inputStream.read(this.buffer, n2, this.buffer.length - n2);
                    if (n3 != -1) continue;
                    boolean bl3 = false;
                    return bl3;
                }
                for (n3 = 0; n3 < this.magicNumber.length; ++n3) {
                    if (this.magicNumber[n3] == this.buffer[n3]) continue;
                    boolean bl4 = false;
                    return bl4;
                }
            }
            catch (IOException iOException) {
                boolean bl5 = false;
                return bl5;
            }
            finally {
                try {
                    inputStream.reset();
                }
                catch (IOException iOException) {
                    throw new StreamCorruptedException(iOException.getMessage());
                }
            }
            return true;
        }
    }
}

