/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.spi;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.batik.ext.awt.image.URLImageCache;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.ProfileRable;
import org.apache.batik.ext.awt.image.spi.BrokenLinkProvider;
import org.apache.batik.ext.awt.image.spi.DefaultBrokenLinkProvider;
import org.apache.batik.ext.awt.image.spi.ErrorConstants;
import org.apache.batik.ext.awt.image.spi.JDKRegistryEntry;
import org.apache.batik.ext.awt.image.spi.RegistryEntry;
import org.apache.batik.ext.awt.image.spi.StreamRegistryEntry;
import org.apache.batik.ext.awt.image.spi.URLRegistryEntry;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.Service;
import org.apache.xmlgraphics.java2d.color.ICCColorSpaceWithIntent;

public class ImageTagRegistry
implements ErrorConstants {
    List entries = new LinkedList();
    List extensions = null;
    List mimeTypes = null;
    URLImageCache rawCache;
    URLImageCache imgCache;
    static ImageTagRegistry registry = null;
    static BrokenLinkProvider defaultProvider = new DefaultBrokenLinkProvider();
    static BrokenLinkProvider brokenLinkProvider = null;

    public ImageTagRegistry() {
        this(null, null);
    }

    public ImageTagRegistry(URLImageCache uRLImageCache, URLImageCache uRLImageCache2) {
        if (uRLImageCache == null) {
            uRLImageCache = new URLImageCache();
        }
        if (uRLImageCache2 == null) {
            uRLImageCache2 = new URLImageCache();
        }
        this.rawCache = uRLImageCache;
        this.imgCache = uRLImageCache2;
    }

    public void flushCache() {
        this.rawCache.flush();
        this.imgCache.flush();
    }

    public void flushImage(ParsedURL parsedURL) {
        this.rawCache.clear(parsedURL);
        this.imgCache.clear(parsedURL);
    }

    public Filter checkCache(ParsedURL parsedURL, ICCColorSpaceWithIntent iCCColorSpaceWithIntent) {
        boolean bl2 = iCCColorSpaceWithIntent != null;
        Filter filter = null;
        URLImageCache uRLImageCache = bl2 ? this.rawCache : this.imgCache;
        filter = uRLImageCache.request(parsedURL);
        if (filter == null) {
            uRLImageCache.clear(parsedURL);
            return null;
        }
        if (iCCColorSpaceWithIntent != null) {
            filter = new ProfileRable(filter, iCCColorSpaceWithIntent);
        }
        return filter;
    }

    public Filter readURL(ParsedURL parsedURL) {
        return this.readURL(null, parsedURL, null, true, true);
    }

    public Filter readURL(ParsedURL parsedURL, ICCColorSpaceWithIntent iCCColorSpaceWithIntent) {
        return this.readURL(null, parsedURL, iCCColorSpaceWithIntent, true, true);
    }

    public Filter readURL(InputStream inputStream, ParsedURL parsedURL, ICCColorSpaceWithIntent iCCColorSpaceWithIntent, boolean bl2, boolean bl3) {
        if (inputStream != null && !inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        boolean bl4 = iCCColorSpaceWithIntent != null;
        Filter filter = null;
        URLImageCache uRLImageCache = null;
        if (parsedURL != null && (filter = (uRLImageCache = bl4 ? this.rawCache : this.imgCache).request(parsedURL)) != null) {
            if (iCCColorSpaceWithIntent != null) {
                filter = new ProfileRable(filter, iCCColorSpaceWithIntent);
            }
            return filter;
        }
        boolean bl5 = false;
        List list = this.getRegisteredMimeTypes();
        for (RegistryEntry registryEntry : this.entries) {
            RegistryEntry registryEntry2;
            if (registryEntry instanceof URLRegistryEntry) {
                if (parsedURL == null || !bl2 || !(registryEntry2 = (URLRegistryEntry)registryEntry).isCompatibleURL(parsedURL) || (filter = registryEntry2.handleURL(parsedURL, bl4)) == null) continue;
                break;
            }
            if (!(registryEntry instanceof StreamRegistryEntry)) continue;
            registryEntry2 = (StreamRegistryEntry)registryEntry;
            if (bl5) continue;
            try {
                if (inputStream == null) {
                    if (parsedURL == null || !bl2) break;
                    try {
                        inputStream = parsedURL.openStream(list.iterator());
                    }
                    catch (IOException iOException) {
                        bl5 = true;
                        continue;
                    }
                    if (!inputStream.markSupported()) {
                        inputStream = new BufferedInputStream(inputStream);
                    }
                }
                if (!registryEntry2.isCompatibleStream(inputStream) || (filter = registryEntry2.handleStream(inputStream, parsedURL, bl4)) == null) continue;
                break;
            }
            catch (StreamCorruptedException streamCorruptedException) {
                inputStream = null;
            }
        }
        if (uRLImageCache != null) {
            uRLImageCache.put(parsedURL, filter);
        }
        if (filter == null) {
            if (!bl3) {
                return null;
            }
            if (bl5) {
                return ImageTagRegistry.getBrokenLinkImage(this, "url.unreachable", null);
            }
            return ImageTagRegistry.getBrokenLinkImage(this, "url.uninterpretable", null);
        }
        if (BrokenLinkProvider.hasBrokenLinkProperty(filter)) {
            return bl3 ? filter : null;
        }
        if (iCCColorSpaceWithIntent != null) {
            filter = new ProfileRable(filter, iCCColorSpaceWithIntent);
        }
        return filter;
    }

    public Filter readStream(InputStream inputStream) {
        return this.readStream(inputStream, null);
    }

    public Filter readStream(InputStream inputStream, ICCColorSpaceWithIntent iCCColorSpaceWithIntent) {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        boolean bl2 = iCCColorSpaceWithIntent != null;
        Filter filter = null;
        for (RegistryEntry registryEntry : this.entries) {
            if (!(registryEntry instanceof StreamRegistryEntry)) continue;
            StreamRegistryEntry streamRegistryEntry = (StreamRegistryEntry)registryEntry;
            try {
                if (!streamRegistryEntry.isCompatibleStream(inputStream) || (filter = streamRegistryEntry.handleStream(inputStream, null, bl2)) == null) continue;
            }
            catch (StreamCorruptedException streamCorruptedException) {}
            break;
        }
        if (filter == null) {
            return ImageTagRegistry.getBrokenLinkImage(this, "stream.unreadable", null);
        }
        if (iCCColorSpaceWithIntent != null && !BrokenLinkProvider.hasBrokenLinkProperty(filter)) {
            filter = new ProfileRable(filter, iCCColorSpaceWithIntent);
        }
        return filter;
    }

    public synchronized void register(RegistryEntry registryEntry) {
        float f2 = registryEntry.getPriority();
        ListIterator<RegistryEntry> listIterator = this.entries.listIterator();
        while (listIterator.hasNext()) {
            RegistryEntry registryEntry2 = (RegistryEntry)listIterator.next();
            if (!(registryEntry2.getPriority() > f2)) continue;
            listIterator.previous();
            listIterator.add(registryEntry);
            return;
        }
        listIterator.add(registryEntry);
        this.extensions = null;
        this.mimeTypes = null;
    }

    public synchronized List getRegisteredExtensions() {
        if (this.extensions != null) {
            return this.extensions;
        }
        this.extensions = new LinkedList();
        for (RegistryEntry registryEntry : this.entries) {
            this.extensions.addAll(registryEntry.getStandardExtensions());
        }
        this.extensions = Collections.unmodifiableList(this.extensions);
        return this.extensions;
    }

    public synchronized List getRegisteredMimeTypes() {
        if (this.mimeTypes != null) {
            return this.mimeTypes;
        }
        this.mimeTypes = new LinkedList();
        for (RegistryEntry registryEntry : this.entries) {
            this.mimeTypes.addAll(registryEntry.getMimeTypes());
        }
        this.mimeTypes = Collections.unmodifiableList(this.mimeTypes);
        return this.mimeTypes;
    }

    public static synchronized ImageTagRegistry getRegistry() {
        if (registry != null) {
            return registry;
        }
        registry = new ImageTagRegistry();
        registry.register(new JDKRegistryEntry());
        Iterator iterator = Service.providers(RegistryEntry.class);
        while (iterator.hasNext()) {
            RegistryEntry registryEntry = (RegistryEntry)iterator.next();
            registry.register(registryEntry);
        }
        return registry;
    }

    public static synchronized Filter getBrokenLinkImage(Object object, String string2, Object[] objectArray) {
        Filter filter = null;
        if (brokenLinkProvider != null) {
            filter = brokenLinkProvider.getBrokenLinkImage(object, string2, objectArray);
        }
        if (filter == null) {
            filter = defaultProvider.getBrokenLinkImage(object, string2, objectArray);
        }
        return filter;
    }

    public static synchronized void setBrokenLinkProvider(BrokenLinkProvider brokenLinkProvider) {
        ImageTagRegistry.brokenLinkProvider = brokenLinkProvider;
    }
}

