/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.AbstractTiledRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.TileCacheRed;
import org.apache.batik.ext.awt.image.rendered.TileGenerator;
import org.apache.batik.ext.awt.image.rendered.TileStore;
import org.apache.batik.util.HaltingThread;

public class TileRed
extends AbstractRed
implements TileGenerator {
    static final AffineTransform IDENTITY = new AffineTransform();
    Rectangle tiledRegion;
    int xStep;
    int yStep;
    TileStore tiles;
    private RenderingHints hints;
    final boolean is_INT_PACK;
    RenderedImage tile = null;
    WritableRaster raster = null;

    public TileRed(RenderedImage renderedImage, Rectangle rectangle) {
        this(renderedImage, rectangle, renderedImage.getWidth(), renderedImage.getHeight(), null);
    }

    public TileRed(RenderedImage renderedImage, Rectangle rectangle, RenderingHints renderingHints) {
        this(renderedImage, rectangle, renderedImage.getWidth(), renderedImage.getHeight(), renderingHints);
    }

    public TileRed(RenderedImage renderedImage, Rectangle rectangle, int n2, int n3) {
        this(renderedImage, rectangle, n2, n3, null);
    }

    public TileRed(RenderedImage renderedImage, Rectangle rectangle, int n2, int n3, RenderingHints renderingHints) {
        if (rectangle == null) {
            throw new IllegalArgumentException();
        }
        if (renderedImage == null) {
            throw new IllegalArgumentException();
        }
        this.tiledRegion = rectangle;
        this.xStep = n2;
        this.yStep = n3;
        this.hints = renderingHints;
        SampleModel sampleModel = TileRed.fixSampleModel(renderedImage, n2, n3, rectangle.width, rectangle.height);
        ColorModel colorModel = renderedImage.getColorModel();
        double d2 = AbstractTiledRed.getDefaultTileSize();
        double d3 = (double)n2 * (double)n3;
        if (16.1 * (d2 *= d2) > d3) {
            int n4 = n2;
            int n5 = n3;
            if (4.0 * d3 <= d2) {
                int n6 = (int)Math.ceil(Math.sqrt(d2 / d3));
                n4 *= n6;
                n5 *= n6;
            }
            sampleModel = sampleModel.createCompatibleSampleModel(n4, n5);
            this.raster = Raster.createWritableRaster(sampleModel, new Point(renderedImage.getMinX(), renderedImage.getMinY()));
        }
        this.is_INT_PACK = GraphicsUtil.is_INT_PACK_Data(sampleModel, false);
        this.init((CachableRed)null, rectangle, colorModel, sampleModel, renderedImage.getMinX(), renderedImage.getMinY(), null);
        if (this.raster != null) {
            WritableRaster writableRaster = this.raster.createWritableChild(renderedImage.getMinX(), renderedImage.getMinY(), n2, n3, renderedImage.getMinX(), renderedImage.getMinY(), null);
            this.fillRasterFrom(writableRaster, renderedImage);
            this.fillOutRaster(this.raster);
        } else {
            this.tile = new TileCacheRed(GraphicsUtil.wrap(renderedImage));
        }
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        int n2 = (int)Math.floor(writableRaster.getMinX() / this.xStep) * this.xStep;
        int n3 = (int)Math.floor(writableRaster.getMinY() / this.yStep) * this.yStep;
        int n4 = writableRaster.getMinX() - n2;
        int n5 = writableRaster.getMinY() - n3;
        int n6 = this.getXTile(n4);
        int n7 = this.getYTile(n5);
        int n8 = this.getXTile(n4 + writableRaster.getWidth() - 1);
        int n9 = this.getYTile(n5 + writableRaster.getHeight() - 1);
        for (int i2 = n7; i2 <= n9; ++i2) {
            for (int i3 = n6; i3 <= n8; ++i3) {
                Raster raster = this.getTile(i3, i2);
                raster = raster.createChild(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight(), raster.getMinX() + n2, raster.getMinY() + n3, null);
                if (this.is_INT_PACK) {
                    GraphicsUtil.copyData_INT_PACK(raster, writableRaster);
                    continue;
                }
                GraphicsUtil.copyData_FALLBACK(raster, writableRaster);
            }
        }
        return writableRaster;
    }

    @Override
    public Raster getTile(int n2, int n3) {
        if (this.raster != null) {
            int n4 = this.tileGridXOff + n2 * this.tileWidth;
            int n5 = this.tileGridYOff + n3 * this.tileHeight;
            return this.raster.createTranslatedChild(n4, n5);
        }
        return this.genTile(n2, n3);
    }

    @Override
    public Raster genTile(int n2, int n3) {
        int n4 = this.tileGridXOff + n2 * this.tileWidth;
        int n5 = this.tileGridYOff + n3 * this.tileHeight;
        if (this.raster != null) {
            return this.raster.createTranslatedChild(n4, n5);
        }
        Point point = new Point(n4, n5);
        WritableRaster writableRaster = Raster.createWritableRaster(this.sm, point);
        this.fillRasterFrom(writableRaster, this.tile);
        return writableRaster;
    }

    public WritableRaster fillRasterFrom(WritableRaster writableRaster, RenderedImage renderedImage) {
        ColorModel colorModel = this.getColorModel();
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster.createWritableTranslatedChild(0, 0), colorModel.isAlphaPremultiplied(), null);
        Graphics2D graphics2D = GraphicsUtil.createGraphics(bufferedImage, this.hints);
        int n2 = writableRaster.getMinX();
        int n3 = writableRaster.getMinY();
        int n4 = writableRaster.getWidth();
        int n5 = writableRaster.getHeight();
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.setColor(new Color(0, 0, 0, 0));
        graphics2D.fillRect(0, 0, n4, n5);
        graphics2D.setComposite(AlphaComposite.SrcOver);
        graphics2D.translate(-n2, -n3);
        int n6 = renderedImage.getMinX() + renderedImage.getWidth() - 1;
        int n7 = renderedImage.getMinY() + renderedImage.getHeight() - 1;
        int n8 = (int)Math.ceil((n2 - n6) / this.xStep) * this.xStep;
        int n9 = (int)Math.ceil((n3 - n7) / this.yStep) * this.yStep;
        graphics2D.translate(n8, n9);
        int n10 = n8 - writableRaster.getMinX() + renderedImage.getMinX();
        n2 = n10;
        for (int i2 = n9 - writableRaster.getMinY() + renderedImage.getMinY(); i2 < n5; i2 += this.yStep) {
            if (HaltingThread.hasBeenHalted()) {
                return writableRaster;
            }
            while (n10 < n4) {
                GraphicsUtil.drawImage(graphics2D, renderedImage);
                n10 += this.xStep;
                graphics2D.translate(this.xStep, 0);
            }
            graphics2D.translate(n2 - n10, this.yStep);
            n10 = n2;
        }
        return writableRaster;
    }

    protected void fillOutRaster(WritableRaster writableRaster) {
        if (this.is_INT_PACK) {
            this.fillOutRaster_INT_PACK(writableRaster);
        } else {
            this.fillOutRaster_FALLBACK(writableRaster);
        }
    }

    protected void fillOutRaster_INT_PACK(WritableRaster writableRaster) {
        int n2;
        int n3;
        int n4 = writableRaster.getMinX();
        int n5 = writableRaster.getMinY();
        int n6 = writableRaster.getWidth();
        int n7 = writableRaster.getHeight();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n8 = singlePixelPackedSampleModel.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getBankData()[0];
        int n9 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(n4 - writableRaster.getSampleModelTranslateX(), n5 - writableRaster.getSampleModelTranslateY());
        int n10 = this.xStep;
        int n11 = this.xStep;
        while (n11 < n6) {
            int n12;
            int n13;
            n3 = n10;
            if (n11 + n3 > n6) {
                n3 = n6 - n11;
            }
            if (n3 >= 128) {
                n2 = n9;
                n13 = n9 + n11;
                for (n12 = 0; n12 < this.yStep; ++n12) {
                    System.arraycopy(nArray, n2, nArray, n13, n3);
                    n2 += n8;
                    n13 += n8;
                }
            } else {
                n2 = n9;
                n13 = n9 + n11;
                for (n12 = 0; n12 < this.yStep; ++n12) {
                    int n14 = n2;
                    n2 += n3 - 1;
                    n13 += n3 - 1;
                    while (n2 >= n14) {
                        nArray[n13--] = nArray[n2--];
                    }
                    n2 += n8 + 1;
                    n13 += n8 + 1;
                }
            }
            n11 += n10;
            n10 *= 2;
        }
        n10 = this.yStep;
        n11 = this.yStep;
        while (n11 < n7) {
            n3 = n10;
            if (n11 + n3 > n7) {
                n3 = n7 - n11;
            }
            n2 = n9 + n11 * n8;
            System.arraycopy(nArray, n9, nArray, n2, n3 * n8);
            n11 += n10;
            n10 *= 2;
        }
    }

    protected void fillOutRaster_FALLBACK(WritableRaster writableRaster) {
        int n2;
        int n3 = writableRaster.getWidth();
        int n4 = writableRaster.getHeight();
        Object object = null;
        int n5 = this.xStep;
        int n6 = this.xStep;
        while (n6 < n3) {
            n2 = n5;
            if (n6 + n2 > n3) {
                n2 = n3 - n6;
            }
            object = writableRaster.getDataElements(0, 0, n2, this.yStep, object);
            writableRaster.setDataElements(n6, 0, n2, this.yStep, object);
            if ((n6 += n2) >= n3) break;
            if (n6 + n2 > n3) {
                n2 = n3 - n6;
            }
            writableRaster.setDataElements(n6, 0, n2, this.yStep, object);
            if ((n6 += n2) >= n3) break;
            if (n6 + n2 > n3) {
                n2 = n3 - n6;
            }
            writableRaster.setDataElements(n6, 0, n2, this.yStep, object);
            n6 += n5;
            n5 *= 4;
        }
        n5 = this.yStep;
        n6 = this.yStep;
        while (n6 < n4) {
            n2 = n5;
            if (n6 + n2 > n4) {
                n2 = n4 - n6;
            }
            object = writableRaster.getDataElements(0, 0, n3, n2, object);
            writableRaster.setDataElements(0, n6, n3, n2, object);
            n6 += n2;
            if (n2 >= n4) break;
            if (n6 + n2 > n4) {
                n2 = n4 - n6;
            }
            writableRaster.setDataElements(0, n6, n3, n2, object);
            n6 += n2;
            if (n2 >= n4) break;
            if (n6 + n2 > n4) {
                n2 = n4 - n6;
            }
            writableRaster.setDataElements(0, n6, n3, n2, object);
            n6 += n2;
            n6 += n5;
            n5 *= 4;
        }
    }

    protected static SampleModel fixSampleModel(RenderedImage renderedImage, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = AbstractTiledRed.getDefaultTileSize();
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n8 = sampleModel.getWidth();
        if (n8 < n7) {
            n8 = n7;
        }
        if (n8 > n2) {
            n8 = n2;
        }
        if ((n6 = sampleModel.getHeight()) < n7) {
            n6 = n7;
        }
        if (n6 > n3) {
            n6 = n3;
        }
        return sampleModel.createCompatibleSampleModel(n8, n6);
    }
}

