/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.ext.awt.image.renderable.AbstractColorInterpolationRable;
import org.apache.batik.ext.awt.image.renderable.ColorMatrixRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.rendered.ColorMatrixRed;

public class ColorMatrixRable8Bit
extends AbstractColorInterpolationRable
implements ColorMatrixRable {
    private static float[][] MATRIX_LUMINANCE_TO_ALPHA = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.2125f, 0.7154f, 0.0721f, 0.0f, 0.0f}};
    private int type;
    private float[][] matrix;

    @Override
    public void setSource(Filter filter) {
        this.init(filter, null);
    }

    @Override
    public Filter getSource() {
        return (Filter)this.getSources().get(0);
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public float[][] getMatrix() {
        return this.matrix;
    }

    private ColorMatrixRable8Bit() {
    }

    public static ColorMatrixRable buildMatrix(float[][] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException();
        }
        if (fArray.length != 4) {
            throw new IllegalArgumentException();
        }
        float[][] fArrayArray = new float[4][];
        for (int i2 = 0; i2 < 4; ++i2) {
            float[] fArray2 = fArray[i2];
            if (fArray2 == null) {
                throw new IllegalArgumentException();
            }
            if (fArray2.length != 5) {
                throw new IllegalArgumentException();
            }
            fArrayArray[i2] = new float[5];
            for (int i3 = 0; i3 < 5; ++i3) {
                fArrayArray[i2][i3] = fArray2[i3];
            }
        }
        ColorMatrixRable8Bit colorMatrixRable8Bit = new ColorMatrixRable8Bit();
        colorMatrixRable8Bit.type = 0;
        colorMatrixRable8Bit.matrix = fArrayArray;
        return colorMatrixRable8Bit;
    }

    public static ColorMatrixRable buildSaturate(float f2) {
        ColorMatrixRable8Bit colorMatrixRable8Bit = new ColorMatrixRable8Bit();
        colorMatrixRable8Bit.type = 1;
        colorMatrixRable8Bit.matrix = new float[][]{{0.213f + 0.787f * f2, 0.715f - 0.715f * f2, 0.072f - 0.072f * f2, 0.0f, 0.0f}, {0.213f - 0.213f * f2, 0.715f + 0.285f * f2, 0.072f - 0.072f * f2, 0.0f, 0.0f}, {0.213f - 0.213f * f2, 0.715f - 0.715f * f2, 0.072f + 0.928f * f2, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 1.0f, 0.0f}};
        return colorMatrixRable8Bit;
    }

    public static ColorMatrixRable buildHueRotate(float f2) {
        ColorMatrixRable8Bit colorMatrixRable8Bit = new ColorMatrixRable8Bit();
        colorMatrixRable8Bit.type = 2;
        float f3 = (float)Math.cos(f2);
        float f4 = (float)Math.sin(f2);
        float f5 = 0.213f + f3 * 0.787f - f4 * 0.213f;
        float f6 = 0.213f - f3 * 0.212f + f4 * 0.143f;
        float f7 = 0.213f - f3 * 0.213f - f4 * 0.787f;
        float f8 = 0.715f - f3 * 0.715f - f4 * 0.715f;
        float f9 = 0.715f + f3 * 0.285f + f4 * 0.14f;
        float f10 = 0.715f - f3 * 0.715f + f4 * 0.715f;
        float f11 = 0.072f - f3 * 0.072f + f4 * 0.928f;
        float f12 = 0.072f - f3 * 0.072f - f4 * 0.283f;
        float f13 = 0.072f + f3 * 0.928f + f4 * 0.072f;
        colorMatrixRable8Bit.matrix = new float[][]{{f5, f8, f11, 0.0f, 0.0f}, {f6, f9, f12, 0.0f, 0.0f}, {f7, f10, f13, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 1.0f, 0.0f}};
        return colorMatrixRable8Bit;
    }

    public static ColorMatrixRable buildLuminanceToAlpha() {
        ColorMatrixRable8Bit colorMatrixRable8Bit = new ColorMatrixRable8Bit();
        colorMatrixRable8Bit.type = 3;
        colorMatrixRable8Bit.matrix = MATRIX_LUMINANCE_TO_ALPHA;
        return colorMatrixRable8Bit;
    }

    @Override
    public RenderedImage createRendering(RenderContext renderContext) {
        RenderedImage renderedImage = this.getSource().createRendering(renderContext);
        if (renderedImage == null) {
            return null;
        }
        return new ColorMatrixRed(this.convertSourceCS(renderedImage), this.matrix);
    }
}

