/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.batik.ext.awt.image.renderable.ClipRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.BufferedImageCachableRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.MultiplyAlphaRed;
import org.apache.batik.ext.awt.image.rendered.PadRed;
import org.apache.batik.ext.awt.image.rendered.RenderedImageCachableRed;

public class ClipRable8Bit
extends AbstractRable
implements ClipRable {
    protected boolean useAA;
    protected Shape clipPath;

    public ClipRable8Bit(Filter filter, Shape shape) {
        super(filter, null);
        this.setClipPath(shape);
        this.setUseAntialiasedClip(false);
    }

    public ClipRable8Bit(Filter filter, Shape shape, boolean bl2) {
        super(filter, null);
        this.setClipPath(shape);
        this.setUseAntialiasedClip(bl2);
    }

    @Override
    public void setSource(Filter filter) {
        this.init(filter, null);
    }

    @Override
    public Filter getSource() {
        return (Filter)this.getSources().get(0);
    }

    @Override
    public void setUseAntialiasedClip(boolean bl2) {
        this.touch();
        this.useAA = bl2;
    }

    @Override
    public boolean getUseAntialiasedClip() {
        return this.useAA;
    }

    @Override
    public void setClipPath(Shape shape) {
        this.touch();
        this.clipPath = shape;
    }

    @Override
    public Shape getClipPath() {
        return this.clipPath;
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.getSource().getBounds2D();
    }

    @Override
    public RenderedImage createRendering(RenderContext renderContext) {
        Shape shape;
        AffineTransform affineTransform = renderContext.getTransform();
        RenderingHints renderingHints = renderContext.getRenderingHints();
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        if ((shape = renderContext.getAreaOfInterest()) == null) {
            shape = this.getBounds2D();
        }
        Rectangle2D rectangle2D = this.getBounds2D();
        Rectangle2D rectangle2D2 = this.clipPath.getBounds2D();
        Rectangle2D rectangle2D3 = shape.getBounds2D();
        if (!rectangle2D.intersects(rectangle2D2)) {
            return null;
        }
        Rectangle2D.intersect(rectangle2D, rectangle2D2, rectangle2D);
        if (!rectangle2D.intersects(rectangle2D3)) {
            return null;
        }
        Rectangle2D.intersect(rectangle2D, shape.getBounds2D(), rectangle2D);
        Rectangle rectangle = affineTransform.createTransformedShape(rectangle2D).getBounds();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 10);
        Shape shape2 = affineTransform.createTransformedShape(this.getClipPath());
        Rectangle rectangle2 = affineTransform.createTransformedShape(shape).getBounds();
        Graphics2D graphics2D = GraphicsUtil.createGraphics(bufferedImage, renderingHints);
        graphics2D.translate(-rectangle.x, -rectangle.y);
        graphics2D.setPaint(Color.white);
        graphics2D.fill(shape2);
        graphics2D.dispose();
        RenderedImage renderedImage = this.getSource().createRendering(new RenderContext(affineTransform, rectangle2D, renderingHints));
        CachableRed cachableRed = RenderedImageCachableRed.wrap(renderedImage);
        BufferedImageCachableRed bufferedImageCachableRed = new BufferedImageCachableRed(bufferedImage, rectangle.x, rectangle.y);
        AbstractRed abstractRed = new MultiplyAlphaRed(cachableRed, bufferedImageCachableRed);
        abstractRed = new PadRed(abstractRed, rectangle2, PadMode.ZERO_PAD, renderingHints);
        return abstractRed;
    }
}

