/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.ext.awt.image.SVGComposite;
import org.apache.batik.ext.awt.image.renderable.PaintRable;
import org.apache.batik.ext.awt.image.rendered.AffineRed;
import org.apache.batik.ext.awt.image.rendered.Any2LsRGBRed;
import org.apache.batik.ext.awt.image.rendered.Any2sRGBRed;
import org.apache.batik.ext.awt.image.rendered.BufferedImageCachableRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.FormatRed;
import org.apache.batik.ext.awt.image.rendered.RenderedImageCachableRed;
import org.apache.batik.ext.awt.image.rendered.TranslateRed;

public class GraphicsUtil {
    public static AffineTransform IDENTITY = new AffineTransform();
    public static final boolean WARN_DESTINATION;
    public static final ColorModel Linear_sRGB;
    public static final ColorModel Linear_sRGB_Pre;
    public static final ColorModel Linear_sRGB_Unpre;
    public static final ColorModel sRGB;
    public static final ColorModel sRGB_Pre;
    public static final ColorModel sRGB_Unpre;

    public static void drawImage(Graphics2D graphics2D, RenderedImage renderedImage) {
        GraphicsUtil.drawImage(graphics2D, GraphicsUtil.wrap(renderedImage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawImage(Graphics2D graphics2D, CachableRed cachableRed) {
        block41: {
            Object object;
            Object object2 = null;
            while (true) {
                if (cachableRed instanceof AffineRed) {
                    object = (AffineRed)cachableRed;
                    if (object2 == null) {
                        object2 = ((AffineRed)object).getTransform();
                    } else {
                        ((AffineTransform)object2).concatenate(((AffineRed)object).getTransform());
                    }
                    cachableRed = ((AffineRed)object).getSource();
                    continue;
                }
                if (!(cachableRed instanceof TranslateRed)) break;
                object = (TranslateRed)cachableRed;
                int n2 = ((TranslateRed)object).getDeltaX();
                int n3 = ((TranslateRed)object).getDeltaY();
                if (object2 == null) {
                    object2 = AffineTransform.getTranslateInstance(n2, n3);
                } else {
                    ((AffineTransform)object2).translate(n2, n3);
                }
                cachableRed = ((TranslateRed)object).getSource();
            }
            object = graphics2D.getTransform();
            if (object2 == null || ((AffineTransform)object2).isIdentity()) {
                object2 = object;
            } else {
                ((AffineTransform)object2).preConcatenate((AffineTransform)object);
            }
            ColorModel colorModel = cachableRed.getColorModel();
            ColorModel colorModel2 = GraphicsUtil.getDestinationColorModel(graphics2D);
            ColorSpace colorSpace = null;
            if (colorModel2 != null) {
                colorSpace = colorModel2.getColorSpace();
            }
            if (colorSpace == null) {
                colorSpace = ColorSpace.getInstance(1000);
            }
            ColorModel colorModel3 = colorModel2;
            if (colorModel2 == null || !colorModel2.hasAlpha()) {
                colorModel3 = sRGB_Unpre;
            }
            if (cachableRed instanceof BufferedImageCachableRed && colorSpace.equals(colorModel.getColorSpace()) && colorModel3.equals(colorModel)) {
                graphics2D.setTransform((AffineTransform)object2);
                BufferedImageCachableRed bufferedImageCachableRed = (BufferedImageCachableRed)cachableRed;
                graphics2D.drawImage((Image)bufferedImageCachableRed.getBufferedImage(), bufferedImageCachableRed.getMinX(), bufferedImageCachableRed.getMinY(), null);
                graphics2D.setTransform((AffineTransform)object);
                return;
            }
            double d2 = ((AffineTransform)object2).getDeterminant();
            if (!((AffineTransform)object2).isIdentity() && d2 <= 1.0) {
                if (((AffineTransform)object2).getType() != 1) {
                    cachableRed = new AffineRed(cachableRed, (AffineTransform)object2, graphics2D.getRenderingHints());
                } else {
                    int n4 = cachableRed.getMinX() + (int)((AffineTransform)object2).getTranslateX();
                    int n5 = cachableRed.getMinY() + (int)((AffineTransform)object2).getTranslateY();
                    cachableRed = new TranslateRed(cachableRed, n4, n5);
                }
            }
            if (colorSpace != colorModel.getColorSpace()) {
                if (colorSpace == ColorSpace.getInstance(1000)) {
                    cachableRed = GraphicsUtil.convertTosRGB(cachableRed);
                } else if (colorSpace == ColorSpace.getInstance(1004)) {
                    cachableRed = GraphicsUtil.convertToLsRGB(cachableRed);
                }
            }
            if (!colorModel3.equals(colorModel = cachableRed.getColorModel())) {
                cachableRed = FormatRed.construct(cachableRed, colorModel3);
            }
            if (!((AffineTransform)object2).isIdentity() && d2 > 1.0) {
                cachableRed = new AffineRed(cachableRed, (AffineTransform)object2, graphics2D.getRenderingHints());
            }
            graphics2D.setTransform(IDENTITY);
            Composite composite = graphics2D.getComposite();
            if (graphics2D.getRenderingHint(RenderingHintsKeyExt.KEY_TRANSCODING) == "Printing" && SVGComposite.OVER.equals(composite)) {
                graphics2D.setComposite(SVGComposite.OVER);
            }
            Rectangle rectangle = cachableRed.getBounds();
            Shape shape = graphics2D.getClip();
            try {
                Object object3;
                Rectangle rectangle2;
                if (shape == null) {
                    shape = rectangle;
                    rectangle2 = rectangle;
                } else {
                    rectangle2 = shape.getBounds();
                    if (!rectangle2.intersects(rectangle)) {
                        return;
                    }
                    rectangle2 = rectangle2.intersection(rectangle);
                }
                Rectangle rectangle3 = GraphicsUtil.getDestinationBounds(graphics2D);
                if (rectangle3 != null) {
                    if (!rectangle2.intersects(rectangle3)) {
                        return;
                    }
                    rectangle2 = rectangle2.intersection(rectangle3);
                }
                boolean bl2 = false;
                colorModel = cachableRed.getColorModel();
                SampleModel sampleModel = cachableRed.getSampleModel();
                if (sampleModel.getWidth() * sampleModel.getHeight() >= rectangle2.width * rectangle2.height) {
                    bl2 = true;
                }
                if ((object3 = graphics2D.getRenderingHint(RenderingHintsKeyExt.KEY_AVOID_TILE_PAINTING)) == RenderingHintsKeyExt.VALUE_AVOID_TILE_PAINTING_ON) {
                    bl2 = true;
                }
                if (object3 == RenderingHintsKeyExt.VALUE_AVOID_TILE_PAINTING_OFF) {
                    bl2 = false;
                }
                if (bl2) {
                    Raster raster = cachableRed.getData(rectangle2);
                    WritableRaster writableRaster = ((WritableRaster)raster).createWritableChild(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, 0, 0, null);
                    BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
                    graphics2D.drawImage((Image)bufferedImage, rectangle2.x, rectangle2.y, null);
                    break block41;
                }
                WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, new Point(0, 0));
                BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
                int n6 = cachableRed.getMinTileX();
                int n7 = n6 + cachableRed.getNumXTiles();
                int n8 = cachableRed.getMinTileY();
                int n9 = n8 + cachableRed.getNumYTiles();
                int n10 = sampleModel.getWidth();
                int n11 = sampleModel.getHeight();
                Rectangle rectangle4 = new Rectangle(0, 0, n10, n11);
                Rectangle rectangle5 = new Rectangle(0, 0, 0, 0);
                int n12 = n8 * n11 + cachableRed.getTileGridYOffset();
                int n13 = (rectangle2.y - n12) / n11;
                if (n13 < 0) {
                    n13 = 0;
                }
                n8 += n13;
                int n14 = n6 * n10 + cachableRed.getTileGridXOffset();
                n13 = (rectangle2.x - n14) / n10;
                if (n13 < 0) {
                    n13 = 0;
                }
                int n15 = rectangle2.x + rectangle2.width - 1;
                int n16 = rectangle2.y + rectangle2.height - 1;
                n12 = n8 * n11 + cachableRed.getTileGridYOffset();
                int n17 = (n6 += n13) * n10 + cachableRed.getTileGridXOffset();
                int n18 = n10;
                n14 = n17;
                int n19 = n8;
                while (n19 < n9) {
                    if (n12 > n16) {
                        break;
                    }
                    for (int i2 = n6; i2 < n7 && n14 >= n17 && n14 <= n15; ++i2, n14 += n18) {
                        rectangle4.x = n14;
                        rectangle4.y = n12;
                        Rectangle2D.intersect(rectangle, rectangle4, rectangle5);
                        WritableRaster writableRaster2 = writableRaster.createWritableChild(0, 0, rectangle5.width, rectangle5.height, rectangle5.x, rectangle5.y, null);
                        cachableRed.copyData(writableRaster2);
                        BufferedImage bufferedImage2 = bufferedImage.getSubimage(0, 0, rectangle5.width, rectangle5.height);
                        graphics2D.drawImage((Image)bufferedImage2, rectangle5.x, rectangle5.y, null);
                    }
                    n18 = -n18;
                    n14 += n18;
                    ++n19;
                    n12 += n11;
                }
            }
            finally {
                graphics2D.setTransform((AffineTransform)object);
                graphics2D.setComposite(composite);
            }
        }
    }

    public static void drawImage(Graphics2D graphics2D, RenderableImage renderableImage, RenderContext renderContext) {
        AffineTransform affineTransform = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        Shape shape2 = renderContext.getAreaOfInterest();
        if (shape2 != null) {
            graphics2D.clip(shape2);
        }
        graphics2D.transform(renderContext.getTransform());
        graphics2D.setRenderingHints(renderContext.getRenderingHints());
        GraphicsUtil.drawImage(graphics2D, renderableImage);
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape);
        graphics2D.setRenderingHints(renderingHints);
    }

    public static void drawImage(Graphics2D graphics2D, RenderableImage renderableImage) {
        Object object;
        if (renderableImage instanceof PaintRable && (object = (PaintRable)((Object)renderableImage)).paintRable(graphics2D)) {
            return;
        }
        object = graphics2D.getTransform();
        RenderedImage renderedImage = renderableImage.createRendering(new RenderContext((AffineTransform)object, graphics2D.getClip(), graphics2D.getRenderingHints()));
        if (renderedImage == null) {
            return;
        }
        graphics2D.setTransform(IDENTITY);
        GraphicsUtil.drawImage(graphics2D, GraphicsUtil.wrap(renderedImage));
        graphics2D.setTransform((AffineTransform)object);
    }

    public static Graphics2D createGraphics(BufferedImage bufferedImage, RenderingHints renderingHints) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (renderingHints != null) {
            graphics2D.addRenderingHints(renderingHints);
        }
        graphics2D.setRenderingHint(RenderingHintsKeyExt.KEY_BUFFERED_IMAGE, new WeakReference<BufferedImage>(bufferedImage));
        graphics2D.clip(new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
        return graphics2D;
    }

    public static Graphics2D createGraphics(BufferedImage bufferedImage) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHintsKeyExt.KEY_BUFFERED_IMAGE, new WeakReference<BufferedImage>(bufferedImage));
        graphics2D.clip(new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
        return graphics2D;
    }

    public static BufferedImage getDestination(Graphics2D graphics2D) {
        Object object = graphics2D.getRenderingHint(RenderingHintsKeyExt.KEY_BUFFERED_IMAGE);
        if (object != null) {
            return (BufferedImage)((Reference)object).get();
        }
        GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
        if (graphicsConfiguration == null) {
            return null;
        }
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        if (WARN_DESTINATION && graphicsDevice.getType() == 2 && graphics2D.getRenderingHint(RenderingHintsKeyExt.KEY_TRANSCODING) != "Printing") {
            System.err.println("Graphics2D from BufferedImage lacks BUFFERED_IMAGE hint");
        }
        return null;
    }

    public static ColorModel getDestinationColorModel(Graphics2D graphics2D) {
        BufferedImage bufferedImage = GraphicsUtil.getDestination(graphics2D);
        if (bufferedImage != null) {
            return bufferedImage.getColorModel();
        }
        GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
        if (graphicsConfiguration == null) {
            return null;
        }
        if (graphicsConfiguration.getDevice().getType() == 2) {
            if (graphics2D.getRenderingHint(RenderingHintsKeyExt.KEY_TRANSCODING) == "Printing") {
                return sRGB_Unpre;
            }
            return null;
        }
        return graphicsConfiguration.getColorModel();
    }

    public static ColorSpace getDestinationColorSpace(Graphics2D graphics2D) {
        ColorModel colorModel = GraphicsUtil.getDestinationColorModel(graphics2D);
        if (colorModel != null) {
            return colorModel.getColorSpace();
        }
        return null;
    }

    public static Rectangle getDestinationBounds(Graphics2D graphics2D) {
        BufferedImage bufferedImage = GraphicsUtil.getDestination(graphics2D);
        if (bufferedImage != null) {
            return new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        }
        GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
        if (graphicsConfiguration == null) {
            return null;
        }
        if (graphicsConfiguration.getDevice().getType() == 2) {
            return null;
        }
        return null;
    }

    public static ColorModel makeLinear_sRGBCM(boolean bl2) {
        return bl2 ? Linear_sRGB_Pre : Linear_sRGB_Unpre;
    }

    public static BufferedImage makeLinearBufferedImage(int n2, int n3, boolean bl2) {
        ColorModel colorModel = GraphicsUtil.makeLinear_sRGBCM(bl2);
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n2, n3);
        return new BufferedImage(colorModel, writableRaster, bl2, null);
    }

    public static CachableRed convertToLsRGB(CachableRed cachableRed) {
        ColorModel colorModel = cachableRed.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        if (colorSpace == ColorSpace.getInstance(1004)) {
            return cachableRed;
        }
        return new Any2LsRGBRed(cachableRed);
    }

    public static CachableRed convertTosRGB(CachableRed cachableRed) {
        ColorModel colorModel = cachableRed.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        if (colorSpace == ColorSpace.getInstance(1000)) {
            return cachableRed;
        }
        return new Any2sRGBRed(cachableRed);
    }

    public static CachableRed wrap(RenderedImage renderedImage) {
        if (renderedImage instanceof CachableRed) {
            return (CachableRed)renderedImage;
        }
        if (renderedImage instanceof BufferedImage) {
            return new BufferedImageCachableRed((BufferedImage)renderedImage);
        }
        return new RenderedImageCachableRed(renderedImage);
    }

    public static void copyData_INT_PACK(Raster raster, WritableRaster writableRaster) {
        int n2;
        int n3;
        int n4;
        int n5 = writableRaster.getMinX();
        if (n5 < raster.getMinX()) {
            n5 = raster.getMinX();
        }
        if ((n4 = writableRaster.getMinY()) < raster.getMinY()) {
            n4 = raster.getMinY();
        }
        if ((n3 = writableRaster.getMinX() + writableRaster.getWidth() - 1) > raster.getMinX() + raster.getWidth() - 1) {
            n3 = raster.getMinX() + raster.getWidth() - 1;
        }
        if ((n2 = writableRaster.getMinY() + writableRaster.getHeight() - 1) > raster.getMinY() + raster.getHeight() - 1) {
            n2 = raster.getMinY() + raster.getHeight() - 1;
        }
        int n6 = n3 - n5 + 1;
        int n7 = n2 - n4 + 1;
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)raster.getSampleModel();
        int n8 = singlePixelPackedSampleModel.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int[] nArray = dataBufferInt.getBankData()[0];
        int n9 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(n5 - raster.getSampleModelTranslateX(), n4 - raster.getSampleModelTranslateY());
        SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n10 = singlePixelPackedSampleModel2.getScanlineStride();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray2 = dataBufferInt2.getBankData()[0];
        int n11 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel2.getOffset(n5 - writableRaster.getSampleModelTranslateX(), n4 - writableRaster.getSampleModelTranslateY());
        if (n8 == n10 && n8 == n6) {
            System.arraycopy(nArray, n9, nArray2, n11, n6 * n7);
        } else if (n6 > 128) {
            int n12 = n9;
            int n13 = n11;
            for (int i2 = 0; i2 < n7; ++i2) {
                System.arraycopy(nArray, n12, nArray2, n13, n6);
                n12 += n8;
                n13 += n10;
            }
        } else {
            for (int i3 = 0; i3 < n7; ++i3) {
                int n14 = n9 + i3 * n8;
                int n15 = n11 + i3 * n10;
                for (int i4 = 0; i4 < n6; ++i4) {
                    nArray2[n15++] = nArray[n14++];
                }
            }
        }
    }

    public static void copyData_FALLBACK(Raster raster, WritableRaster writableRaster) {
        int n2;
        int n3;
        int n4;
        int n5 = writableRaster.getMinX();
        if (n5 < raster.getMinX()) {
            n5 = raster.getMinX();
        }
        if ((n4 = writableRaster.getMinY()) < raster.getMinY()) {
            n4 = raster.getMinY();
        }
        if ((n3 = writableRaster.getMinX() + writableRaster.getWidth() - 1) > raster.getMinX() + raster.getWidth() - 1) {
            n3 = raster.getMinX() + raster.getWidth() - 1;
        }
        if ((n2 = writableRaster.getMinY() + writableRaster.getHeight() - 1) > raster.getMinY() + raster.getHeight() - 1) {
            n2 = raster.getMinY() + raster.getHeight() - 1;
        }
        int n6 = n3 - n5 + 1;
        int[] nArray = null;
        for (int i2 = n4; i2 <= n2; ++i2) {
            nArray = raster.getPixels(n5, i2, n6, 1, nArray);
            writableRaster.setPixels(n5, i2, n6, 1, nArray);
        }
    }

    public static void copyData(Raster raster, WritableRaster writableRaster) {
        if (GraphicsUtil.is_INT_PACK_Data(raster.getSampleModel(), false) && GraphicsUtil.is_INT_PACK_Data(writableRaster.getSampleModel(), false)) {
            GraphicsUtil.copyData_INT_PACK(raster, writableRaster);
            return;
        }
        GraphicsUtil.copyData_FALLBACK(raster, writableRaster);
    }

    public static WritableRaster copyRaster(Raster raster) {
        return GraphicsUtil.copyRaster(raster, raster.getMinX(), raster.getMinY());
    }

    public static WritableRaster copyRaster(Raster raster, int n2, int n3) {
        WritableRaster writableRaster = Raster.createWritableRaster(raster.getSampleModel(), new Point(0, 0));
        writableRaster = writableRaster.createWritableChild(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY(), raster.getWidth(), raster.getHeight(), n2, n3, null);
        DataBuffer dataBuffer = raster.getDataBuffer();
        DataBuffer dataBuffer2 = writableRaster.getDataBuffer();
        if (dataBuffer.getDataType() != dataBuffer2.getDataType()) {
            throw new IllegalArgumentException("New DataBuffer doesn't match original");
        }
        int n4 = dataBuffer.getSize();
        int n5 = dataBuffer.getNumBanks();
        int[] nArray = dataBuffer.getOffsets();
        block6: for (int i2 = 0; i2 < n5; ++i2) {
            switch (dataBuffer.getDataType()) {
                case 0: {
                    DataBuffer dataBuffer3 = (DataBufferByte)dataBuffer;
                    DataBuffer dataBuffer4 = (DataBufferByte)dataBuffer2;
                    System.arraycopy(((DataBufferByte)dataBuffer3).getData(i2), nArray[i2], ((DataBufferByte)dataBuffer4).getData(i2), nArray[i2], n4);
                    continue block6;
                }
                case 3: {
                    DataBuffer dataBuffer3 = (DataBufferInt)dataBuffer;
                    DataBuffer dataBuffer4 = (DataBufferInt)dataBuffer2;
                    System.arraycopy(((DataBufferInt)dataBuffer3).getData(i2), nArray[i2], ((DataBufferInt)dataBuffer4).getData(i2), nArray[i2], n4);
                    continue block6;
                }
                case 2: {
                    DataBuffer dataBuffer3 = (DataBufferShort)dataBuffer;
                    DataBuffer dataBuffer4 = (DataBufferShort)dataBuffer2;
                    System.arraycopy(((DataBufferShort)dataBuffer3).getData(i2), nArray[i2], ((DataBufferShort)dataBuffer4).getData(i2), nArray[i2], n4);
                    continue block6;
                }
                case 1: {
                    DataBuffer dataBuffer3 = (DataBufferUShort)dataBuffer;
                    DataBuffer dataBuffer4 = (DataBufferUShort)dataBuffer2;
                    System.arraycopy(((DataBufferUShort)dataBuffer3).getData(i2), nArray[i2], ((DataBufferUShort)dataBuffer4).getData(i2), nArray[i2], n4);
                    continue block6;
                }
            }
        }
        return writableRaster;
    }

    public static WritableRaster makeRasterWritable(Raster raster) {
        return GraphicsUtil.makeRasterWritable(raster, raster.getMinX(), raster.getMinY());
    }

    public static WritableRaster makeRasterWritable(Raster raster, int n2, int n3) {
        WritableRaster writableRaster = Raster.createWritableRaster(raster.getSampleModel(), raster.getDataBuffer(), new Point(0, 0));
        writableRaster = writableRaster.createWritableChild(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY(), raster.getWidth(), raster.getHeight(), n2, n3, null);
        return writableRaster;
    }

    public static ColorModel coerceColorModel(ColorModel colorModel, boolean bl2) {
        if (colorModel.isAlphaPremultiplied() == bl2) {
            return colorModel;
        }
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(1, 1);
        return colorModel.coerceData(writableRaster, bl2);
    }

    public static ColorModel coerceData(WritableRaster writableRaster, ColorModel colorModel, boolean bl2) {
        if (!colorModel.hasAlpha()) {
            return colorModel;
        }
        if (colorModel.isAlphaPremultiplied() == bl2) {
            return colorModel;
        }
        if (bl2) {
            GraphicsUtil.multiplyAlpha(writableRaster);
        } else {
            GraphicsUtil.divideAlpha(writableRaster);
        }
        return GraphicsUtil.coerceColorModel(colorModel, bl2);
    }

    public static void multiplyAlpha(WritableRaster writableRaster) {
        if (GraphicsUtil.is_BYTE_COMP_Data(writableRaster.getSampleModel())) {
            GraphicsUtil.mult_BYTE_COMP_Data(writableRaster);
        } else if (GraphicsUtil.is_INT_PACK_Data(writableRaster.getSampleModel(), true)) {
            GraphicsUtil.mult_INT_PACK_Data(writableRaster);
        } else {
            int[] nArray = null;
            int n2 = writableRaster.getNumBands();
            float f2 = 0.003921569f;
            int n3 = writableRaster.getMinX();
            int n4 = n3 + writableRaster.getWidth();
            int n5 = writableRaster.getMinY();
            int n6 = n5 + writableRaster.getHeight();
            for (int i2 = n5; i2 < n6; ++i2) {
                for (int i3 = n3; i3 < n4; ++i3) {
                    int n7 = (nArray = writableRaster.getPixel(i3, i2, nArray))[n2 - 1];
                    if (n7 < 0 || n7 >= 255) continue;
                    float f3 = (float)n7 * f2;
                    for (int i4 = 0; i4 < n2 - 1; ++i4) {
                        nArray[i4] = (int)((float)nArray[i4] * f3 + 0.5f);
                    }
                    writableRaster.setPixel(i3, i2, nArray);
                }
            }
        }
    }

    public static void divideAlpha(WritableRaster writableRaster) {
        if (GraphicsUtil.is_BYTE_COMP_Data(writableRaster.getSampleModel())) {
            GraphicsUtil.divide_BYTE_COMP_Data(writableRaster);
        } else if (GraphicsUtil.is_INT_PACK_Data(writableRaster.getSampleModel(), true)) {
            GraphicsUtil.divide_INT_PACK_Data(writableRaster);
        } else {
            int n2 = writableRaster.getNumBands();
            int[] nArray = null;
            int n3 = writableRaster.getMinX();
            int n4 = n3 + writableRaster.getWidth();
            int n5 = writableRaster.getMinY();
            int n6 = n5 + writableRaster.getHeight();
            for (int i2 = n5; i2 < n6; ++i2) {
                for (int i3 = n3; i3 < n4; ++i3) {
                    int n7 = (nArray = writableRaster.getPixel(i3, i2, nArray))[n2 - 1];
                    if (n7 <= 0 || n7 >= 255) continue;
                    float f2 = 255.0f / (float)n7;
                    for (int i4 = 0; i4 < n2 - 1; ++i4) {
                        nArray[i4] = (int)((float)nArray[i4] * f2 + 0.5f);
                    }
                    writableRaster.setPixel(i3, i2, nArray);
                }
            }
        }
    }

    public static void copyData(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Rectangle rectangle = new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        GraphicsUtil.copyData(bufferedImage, rectangle, bufferedImage2, new Point(0, 0));
    }

    public static void copyData(BufferedImage bufferedImage, Rectangle rectangle, BufferedImage bufferedImage2, Point point) {
        boolean bl2;
        boolean bl3 = bufferedImage.getColorModel().hasAlpha();
        if (!(bl3 != (bl2 = bufferedImage2.getColorModel().hasAlpha()) || bl3 && bufferedImage.isAlphaPremultiplied() != bufferedImage2.isAlphaPremultiplied())) {
            GraphicsUtil.copyData(bufferedImage.getRaster(), bufferedImage2.getRaster());
            return;
        }
        int[] nArray = null;
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        int n2 = writableRaster2.getNumBands();
        int n3 = point.x - rectangle.x;
        int n4 = point.y - rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.x;
        int n7 = rectangle.y;
        int n8 = n7 + rectangle.height - 1;
        if (!bl3) {
            int n9;
            int[] nArray2 = new int[n2 * n5];
            for (n9 = n5 * n2 - 1; n9 >= 0; n9 -= n2) {
                nArray2[n9] = 255;
            }
            for (int i2 = n7; i2 <= n8; ++i2) {
                nArray = writableRaster.getPixels(n6, i2, n5, 1, nArray);
                int n10 = n5 * (n2 - 1) - 1;
                n9 = n5 * n2 - 2;
                switch (n2) {
                    case 4: {
                        while (n10 >= 0) {
                            nArray2[n9--] = nArray[n10--];
                            nArray2[n9--] = nArray[n10--];
                            nArray2[n9--] = nArray[n10--];
                            --n9;
                        }
                        break;
                    }
                    default: {
                        while (n10 >= 0) {
                            for (int i3 = 0; i3 < n2 - 1; ++i3) {
                                nArray2[n9--] = nArray[n10--];
                            }
                            --n9;
                        }
                        break block0;
                    }
                }
                writableRaster2.setPixels(n6 + n3, i2 + n4, n5, 1, nArray2);
            }
        } else if (bl2 && bufferedImage2.isAlphaPremultiplied()) {
            int n11 = 65793;
            int n12 = 0x800000;
            for (int i4 = n7; i4 <= n8; ++i4) {
                nArray = writableRaster.getPixels(n6, i4, n5, 1, nArray);
                int n13 = n2 * n5 - 1;
                switch (n2) {
                    case 4: {
                        int n14;
                        int n15;
                        while (n13 >= 0) {
                            n15 = nArray[n13];
                            if (n15 == 255) {
                                n13 -= 4;
                                continue;
                            }
                            n14 = n11 * n15;
                            nArray[--n13] = nArray[n13] * n14 + n12 >>> 24;
                            nArray[--n13] = nArray[n13] * n14 + n12 >>> 24;
                            nArray[--n13] = nArray[n13] * n14 + n12 >>> 24;
                            --n13;
                        }
                        break;
                    }
                    default: {
                        int n14;
                        int n15;
                        while (n13 >= 0) {
                            n15 = nArray[n13];
                            if (n15 == 255) {
                                n13 -= n2;
                                continue;
                            }
                            --n13;
                            n14 = n11 * n15;
                            for (int i5 = 0; i5 < n2 - 1; ++i5) {
                                nArray[n13] = nArray[n13] * n14 + n12 >>> 24;
                                --n13;
                            }
                        }
                        break block3;
                    }
                }
                writableRaster2.setPixels(n6 + n3, i4 + n4, n5, 1, nArray);
            }
        } else if (bl2 && !bufferedImage2.isAlphaPremultiplied()) {
            int n16 = 0xFF0000;
            int n17 = 32768;
            for (int i6 = n7; i6 <= n8; ++i6) {
                nArray = writableRaster.getPixels(n6, i6, n5, 1, nArray);
                int n18 = n2 * n5 - 1;
                switch (n2) {
                    case 4: {
                        int n19;
                        int n20;
                        while (n18 >= 0) {
                            n20 = nArray[n18];
                            if (n20 <= 0 || n20 >= 255) {
                                n18 -= 4;
                                continue;
                            }
                            n19 = n16 / n20;
                            nArray[--n18] = nArray[n18] * n19 + n17 >>> 16;
                            nArray[--n18] = nArray[n18] * n19 + n17 >>> 16;
                            nArray[--n18] = nArray[n18] * n19 + n17 >>> 16;
                            --n18;
                        }
                        break;
                    }
                    default: {
                        int n19;
                        int n20;
                        while (n18 >= 0) {
                            n20 = nArray[n18];
                            if (n20 <= 0 || n20 >= 255) {
                                n18 -= n2;
                                continue;
                            }
                            --n18;
                            n19 = n16 / n20;
                            for (int i7 = 0; i7 < n2 - 1; ++i7) {
                                nArray[n18] = nArray[n18] * n19 + n17 >>> 16;
                                --n18;
                            }
                        }
                        break block6;
                    }
                }
                writableRaster2.setPixels(n6 + n3, i6 + n4, n5, 1, nArray);
            }
        } else if (bufferedImage.isAlphaPremultiplied()) {
            int[] nArray3 = new int[n2 * n5];
            int n21 = 0xFF0000;
            int n22 = 32768;
            for (int i8 = n7; i8 <= n8; ++i8) {
                nArray = writableRaster.getPixels(n6, i8, n5, 1, nArray);
                int n23 = (n2 + 1) * n5 - 1;
                int n24 = n2 * n5 - 1;
                while (n23 >= 0) {
                    int n25;
                    int n26 = nArray[n23];
                    --n23;
                    if (n26 > 0) {
                        if (n26 < 255) {
                            int n27 = n21 / n26;
                            for (n25 = 0; n25 < n2; ++n25) {
                                nArray3[n24--] = nArray[n23--] * n27 + n22 >>> 16;
                            }
                            continue;
                        }
                        for (n25 = 0; n25 < n2; ++n25) {
                            nArray3[n24--] = nArray[n23--];
                        }
                        continue;
                    }
                    n23 -= n2;
                    for (n25 = 0; n25 < n2; ++n25) {
                        nArray3[n24--] = 255;
                    }
                }
                writableRaster2.setPixels(n6 + n3, i8 + n4, n5, 1, nArray3);
            }
        } else {
            Rectangle rectangle2 = new Rectangle(point.x, point.y, rectangle.width, rectangle.height);
            for (int i9 = 0; i9 < n2; ++i9) {
                GraphicsUtil.copyBand(writableRaster, rectangle, i9, writableRaster2, rectangle2, i9);
            }
        }
    }

    public static void copyBand(Raster raster, int n2, WritableRaster writableRaster, int n3) {
        Rectangle rectangle = raster.getBounds();
        Rectangle rectangle2 = writableRaster.getBounds();
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        GraphicsUtil.copyBand(raster, rectangle3, n2, writableRaster, rectangle3, n3);
    }

    public static void copyBand(Raster raster, Rectangle rectangle, int n2, WritableRaster writableRaster, Rectangle rectangle2, int n3) {
        int n4 = rectangle2.y - rectangle.y;
        int n5 = rectangle2.x - rectangle.x;
        rectangle = rectangle.intersection(raster.getBounds());
        rectangle2 = rectangle2.intersection(writableRaster.getBounds());
        int n6 = rectangle2.width < rectangle.width ? rectangle2.width : rectangle.width;
        int n7 = rectangle2.height < rectangle.height ? rectangle2.height : rectangle.height;
        int n8 = rectangle.x + n5;
        int[] nArray = null;
        for (int i2 = rectangle.y; i2 < rectangle.y + n7; ++i2) {
            nArray = raster.getSamples(rectangle.x, i2, n6, 1, n2, nArray);
            writableRaster.setSamples(n8, i2 + n4, n6, 1, n3, nArray);
        }
    }

    public static boolean is_INT_PACK_Data(SampleModel sampleModel, boolean bl2) {
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        if (sampleModel.getDataType() != 3) {
            return false;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
        int[] nArray = singlePixelPackedSampleModel.getBitMasks();
        if (nArray.length == 3 ? bl2 : nArray.length != 4) {
            return false;
        }
        if (nArray[0] != 0xFF0000) {
            return false;
        }
        if (nArray[1] != 65280) {
            return false;
        }
        if (nArray[2] != 255) {
            return false;
        }
        return nArray.length != 4 || nArray[3] == -16777216;
    }

    public static boolean is_BYTE_COMP_Data(SampleModel sampleModel) {
        if (!(sampleModel instanceof ComponentSampleModel)) {
            return false;
        }
        return sampleModel.getDataType() == 0;
    }

    protected static void divide_INT_PACK_Data(WritableRaster writableRaster) {
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n2 = writableRaster.getWidth();
        int n3 = singlePixelPackedSampleModel.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int n4 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int[] nArray = dataBufferInt.getBankData()[0];
        for (int i2 = 0; i2 < writableRaster.getHeight(); ++i2) {
            int n5;
            int n6 = n5 + n2;
            for (n5 = n4 + i2 * n3; n5 < n6; ++n5) {
                int n7 = nArray[n5];
                int n8 = n7 >>> 24;
                if (n8 <= 0) {
                    nArray[n5] = 0xFFFFFF;
                    continue;
                }
                if (n8 >= 255) continue;
                int n9 = 0xFF0000 / n8;
                nArray[n5] = n8 << 24 | ((n7 & 0xFF0000) >> 16) * n9 & 0xFF0000 | (((n7 & 0xFF00) >> 8) * n9 & 0xFF0000) >> 8 | ((n7 & 0xFF) * n9 & 0xFF0000) >> 16;
            }
        }
    }

    protected static void mult_INT_PACK_Data(WritableRaster writableRaster) {
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n2 = writableRaster.getWidth();
        int n3 = singlePixelPackedSampleModel.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int n4 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int[] nArray = dataBufferInt.getBankData()[0];
        for (int i2 = 0; i2 < writableRaster.getHeight(); ++i2) {
            int n5;
            int n6 = n5 + n2;
            for (n5 = n4 + i2 * n3; n5 < n6; ++n5) {
                int n7 = nArray[n5];
                int n8 = n7 >>> 24;
                if (n8 < 0 || n8 >= 255) continue;
                nArray[n5] = n8 << 24 | (n7 & 0xFF0000) * n8 >> 8 & 0xFF0000 | (n7 & 0xFF00) * n8 >> 8 & 0xFF00 | (n7 & 0xFF) * n8 >> 8 & 0xFF;
            }
        }
    }

    protected static void divide_BYTE_COMP_Data(WritableRaster writableRaster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)writableRaster.getSampleModel();
        int n2 = writableRaster.getWidth();
        int n3 = componentSampleModel.getScanlineStride();
        int n4 = componentSampleModel.getPixelStride();
        int[] nArray = componentSampleModel.getBandOffsets();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        int n5 = dataBufferByte.getOffset() + componentSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int n6 = nArray[nArray.length - 1];
        int n7 = nArray.length - 1;
        byte[] byArray = dataBufferByte.getBankData()[0];
        for (int i2 = 0; i2 < writableRaster.getHeight(); ++i2) {
            int n8;
            int n9 = n8 + n2 * n4;
            for (n8 = n5 + i2 * n3; n8 < n9; n8 += n4) {
                int n10;
                int n11 = byArray[n8 + n6] & 0xFF;
                if (n11 == 0) {
                    for (n10 = 0; n10 < n7; ++n10) {
                        byArray[n8 + nArray[n10]] = -1;
                    }
                    continue;
                }
                if (n11 >= 255) continue;
                n10 = 0xFF0000 / n11;
                for (int i3 = 0; i3 < n7; ++i3) {
                    int n12 = n8 + nArray[i3];
                    byArray[n12] = (byte)((byArray[n12] & 0xFF) * n10 >>> 16);
                }
            }
        }
    }

    protected static void mult_BYTE_COMP_Data(WritableRaster writableRaster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)writableRaster.getSampleModel();
        int n2 = writableRaster.getWidth();
        int n3 = componentSampleModel.getScanlineStride();
        int n4 = componentSampleModel.getPixelStride();
        int[] nArray = componentSampleModel.getBandOffsets();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        int n5 = dataBufferByte.getOffset() + componentSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int n6 = nArray[nArray.length - 1];
        int n7 = nArray.length - 1;
        byte[] byArray = dataBufferByte.getBankData()[0];
        for (int i2 = 0; i2 < writableRaster.getHeight(); ++i2) {
            int n8;
            int n9 = n8 + n2 * n4;
            for (n8 = n5 + i2 * n3; n8 < n9; n8 += n4) {
                int n10 = byArray[n8 + n6] & 0xFF;
                if (n10 == 255) continue;
                for (int i3 = 0; i3 < n7; ++i3) {
                    int n11 = n8 + nArray[i3];
                    byArray[n11] = (byte)((byArray[n11] & 0xFF) * n10 >> 8);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        boolean bl2 = true;
        try {
            String string2 = System.getProperty("org.apache.batik.warn_destination", "true");
            bl2 = Boolean.valueOf(string2);
        }
        catch (SecurityException securityException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        finally {
            WARN_DESTINATION = bl2;
        }
        Linear_sRGB = new DirectColorModel(ColorSpace.getInstance(1004), 24, 0xFF0000, 65280, 255, 0, false, 3);
        Linear_sRGB_Pre = new DirectColorModel(ColorSpace.getInstance(1004), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
        Linear_sRGB_Unpre = new DirectColorModel(ColorSpace.getInstance(1004), 32, 0xFF0000, 65280, 255, -16777216, false, 3);
        sRGB = new DirectColorModel(ColorSpace.getInstance(1000), 24, 0xFF0000, 65280, 255, 0, false, 3);
        sRGB_Pre = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
        sRGB_Unpre = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, false, 3);
    }
}

