/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.geom;

import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class RectListManager
implements Collection {
    Rectangle[] rects = null;
    int size = 0;
    Rectangle bounds = null;
    public static Comparator comparator = new RectXComparator();

    public void dump() {
        System.err.println("RLM: " + this + " Sz: " + this.size);
        System.err.println("Bounds: " + this.getBounds());
        for (int i2 = 0; i2 < this.size; ++i2) {
            Rectangle rectangle = this.rects[i2];
            System.err.println("  [" + rectangle.x + ", " + rectangle.y + ", " + rectangle.width + ", " + rectangle.height + ']');
        }
    }

    public RectListManager(Collection collection) {
        this.rects = new Rectangle[collection.size()];
        Iterator iterator = collection.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            this.rects[n2++] = (Rectangle)iterator.next();
        }
        this.size = this.rects.length;
        Arrays.sort(this.rects, comparator);
    }

    public RectListManager(Rectangle[] rectangleArray) {
        this(rectangleArray, 0, rectangleArray.length);
    }

    public RectListManager(Rectangle[] rectangleArray, int n2, int n3) {
        this.size = n3;
        this.rects = new Rectangle[n3];
        System.arraycopy(rectangleArray, n2, this.rects, 0, n3);
        Arrays.sort(this.rects, comparator);
    }

    public RectListManager(RectListManager rectListManager) {
        this(rectListManager.rects);
    }

    public RectListManager(Rectangle rectangle) {
        this();
        this.add(rectangle);
    }

    public RectListManager() {
        this.rects = new Rectangle[10];
        this.size = 0;
    }

    public RectListManager(int n2) {
        this.rects = new Rectangle[n2];
    }

    public Rectangle getBounds() {
        if (this.bounds != null) {
            return this.bounds;
        }
        if (this.size == 0) {
            return null;
        }
        this.bounds = new Rectangle(this.rects[0]);
        for (int i2 = 1; i2 < this.size; ++i2) {
            Rectangle rectangle = this.rects[i2];
            if (rectangle.x < this.bounds.x) {
                this.bounds.width = this.bounds.x + this.bounds.width - rectangle.x;
                this.bounds.x = rectangle.x;
            }
            if (rectangle.y < this.bounds.y) {
                this.bounds.height = this.bounds.y + this.bounds.height - rectangle.y;
                this.bounds.y = rectangle.y;
            }
            if (rectangle.x + rectangle.width > this.bounds.x + this.bounds.width) {
                this.bounds.width = rectangle.x + rectangle.width - this.bounds.x;
            }
            if (rectangle.y + rectangle.height <= this.bounds.y + this.bounds.height) continue;
            this.bounds.height = rectangle.y + rectangle.height - this.bounds.y;
        }
        return this.bounds;
    }

    public Object clone() throws CloneNotSupportedException {
        return this.copy();
    }

    public RectListManager copy() {
        return new RectListManager(this.rects);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.rects, null);
        this.size = 0;
        this.bounds = null;
    }

    @Override
    public Iterator iterator() {
        return new RLMIterator();
    }

    public ListIterator listIterator() {
        return new RLMIterator();
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Rectangle[this.size];
        System.arraycopy(this.rects, 0, objectArray, 0, this.size);
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        Class<?> clazz = objectArray.getClass().getComponentType();
        if (clazz != Object.class && clazz != Rectangle.class) {
            Arrays.fill(objectArray, null);
            return objectArray;
        }
        if (objectArray.length < this.size) {
            objectArray = new Rectangle[this.size];
        }
        System.arraycopy(this.rects, 0, objectArray, 0, this.size);
        Arrays.fill(objectArray, this.size, objectArray.length, null);
        return objectArray;
    }

    public boolean add(Object object) {
        this.add((Rectangle)object);
        return true;
    }

    public void add(Rectangle rectangle) {
        this.add(rectangle, 0, this.size - 1);
    }

    protected void add(Rectangle rectangle, int n2, int n3) {
        this.ensureCapacity(this.size + 1);
        int n4 = n2;
        while (n2 <= n3) {
            for (n4 = (n2 + n3) / 2; this.rects[n4] == null && n4 < n3; ++n4) {
            }
            if (this.rects[n4] == null) {
                n3 = (n2 + n3) / 2;
                n4 = (n2 + n3) / 2;
                if (n2 > n3) {
                    n4 = n2;
                }
                while (this.rects[n4] == null && n4 > n2) {
                    --n4;
                }
                if (this.rects[n4] == null) {
                    this.rects[n4] = rectangle;
                    return;
                }
            }
            if (rectangle.x == this.rects[n4].x) break;
            if (rectangle.x < this.rects[n4].x) {
                if (n4 == 0 || this.rects[n4 - 1] != null && rectangle.x >= this.rects[n4 - 1].x) break;
                n3 = n4 - 1;
                continue;
            }
            if (n4 == this.size - 1) {
                ++n4;
                break;
            }
            if (this.rects[n4 + 1] != null && rectangle.x <= this.rects[n4 + 1].x) {
                ++n4;
                break;
            }
            n2 = n4 + 1;
        }
        if (n4 < this.size) {
            System.arraycopy(this.rects, n4, this.rects, n4 + 1, this.size - n4);
        }
        this.rects[n4] = rectangle;
        ++this.size;
        this.bounds = null;
    }

    public boolean addAll(Collection collection) {
        if (collection instanceof RectListManager) {
            this.add((RectListManager)collection);
        } else {
            this.add(new RectListManager(collection));
        }
        return collection.size() != 0;
    }

    @Override
    public boolean contains(Object object) {
        int n2;
        Rectangle rectangle = (Rectangle)object;
        int n3 = 0;
        int n4 = this.size - 1;
        int n5 = 0;
        while (n3 <= n4) {
            n5 = n3 + n4 >>> 1;
            if (rectangle.x == this.rects[n5].x) break;
            if (rectangle.x < this.rects[n5].x) {
                if (n5 == 0 || rectangle.x >= this.rects[n5 - 1].x) break;
                n4 = n5 - 1;
                continue;
            }
            if (n5 == this.size - 1) {
                ++n5;
                break;
            }
            if (rectangle.x <= this.rects[n5 + 1].x) {
                ++n5;
                break;
            }
            n3 = n5 + 1;
        }
        if (this.rects[n5].x != rectangle.x) {
            return false;
        }
        for (n2 = n5; n2 >= 0; --n2) {
            if (this.rects[n5].equals(rectangle)) {
                return true;
            }
            if (this.rects[n5].x != rectangle.x) break;
        }
        for (n2 = n5 + 1; n2 < this.size; ++n2) {
            if (this.rects[n5].equals(rectangle)) {
                return true;
            }
            if (this.rects[n5].x != rectangle.x) break;
        }
        return false;
    }

    public boolean containsAll(Collection collection) {
        if (collection instanceof RectListManager) {
            return this.containsAll((RectListManager)collection);
        }
        return this.containsAll(new RectListManager(collection));
    }

    public boolean containsAll(RectListManager rectListManager) {
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < rectListManager.size; ++i2) {
            n3 = n2;
            while (this.rects[n3].x < rectListManager.rects[i2].x) {
                if (++n3 != this.size) continue;
                return false;
            }
            n2 = n3;
            int n4 = this.rects[n3].x;
            while (!rectListManager.rects[i2].equals(this.rects[n3])) {
                if (++n3 == this.size) {
                    return false;
                }
                if (n4 == this.rects[n3].x) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean remove(Object object) {
        return this.remove((Rectangle)object);
    }

    public boolean remove(Rectangle rectangle) {
        int n2;
        int n3 = 0;
        int n4 = this.size - 1;
        int n5 = 0;
        while (n3 <= n4) {
            n5 = n3 + n4 >>> 1;
            if (rectangle.x == this.rects[n5].x) break;
            if (rectangle.x < this.rects[n5].x) {
                if (n5 == 0 || rectangle.x >= this.rects[n5 - 1].x) break;
                n4 = n5 - 1;
                continue;
            }
            if (n5 == this.size - 1) {
                ++n5;
                break;
            }
            if (rectangle.x <= this.rects[n5 + 1].x) {
                ++n5;
                break;
            }
            n3 = n5 + 1;
        }
        if (this.rects[n5].x != rectangle.x) {
            return false;
        }
        for (n2 = n5; n2 >= 0; --n2) {
            if (this.rects[n5].equals(rectangle)) {
                System.arraycopy(this.rects, n5 + 1, this.rects, n5, this.size - n5);
                --this.size;
                this.bounds = null;
                return true;
            }
            if (this.rects[n5].x != rectangle.x) break;
        }
        for (n2 = n5 + 1; n2 < this.size; ++n2) {
            if (this.rects[n5].equals(rectangle)) {
                System.arraycopy(this.rects, n5 + 1, this.rects, n5, this.size - n5);
                --this.size;
                this.bounds = null;
                return true;
            }
            if (this.rects[n5].x != rectangle.x) break;
        }
        return false;
    }

    public boolean removeAll(Collection collection) {
        if (collection instanceof RectListManager) {
            return this.removeAll((RectListManager)collection);
        }
        return this.removeAll(new RectListManager(collection));
    }

    public boolean removeAll(RectListManager rectListManager) {
        int n2;
        int n3 = 0;
        boolean bl2 = false;
        int n4 = 0;
        block0: for (n2 = 0; n2 < rectListManager.size; ++n2) {
            n4 = n3;
            while ((this.rects[n4] == null || this.rects[n4].x < rectListManager.rects[n2].x) && ++n4 != this.size) {
            }
            if (n4 == this.size) break;
            n3 = n4;
            int n5 = this.rects[n4].x;
            while (true) {
                if (this.rects[n4] == null) {
                    if (++n4 != this.size) continue;
                    continue block0;
                }
                if (rectListManager.rects[n2].equals(this.rects[n4])) {
                    this.rects[n4] = null;
                    bl2 = true;
                }
                if (++n4 == this.size || n5 != this.rects[n4].x) continue block0;
            }
        }
        if (bl2) {
            n2 = 0;
            for (n4 = 0; n4 < this.size; ++n4) {
                if (this.rects[n4] == null) continue;
                this.rects[n2++] = this.rects[n4];
            }
            this.size = n2;
            this.bounds = null;
        }
        return bl2;
    }

    public boolean retainAll(Collection collection) {
        if (collection instanceof RectListManager) {
            return this.retainAll((RectListManager)collection);
        }
        return this.retainAll(new RectListManager(collection));
    }

    public boolean retainAll(RectListManager rectListManager) {
        int n2;
        int n3 = 0;
        boolean bl2 = false;
        int n4 = 0;
        block0: for (n2 = 0; n2 < this.size; ++n2) {
            n4 = n3;
            while (rectListManager.rects[n4].x < this.rects[n2].x && ++n4 != rectListManager.size) {
            }
            if (n4 == rectListManager.size) {
                bl2 = true;
                for (int i2 = n2; i2 < this.size; ++i2) {
                    this.rects[i2] = null;
                }
                this.size = n2;
                break;
            }
            n3 = n4;
            int n5 = rectListManager.rects[n4].x;
            while (!this.rects[n2].equals(rectListManager.rects[n4])) {
                if (++n4 != rectListManager.size && n5 == rectListManager.rects[n4].x) continue;
                this.rects[n2] = null;
                bl2 = true;
                continue block0;
            }
        }
        if (bl2) {
            n2 = 0;
            for (n4 = 0; n4 < this.size; ++n4) {
                if (this.rects[n4] == null) continue;
                this.rects[n2++] = this.rects[n4];
            }
            this.size = n2;
            this.bounds = null;
        }
        return bl2;
    }

    public void add(RectListManager rectListManager) {
        if (rectListManager.size == 0) {
            return;
        }
        Rectangle[] rectangleArray = this.rects;
        if (this.rects.length < this.size + rectListManager.size) {
            rectangleArray = new Rectangle[this.size + rectListManager.size];
        }
        if (this.size == 0) {
            System.arraycopy(rectListManager.rects, 0, rectangleArray, this.size, rectListManager.size);
            this.size = rectListManager.size;
            this.bounds = null;
            return;
        }
        Rectangle[] rectangleArray2 = rectListManager.rects;
        int n2 = rectListManager.size;
        int n3 = n2 - 1;
        Rectangle[] rectangleArray3 = this.rects;
        int n4 = this.size;
        int n5 = n4 - 1;
        int n6 = rectangleArray2[n3].x;
        int n7 = rectangleArray3[n5].x;
        for (int i2 = this.size + rectListManager.size - 1; i2 >= 0; --i2) {
            if (n6 <= n7) {
                rectangleArray[i2] = rectangleArray3[n5];
                if (n5 == 0) {
                    System.arraycopy(rectangleArray2, 0, rectangleArray, 0, n3 + 1);
                    break;
                }
                n7 = rectangleArray3[--n5].x;
                continue;
            }
            rectangleArray[i2] = rectangleArray2[n3];
            if (n3 == 0) {
                System.arraycopy(rectangleArray3, 0, rectangleArray, 0, n5 + 1);
                break;
            }
            n6 = rectangleArray2[--n3].x;
        }
        this.rects = rectangleArray;
        this.size += rectListManager.size;
        this.bounds = null;
    }

    public void mergeRects(int n2, int n3) {
        int n4;
        Rectangle rectangle;
        int n5;
        if (this.size == 0) {
            return;
        }
        Rectangle[] rectangleArray = new Rectangle[4];
        for (n5 = 0; n5 < this.size; ++n5) {
            rectangle = this.rects[n5];
            if (rectangle == null) continue;
            int n6 = n2 + rectangle.height * n3 + rectangle.height * rectangle.width;
            block1: do {
                int n7 = rectangle.x + rectangle.width + n2 / rectangle.height;
                for (n4 = n5 + 1; n4 < this.size; ++n4) {
                    Rectangle rectangle2 = this.rects[n4];
                    if (rectangle2 == null || rectangle2 == rectangle) continue;
                    if (rectangle2.x >= n7) {
                        n4 = this.size;
                        continue block1;
                    }
                    int n8 = n2 + rectangle2.height * n3 + rectangle2.height * rectangle2.width;
                    Rectangle rectangle3 = rectangle.union(rectangle2);
                    int n9 = n2 + rectangle3.height * n3 + rectangle3.height * rectangle3.width;
                    if (n9 <= n6 + n8) {
                        rectangle = this.rects[n5] = rectangle3;
                        this.rects[n4] = null;
                        n6 = n9;
                        n4 = -1;
                        continue block1;
                    }
                    if (!rectangle.intersects(rectangle2)) continue;
                    this.splitRect(rectangle2, rectangle, rectangleArray);
                    int n10 = 0;
                    int n11 = 0;
                    for (int i2 = 0; i2 < 4; ++i2) {
                        if (rectangleArray[i2] == null) continue;
                        Rectangle rectangle4 = rectangleArray[i2];
                        if (i2 < 3) {
                            rectangleArray[n11++] = rectangle4;
                        }
                        n10 += n2 + rectangle4.height * n3 + rectangle4.height * rectangle4.width;
                    }
                    if (n10 >= n8) continue;
                    if (n11 == 0) {
                        this.rects[n4] = null;
                        if (rectangleArray[3] == null) continue;
                        this.add(rectangleArray[3], n4, this.size - 1);
                        continue;
                    }
                    this.rects[n4] = rectangleArray[0];
                    if (n11 > 1) {
                        this.insertRects(rectangleArray, 1, n4 + 1, n11 - 1);
                    }
                    if (rectangleArray[3] == null) continue;
                    this.add(rectangleArray[3], n4, this.size - 1);
                }
            } while (n4 != this.size);
        }
        n4 = 0;
        float f2 = 0.0f;
        for (n5 = 0; n5 < this.size; ++n5) {
            if (this.rects[n5] == null) continue;
            rectangle = this.rects[n5];
            this.rects[n4++] = rectangle;
            f2 += (float)(n2 + rectangle.height * n3 + rectangle.height * rectangle.width);
        }
        this.size = n4;
        this.bounds = null;
        rectangle = this.getBounds();
        if (rectangle == null) {
            return;
        }
        if ((float)(n2 + rectangle.height * n3 + rectangle.height * rectangle.width) < f2) {
            this.rects[0] = rectangle;
            this.size = 1;
        }
    }

    public void subtract(RectListManager rectListManager, int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        Rectangle[] rectangleArray = new Rectangle[4];
        block0: for (n5 = 0; n5 < this.size; ++n5) {
            Rectangle rectangle = this.rects[n5];
            int n7 = n2 + rectangle.height * n3 + rectangle.height * rectangle.width;
            for (n4 = n6; n4 < rectListManager.size; ++n4) {
                int n8;
                Rectangle rectangle2 = rectListManager.rects[n4];
                if (rectangle2.x + rectangle2.width < rectangle.x) {
                    if (n4 != n6) continue;
                    ++n6;
                    continue;
                }
                if (rectangle2.x > rectangle.x + rectangle.width) continue block0;
                if (!rectangle.intersects(rectangle2)) continue;
                this.splitRect(rectangle, rectangle2, rectangleArray);
                int n9 = 0;
                for (n8 = 0; n8 < 4; ++n8) {
                    Rectangle rectangle3 = rectangleArray[n8];
                    if (rectangle3 == null) continue;
                    n9 += n2 + rectangle3.height * n3 + rectangle3.height * rectangle3.width;
                }
                if (n9 >= n7) continue;
                n8 = 0;
                for (int i2 = 0; i2 < 3; ++i2) {
                    if (rectangleArray[i2] == null) continue;
                    rectangleArray[n8++] = rectangleArray[i2];
                }
                if (n8 == 0) {
                    this.rects[n5].width = 0;
                    if (rectangleArray[3] == null) continue block0;
                    this.add(rectangleArray[3], n5, this.size - 1);
                    continue block0;
                }
                this.rects[n5] = rectangle = rectangleArray[0];
                n7 = n2 + rectangle.height * n3 + rectangle.height * rectangle.width;
                if (n8 > 1) {
                    this.insertRects(rectangleArray, 1, n5 + 1, n8 - 1);
                }
                if (rectangleArray[3] == null) continue;
                this.add(rectangleArray[3], n5 + n8, this.size - 1);
            }
        }
        n5 = 0;
        for (n4 = 0; n4 < this.size; ++n4) {
            if (this.rects[n4].width == 0) {
                this.rects[n4] = null;
                continue;
            }
            this.rects[n5++] = this.rects[n4];
        }
        this.size = n5;
        this.bounds = null;
    }

    protected void splitRect(Rectangle rectangle, Rectangle rectangle2, Rectangle[] rectangleArray) {
        int n2 = rectangle.x;
        int n3 = n2 + rectangle.width - 1;
        int n4 = rectangle.y;
        int n5 = n4 + rectangle.height - 1;
        int n6 = rectangle2.x;
        int n7 = n6 + rectangle2.width - 1;
        int n8 = rectangle2.y;
        int n9 = n8 + rectangle2.height - 1;
        if (n4 < n8 && n5 >= n8) {
            rectangleArray[0] = new Rectangle(n2, n4, rectangle.width, n8 - n4);
            n4 = n8;
        } else {
            rectangleArray[0] = null;
        }
        if (n4 <= n9 && n5 > n9) {
            rectangleArray[1] = new Rectangle(n2, n9 + 1, rectangle.width, n5 - n9);
            n5 = n9;
        } else {
            rectangleArray[1] = null;
        }
        rectangleArray[2] = n2 < n6 && n3 >= n6 ? new Rectangle(n2, n4, n6 - n2, n5 - n4 + 1) : null;
        rectangleArray[3] = n2 <= n7 && n3 > n7 ? new Rectangle(n7 + 1, n4, n3 - n7, n5 - n4 + 1) : null;
    }

    protected void insertRects(Rectangle[] rectangleArray, int n2, int n3, int n4) {
        if (n4 == 0) {
            return;
        }
        this.ensureCapacity(this.size + n4);
        for (int i2 = this.size - 1; i2 >= n3; --i2) {
            this.rects[i2 + n4] = this.rects[i2];
        }
        System.arraycopy(rectangleArray, n2, this.rects, n3, n4);
        this.size += n4;
    }

    public void ensureCapacity(int n2) {
        int n3;
        if (n2 <= this.rects.length) {
            return;
        }
        for (n3 = this.rects.length + (this.rects.length >> 1) + 1; n3 < n2; n3 += (n3 >> 1) + 1) {
        }
        Rectangle[] rectangleArray = new Rectangle[n3];
        System.arraycopy(this.rects, 0, rectangleArray, 0, this.size);
        this.rects = rectangleArray;
    }

    private class RLMIterator
    implements ListIterator {
        int idx = 0;
        boolean removeOk = false;
        boolean forward = true;

        RLMIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.idx < RectListManager.this.size;
        }

        @Override
        public int nextIndex() {
            return this.idx;
        }

        @Override
        public Object next() {
            if (this.idx >= RectListManager.this.size) {
                throw new NoSuchElementException("No Next Element");
            }
            this.forward = true;
            this.removeOk = true;
            return RectListManager.this.rects[this.idx++];
        }

        @Override
        public boolean hasPrevious() {
            return this.idx > 0;
        }

        @Override
        public int previousIndex() {
            return this.idx - 1;
        }

        public Object previous() {
            if (this.idx <= 0) {
                throw new NoSuchElementException("No Previous Element");
            }
            this.forward = false;
            this.removeOk = true;
            return RectListManager.this.rects[--this.idx];
        }

        @Override
        public void remove() {
            if (!this.removeOk) {
                throw new IllegalStateException("remove can only be called directly after next/previous");
            }
            if (this.forward) {
                --this.idx;
            }
            if (this.idx != RectListManager.this.size - 1) {
                System.arraycopy(RectListManager.this.rects, this.idx + 1, RectListManager.this.rects, this.idx, RectListManager.this.size - (this.idx + 1));
            }
            --RectListManager.this.size;
            RectListManager.this.rects[RectListManager.this.size] = null;
            this.removeOk = false;
        }

        public void set(Object object) {
            Rectangle rectangle = (Rectangle)object;
            if (!this.removeOk) {
                throw new IllegalStateException("set can only be called directly after next/previous");
            }
            if (this.forward) {
                --this.idx;
            }
            if (this.idx + 1 < RectListManager.this.size && RectListManager.this.rects[this.idx + 1].x < rectangle.x) {
                throw new UnsupportedOperationException("RectListManager entries must be sorted");
            }
            if (this.idx >= 0 && RectListManager.this.rects[this.idx - 1].x > rectangle.x) {
                throw new UnsupportedOperationException("RectListManager entries must be sorted");
            }
            RectListManager.this.rects[this.idx] = rectangle;
            this.removeOk = false;
        }

        public void add(Object object) {
            Rectangle rectangle = (Rectangle)object;
            if (this.idx < RectListManager.this.size && RectListManager.this.rects[this.idx].x < rectangle.x) {
                throw new UnsupportedOperationException("RectListManager entries must be sorted");
            }
            if (this.idx != 0 && RectListManager.this.rects[this.idx - 1].x > rectangle.x) {
                throw new UnsupportedOperationException("RectListManager entries must be sorted");
            }
            RectListManager.this.ensureCapacity(RectListManager.this.size + 1);
            if (this.idx != RectListManager.this.size) {
                System.arraycopy(RectListManager.this.rects, this.idx, RectListManager.this.rects, this.idx + 1, RectListManager.this.size - this.idx);
            }
            RectListManager.this.rects[this.idx] = rectangle;
            ++this.idx;
            this.removeOk = false;
        }
    }

    private static class RectXComparator
    implements Comparator,
    Serializable {
        RectXComparator() {
        }

        public final int compare(Object object, Object object2) {
            return ((Rectangle)object).x - ((Rectangle)object2).x;
        }
    }
}

