/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.geom;

import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import org.apache.batik.ext.awt.geom.AbstractSegment;
import org.apache.batik.ext.awt.geom.Segment;

public class Quadradic
extends AbstractSegment {
    public Point2D.Double p1;
    public Point2D.Double p2;
    public Point2D.Double p3;
    static int count = 0;

    public Quadradic() {
        this.p1 = new Point2D.Double();
        this.p2 = new Point2D.Double();
        this.p3 = new Point2D.Double();
    }

    public Quadradic(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.p1 = new Point2D.Double(d2, d3);
        this.p2 = new Point2D.Double(d4, d5);
        this.p3 = new Point2D.Double(d6, d7);
    }

    public Quadradic(Point2D.Double double_, Point2D.Double double_2, Point2D.Double double_3) {
        this.p1 = double_;
        this.p2 = double_2;
        this.p3 = double_3;
    }

    public Object clone() {
        return new Quadradic(new Point2D.Double(this.p1.x, this.p1.y), new Point2D.Double(this.p2.x, this.p2.y), new Point2D.Double(this.p3.x, this.p3.y));
    }

    public Segment reverse() {
        return new Quadradic(new Point2D.Double(this.p3.x, this.p3.y), new Point2D.Double(this.p2.x, this.p2.y), new Point2D.Double(this.p1.x, this.p1.y));
    }

    private void getMinMax(double d2, double d3, double d4, double[] dArray) {
        if (d4 > d2) {
            dArray[0] = d2;
            dArray[1] = d4;
        } else {
            dArray[0] = d4;
            dArray[1] = d2;
        }
        double d5 = d2 - 2.0 * d3 + d4;
        double d6 = d4 - d3;
        if (d5 == 0.0) {
            return;
        }
        double d7 = d6 / d5;
        if (d7 <= 0.0 || d7 >= 1.0) {
            return;
        }
        if ((d7 = ((d2 - 2.0 * d3 + d4) * d7 + 2.0 * (d3 - d2)) * d7 + d2) < dArray[0]) {
            dArray[0] = d7;
        } else if (d7 > dArray[1]) {
            dArray[1] = d7;
        }
    }

    @Override
    public double minX() {
        double[] dArray = new double[]{0.0, 0.0};
        this.getMinMax(this.p1.x, this.p2.x, this.p3.x, dArray);
        return dArray[0];
    }

    @Override
    public double maxX() {
        double[] dArray = new double[]{0.0, 0.0};
        this.getMinMax(this.p1.x, this.p2.x, this.p3.x, dArray);
        return dArray[1];
    }

    @Override
    public double minY() {
        double[] dArray = new double[]{0.0, 0.0};
        this.getMinMax(this.p1.y, this.p2.y, this.p3.y, dArray);
        return dArray[0];
    }

    @Override
    public double maxY() {
        double[] dArray = new double[]{0.0, 0.0};
        this.getMinMax(this.p1.y, this.p2.y, this.p3.y, dArray);
        return dArray[1];
    }

    @Override
    public Rectangle2D getBounds2D() {
        double[] dArray = new double[]{0.0, 0.0};
        this.getMinMax(this.p1.x, this.p2.x, this.p3.x, dArray);
        double[] dArray2 = new double[]{0.0, 0.0};
        this.getMinMax(this.p1.y, this.p2.y, this.p3.y, dArray2);
        return new Rectangle2D.Double(dArray[0], dArray2[0], dArray[1] - dArray[0], dArray2[1] - dArray2[0]);
    }

    @Override
    protected int findRoots(double d2, double[] dArray) {
        double[] dArray2 = new double[]{this.p1.y - d2, 2.0 * (this.p2.y - this.p1.y), this.p1.y - 2.0 * this.p2.y + this.p3.y};
        return QuadCurve2D.solveQuadratic(dArray2, dArray);
    }

    @Override
    public Point2D.Double evalDt(double d2) {
        double d3 = 2.0 * (this.p1.x - 2.0 * this.p2.x + this.p3.x) * d2 + 2.0 * (this.p2.x - this.p1.x);
        double d4 = 2.0 * (this.p1.y - 2.0 * this.p2.y + this.p3.y) * d2 + 2.0 * (this.p2.y - this.p1.y);
        return new Point2D.Double(d3, d4);
    }

    @Override
    public Point2D.Double eval(double d2) {
        double d3 = ((this.p1.x - 2.0 * this.p2.x + this.p3.x) * d2 + 2.0 * (this.p2.x - this.p1.x)) * d2 + this.p1.x;
        double d4 = ((this.p1.y - 2.0 * this.p2.y + this.p3.y) * d2 + 2.0 * (this.p2.y - this.p1.y)) * d2 + this.p1.y;
        return new Point2D.Double(d3, d4);
    }

    @Override
    public Segment getSegment(double d2, double d3) {
        double d4 = d3 - d2;
        Point2D.Double double_ = this.eval(d2);
        Point2D.Double double_2 = this.evalDt(d2);
        Point2D.Double double_3 = new Point2D.Double(double_.x + 0.5 * d4 * double_2.x, double_.y + 0.5 * d4 * double_2.y);
        Point2D.Double double_4 = this.eval(d3);
        return new Quadradic(double_, double_3, double_4);
    }

    public void subdivide(Quadradic quadradic, Quadradic quadradic2) {
        if (quadradic == null && quadradic2 == null) {
            return;
        }
        double d2 = (this.p1.x - 2.0 * this.p2.x + this.p3.x) * 0.25 + (this.p2.x - this.p1.x) + this.p1.x;
        double d3 = (this.p1.y - 2.0 * this.p2.y + this.p3.y) * 0.25 + (this.p2.y - this.p1.y) + this.p1.y;
        double d4 = (this.p1.x - 2.0 * this.p2.x + this.p3.x) * 0.25 + (this.p2.x - this.p1.x) * 0.5;
        double d5 = (this.p1.y - 2.0 * this.p2.y + this.p3.y) * 0.25 + (this.p2.y - this.p1.y) * 0.5;
        if (quadradic != null) {
            quadradic.p1.x = this.p1.x;
            quadradic.p1.y = this.p1.y;
            quadradic.p2.x = d2 - d4;
            quadradic.p2.y = d3 - d5;
            quadradic.p3.x = d2;
            quadradic.p3.y = d3;
        }
        if (quadradic2 != null) {
            quadradic2.p1.x = d2;
            quadradic2.p1.y = d3;
            quadradic2.p2.x = d2 + d4;
            quadradic2.p2.y = d3 + d5;
            quadradic2.p3.x = this.p3.x;
            quadradic2.p3.y = this.p3.y;
        }
    }

    public void subdivide(double d2, Quadradic quadradic, Quadradic quadradic2) {
        Point2D.Double double_ = this.eval(d2);
        Point2D.Double double_2 = this.evalDt(d2);
        if (quadradic != null) {
            quadradic.p1.x = this.p1.x;
            quadradic.p1.y = this.p1.y;
            quadradic.p2.x = double_.x - double_2.x * d2 * 0.5;
            quadradic.p2.y = double_.y - double_2.y * d2 * 0.5;
            quadradic.p3.x = double_.x;
            quadradic.p3.y = double_.y;
        }
        if (quadradic2 != null) {
            quadradic2.p1.x = double_.x;
            quadradic2.p1.y = double_.y;
            quadradic2.p2.x = double_.x + double_2.x * (1.0 - d2) * 0.5;
            quadradic2.p2.y = double_.y + double_2.y * (1.0 - d2) * 0.5;
            quadradic2.p3.x = this.p3.x;
            quadradic2.p3.y = this.p3.y;
        }
    }

    @Override
    public void subdivide(Segment segment, Segment segment2) {
        Quadradic quadradic = null;
        Quadradic quadradic2 = null;
        if (segment instanceof Quadradic) {
            quadradic = (Quadradic)segment;
        }
        if (segment2 instanceof Quadradic) {
            quadradic2 = (Quadradic)segment2;
        }
        this.subdivide(quadradic, quadradic2);
    }

    @Override
    public void subdivide(double d2, Segment segment, Segment segment2) {
        Quadradic quadradic = null;
        Quadradic quadradic2 = null;
        if (segment instanceof Quadradic) {
            quadradic = (Quadradic)segment;
        }
        if (segment2 instanceof Quadradic) {
            quadradic2 = (Quadradic)segment2;
        }
        this.subdivide(d2, quadradic, quadradic2);
    }

    protected double subLength(double d2, double d3, double d4) {
        ++count;
        double d5 = this.p3.x - this.p1.x;
        double d6 = this.p3.y - this.p1.y;
        double d7 = Math.sqrt(d5 * d5 + d6 * d6);
        double d8 = d2 + d3;
        if (d8 < d4) {
            return (d8 + d7) * 0.5;
        }
        double d9 = d8 - d7;
        if (d9 < d4) {
            return (d8 + d7) * 0.5;
        }
        Quadradic quadradic = new Quadradic();
        double d10 = (this.p1.x + 2.0 * this.p2.x + this.p3.x) * 0.25;
        double d11 = (this.p1.y + 2.0 * this.p2.y + this.p3.y) * 0.25;
        d5 = 0.25 * d5;
        d6 = 0.25 * d6;
        quadradic.p1.x = this.p1.x;
        quadradic.p1.y = this.p1.y;
        quadradic.p2.x = d10 - d5;
        quadradic.p2.y = d11 - d6;
        quadradic.p3.x = d10;
        quadradic.p3.y = d11;
        double d12 = 0.25 * d7;
        double d13 = quadradic.subLength(d2 * 0.5, d12, d4 * 0.5);
        quadradic.p1.x = d10;
        quadradic.p1.y = d11;
        quadradic.p2.x = d10 + d5;
        quadradic.p2.y = d11 + d6;
        quadradic.p3.x = this.p3.x;
        quadradic.p3.y = this.p3.y;
        return d13 += quadradic.subLength(d12, d3 * 0.5, d4 * 0.5);
    }

    @Override
    public double getLength() {
        return this.getLength(1.0E-6);
    }

    @Override
    public double getLength(double d2) {
        double d3 = this.p2.x - this.p1.x;
        double d4 = this.p2.y - this.p1.y;
        double d5 = Math.sqrt(d3 * d3 + d4 * d4);
        d3 = this.p3.x - this.p2.x;
        d4 = this.p3.y - this.p2.y;
        double d6 = Math.sqrt(d3 * d3 + d4 * d4);
        double d7 = d2 * (d5 + d6);
        return this.subLength(d5, d6, d7);
    }

    public String toString() {
        return "M" + this.p1.x + ',' + this.p1.y + 'Q' + this.p2.x + ',' + this.p2.y + ' ' + this.p3.x + ',' + this.p3.y;
    }
}

