/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.geom;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class PathLength {
    protected Shape path;
    protected List segments;
    protected int[] segmentIndexes;
    protected float pathLength;
    protected boolean initialised;

    public PathLength(Shape shape) {
        this.setPath(shape);
    }

    public Shape getPath() {
        return this.path;
    }

    public void setPath(Shape shape) {
        this.path = shape;
        this.initialised = false;
    }

    public float lengthOfPath() {
        if (!this.initialised) {
            this.initialise();
        }
        return this.pathLength;
    }

    protected void initialise() {
        this.pathLength = 0.0f;
        PathIterator pathIterator = this.path.getPathIterator(new AffineTransform());
        SingleSegmentPathIterator singleSegmentPathIterator = new SingleSegmentPathIterator();
        this.segments = new ArrayList(20);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(20);
        int n2 = 0;
        int n3 = -1;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float[] fArray = new float[6];
        this.segments.add(new PathSegment(0, 0.0f, 0.0f, 0.0f, n3));
        block5: while (!pathIterator.isDone()) {
            ++n3;
            arrayList.add(new Integer(n2));
            int n4 = pathIterator.currentSegment(fArray);
            switch (n4) {
                case 0: {
                    this.segments.add(new PathSegment(n4, fArray[0], fArray[1], this.pathLength, n3));
                    f4 = fArray[0];
                    f5 = fArray[1];
                    f2 = f4;
                    f3 = f5;
                    ++n2;
                    pathIterator.next();
                    continue block5;
                }
                case 1: {
                    this.pathLength = (float)((double)this.pathLength + Point2D.distance(f4, f5, fArray[0], fArray[1]));
                    this.segments.add(new PathSegment(n4, fArray[0], fArray[1], this.pathLength, n3));
                    f4 = fArray[0];
                    f5 = fArray[1];
                    ++n2;
                    pathIterator.next();
                    continue block5;
                }
                case 4: {
                    this.pathLength = (float)((double)this.pathLength + Point2D.distance(f4, f5, f2, f3));
                    this.segments.add(new PathSegment(1, f2, f3, this.pathLength, n3));
                    f4 = f2;
                    f5 = f3;
                    ++n2;
                    pathIterator.next();
                    continue block5;
                }
            }
            singleSegmentPathIterator.setPathIterator(pathIterator, f4, f5);
            FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(singleSegmentPathIterator, 0.01f);
            while (!flatteningPathIterator.isDone()) {
                n4 = flatteningPathIterator.currentSegment(fArray);
                if (n4 == 1) {
                    this.pathLength = (float)((double)this.pathLength + Point2D.distance(f4, f5, fArray[0], fArray[1]));
                    this.segments.add(new PathSegment(n4, fArray[0], fArray[1], this.pathLength, n3));
                    f4 = fArray[0];
                    f5 = fArray[1];
                    ++n2;
                }
                flatteningPathIterator.next();
            }
        }
        this.segmentIndexes = new int[arrayList.size()];
        for (int i2 = 0; i2 < this.segmentIndexes.length; ++i2) {
            this.segmentIndexes[i2] = (Integer)arrayList.get(i2);
        }
        this.initialised = true;
    }

    public int getNumberOfSegments() {
        if (!this.initialised) {
            this.initialise();
        }
        return this.segmentIndexes.length;
    }

    public float getLengthAtSegment(int n2) {
        if (!this.initialised) {
            this.initialise();
        }
        if (n2 <= 0) {
            return 0.0f;
        }
        if (n2 >= this.segmentIndexes.length) {
            return this.pathLength;
        }
        PathSegment pathSegment = (PathSegment)this.segments.get(this.segmentIndexes[n2]);
        return pathSegment.getLength();
    }

    public int segmentAtLength(float f2) {
        int n2 = this.findUpperIndex(f2);
        if (n2 == -1) {
            return -1;
        }
        if (n2 == 0) {
            PathSegment pathSegment = (PathSegment)this.segments.get(n2);
            return pathSegment.getIndex();
        }
        PathSegment pathSegment = (PathSegment)this.segments.get(n2 - 1);
        return pathSegment.getIndex();
    }

    public Point2D pointAtLength(int n2, float f2) {
        float f3;
        if (!this.initialised) {
            this.initialise();
        }
        if (n2 < 0 || n2 >= this.segmentIndexes.length) {
            return null;
        }
        PathSegment pathSegment = (PathSegment)this.segments.get(this.segmentIndexes[n2]);
        float f4 = pathSegment.getLength();
        if (n2 == this.segmentIndexes.length - 1) {
            f3 = this.pathLength;
        } else {
            pathSegment = (PathSegment)this.segments.get(this.segmentIndexes[n2 + 1]);
            f3 = pathSegment.getLength();
        }
        return this.pointAtLength(f4 + (f3 - f4) * f2);
    }

    public Point2D pointAtLength(float f2) {
        int n2 = this.findUpperIndex(f2);
        if (n2 == -1) {
            return null;
        }
        PathSegment pathSegment = (PathSegment)this.segments.get(n2);
        if (n2 == 0) {
            return new Point2D.Float(pathSegment.getX(), pathSegment.getY());
        }
        PathSegment pathSegment2 = (PathSegment)this.segments.get(n2 - 1);
        float f3 = f2 - pathSegment2.getLength();
        double d2 = Math.atan2(pathSegment.getY() - pathSegment2.getY(), pathSegment.getX() - pathSegment2.getX());
        float f4 = (float)((double)pathSegment2.getX() + (double)f3 * Math.cos(d2));
        float f5 = (float)((double)pathSegment2.getY() + (double)f3 * Math.sin(d2));
        return new Point2D.Float(f4, f5);
    }

    public float angleAtLength(int n2, float f2) {
        float f3;
        if (!this.initialised) {
            this.initialise();
        }
        if (n2 < 0 || n2 >= this.segmentIndexes.length) {
            return 0.0f;
        }
        PathSegment pathSegment = (PathSegment)this.segments.get(this.segmentIndexes[n2]);
        float f4 = pathSegment.getLength();
        if (n2 == this.segmentIndexes.length - 1) {
            f3 = this.pathLength;
        } else {
            pathSegment = (PathSegment)this.segments.get(this.segmentIndexes[n2 + 1]);
            f3 = pathSegment.getLength();
        }
        return this.angleAtLength(f4 + (f3 - f4) * f2);
    }

    public float angleAtLength(float f2) {
        int n2 = this.findUpperIndex(f2);
        if (n2 == -1) {
            return 0.0f;
        }
        PathSegment pathSegment = (PathSegment)this.segments.get(n2);
        if (n2 == 0) {
            n2 = 1;
        }
        PathSegment pathSegment2 = (PathSegment)this.segments.get(n2 - 1);
        return (float)Math.atan2(pathSegment.getY() - pathSegment2.getY(), pathSegment.getX() - pathSegment2.getX());
    }

    public int findUpperIndex(float f2) {
        PathSegment pathSegment;
        if (!this.initialised) {
            this.initialise();
        }
        if (f2 < 0.0f || f2 > this.pathLength) {
            return -1;
        }
        int n2 = 0;
        int n3 = this.segments.size() - 1;
        while (n2 != n3) {
            int n4 = n2 + n3 >> 1;
            PathSegment pathSegment2 = (PathSegment)this.segments.get(n4);
            if (pathSegment2.getLength() >= f2) {
                n3 = n4;
                continue;
            }
            n2 = n4 + 1;
        }
        while ((pathSegment = (PathSegment)this.segments.get(n3)).getSegType() == 0 && n3 != this.segments.size() - 1) {
            ++n3;
        }
        int n5 = -1;
        int n6 = this.segments.size();
        for (int i2 = 0; n5 <= 0 && i2 < n6; ++i2) {
            PathSegment pathSegment3 = (PathSegment)this.segments.get(i2);
            if (!(pathSegment3.getLength() >= f2) || pathSegment3.getSegType() == 0) continue;
            n5 = i2;
        }
        return n5;
    }

    protected static class PathSegment {
        protected final int segType;
        protected float x;
        protected float y;
        protected float length;
        protected int index;

        PathSegment(int n2, float f2, float f3, float f4, int n3) {
            this.segType = n2;
            this.x = f2;
            this.y = f3;
            this.length = f4;
            this.index = n3;
        }

        public int getSegType() {
            return this.segType;
        }

        public float getX() {
            return this.x;
        }

        public void setX(float f2) {
            this.x = f2;
        }

        public float getY() {
            return this.y;
        }

        public void setY(float f2) {
            this.y = f2;
        }

        public float getLength() {
            return this.length;
        }

        public void setLength(float f2) {
            this.length = f2;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int n2) {
            this.index = n2;
        }
    }

    protected static class SingleSegmentPathIterator
    implements PathIterator {
        protected PathIterator it;
        protected boolean done;
        protected boolean moveDone;
        protected double x;
        protected double y;

        protected SingleSegmentPathIterator() {
        }

        public void setPathIterator(PathIterator pathIterator, double d2, double d3) {
            this.it = pathIterator;
            this.x = d2;
            this.y = d3;
            this.done = false;
            this.moveDone = false;
        }

        @Override
        public int currentSegment(double[] dArray) {
            int n2 = this.it.currentSegment(dArray);
            if (!this.moveDone) {
                dArray[0] = this.x;
                dArray[1] = this.y;
                return 0;
            }
            return n2;
        }

        @Override
        public int currentSegment(float[] fArray) {
            int n2 = this.it.currentSegment(fArray);
            if (!this.moveDone) {
                fArray[0] = (float)this.x;
                fArray[1] = (float)this.y;
                return 0;
            }
            return n2;
        }

        @Override
        public int getWindingRule() {
            return this.it.getWindingRule();
        }

        @Override
        public boolean isDone() {
            return this.done || this.it.isDone();
        }

        @Override
        public void next() {
            if (!this.done) {
                if (!this.moveDone) {
                    this.moveDone = true;
                } else {
                    this.it.next();
                    this.done = true;
                }
            }
        }
    }
}

