/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.g2d;

import java.awt.geom.AffineTransform;
import org.apache.batik.ext.awt.g2d.TransformType;

public abstract class TransformStackElement
implements Cloneable {
    private TransformType type;
    private double[] transformParameters;

    protected TransformStackElement(TransformType transformType, double[] dArray) {
        this.type = transformType;
        this.transformParameters = dArray;
    }

    public Object clone() {
        TransformStackElement transformStackElement = null;
        try {
            transformStackElement = (TransformStackElement)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        double[] dArray = new double[this.transformParameters.length];
        System.arraycopy(this.transformParameters, 0, dArray, 0, dArray.length);
        transformStackElement.transformParameters = dArray;
        return transformStackElement;
    }

    public static TransformStackElement createTranslateElement(double d2, double d3) {
        return new TransformStackElement(TransformType.TRANSLATE, new double[]{d2, d3}){

            @Override
            boolean isIdentity(double[] dArray) {
                return dArray[0] == 0.0 && dArray[1] == 0.0;
            }
        };
    }

    public static TransformStackElement createRotateElement(double d2) {
        return new TransformStackElement(TransformType.ROTATE, new double[]{d2}){

            @Override
            boolean isIdentity(double[] dArray) {
                return Math.cos(dArray[0]) == 1.0;
            }
        };
    }

    public static TransformStackElement createScaleElement(double d2, double d3) {
        return new TransformStackElement(TransformType.SCALE, new double[]{d2, d3}){

            @Override
            boolean isIdentity(double[] dArray) {
                return dArray[0] == 1.0 && dArray[1] == 1.0;
            }
        };
    }

    public static TransformStackElement createShearElement(double d2, double d3) {
        return new TransformStackElement(TransformType.SHEAR, new double[]{d2, d3}){

            @Override
            boolean isIdentity(double[] dArray) {
                return dArray[0] == 0.0 && dArray[1] == 0.0;
            }
        };
    }

    public static TransformStackElement createGeneralTransformElement(AffineTransform affineTransform) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        return new TransformStackElement(TransformType.GENERAL, dArray){

            @Override
            boolean isIdentity(double[] dArray) {
                return dArray[0] == 1.0 && dArray[2] == 0.0 && dArray[4] == 0.0 && dArray[1] == 0.0 && dArray[3] == 1.0 && dArray[5] == 0.0;
            }
        };
    }

    abstract boolean isIdentity(double[] var1);

    public boolean isIdentity() {
        return this.isIdentity(this.transformParameters);
    }

    public double[] getTransformParameters() {
        return this.transformParameters;
    }

    public TransformType getType() {
        return this.type;
    }

    public boolean concatenate(TransformStackElement transformStackElement) {
        boolean bl2 = false;
        if (this.type.toInt() == transformStackElement.type.toInt()) {
            bl2 = true;
            switch (this.type.toInt()) {
                case 0: {
                    this.transformParameters[0] = this.transformParameters[0] + transformStackElement.transformParameters[0];
                    this.transformParameters[1] = this.transformParameters[1] + transformStackElement.transformParameters[1];
                    break;
                }
                case 1: {
                    this.transformParameters[0] = this.transformParameters[0] + transformStackElement.transformParameters[0];
                    break;
                }
                case 2: {
                    this.transformParameters[0] = this.transformParameters[0] * transformStackElement.transformParameters[0];
                    this.transformParameters[1] = this.transformParameters[1] * transformStackElement.transformParameters[1];
                    break;
                }
                case 4: {
                    this.transformParameters = this.matrixMultiply(this.transformParameters, transformStackElement.transformParameters);
                    break;
                }
                default: {
                    bl2 = false;
                }
            }
        }
        return bl2;
    }

    private double[] matrixMultiply(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[6];
        AffineTransform affineTransform = new AffineTransform(dArray);
        affineTransform.concatenate(new AffineTransform(dArray2));
        affineTransform.getMatrix(dArray3);
        return dArray3;
    }
}

