/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaintContext;
import org.apache.batik.ext.awt.RadialGradientPaint;

final class RadialGradientPaintContext
extends MultipleGradientPaintContext {
    private boolean isSimpleFocus = false;
    private boolean isNonCyclic = false;
    private float radius;
    private float centerX;
    private float centerY;
    private float focusX;
    private float focusY;
    private float radiusSq;
    private float constA;
    private float constB;
    private float trivial;
    private static final int FIXED_POINT_IMPL = 1;
    private static final int DEFAULT_IMPL = 2;
    private static final int ANTI_ALIAS_IMPL = 3;
    private int fillMethod;
    private static final float SCALEBACK = 0.999f;
    private float invSqStepFloat;
    private static final int MAX_PRECISION = 256;
    private int[] sqrtLutFixed = new int[256];

    public RadialGradientPaintContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints, float f2, float f3, float f4, float f5, float f6, float[] fArray, Color[] colorArray, MultipleGradientPaint.CycleMethodEnum cycleMethodEnum, MultipleGradientPaint.ColorSpaceEnum colorSpaceEnum) throws NoninvertibleTransformException {
        super(colorModel, rectangle, rectangle2D, affineTransform, renderingHints, fArray, colorArray, cycleMethodEnum, colorSpaceEnum);
        this.centerX = f2;
        this.centerY = f3;
        this.focusX = f5;
        this.focusY = f6;
        this.radius = f4;
        this.isSimpleFocus = this.focusX == this.centerX && this.focusY == this.centerY;
        this.isNonCyclic = cycleMethodEnum == RadialGradientPaint.NO_CYCLE;
        this.radiusSq = this.radius * this.radius;
        float f7 = this.focusX - this.centerX;
        float f8 = this.focusY - this.centerY;
        double d2 = Math.sqrt(f7 * f7 + f8 * f8);
        if (d2 > (double)(this.radius * 0.999f)) {
            double d3 = Math.atan2(f8, f7);
            this.focusX = (float)((double)(0.999f * this.radius) * Math.cos(d3)) + this.centerX;
            this.focusY = (float)((double)(0.999f * this.radius) * Math.sin(d3)) + this.centerY;
        }
        f7 = this.focusX - this.centerX;
        this.trivial = (float)Math.sqrt(this.radiusSq - f7 * f7);
        this.constA = this.a02 - this.centerX;
        this.constB = this.a12 - this.centerY;
        Object object = renderingHints.get(RenderingHints.KEY_COLOR_RENDERING);
        Object object2 = renderingHints.get(RenderingHints.KEY_RENDERING);
        this.fillMethod = 0;
        if (object2 == RenderingHints.VALUE_RENDER_QUALITY || object == RenderingHints.VALUE_COLOR_RENDER_QUALITY) {
            this.fillMethod = 3;
        }
        if (object2 == RenderingHints.VALUE_RENDER_SPEED || object == RenderingHints.VALUE_COLOR_RENDER_SPEED) {
            this.fillMethod = 2;
        }
        if (this.fillMethod == 0) {
            this.fillMethod = 2;
        }
        if (this.fillMethod == 2 && this.isSimpleFocus && this.isNonCyclic && this.isSimpleLookup) {
            this.calculateFixedPointSqrtLookupTable();
            this.fillMethod = 1;
        }
    }

    @Override
    protected void fillRaster(int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        switch (this.fillMethod) {
            case 1: {
                this.fixedPointSimplestCaseNonCyclicFillRaster(nArray, n2, n3, n4, n5, n6, n7);
                break;
            }
            case 3: {
                this.antiAliasFillRaster(nArray, n2, n3, n4, n5, n6, n7);
                break;
            }
            default: {
                this.cyclicCircularGradientFillRaster(nArray, n2, n3, n4, n5, n6, n7);
            }
        }
    }

    private void fixedPointSimplestCaseNonCyclicFillRaster(int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        float f2 = 0.0f;
        float f3 = (float)this.fastGradientArraySize / this.radius;
        float f4 = this.a00 * (float)n4 + this.a01 * (float)n5 + this.constA;
        float f5 = this.a10 * (float)n4 + this.a11 * (float)n5 + this.constB;
        float f6 = f3 * this.a00;
        float f7 = f3 * this.a10;
        int n8 = this.fastGradientArraySize * this.fastGradientArraySize;
        int n9 = n2;
        float f8 = f6 * f6 + f7 * f7;
        float f9 = f8 * 2.0f;
        if (f8 > (float)n8) {
            int n10 = this.gradientOverflow;
            for (int i2 = 0; i2 < n7; ++i2) {
                int n11 = n9 + n6;
                while (n9 < n11) {
                    nArray[n9] = n10;
                    ++n9;
                }
                n9 += n3;
            }
            return;
        }
        for (int i3 = 0; i3 < n7; ++i3) {
            float f10 = f3 * (this.a01 * (float)i3 + f4);
            float f11 = f3 * (this.a11 * (float)i3 + f5);
            float f12 = f11 * f11 + f10 * f10;
            float f13 = (f7 * f11 + f6 * f10) * 2.0f + f8;
            int n12 = n9 + n6;
            while (n9 < n12) {
                if (f12 >= (float)n8) {
                    nArray[n9] = this.gradientOverflow;
                } else {
                    f2 = f12 * this.invSqStepFloat;
                    int n13 = (int)f2;
                    int n14 = this.sqrtLutFixed[n13];
                    n14 += (int)((f2 -= (float)n13) * (float)(this.sqrtLutFixed[n13 + 1] - n14));
                    nArray[n9] = this.gradient[n14];
                }
                f12 += f13;
                f13 += f9;
                ++n9;
            }
            n9 += n3;
        }
    }

    private void calculateFixedPointSqrtLookupTable() {
        int n2;
        float f2 = (float)(this.fastGradientArraySize * this.fastGradientArraySize) / 254.0f;
        int[] nArray = this.sqrtLutFixed;
        for (n2 = 0; n2 < 255; ++n2) {
            nArray[n2] = (int)Math.sqrt((float)n2 * f2);
        }
        nArray[n2] = nArray[n2 - 1];
        this.invSqStepFloat = 1.0f / f2;
    }

    private void cyclicCircularGradientFillRaster(int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        double d2 = -this.radiusSq + this.centerX * this.centerX + this.centerY * this.centerY;
        float f2 = this.a00 * (float)n4 + this.a01 * (float)n5 + this.a02;
        float f3 = this.a10 * (float)n4 + this.a11 * (float)n5 + this.a12;
        float f4 = 2.0f * this.centerY;
        float f5 = -2.0f * this.centerX;
        int n8 = n2;
        int n9 = n6 + n3;
        for (int i2 = 0; i2 < n7; ++i2) {
            float f6 = this.a01 * (float)i2 + f2;
            float f7 = this.a11 * (float)i2 + f3;
            for (int i3 = 0; i3 < n6; ++i3) {
                double d3;
                double d4;
                if (f6 - this.focusX > -1.0E-6f && f6 - this.focusX < 1.0E-6f) {
                    d4 = this.focusX;
                    d3 = this.centerY;
                    d3 += f7 > this.focusY ? (double)this.trivial : (double)(-this.trivial);
                } else {
                    double d5 = (f7 - this.focusY) / (f6 - this.focusX);
                    double d6 = (double)f7 - d5 * (double)f6;
                    double d7 = d5 * d5 + 1.0;
                    double d8 = (double)f5 + -2.0 * d5 * ((double)this.centerY - d6);
                    double d9 = d2 + d6 * (d6 - (double)f4);
                    float f8 = (float)Math.sqrt(d8 * d8 - 4.0 * d7 * d9);
                    d4 = -d8;
                    d4 += f6 < this.focusX ? (double)(-f8) : (double)f8;
                    d3 = d5 * (d4 /= 2.0 * d7) + d6;
                }
                float f9 = (float)d4 - this.focusX;
                f9 *= f9;
                float f10 = (float)d3 - this.focusY;
                f10 *= f10;
                float f11 = f9 + f10;
                f9 = f6 - this.focusX;
                f9 *= f9;
                f10 = f7 - this.focusY;
                f10 *= f10;
                float f12 = f9 + f10;
                float f13 = (float)Math.sqrt(f12 / f11);
                nArray[n8 + i3] = this.indexIntoGradientsArrays(f13);
                f6 += this.a00;
                f7 += this.a10;
            }
            n8 += n9;
        }
    }

    private void antiAliasFillRaster(int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        float f2;
        int n8;
        double d14 = -this.radiusSq + this.centerX * this.centerX + this.centerY * this.centerY;
        float f3 = 2.0f * this.centerY;
        float f4 = -2.0f * this.centerX;
        float f5 = this.a00 * ((float)n4 - 0.5f) + this.a01 * ((float)n5 + 0.5f) + this.a02;
        float f6 = this.a10 * ((float)n4 - 0.5f) + this.a11 * ((float)n5 + 0.5f) + this.a12;
        int n9 = n2 - 1;
        double[] dArray = new double[n6 + 1];
        float f7 = f5 - this.a01;
        float f8 = f6 - this.a11;
        for (n8 = 0; n8 <= n6; ++n8) {
            f2 = f7 - this.focusX;
            if (f2 > -1.0E-6f && f2 < 1.0E-6f) {
                d13 = this.focusX;
                d12 = this.centerY;
                d12 += f8 > this.focusY ? (double)this.trivial : (double)(-this.trivial);
            } else {
                d11 = (f8 - this.focusY) / (f7 - this.focusX);
                d10 = (double)f8 - d11 * (double)f7;
                d9 = d11 * d11 + 1.0;
                d8 = (double)f4 + -2.0 * d11 * ((double)this.centerY - d10);
                d7 = d14 + d10 * (d10 - (double)f3);
                d6 = Math.sqrt(d8 * d8 - 4.0 * d9 * d7);
                d13 = -d8;
                d13 += f7 < this.focusX ? -d6 : d6;
                d12 = d11 * (d13 /= 2.0 * d9) + d10;
            }
            d5 = d13 - (double)this.focusX;
            d5 *= d5;
            d4 = d12 - (double)this.focusY;
            d4 *= d4;
            d3 = d5 + d4;
            d5 = f7 - this.focusX;
            d5 *= d5;
            d4 = f8 - this.focusY;
            d4 *= d4;
            d2 = d5 + d4;
            dArray[n8] = Math.sqrt(d2 / d3);
            f7 += this.a00;
            f8 += this.a10;
        }
        for (int i2 = 0; i2 < n7; ++i2) {
            double d15;
            f7 = this.a01 * (float)i2 + f5;
            f8 = this.a11 * (float)i2 + f6;
            double d16 = dArray[0];
            f2 = f7 - this.focusX;
            if (f2 > -1.0E-6f && f2 < 1.0E-6f) {
                d13 = this.focusX;
                d12 = this.centerY;
                d12 += f8 > this.focusY ? (double)this.trivial : (double)(-this.trivial);
            } else {
                d11 = (f8 - this.focusY) / (f7 - this.focusX);
                d10 = (double)f8 - d11 * (double)f7;
                d9 = d11 * d11 + 1.0;
                d8 = (double)f4 + -2.0 * d11 * ((double)this.centerY - d10);
                d7 = d14 + d10 * (d10 - (double)f3);
                d6 = Math.sqrt(d8 * d8 - 4.0 * d9 * d7);
                d13 = -d8;
                d13 += f7 < this.focusX ? -d6 : d6;
                d12 = d11 * (d13 /= 2.0 * d9) + d10;
            }
            d5 = d13 - (double)this.focusX;
            d5 *= d5;
            d4 = d12 - (double)this.focusY;
            d4 *= d4;
            d3 = d5 + d4;
            d5 = f7 - this.focusX;
            d5 *= d5;
            d4 = f8 - this.focusY;
            d4 *= d4;
            d2 = d5 + d4;
            dArray[0] = d15 = Math.sqrt(d2 / d3);
            f7 += this.a00;
            f8 += this.a10;
            for (n8 = 1; n8 <= n6; ++n8) {
                double d17 = d16;
                double d18 = d15;
                d16 = dArray[n8];
                f2 = f7 - this.focusX;
                if (f2 > -1.0E-6f && f2 < 1.0E-6f) {
                    d13 = this.focusX;
                    d12 = this.centerY;
                    d12 += f8 > this.focusY ? (double)this.trivial : (double)(-this.trivial);
                } else {
                    d11 = (f8 - this.focusY) / (f7 - this.focusX);
                    d10 = (double)f8 - d11 * (double)f7;
                    d9 = d11 * d11 + 1.0;
                    d8 = (double)f4 + -2.0 * d11 * ((double)this.centerY - d10);
                    d7 = d14 + d10 * (d10 - (double)f3);
                    d6 = Math.sqrt(d8 * d8 - 4.0 * d9 * d7);
                    d13 = -d8;
                    d13 += f7 < this.focusX ? -d6 : d6;
                    d12 = d11 * (d13 /= 2.0 * d9) + d10;
                }
                d5 = d13 - (double)this.focusX;
                d5 *= d5;
                d4 = d12 - (double)this.focusY;
                d4 *= d4;
                d3 = d5 + d4;
                d5 = f7 - this.focusX;
                d5 *= d5;
                d4 = f8 - this.focusY;
                d4 *= d4;
                d2 = d5 + d4;
                dArray[n8] = d15 = Math.sqrt(d2 / d3);
                nArray[n9 + n8] = this.indexGradientAntiAlias((float)((d17 + d18 + d16 + d15) / 4.0), (float)Math.max(Math.abs(d15 - d17), Math.abs(d16 - d18)));
                f7 += this.a00;
                f8 += this.a10;
            }
            n9 += n6 + n3;
        }
    }
}

