/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.util.HashTable;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.util.XMLConstants;
import org.apache.batik.xml.XMLUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtilities
extends XMLUtilities
implements XMLConstants {
    protected static final String[] LOCK_STRINGS = new String[]{"", "CapsLock", "NumLock", "NumLock CapsLock", "Scroll", "Scroll CapsLock", "Scroll NumLock", "Scroll NumLock CapsLock", "KanaMode", "KanaMode CapsLock", "KanaMode NumLock", "KanaMode NumLock CapsLock", "KanaMode Scroll", "KanaMode Scroll CapsLock", "KanaMode Scroll NumLock", "KanaMode Scroll NumLock CapsLock"};
    protected static final String[] MODIFIER_STRINGS = new String[]{"", "Shift", "Control", "Control Shift", "Meta", "Meta Shift", "Control Meta", "Control Meta Shift", "Alt", "Alt Shift", "Alt Control", "Alt Control Shift", "Alt Meta", "Alt Meta Shift", "Alt Control Meta", "Alt Control Meta Shift", "AltGraph", "AltGraph Shift", "AltGraph Control", "AltGraph Control Shift", "AltGraph Meta", "AltGraph Meta Shift", "AltGraph Control Meta", "AltGraph Control Meta Shift", "Alt AltGraph", "Alt AltGraph Shift", "Alt AltGraph Control", "Alt AltGraph Control Shift", "Alt AltGraph Meta", "Alt AltGraph Meta Shift", "Alt AltGraph Control Meta", "Alt AltGraph Control Meta Shift"};

    protected DOMUtilities() {
    }

    public static void writeDocument(Document document, Writer writer) throws IOException {
        AbstractDocument abstractDocument = (AbstractDocument)document;
        if (document.getDocumentElement() == null) {
            throw new IOException("No document element");
        }
        NSMap nSMap = NSMap.create();
        for (Node node = document.getFirstChild(); node != null; node = node.getNextSibling()) {
            DOMUtilities.writeNode(node, writer, nSMap, "1.1".equals(abstractDocument.getXmlVersion()));
        }
    }

    protected static void writeNode(Node node, Writer writer, NSMap nSMap, boolean bl2) throws IOException {
        switch (node.getNodeType()) {
            case 1: {
                Node node2;
                String string2;
                Object object;
                Object object2;
                if (node.hasAttributes()) {
                    object2 = node.getAttributes();
                    int n2 = object2.getLength();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Attr attr = (Attr)object2.item(i2);
                        String string3 = attr.getNodeName();
                        if (!string3.startsWith("xmlns")) continue;
                        if (string3.length() == 5) {
                            nSMap = nSMap.declare("", attr.getNodeValue());
                            continue;
                        }
                        object = string3.substring(6);
                        nSMap = nSMap.declare((String)object, attr.getNodeValue());
                    }
                }
                writer.write(60);
                object2 = node.getNamespaceURI();
                if (object2 == null) {
                    string2 = node.getNodeName();
                    writer.write(string2);
                    if (!"".equals(nSMap.getNamespace(""))) {
                        writer.write(" xmlns=\"\"");
                        nSMap = nSMap.declare("", "");
                    }
                } else {
                    String string4 = node.getPrefix();
                    if (string4 == null) {
                        string4 = "";
                    }
                    if (((String)object2).equals(nSMap.getNamespace(string4))) {
                        string2 = node.getNodeName();
                        writer.write(string2);
                    } else {
                        string4 = nSMap.getPrefixForElement((String)object2);
                        if (string4 == null) {
                            string4 = nSMap.getNewPrefix();
                            string2 = string4 + ':' + node.getLocalName();
                            writer.write(string2 + " xmlns:" + string4 + "=\"" + DOMUtilities.contentToString((String)object2, bl2) + '\"');
                            nSMap = nSMap.declare(string4, (String)object2);
                        } else {
                            string2 = string4.equals("") ? node.getLocalName() : string4 + ':' + node.getLocalName();
                            writer.write(string2);
                        }
                    }
                }
                if (node.hasAttributes()) {
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    int n3 = namedNodeMap.getLength();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        object = (Attr)namedNodeMap.item(i3);
                        String string5 = object.getNodeName();
                        String string6 = object.getPrefix();
                        String string7 = object.getNamespaceURI();
                        if (!(string7 == null || "xmlns".equals(string6) || string5.equals("xmlns") || (string6 == null || string7.equals(nSMap.getNamespace(string6))) && string6 != null)) {
                            string6 = nSMap.getPrefixForAttr(string7);
                            if (string6 == null) {
                                string6 = nSMap.getNewPrefix();
                                nSMap = nSMap.declare(string6, string7);
                                writer.write(" xmlns:" + string6 + "=\"" + DOMUtilities.contentToString(string7, bl2) + '\"');
                            }
                            string5 = string6 + ':' + object.getLocalName();
                        }
                        writer.write(' ' + string5 + "=\"" + DOMUtilities.contentToString(object.getNodeValue(), bl2) + '\"');
                    }
                }
                if ((node2 = node.getFirstChild()) != null) {
                    writer.write(62);
                    do {
                        DOMUtilities.writeNode(node2, writer, nSMap, bl2);
                    } while ((node2 = node2.getNextSibling()) != null);
                    writer.write("</" + string2 + '>');
                    break;
                }
                writer.write("/>");
                break;
            }
            case 3: {
                writer.write(DOMUtilities.contentToString(node.getNodeValue(), bl2));
                break;
            }
            case 4: {
                String string8 = node.getNodeValue();
                if (string8.indexOf("]]>") != -1) {
                    throw new IOException("Unserializable CDATA section node");
                }
                writer.write("<![CDATA[" + DOMUtilities.assertValidCharacters(string8, bl2) + "]]>");
                break;
            }
            case 5: {
                writer.write('&' + node.getNodeName() + ';');
                break;
            }
            case 7: {
                String string9 = node.getNodeName();
                String string10 = node.getNodeValue();
                if (string9.equalsIgnoreCase("xml") || string9.indexOf(58) != -1 || string10.indexOf("?>") != -1) {
                    throw new IOException("Unserializable processing instruction node");
                }
                writer.write("<?" + string9 + ' ' + string10 + "?>");
                break;
            }
            case 8: {
                writer.write("<!--");
                String string11 = node.getNodeValue();
                int n4 = string11.length();
                if (n4 != 0 && string11.charAt(n4 - 1) == '-' || string11.indexOf("--") != -1) {
                    throw new IOException("Unserializable comment node");
                }
                writer.write(string11);
                writer.write("-->");
                break;
            }
            case 10: {
                String string12;
                String string13;
                DocumentType documentType = (DocumentType)node;
                writer.write("<!DOCTYPE " + node.getOwnerDocument().getDocumentElement().getNodeName());
                String string14 = documentType.getPublicId();
                if (string14 != null) {
                    char c2 = DOMUtilities.getUsableQuote(string14);
                    if (c2 == '\u0000') {
                        throw new IOException("Unserializable DOCTYPE node");
                    }
                    writer.write(" PUBLIC " + c2 + string14 + c2);
                }
                if ((string13 = documentType.getSystemId()) != null) {
                    char c3 = DOMUtilities.getUsableQuote(string13);
                    if (c3 == '\u0000') {
                        throw new IOException("Unserializable DOCTYPE node");
                    }
                    if (string14 == null) {
                        writer.write(" SYSTEM");
                    }
                    writer.write(" " + c3 + string13 + c3);
                }
                if ((string12 = documentType.getInternalSubset()) != null) {
                    writer.write('[' + string12 + ']');
                }
                writer.write(62);
                break;
            }
            default: {
                throw new IOException("Unknown DOM node type " + node.getNodeType());
            }
        }
    }

    public static void writeNode(Node node, Writer writer) throws IOException {
        if (node.getNodeType() == 9) {
            DOMUtilities.writeDocument((Document)node, writer);
        } else {
            AbstractDocument abstractDocument = (AbstractDocument)node.getOwnerDocument();
            DOMUtilities.writeNode(node, writer, NSMap.create(), abstractDocument == null ? false : "1.1".equals(abstractDocument.getXmlVersion()));
        }
    }

    private static char getUsableQuote(String string2) {
        int n2 = 0;
        for (int i2 = string2.length() - 1; i2 >= 0; --i2) {
            char c2 = string2.charAt(i2);
            if (c2 == '\"') {
                if (n2 == 0) {
                    n2 = 39;
                    continue;
                }
                return '\u0000';
            }
            if (c2 != '\'') continue;
            if (n2 == 0) {
                n2 = 34;
                continue;
            }
            return '\u0000';
        }
        return (char)(n2 == 0 ? 34 : n2);
    }

    public static String getXML(Node node) {
        StringWriter stringWriter = new StringWriter();
        try {
            DOMUtilities.writeNode(node, stringWriter);
            ((Writer)stringWriter).close();
        }
        catch (IOException iOException) {
            return "";
        }
        return ((Object)stringWriter).toString();
    }

    protected static String assertValidCharacters(String string2, boolean bl2) throws IOException {
        int n2 = string2.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string2.charAt(i2);
            if ((bl2 || DOMUtilities.isXMLCharacter(c2)) && (!bl2 || DOMUtilities.isXML11Character(c2))) continue;
            throw new IOException("Invalid character");
        }
        return string2;
    }

    public static String contentToString(String string2, boolean bl2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(string2.length());
        int n2 = string2.length();
        block7: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string2.charAt(i2);
            if (!bl2 && !DOMUtilities.isXMLCharacter(c2) || bl2 && !DOMUtilities.isXML11Character(c2)) {
                throw new IOException("Invalid character");
            }
            switch (c2) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block7;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static int getChildIndex(Node node, Node node2) {
        if (node == null || node.getParentNode() != node2 || node.getParentNode() == null) {
            return -1;
        }
        return DOMUtilities.getChildIndex(node);
    }

    public static int getChildIndex(Node node) {
        NodeList nodeList = node.getParentNode().getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node2 = nodeList.item(i2);
            if (node2 != node) continue;
            return i2;
        }
        return -1;
    }

    public static boolean isAnyNodeAncestorOf(ArrayList arrayList, Node node) {
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node2 = (Node)arrayList.get(i2);
            if (!DOMUtilities.isAncestorOf(node2, node)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAncestorOf(Node node, Node node2) {
        if (node == null || node2 == null) {
            return false;
        }
        for (Node node3 = node2.getParentNode(); node3 != null; node3 = node3.getParentNode()) {
            if (node3 != node) continue;
            return true;
        }
        return false;
    }

    public static boolean isParentOf(Node node, Node node2) {
        return node != null && node2 != null && node.getParentNode() == node2;
    }

    public static boolean canAppend(Node node, Node node2) {
        return node != null && node2 != null && node != node2 && !DOMUtilities.isAncestorOf(node, node2);
    }

    public static boolean canAppendAny(ArrayList arrayList, Node node) {
        if (!DOMUtilities.canHaveChildren(node)) {
            return false;
        }
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node2 = (Node)arrayList.get(i2);
            if (!DOMUtilities.canAppend(node2, node)) continue;
            return true;
        }
        return false;
    }

    public static boolean canHaveChildren(Node node) {
        if (node == null) {
            return false;
        }
        switch (node.getNodeType()) {
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                return false;
            }
        }
        return true;
    }

    public static Node parseXML(String string2, Document document, String string3, Map map, String string4, SAXDocumentFactory sAXDocumentFactory) {
        Iterator iterator;
        Object object;
        Object object2;
        String string5 = "";
        String string6 = "";
        if (string4 != null) {
            string5 = "<" + string4;
            if (map != null) {
                string5 = string5 + " ";
                for (Map.Entry object32 : map.entrySet()) {
                    object2 = (String)object32.getKey();
                    object = (String)object32.getValue();
                    string5 = string5 + (String)object2 + "=\"" + (String)object + "\" ";
                }
            }
            string5 = string5 + ">";
            string6 = string6 + "</" + string4 + '>';
        }
        if (string5.trim().length() == 0 && string6.trim().length() == 0) {
            try {
                iterator = sAXDocumentFactory.createDocument(string3, new StringReader(string2));
                if (document == null) {
                    return iterator;
                }
                DocumentFragment documentFragment = document.createDocumentFragment();
                documentFragment.appendChild(document.importNode(iterator.getDocumentElement(), true));
                return documentFragment;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        iterator = new StringBuffer(string5.length() + string2.length() + string6.length());
        ((StringBuffer)((Object)iterator)).append(string5);
        ((StringBuffer)((Object)iterator)).append(string2);
        ((StringBuffer)((Object)iterator)).append(string6);
        String string7 = ((StringBuffer)((Object)iterator)).toString();
        try {
            object2 = sAXDocumentFactory.createDocument(string3, new StringReader(string7));
            if (document == null) {
                return object2;
            }
            for (object = object2.getDocumentElement().getFirstChild(); object != null; object = object.getNextSibling()) {
                if (object.getNodeType() != 1) continue;
                object = document.importNode((Node)object, true);
                DocumentFragment documentFragment = document.createDocumentFragment();
                documentFragment.appendChild((Node)object);
                return documentFragment;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Document deepCloneDocument(Document document, DOMImplementation dOMImplementation) {
        Element element = document.getDocumentElement();
        Document document2 = dOMImplementation.createDocument(element.getNamespaceURI(), element.getNodeName(), null);
        Element element2 = document2.getDocumentElement();
        boolean bl2 = true;
        for (Node node = document.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == element) {
                Object object;
                bl2 = false;
                if (element.hasAttributes()) {
                    object = element.getAttributes();
                    int n2 = object.getLength();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        element2.setAttributeNode((Attr)document2.importNode(object.item(i2), true));
                    }
                }
                for (object = element.getFirstChild(); object != null; object = object.getNextSibling()) {
                    element2.appendChild(document2.importNode((Node)object, true));
                }
                continue;
            }
            if (node.getNodeType() == 10) continue;
            if (bl2) {
                document2.insertBefore(document2.importNode(node, true), element2);
                continue;
            }
            document2.appendChild(document2.importNode(node, true));
        }
        return document2;
    }

    public static boolean isValidName(String string2) {
        int n2;
        int n3 = string2.length();
        if (n3 == 0) {
            return false;
        }
        char c2 = string2.charAt(0);
        int n4 = c2 / 32;
        if ((NAME_FIRST_CHARACTER[n4] & 1 << (n2 = c2 % 32)) == 0) {
            return false;
        }
        for (int i2 = 1; i2 < n3; ++i2) {
            c2 = string2.charAt(i2);
            n4 = c2 / 32;
            if ((NAME_CHARACTER[n4] & 1 << (n2 = c2 % 32)) != 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidName11(String string2) {
        int n2;
        int n3 = string2.length();
        if (n3 == 0) {
            return false;
        }
        char c2 = string2.charAt(0);
        int n4 = c2 / 32;
        if ((NAME11_FIRST_CHARACTER[n4] & 1 << (n2 = c2 % 32)) == 0) {
            return false;
        }
        for (int i2 = 1; i2 < n3; ++i2) {
            c2 = string2.charAt(i2);
            n4 = c2 / 32;
            if ((NAME11_CHARACTER[n4] & 1 << (n2 = c2 % 32)) != 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidPrefix(String string2) {
        return string2.indexOf(58) == -1;
    }

    public static String getPrefix(String string2) {
        int n2 = string2.indexOf(58);
        return n2 == -1 || n2 == string2.length() - 1 ? null : string2.substring(0, n2);
    }

    public static String getLocalName(String string2) {
        int n2 = string2.indexOf(58);
        return n2 == -1 || n2 == string2.length() - 1 ? string2 : string2.substring(n2 + 1);
    }

    public static void parseStyleSheetPIData(String string2, HashTable hashTable) {
        char c2;
        int n2;
        for (n2 = 0; n2 < string2.length() && XMLUtilities.isXMLSpace(c2 = string2.charAt(n2)); ++n2) {
        }
        while (n2 < string2.length()) {
            int n3;
            c2 = string2.charAt(n2);
            int n4 = c2 / 32;
            if ((NAME_FIRST_CHARACTER[n4] & 1 << (n3 = c2 % 32)) == 0) {
                throw new DOMException(5, "Wrong name initial:  " + c2);
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(c2);
            while (++n2 < string2.length() && (NAME_CHARACTER[n4 = (c2 = string2.charAt(n2)) / 32] & 1 << (n3 = c2 % 32)) != 0) {
                stringBuffer.append(c2);
            }
            if (n2 >= string2.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + string2);
            }
            while (n2 < string2.length() && XMLUtilities.isXMLSpace(c2 = string2.charAt(n2))) {
                ++n2;
            }
            if (n2 >= string2.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + string2);
            }
            if (string2.charAt(n2) != '=') {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + string2);
            }
            ++n2;
            while (n2 < string2.length() && XMLUtilities.isXMLSpace(c2 = string2.charAt(n2))) {
                ++n2;
            }
            if (n2 >= string2.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + string2);
            }
            c2 = string2.charAt(n2);
            ++n2;
            StringBuffer stringBuffer2 = new StringBuffer();
            if (c2 == '\'') {
                while (n2 < string2.length() && (c2 = string2.charAt(n2)) != '\'') {
                    stringBuffer2.append(c2);
                    ++n2;
                }
                if (n2 >= string2.length()) {
                    throw new DOMException(12, "Wrong xml-stylesheet data: " + string2);
                }
            } else if (c2 == '\"') {
                while (n2 < string2.length() && (c2 = string2.charAt(n2)) != '\"') {
                    stringBuffer2.append(c2);
                    ++n2;
                }
                if (n2 >= string2.length()) {
                    throw new DOMException(12, "Wrong xml-stylesheet data: " + string2);
                }
            } else {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + string2);
            }
            hashTable.put(stringBuffer.toString().intern(), stringBuffer2.toString());
            ++n2;
            while (n2 < string2.length() && XMLUtilities.isXMLSpace(c2 = string2.charAt(n2))) {
                ++n2;
            }
        }
    }

    public static String getModifiersList(int n2, int n3) {
        n3 = (n3 & 0x2000) != 0 ? 0x10 | n3 >> 6 & 0xF : n3 >> 6 & 0xF;
        String string2 = LOCK_STRINGS[n2 & 0xF];
        if (string2.length() != 0) {
            return string2 + ' ' + MODIFIER_STRINGS[n3];
        }
        return MODIFIER_STRINGS[n3];
    }

    public static boolean isAttributeSpecifiedNS(Element element, String string2, String string3) {
        Attr attr = element.getAttributeNodeNS(string2, string3);
        return attr != null && attr.getSpecified();
    }

    private static class NSMap {
        private String prefix;
        private String ns;
        private NSMap next;
        private int nextPrefixNumber;

        public static NSMap create() {
            return new NSMap().declare("xml", "http://www.w3.org/XML/1998/namespace").declare("xmlns", "http://www.w3.org/2000/xmlns/");
        }

        private NSMap() {
        }

        public NSMap declare(String string2, String string3) {
            NSMap nSMap = new NSMap();
            nSMap.prefix = string2;
            nSMap.ns = string3;
            nSMap.next = this;
            nSMap.nextPrefixNumber = this.nextPrefixNumber;
            return nSMap;
        }

        public String getNewPrefix() {
            String string2;
            while (this.getNamespace(string2 = "a" + this.nextPrefixNumber++) != null) {
            }
            return string2;
        }

        public String getNamespace(String string2) {
            NSMap nSMap = this;
            while (nSMap.next != null) {
                if (nSMap.prefix.equals(string2)) {
                    return nSMap.ns;
                }
                nSMap = nSMap.next;
            }
            return null;
        }

        public String getPrefixForElement(String string2) {
            NSMap nSMap = this;
            while (nSMap.next != null) {
                if (string2.equals(nSMap.ns)) {
                    return nSMap.prefix;
                }
                nSMap = nSMap.next;
            }
            return null;
        }

        public String getPrefixForAttr(String string2) {
            NSMap nSMap = this;
            while (nSMap.next != null) {
                if (string2.equals(nSMap.ns) && !nSMap.prefix.equals("")) {
                    return nSMap.prefix;
                }
                nSMap = nSMap.next;
            }
            return null;
        }
    }
}

